/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.util.Comparator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;

public final class UTF16 {
    public static final int SINGLE_CHAR_BOUNDARY = 1;
    public static final int LEAD_SURROGATE_BOUNDARY = 2;
    public static final int TRAIL_SURROGATE_BOUNDARY = 5;
    public static final int CODEPOINT_MIN_VALUE = 0;
    public static final int CODEPOINT_MAX_VALUE = 0x10FFFF;
    public static final int SUPPLEMENTARY_MIN_VALUE = 65536;
    public static final int LEAD_SURROGATE_MIN_VALUE = 55296;
    public static final int TRAIL_SURROGATE_MIN_VALUE = 56320;
    public static final int LEAD_SURROGATE_MAX_VALUE = 56319;
    public static final int TRAIL_SURROGATE_MAX_VALUE = 57343;
    public static final int SURROGATE_MIN_VALUE = 55296;
    public static final int SURROGATE_MAX_VALUE = 57343;
    private static final int LEAD_SURROGATE_BITMASK = -1024;
    private static final int TRAIL_SURROGATE_BITMASK = -1024;
    private static final int SURROGATE_BITMASK = -2048;
    private static final int LEAD_SURROGATE_BITS = 55296;
    private static final int TRAIL_SURROGATE_BITS = 56320;
    private static final int SURROGATE_BITS = 55296;
    private static final int LEAD_SURROGATE_SHIFT_ = 10;
    private static final int TRAIL_SURROGATE_MASK_ = 1023;
    private static final int LEAD_SURROGATE_OFFSET_ = 55232;

    private UTF16() {
    }

    public static int charAt(String string, int n2) {
        char c2 = string.charAt(n2);
        if (c2 < '\ud800') {
            return c2;
        }
        return UTF16._charAt(string, n2, c2);
    }

    private static int _charAt(String string, int n2, char c2) {
        char c3;
        if (c2 > '\udfff') {
            return c2;
        }
        if (c2 <= '\udbff') {
            char c4;
            if (string.length() != ++n2 && (c4 = string.charAt(n2)) >= '\udc00' && c4 <= '\udfff') {
                return Character.toCodePoint(c2, c4);
            }
        } else if (--n2 >= 0 && (c3 = string.charAt(n2)) >= '\ud800' && c3 <= '\udbff') {
            return Character.toCodePoint(c3, c2);
        }
        return c2;
    }

    public static int charAt(CharSequence charSequence, int n2) {
        char c2 = charSequence.charAt(n2);
        if (c2 < '\ud800') {
            return c2;
        }
        return UTF16._charAt(charSequence, n2, c2);
    }

    private static int _charAt(CharSequence charSequence, int n2, char c2) {
        char c3;
        if (c2 > '\udfff') {
            return c2;
        }
        if (c2 <= '\udbff') {
            char c4;
            if (charSequence.length() != ++n2 && (c4 = charSequence.charAt(n2)) >= '\udc00' && c4 <= '\udfff') {
                return Character.toCodePoint(c2, c4);
            }
        } else if (--n2 >= 0 && (c3 = charSequence.charAt(n2)) >= '\ud800' && c3 <= '\udbff') {
            return Character.toCodePoint(c3, c2);
        }
        return c2;
    }

    public static int charAt(StringBuffer stringBuffer, int n2) {
        char c2;
        if (n2 < 0 || n2 >= stringBuffer.length()) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        char c3 = stringBuffer.charAt(n2);
        if (!UTF16.isSurrogate(c3)) {
            return c3;
        }
        if (c3 <= '\udbff') {
            char c4;
            if (stringBuffer.length() != ++n2 && UTF16.isTrailSurrogate(c4 = stringBuffer.charAt(n2))) {
                return Character.toCodePoint(c3, c4);
            }
        } else if (--n2 >= 0 && UTF16.isLeadSurrogate(c2 = stringBuffer.charAt(n2))) {
            return Character.toCodePoint(c2, c3);
        }
        return c3;
    }

    public static int charAt(char[] cArray, int n2, int n3, int n4) {
        if ((n4 += n2) < n2 || n4 >= n3) {
            throw new ArrayIndexOutOfBoundsException(n4);
        }
        char c2 = cArray[n4];
        if (!UTF16.isSurrogate(c2)) {
            return c2;
        }
        if (c2 <= '\udbff') {
            if (++n4 >= n3) {
                return c2;
            }
            char c3 = cArray[n4];
            if (UTF16.isTrailSurrogate(c3)) {
                return Character.toCodePoint(c2, c3);
            }
        } else {
            char c4;
            if (n4 == n2) {
                return c2;
            }
            if (UTF16.isLeadSurrogate(c4 = cArray[--n4])) {
                return Character.toCodePoint(c4, c2);
            }
        }
        return c2;
    }

    public static int charAt(Replaceable replaceable, int n2) {
        char c2;
        if (n2 < 0 || n2 >= replaceable.length()) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        char c3 = replaceable.charAt(n2);
        if (!UTF16.isSurrogate(c3)) {
            return c3;
        }
        if (c3 <= '\udbff') {
            char c4;
            if (replaceable.length() != ++n2 && UTF16.isTrailSurrogate(c4 = replaceable.charAt(n2))) {
                return Character.toCodePoint(c3, c4);
            }
        } else if (--n2 >= 0 && UTF16.isLeadSurrogate(c2 = replaceable.charAt(n2))) {
            return Character.toCodePoint(c2, c3);
        }
        return c3;
    }

    public static int getCharCount(int n2) {
        if (n2 < 65536) {
            return 1;
        }
        return 2;
    }

    public static int bounds(String string, int n2) {
        char c2 = string.charAt(n2);
        if (UTF16.isSurrogate(c2)) {
            if (UTF16.isLeadSurrogate(c2)) {
                if (++n2 < string.length() && UTF16.isTrailSurrogate(string.charAt(n2))) {
                    return 2;
                }
            } else if (--n2 >= 0 && UTF16.isLeadSurrogate(string.charAt(n2))) {
                return 5;
            }
        }
        return 1;
    }

    public static int bounds(StringBuffer stringBuffer, int n2) {
        char c2 = stringBuffer.charAt(n2);
        if (UTF16.isSurrogate(c2)) {
            if (UTF16.isLeadSurrogate(c2)) {
                if (++n2 < stringBuffer.length() && UTF16.isTrailSurrogate(stringBuffer.charAt(n2))) {
                    return 2;
                }
            } else if (--n2 >= 0 && UTF16.isLeadSurrogate(stringBuffer.charAt(n2))) {
                return 5;
            }
        }
        return 1;
    }

    public static int bounds(char[] cArray, int n2, int n3, int n4) {
        if ((n4 += n2) < n2 || n4 >= n3) {
            throw new ArrayIndexOutOfBoundsException(n4);
        }
        char c2 = cArray[n4];
        if (UTF16.isSurrogate(c2)) {
            if (UTF16.isLeadSurrogate(c2)) {
                if (++n4 < n3 && UTF16.isTrailSurrogate(cArray[n4])) {
                    return 2;
                }
            } else if (--n4 >= n2 && UTF16.isLeadSurrogate(cArray[n4])) {
                return 5;
            }
        }
        return 1;
    }

    public static boolean isSurrogate(int n2) {
        return (n2 & 0xFFFFF800) == 55296;
    }

    public static boolean isTrailSurrogate(int n2) {
        return (n2 & 0xFFFFFC00) == 56320;
    }

    public static boolean isLeadSurrogate(int n2) {
        return (n2 & 0xFFFFFC00) == 55296;
    }

    public static char getLeadSurrogate(int n2) {
        if (n2 >= 65536) {
            return (char)(55232 + (n2 >> 10));
        }
        return '\u0000';
    }

    public static char getTrailSurrogate(int n2) {
        if (n2 >= 65536) {
            return (char)(56320 + (n2 & 0x3FF));
        }
        return (char)n2;
    }

    public static String valueOf(int n2) {
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal codepoint");
        }
        return UTF16.toString(n2);
    }

    public static String valueOf(String string, int n2) {
        switch (UTF16.bounds(string, n2)) {
            case 2: {
                return string.substring(n2, n2 + 2);
            }
            case 5: {
                return string.substring(n2 - 1, n2 + 1);
            }
        }
        return string.substring(n2, n2 + 1);
    }

    public static String valueOf(StringBuffer stringBuffer, int n2) {
        switch (UTF16.bounds(stringBuffer, n2)) {
            case 2: {
                return stringBuffer.substring(n2, n2 + 2);
            }
            case 5: {
                return stringBuffer.substring(n2 - 1, n2 + 1);
            }
        }
        return stringBuffer.substring(n2, n2 + 1);
    }

    public static String valueOf(char[] cArray, int n2, int n3, int n4) {
        switch (UTF16.bounds(cArray, n2, n3, n4)) {
            case 2: {
                return new String(cArray, n2 + n4, 2);
            }
            case 5: {
                return new String(cArray, n2 + n4 - 1, 2);
            }
        }
        return new String(cArray, n2 + n4, 1);
    }

    public static int findOffsetFromCodePoint(String string, int n2) {
        int n3;
        int n4 = string.length();
        int n5 = 0;
        if (n2 < 0 || n2 > n4) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        for (n3 = n2; n5 < n4 && n3 > 0; --n3, ++n5) {
            char c2 = string.charAt(n5);
            if (!UTF16.isLeadSurrogate(c2) || n5 + 1 >= n4 || !UTF16.isTrailSurrogate(string.charAt(n5 + 1))) continue;
            ++n5;
        }
        if (n3 != 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        return n5;
    }

    public static int findOffsetFromCodePoint(StringBuffer stringBuffer, int n2) {
        int n3;
        int n4 = stringBuffer.length();
        int n5 = 0;
        if (n2 < 0 || n2 > n4) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        for (n3 = n2; n5 < n4 && n3 > 0; --n3, ++n5) {
            char c2 = stringBuffer.charAt(n5);
            if (!UTF16.isLeadSurrogate(c2) || n5 + 1 >= n4 || !UTF16.isTrailSurrogate(stringBuffer.charAt(n5 + 1))) continue;
            ++n5;
        }
        if (n3 != 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        return n5;
    }

    public static int findOffsetFromCodePoint(char[] cArray, int n2, int n3, int n4) {
        int n5;
        int n6 = n2;
        if (n4 > n3 - n2) {
            throw new ArrayIndexOutOfBoundsException(n4);
        }
        for (n5 = n4; n6 < n3 && n5 > 0; --n5, ++n6) {
            char c2 = cArray[n6];
            if (!UTF16.isLeadSurrogate(c2) || n6 + 1 >= n3 || !UTF16.isTrailSurrogate(cArray[n6 + 1])) continue;
            ++n6;
        }
        if (n5 != 0) {
            throw new ArrayIndexOutOfBoundsException(n4);
        }
        return n6 - n2;
    }

    public static int findCodePointOffset(String string, int n2) {
        if (n2 < 0 || n2 > string.length()) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        int n3 = 0;
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (bl2 && UTF16.isTrailSurrogate(c2)) {
                bl2 = false;
                continue;
            }
            bl2 = UTF16.isLeadSurrogate(c2);
            ++n3;
        }
        if (n2 == string.length()) {
            return n3;
        }
        if (bl2 && UTF16.isTrailSurrogate(string.charAt(n2))) {
            --n3;
        }
        return n3;
    }

    public static int findCodePointOffset(StringBuffer stringBuffer, int n2) {
        if (n2 < 0 || n2 > stringBuffer.length()) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        int n3 = 0;
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = stringBuffer.charAt(i2);
            if (bl2 && UTF16.isTrailSurrogate(c2)) {
                bl2 = false;
                continue;
            }
            bl2 = UTF16.isLeadSurrogate(c2);
            ++n3;
        }
        if (n2 == stringBuffer.length()) {
            return n3;
        }
        if (bl2 && UTF16.isTrailSurrogate(stringBuffer.charAt(n2))) {
            --n3;
        }
        return n3;
    }

    public static int findCodePointOffset(char[] cArray, int n2, int n3, int n4) {
        if ((n4 += n2) > n3) {
            throw new StringIndexOutOfBoundsException(n4);
        }
        int n5 = 0;
        boolean bl2 = false;
        for (int i2 = n2; i2 < n4; ++i2) {
            char c2 = cArray[i2];
            if (bl2 && UTF16.isTrailSurrogate(c2)) {
                bl2 = false;
                continue;
            }
            bl2 = UTF16.isLeadSurrogate(c2);
            ++n5;
        }
        if (n4 == n3) {
            return n5;
        }
        if (bl2 && UTF16.isTrailSurrogate(cArray[n4])) {
            --n5;
        }
        return n5;
    }

    public static StringBuffer append(StringBuffer stringBuffer, int n2) {
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal codepoint: " + Integer.toHexString(n2));
        }
        if (n2 >= 65536) {
            stringBuffer.append(UTF16.getLeadSurrogate(n2));
            stringBuffer.append(UTF16.getTrailSurrogate(n2));
        } else {
            stringBuffer.append((char)n2);
        }
        return stringBuffer;
    }

    public static StringBuffer appendCodePoint(StringBuffer stringBuffer, int n2) {
        return UTF16.append(stringBuffer, n2);
    }

    public static int append(char[] cArray, int n2, int n3) {
        if (n3 < 0 || n3 > 0x10FFFF) {
            throw new IllegalArgumentException("Illegal codepoint");
        }
        if (n3 >= 65536) {
            cArray[n2++] = UTF16.getLeadSurrogate(n3);
            cArray[n2++] = UTF16.getTrailSurrogate(n3);
        } else {
            cArray[n2++] = (char)n3;
        }
        return n2;
    }

    public static int countCodePoint(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        return UTF16.findCodePointOffset(string, string.length());
    }

    public static int countCodePoint(StringBuffer stringBuffer) {
        if (stringBuffer == null || stringBuffer.length() == 0) {
            return 0;
        }
        return UTF16.findCodePointOffset(stringBuffer, stringBuffer.length());
    }

    public static int countCodePoint(char[] cArray, int n2, int n3) {
        if (cArray == null || cArray.length == 0) {
            return 0;
        }
        return UTF16.findCodePointOffset(cArray, n2, n3, n3 - n2);
    }

    public static void setCharAt(StringBuffer stringBuffer, int n2, int n3) {
        int n4 = 1;
        char c2 = stringBuffer.charAt(n2);
        if (UTF16.isSurrogate(c2)) {
            if (UTF16.isLeadSurrogate(c2) && stringBuffer.length() > n2 + 1 && UTF16.isTrailSurrogate(stringBuffer.charAt(n2 + 1))) {
                ++n4;
            } else if (UTF16.isTrailSurrogate(c2) && n2 > 0 && UTF16.isLeadSurrogate(stringBuffer.charAt(n2 - 1))) {
                --n2;
                ++n4;
            }
        }
        stringBuffer.replace(n2, n2 + n4, UTF16.valueOf(n3));
    }

    public static int setCharAt(char[] cArray, int n2, int n3, int n4) {
        if (n3 >= n2) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
        int n5 = 1;
        char c2 = cArray[n3];
        if (UTF16.isSurrogate(c2)) {
            if (UTF16.isLeadSurrogate(c2) && cArray.length > n3 + 1 && UTF16.isTrailSurrogate(cArray[n3 + 1])) {
                ++n5;
            } else if (UTF16.isTrailSurrogate(c2) && n3 > 0 && UTF16.isLeadSurrogate(cArray[n3 - 1])) {
                --n3;
                ++n5;
            }
        }
        String string = UTF16.valueOf(n4);
        int n6 = n2;
        int n7 = string.length();
        cArray[n3] = string.charAt(0);
        if (n5 == n7) {
            if (n5 == 2) {
                cArray[n3 + 1] = string.charAt(1);
            }
        } else {
            System.arraycopy(cArray, n3 + n5, cArray, n3 + n7, n2 - (n3 + n5));
            if (n5 < n7) {
                cArray[n3 + 1] = string.charAt(1);
                if (++n6 < cArray.length) {
                    cArray[n6] = '\u0000';
                }
            } else {
                cArray[--n6] = '\u0000';
            }
        }
        return n6;
    }

    public static int moveCodePointOffset(String string, int n2, int n3) {
        int n4;
        int n5 = n2;
        int n6 = string.length();
        if (n2 < 0 || n2 > n6) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > 0) {
            if (n3 + n2 > n6) {
                throw new StringIndexOutOfBoundsException(n2);
            }
            for (n4 = n3; n5 < n6 && n4 > 0; --n4, ++n5) {
                char c2 = string.charAt(n5);
                if (!UTF16.isLeadSurrogate(c2) || n5 + 1 >= n6 || !UTF16.isTrailSurrogate(string.charAt(n5 + 1))) continue;
                ++n5;
            }
        } else {
            if (n2 + n3 < 0) {
                throw new StringIndexOutOfBoundsException(n2);
            }
            for (n4 = -n3; n4 > 0 && --n5 >= 0; --n4) {
                char c3 = string.charAt(n5);
                if (!UTF16.isTrailSurrogate(c3) || n5 <= 0 || !UTF16.isLeadSurrogate(string.charAt(n5 - 1))) continue;
                --n5;
            }
        }
        if (n4 != 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        return n5;
    }

    public static int moveCodePointOffset(StringBuffer stringBuffer, int n2, int n3) {
        int n4;
        int n5 = n2;
        int n6 = stringBuffer.length();
        if (n2 < 0 || n2 > n6) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > 0) {
            if (n3 + n2 > n6) {
                throw new StringIndexOutOfBoundsException(n2);
            }
            for (n4 = n3; n5 < n6 && n4 > 0; --n4, ++n5) {
                char c2 = stringBuffer.charAt(n5);
                if (!UTF16.isLeadSurrogate(c2) || n5 + 1 >= n6 || !UTF16.isTrailSurrogate(stringBuffer.charAt(n5 + 1))) continue;
                ++n5;
            }
        } else {
            if (n2 + n3 < 0) {
                throw new StringIndexOutOfBoundsException(n2);
            }
            for (n4 = -n3; n4 > 0 && --n5 >= 0; --n4) {
                char c3 = stringBuffer.charAt(n5);
                if (!UTF16.isTrailSurrogate(c3) || n5 <= 0 || !UTF16.isLeadSurrogate(stringBuffer.charAt(n5 - 1))) continue;
                --n5;
            }
        }
        if (n4 != 0) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        return n5;
    }

    public static int moveCodePointOffset(char[] cArray, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = cArray.length;
        int n8 = n4 + n2;
        if (n2 < 0 || n3 < n2) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > n7) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n4 < 0 || n8 > n3) {
            throw new StringIndexOutOfBoundsException(n4);
        }
        if (n5 > 0) {
            if (n5 + n8 > n7) {
                throw new StringIndexOutOfBoundsException(n8);
            }
            for (n6 = n5; n8 < n3 && n6 > 0; --n6, ++n8) {
                char c2 = cArray[n8];
                if (!UTF16.isLeadSurrogate(c2) || n8 + 1 >= n3 || !UTF16.isTrailSurrogate(cArray[n8 + 1])) continue;
                ++n8;
            }
        } else {
            if (n8 + n5 < n2) {
                throw new StringIndexOutOfBoundsException(n8);
            }
            for (n6 = -n5; n6 > 0 && --n8 >= n2; --n6) {
                char c3 = cArray[n8];
                if (!UTF16.isTrailSurrogate(c3) || n8 <= n2 || !UTF16.isLeadSurrogate(cArray[n8 - 1])) continue;
                --n8;
            }
        }
        if (n6 != 0) {
            throw new StringIndexOutOfBoundsException(n5);
        }
        return n8 -= n2;
    }

    public static StringBuffer insert(StringBuffer stringBuffer, int n2, int n3) {
        String string = UTF16.valueOf(n3);
        if (n2 != stringBuffer.length() && UTF16.bounds(stringBuffer, n2) == 5) {
            ++n2;
        }
        stringBuffer.insert(n2, string);
        return stringBuffer;
    }

    public static int insert(char[] cArray, int n2, int n3, int n4) {
        int n5;
        String string = UTF16.valueOf(n4);
        if (n3 != n2 && UTF16.bounds(cArray, 0, n2, n3) == 5) {
            ++n3;
        }
        if (n2 + (n5 = string.length()) > cArray.length) {
            throw new ArrayIndexOutOfBoundsException(n3 + n5);
        }
        System.arraycopy(cArray, n3, cArray, n3 + n5, n2 - n3);
        cArray[n3] = string.charAt(0);
        if (n5 == 2) {
            cArray[n3 + 1] = string.charAt(1);
        }
        return n2 + n5;
    }

    public static StringBuffer delete(StringBuffer stringBuffer, int n2) {
        int n3 = 1;
        switch (UTF16.bounds(stringBuffer, n2)) {
            case 2: {
                ++n3;
                break;
            }
            case 5: {
                ++n3;
                --n2;
            }
        }
        stringBuffer.delete(n2, n2 + n3);
        return stringBuffer;
    }

    public static int delete(char[] cArray, int n2, int n3) {
        int n4 = 1;
        switch (UTF16.bounds(cArray, 0, n2, n3)) {
            case 2: {
                ++n4;
                break;
            }
            case 5: {
                ++n4;
                --n3;
            }
        }
        System.arraycopy(cArray, n3 + n4, cArray, n3, n2 - (n3 + n4));
        cArray[n2 - n4] = '\u0000';
        return n2 - n4;
    }

    public static int indexOf(String string, int n2) {
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Argument char32 is not a valid codepoint");
        }
        if (n2 < 55296 || n2 > 57343 && n2 < 65536) {
            return string.indexOf((char)n2);
        }
        if (n2 < 65536) {
            int n3 = string.indexOf((char)n2);
            if (n3 >= 0) {
                if (UTF16.isLeadSurrogate(n2) && n3 < string.length() - 1 && UTF16.isTrailSurrogate(string.charAt(n3 + 1))) {
                    return UTF16.indexOf(string, n2, n3 + 1);
                }
                if (n3 > 0 && UTF16.isLeadSurrogate(string.charAt(n3 - 1))) {
                    return UTF16.indexOf(string, n2, n3 + 1);
                }
            }
            return n3;
        }
        String string2 = UTF16.toString(n2);
        return string.indexOf(string2);
    }

    public static int indexOf(String string, String string2) {
        int n2 = string2.length();
        if (!UTF16.isTrailSurrogate(string2.charAt(0)) && !UTF16.isLeadSurrogate(string2.charAt(n2 - 1))) {
            return string.indexOf(string2);
        }
        int n3 = string.indexOf(string2);
        int n4 = n3 + n2;
        if (n3 >= 0) {
            if (UTF16.isLeadSurrogate(string2.charAt(n2 - 1)) && n3 < string.length() - 1 && UTF16.isTrailSurrogate(string.charAt(n4 + 1))) {
                return UTF16.indexOf(string, string2, n4 + 1);
            }
            if (UTF16.isTrailSurrogate(string2.charAt(0)) && n3 > 0 && UTF16.isLeadSurrogate(string.charAt(n3 - 1))) {
                return UTF16.indexOf(string, string2, n4 + 1);
            }
        }
        return n3;
    }

    public static int indexOf(String string, int n2, int n3) {
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Argument char32 is not a valid codepoint");
        }
        if (n2 < 55296 || n2 > 57343 && n2 < 65536) {
            return string.indexOf((char)n2, n3);
        }
        if (n2 < 65536) {
            int n4 = string.indexOf((char)n2, n3);
            if (n4 >= 0) {
                if (UTF16.isLeadSurrogate(n2) && n4 < string.length() - 1 && UTF16.isTrailSurrogate(string.charAt(n4 + 1))) {
                    return UTF16.indexOf(string, n2, n4 + 1);
                }
                if (n4 > 0 && UTF16.isLeadSurrogate(string.charAt(n4 - 1))) {
                    return UTF16.indexOf(string, n2, n4 + 1);
                }
            }
            return n4;
        }
        String string2 = UTF16.toString(n2);
        return string.indexOf(string2, n3);
    }

    public static int indexOf(String string, String string2, int n2) {
        int n3 = string2.length();
        if (!UTF16.isTrailSurrogate(string2.charAt(0)) && !UTF16.isLeadSurrogate(string2.charAt(n3 - 1))) {
            return string.indexOf(string2, n2);
        }
        int n4 = string.indexOf(string2, n2);
        int n5 = n4 + n3;
        if (n4 >= 0) {
            if (UTF16.isLeadSurrogate(string2.charAt(n3 - 1)) && n4 < string.length() - 1 && UTF16.isTrailSurrogate(string.charAt(n5))) {
                return UTF16.indexOf(string, string2, n5 + 1);
            }
            if (UTF16.isTrailSurrogate(string2.charAt(0)) && n4 > 0 && UTF16.isLeadSurrogate(string.charAt(n4 - 1))) {
                return UTF16.indexOf(string, string2, n5 + 1);
            }
        }
        return n4;
    }

    public static int lastIndexOf(String string, int n2) {
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Argument char32 is not a valid codepoint");
        }
        if (n2 < 55296 || n2 > 57343 && n2 < 65536) {
            return string.lastIndexOf((char)n2);
        }
        if (n2 < 65536) {
            int n3 = string.lastIndexOf((char)n2);
            if (n3 >= 0) {
                if (UTF16.isLeadSurrogate(n2) && n3 < string.length() - 1 && UTF16.isTrailSurrogate(string.charAt(n3 + 1))) {
                    return UTF16.lastIndexOf(string, n2, n3 - 1);
                }
                if (n3 > 0 && UTF16.isLeadSurrogate(string.charAt(n3 - 1))) {
                    return UTF16.lastIndexOf(string, n2, n3 - 1);
                }
            }
            return n3;
        }
        String string2 = UTF16.toString(n2);
        return string.lastIndexOf(string2);
    }

    public static int lastIndexOf(String string, String string2) {
        int n2 = string2.length();
        if (!UTF16.isTrailSurrogate(string2.charAt(0)) && !UTF16.isLeadSurrogate(string2.charAt(n2 - 1))) {
            return string.lastIndexOf(string2);
        }
        int n3 = string.lastIndexOf(string2);
        if (n3 >= 0) {
            if (UTF16.isLeadSurrogate(string2.charAt(n2 - 1)) && n3 < string.length() - 1 && UTF16.isTrailSurrogate(string.charAt(n3 + n2 + 1))) {
                return UTF16.lastIndexOf(string, string2, n3 - 1);
            }
            if (UTF16.isTrailSurrogate(string2.charAt(0)) && n3 > 0 && UTF16.isLeadSurrogate(string.charAt(n3 - 1))) {
                return UTF16.lastIndexOf(string, string2, n3 - 1);
            }
        }
        return n3;
    }

    public static int lastIndexOf(String string, int n2, int n3) {
        if (n2 < 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Argument char32 is not a valid codepoint");
        }
        if (n2 < 55296 || n2 > 57343 && n2 < 65536) {
            return string.lastIndexOf((char)n2, n3);
        }
        if (n2 < 65536) {
            int n4 = string.lastIndexOf((char)n2, n3);
            if (n4 >= 0) {
                if (UTF16.isLeadSurrogate(n2) && n4 < string.length() - 1 && UTF16.isTrailSurrogate(string.charAt(n4 + 1))) {
                    return UTF16.lastIndexOf(string, n2, n4 - 1);
                }
                if (n4 > 0 && UTF16.isLeadSurrogate(string.charAt(n4 - 1))) {
                    return UTF16.lastIndexOf(string, n2, n4 - 1);
                }
            }
            return n4;
        }
        String string2 = UTF16.toString(n2);
        return string.lastIndexOf(string2, n3);
    }

    public static int lastIndexOf(String string, String string2, int n2) {
        int n3 = string2.length();
        if (!UTF16.isTrailSurrogate(string2.charAt(0)) && !UTF16.isLeadSurrogate(string2.charAt(n3 - 1))) {
            return string.lastIndexOf(string2, n2);
        }
        int n4 = string.lastIndexOf(string2, n2);
        if (n4 >= 0) {
            if (UTF16.isLeadSurrogate(string2.charAt(n3 - 1)) && n4 < string.length() - 1 && UTF16.isTrailSurrogate(string.charAt(n4 + n3))) {
                return UTF16.lastIndexOf(string, string2, n4 - 1);
            }
            if (UTF16.isTrailSurrogate(string2.charAt(0)) && n4 > 0 && UTF16.isLeadSurrogate(string.charAt(n4 - 1))) {
                return UTF16.lastIndexOf(string, string2, n4 - 1);
            }
        }
        return n4;
    }

    public static String replace(String string, int n2, int n3) {
        if (n2 <= 0 || n2 > 0x10FFFF) {
            throw new IllegalArgumentException("Argument oldChar32 is not a valid codepoint");
        }
        if (n3 <= 0 || n3 > 0x10FFFF) {
            throw new IllegalArgumentException("Argument newChar32 is not a valid codepoint");
        }
        int n4 = UTF16.indexOf(string, n2);
        if (n4 == -1) {
            return string;
        }
        String string2 = UTF16.toString(n3);
        int n5 = 1;
        int n6 = string2.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        int n7 = n4;
        if (n2 >= 65536) {
            n5 = 2;
        }
        while (n4 != -1) {
            int n8 = n7 + n5;
            stringBuffer.replace(n7, n8, string2);
            int n9 = n4 + n5;
            n4 = UTF16.indexOf(string, n2, n9);
            n7 += n6 + n4 - n9;
        }
        return stringBuffer.toString();
    }

    public static String replace(String string, String string2, String string3) {
        int n2 = UTF16.indexOf(string, string2);
        if (n2 == -1) {
            return string;
        }
        int n3 = string2.length();
        int n4 = string3.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        int n5 = n2;
        while (n2 != -1) {
            int n6 = n5 + n3;
            stringBuffer.replace(n5, n6, string3);
            int n7 = n2 + n3;
            n2 = UTF16.indexOf(string, string2, n7);
            n5 += n4 + n2 - n7;
        }
        return stringBuffer.toString();
    }

    public static StringBuffer reverse(StringBuffer stringBuffer) {
        int n2 = stringBuffer.length();
        StringBuffer stringBuffer2 = new StringBuffer(n2);
        int n3 = n2;
        while (n3-- > 0) {
            char c2;
            char c3 = stringBuffer.charAt(n3);
            if (UTF16.isTrailSurrogate(c3) && n3 > 0 && UTF16.isLeadSurrogate(c2 = stringBuffer.charAt(n3 - 1))) {
                stringBuffer2.append(c2);
                stringBuffer2.append(c3);
                --n3;
                continue;
            }
            stringBuffer2.append(c3);
        }
        return stringBuffer2;
    }

    public static boolean hasMoreCodePointsThan(String string, int n2) {
        if (n2 < 0) {
            return true;
        }
        if (string == null) {
            return false;
        }
        int n3 = string.length();
        if (n3 + 1 >> 1 > n2) {
            return true;
        }
        int n4 = n3 - n2;
        if (n4 <= 0) {
            return false;
        }
        int n5 = 0;
        while (n3 != 0) {
            if (n2 == 0) {
                return true;
            }
            if (UTF16.isLeadSurrogate(string.charAt(n5++)) && n5 != n3 && UTF16.isTrailSurrogate(string.charAt(n5))) {
                ++n5;
                if (--n4 <= 0) {
                    return false;
                }
            }
            --n2;
        }
        return false;
    }

    public static boolean hasMoreCodePointsThan(char[] cArray, int n2, int n3, int n4) {
        int n5 = n3 - n2;
        if (n5 < 0 || n2 < 0 || n3 < 0) {
            throw new IndexOutOfBoundsException("Start and limit indexes should be non-negative and start <= limit");
        }
        if (n4 < 0) {
            return true;
        }
        if (cArray == null) {
            return false;
        }
        if (n5 + 1 >> 1 > n4) {
            return true;
        }
        int n6 = n5 - n4;
        if (n6 <= 0) {
            return false;
        }
        while (n5 != 0) {
            if (n4 == 0) {
                return true;
            }
            if (UTF16.isLeadSurrogate(cArray[n2++]) && n2 != n3 && UTF16.isTrailSurrogate(cArray[n2])) {
                ++n2;
                if (--n6 <= 0) {
                    return false;
                }
            }
            --n4;
        }
        return false;
    }

    public static boolean hasMoreCodePointsThan(StringBuffer stringBuffer, int n2) {
        if (n2 < 0) {
            return true;
        }
        if (stringBuffer == null) {
            return false;
        }
        int n3 = stringBuffer.length();
        if (n3 + 1 >> 1 > n2) {
            return true;
        }
        int n4 = n3 - n2;
        if (n4 <= 0) {
            return false;
        }
        int n5 = 0;
        while (n3 != 0) {
            if (n2 == 0) {
                return true;
            }
            if (UTF16.isLeadSurrogate(stringBuffer.charAt(n5++)) && n5 != n3 && UTF16.isTrailSurrogate(stringBuffer.charAt(n5))) {
                ++n5;
                if (--n4 <= 0) {
                    return false;
                }
            }
            --n2;
        }
        return false;
    }

    public static String newString(int[] nArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException();
        }
        char[] cArray = new char[n3];
        int n4 = 0;
        int n5 = n2 + n3;
        block2: for (int i2 = n2; i2 < n5; ++i2) {
            int n6 = nArray[i2];
            if (n6 < 0 || n6 > 0x10FFFF) {
                throw new IllegalArgumentException();
            }
            while (true) {
                try {
                    if (n6 < 65536) {
                        cArray[n4] = (char)n6;
                        ++n4;
                        continue block2;
                    }
                    cArray[n4] = (char)(55232 + (n6 >> 10));
                    cArray[n4 + 1] = (char)(56320 + (n6 & 0x3FF));
                    n4 += 2;
                    continue block2;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    int n7 = (int)Math.ceil((double)nArray.length * (double)(n4 + 2) / (double)(i2 - n2 + 1));
                    char[] cArray2 = new char[n7];
                    System.arraycopy(cArray, 0, cArray2, 0, n4);
                    cArray = cArray2;
                    continue;
                }
                break;
            }
        }
        return new String(cArray, 0, n4);
    }

    public static int getSingleCodePoint(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0) {
            return -1;
        }
        if (charSequence.length() == 1) {
            return charSequence.charAt(0);
        }
        if (charSequence.length() > 2) {
            return -1;
        }
        int n2 = Character.codePointAt(charSequence, 0);
        if (n2 > 65535) {
            return n2;
        }
        return -1;
    }

    public static int compareCodePoint(int n2, CharSequence charSequence) {
        if (charSequence == null) {
            return 1;
        }
        int n3 = charSequence.length();
        if (n3 == 0) {
            return 1;
        }
        int n4 = Character.codePointAt(charSequence, 0);
        int n5 = n2 - n4;
        if (n5 != 0) {
            return n5;
        }
        return n3 == Character.charCount(n2) ? 0 : -1;
    }

    private static String toString(int n2) {
        if (n2 < 65536) {
            return String.valueOf((char)n2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(UTF16.getLeadSurrogate(n2));
        stringBuilder.append(UTF16.getTrailSurrogate(n2));
        return stringBuilder.toString();
    }

    public static final class StringComparator
    implements Comparator<String> {
        public static final int FOLD_CASE_DEFAULT = 0;
        public static final int FOLD_CASE_EXCLUDE_SPECIAL_I = 1;
        private int m_codePointCompare_;
        private int m_foldCase_;
        private boolean m_ignoreCase_;
        private static final int CODE_POINT_COMPARE_SURROGATE_OFFSET_ = 10240;

        public StringComparator() {
            this(false, false, 0);
        }

        public StringComparator(boolean bl2, boolean bl3, int n2) {
            this.setCodePointCompare(bl2);
            this.m_ignoreCase_ = bl3;
            if (n2 < 0 || n2 > 1) {
                throw new IllegalArgumentException("Invalid fold case option");
            }
            this.m_foldCase_ = n2;
        }

        public void setCodePointCompare(boolean bl2) {
            this.m_codePointCompare_ = bl2 ? 32768 : 0;
        }

        public void setIgnoreCase(boolean bl2, int n2) {
            this.m_ignoreCase_ = bl2;
            if (n2 < 0 || n2 > 1) {
                throw new IllegalArgumentException("Invalid fold case option");
            }
            this.m_foldCase_ = n2;
        }

        public boolean getCodePointCompare() {
            return this.m_codePointCompare_ == 32768;
        }

        public boolean getIgnoreCase() {
            return this.m_ignoreCase_;
        }

        public int getIgnoreCaseOption() {
            return this.m_foldCase_;
        }

        @Override
        public int compare(String string, String string2) {
            if (Utility.sameObjects(string, string2)) {
                return 0;
            }
            if (string == null) {
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            if (this.m_ignoreCase_) {
                return this.compareCaseInsensitive(string, string2);
            }
            return this.compareCaseSensitive(string, string2);
        }

        private int compareCaseInsensitive(String string, String string2) {
            return Normalizer.cmpEquivFold(string, string2, this.m_foldCase_ | this.m_codePointCompare_ | 0x10000);
        }

        private int compareCaseSensitive(String string, String string2) {
            boolean bl2;
            int n2;
            int n3 = string.length();
            int n4 = string2.length();
            int n5 = n3;
            int n6 = 0;
            if (n3 < n4) {
                n6 = -1;
            } else if (n3 > n4) {
                n6 = 1;
                n5 = n4;
            }
            char c2 = '\u0000';
            char c3 = '\u0000';
            for (n2 = 0; n2 < n5 && (c2 = string.charAt(n2)) == (c3 = string2.charAt(n2)); ++n2) {
            }
            if (n2 == n5) {
                return n6;
            }
            boolean bl3 = bl2 = this.m_codePointCompare_ == 32768;
            if (c2 >= '\ud800' && c3 >= '\ud800' && bl2) {
                if (!(c2 <= '\udbff' && n2 + 1 != n3 && UTF16.isTrailSurrogate(string.charAt(n2 + 1)) || UTF16.isTrailSurrogate(c2) && n2 != 0 && UTF16.isLeadSurrogate(string.charAt(n2 - 1)))) {
                    c2 = (char)(c2 - 10240);
                }
                if (!(c3 <= '\udbff' && n2 + 1 != n4 && UTF16.isTrailSurrogate(string2.charAt(n2 + 1)) || UTF16.isTrailSurrogate(c3) && n2 != 0 && UTF16.isLeadSurrogate(string2.charAt(n2 - 1)))) {
                    c3 = (char)(c3 - 10240);
                }
            }
            return c2 - c3;
        }
    }
}

