/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.LocaleUtility;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UScript;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.AnyTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CompoundTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RuleBasedTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Transliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.TransliteratorIDParser;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.TransliteratorParser;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CaseInsensitiveString;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

class TransliteratorRegistry {
    private static final char LOCALE_SEP = '_';
    private static final String NO_VARIANT = "";
    private static final String ANY = "Any";
    private Map<CaseInsensitiveString, Object[]> registry = Collections.synchronizedMap(new HashMap());
    private Map<CaseInsensitiveString, Map<CaseInsensitiveString, List<CaseInsensitiveString>>> specDAG = Collections.synchronizedMap(new HashMap());
    private final Set<CaseInsensitiveString> availableIDs = new LinkedHashSet<CaseInsensitiveString>();
    private static final boolean DEBUG = false;

    public Transliterator get(String string, StringBuffer stringBuffer) {
        Object[] objectArray = this.find(string);
        return objectArray == null ? null : this.instantiateEntry(string, objectArray, stringBuffer);
    }

    public void put(String string, Class<? extends Transliterator> clazz, boolean bl2) {
        this.registerEntry(string, clazz, bl2);
    }

    public void put(String string, Transliterator.Factory factory, boolean bl2) {
        this.registerEntry(string, factory, bl2);
    }

    public void put(String string, String string2, int n2, boolean bl2) {
        this.registerEntry(string, new ResourceEntry(string2, n2), bl2);
    }

    public void put(String string, String string2, boolean bl2) {
        this.registerEntry(string, new AliasEntry(string2), bl2);
    }

    public void put(String string, Transliterator transliterator, boolean bl2) {
        this.registerEntry(string, transliterator, bl2);
    }

    public void remove(String string) {
        String[] stringArray = TransliteratorIDParser.IDtoSTV(string);
        String string2 = TransliteratorIDParser.STVtoID(stringArray[0], stringArray[1], stringArray[2]);
        this.registry.remove(new CaseInsensitiveString(string2));
        this.removeSTV(stringArray[0], stringArray[1], stringArray[2]);
        this.availableIDs.remove(new CaseInsensitiveString(string2));
    }

    public Enumeration<String> getAvailableIDs() {
        return new IDEnumeration(Collections.enumeration(this.availableIDs));
    }

    public Enumeration<String> getAvailableSources() {
        return new IDEnumeration(Collections.enumeration(this.specDAG.keySet()));
    }

    public Enumeration<String> getAvailableTargets(String string) {
        CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(string);
        Map<CaseInsensitiveString, List<CaseInsensitiveString>> map = this.specDAG.get(caseInsensitiveString);
        if (map == null) {
            return new IDEnumeration(null);
        }
        return new IDEnumeration(Collections.enumeration(map.keySet()));
    }

    public Enumeration<String> getAvailableVariants(String string, String string2) {
        CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(string);
        CaseInsensitiveString caseInsensitiveString2 = new CaseInsensitiveString(string2);
        Map<CaseInsensitiveString, List<CaseInsensitiveString>> map = this.specDAG.get(caseInsensitiveString);
        if (map == null) {
            return new IDEnumeration(null);
        }
        List<CaseInsensitiveString> list = map.get(caseInsensitiveString2);
        if (list == null) {
            return new IDEnumeration(null);
        }
        return new IDEnumeration(Collections.enumeration(list));
    }

    private void registerEntry(String string, String string2, String string3, Object object, boolean bl2) {
        String string4 = string;
        if (string4.length() == 0) {
            string4 = ANY;
        }
        String string5 = TransliteratorIDParser.STVtoID(string, string2, string3);
        this.registerEntry(string5, string4, string2, string3, object, bl2);
    }

    private void registerEntry(String string, Object object, boolean bl2) {
        String[] stringArray = TransliteratorIDParser.IDtoSTV(string);
        String string2 = TransliteratorIDParser.STVtoID(stringArray[0], stringArray[1], stringArray[2]);
        this.registerEntry(string2, stringArray[0], stringArray[1], stringArray[2], object, bl2);
    }

    private void registerEntry(String string, String string2, String string3, String string4, Object object, boolean bl2) {
        CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(string);
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        this.registry.put(caseInsensitiveString, objectArray);
        if (bl2) {
            this.registerSTV(string2, string3, string4);
            this.availableIDs.add(caseInsensitiveString);
        } else {
            this.removeSTV(string2, string3, string4);
            this.availableIDs.remove(caseInsensitiveString);
        }
    }

    private void registerSTV(String string, String string2, String string3) {
        List<CaseInsensitiveString> list;
        CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(string);
        CaseInsensitiveString caseInsensitiveString2 = new CaseInsensitiveString(string2);
        CaseInsensitiveString caseInsensitiveString3 = new CaseInsensitiveString(string3);
        Map<CaseInsensitiveString, List<CaseInsensitiveString>> map = this.specDAG.get(caseInsensitiveString);
        if (map == null) {
            map = Collections.synchronizedMap(new HashMap());
            this.specDAG.put(caseInsensitiveString, map);
        }
        if ((list = map.get(caseInsensitiveString2)) == null) {
            list = new ArrayList<CaseInsensitiveString>();
            map.put(caseInsensitiveString2, list);
        }
        if (!list.contains(caseInsensitiveString3)) {
            if (string3.length() > 0) {
                list.add(caseInsensitiveString3);
            } else {
                list.add(0, caseInsensitiveString3);
            }
        }
    }

    private void removeSTV(String string, String string2, String string3) {
        CaseInsensitiveString caseInsensitiveString = new CaseInsensitiveString(string);
        CaseInsensitiveString caseInsensitiveString2 = new CaseInsensitiveString(string2);
        CaseInsensitiveString caseInsensitiveString3 = new CaseInsensitiveString(string3);
        Map<CaseInsensitiveString, List<CaseInsensitiveString>> map = this.specDAG.get(caseInsensitiveString);
        if (map == null) {
            return;
        }
        List<CaseInsensitiveString> list = map.get(caseInsensitiveString2);
        if (list == null) {
            return;
        }
        list.remove(caseInsensitiveString3);
        if (list.size() == 0) {
            map.remove(caseInsensitiveString2);
            if (map.size() == 0) {
                this.specDAG.remove(caseInsensitiveString);
            }
        }
    }

    private Object[] findInDynamicStore(Spec spec, Spec spec2, String string) {
        String string2 = TransliteratorIDParser.STVtoID(spec.get(), spec2.get(), string);
        return this.registry.get(new CaseInsensitiveString(string2));
    }

    private Object[] findInStaticStore(Spec spec, Spec spec2, String string) {
        Object[] objectArray = null;
        if (spec.isLocale()) {
            objectArray = this.findInBundle(spec, spec2, string, 0);
        } else if (spec2.isLocale()) {
            objectArray = this.findInBundle(spec2, spec, string, 1);
        }
        if (objectArray != null) {
            this.registerEntry(spec.getTop(), spec2.getTop(), string, objectArray, false);
        }
        return objectArray;
    }

    private Object[] findInBundle(Spec spec, Spec spec2, String string, int n2) {
        ResourceBundle resourceBundle = spec.getBundle();
        if (resourceBundle == null) {
            return null;
        }
        for (int i2 = 0; i2 < 2; ++i2) {
            StringBuilder stringBuilder = new StringBuilder();
            if (i2 == 0) {
                stringBuilder.append(n2 == 0 ? "TransliterateTo" : "TransliterateFrom");
            } else {
                stringBuilder.append("Transliterate");
            }
            stringBuilder.append(spec2.get().toUpperCase(Locale.ENGLISH));
            try {
                String[] stringArray = resourceBundle.getStringArray(stringBuilder.toString());
                int n3 = 0;
                if (string.length() != 0) {
                    for (n3 = 0; n3 < stringArray.length && !stringArray[n3].equalsIgnoreCase(string); n3 += 2) {
                    }
                }
                if (n3 >= stringArray.length) continue;
                int n4 = i2 == 0 ? 0 : n2;
                return new Object[]{new LocaleEntry(stringArray[n3 + 1], n4)};
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }

    private Object[] find(String string) {
        String[] stringArray = TransliteratorIDParser.IDtoSTV(string);
        return this.find(stringArray[0], stringArray[1], stringArray[2]);
    }

    private Object[] find(String string, String string2, String string3) {
        Spec spec = new Spec(string);
        Spec spec2 = new Spec(string2);
        Object[] objectArray = null;
        if (string3.length() != 0) {
            objectArray = this.findInDynamicStore(spec, spec2, string3);
            if (objectArray != null) {
                return objectArray;
            }
            objectArray = this.findInStaticStore(spec, spec2, string3);
            if (objectArray != null) {
                return objectArray;
            }
        }
        while (true) {
            spec.reset();
            while (true) {
                if ((objectArray = this.findInDynamicStore(spec, spec2, NO_VARIANT)) != null) {
                    return objectArray;
                }
                objectArray = this.findInStaticStore(spec, spec2, NO_VARIANT);
                if (objectArray != null) {
                    return objectArray;
                }
                if (!spec.hasFallback()) break;
                spec.next();
            }
            if (!spec2.hasFallback()) break;
            spec2.next();
        }
        return null;
    }

    private Transliterator instantiateEntry(String string, Object[] objectArray, StringBuffer stringBuffer) {
        while (true) {
            Object object;
            Object object2;
            if ((object2 = objectArray[0]) instanceof RuleBasedTransliterator.Data) {
                object = (RuleBasedTransliterator.Data)object2;
                return new RuleBasedTransliterator(string, (RuleBasedTransliterator.Data)object, null);
            }
            if (object2 instanceof Class) {
                try {
                    return (Transliterator)((Class)object2).newInstance();
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                return null;
            }
            if (object2 instanceof AliasEntry) {
                stringBuffer.append(((AliasEntry)object2).alias);
                return null;
            }
            if (object2 instanceof Transliterator.Factory) {
                return ((Transliterator.Factory)object2).getInstance(string);
            }
            if (object2 instanceof CompoundRBTEntry) {
                return ((CompoundRBTEntry)object2).getInstance();
            }
            if (object2 instanceof AnyTransliterator) {
                object = (AnyTransliterator)object2;
                return ((AnyTransliterator)object).safeClone();
            }
            if (object2 instanceof RuleBasedTransliterator) {
                object = (RuleBasedTransliterator)object2;
                return ((RuleBasedTransliterator)object).safeClone();
            }
            if (object2 instanceof CompoundTransliterator) {
                object = (CompoundTransliterator)object2;
                return ((CompoundTransliterator)object).safeClone();
            }
            if (object2 instanceof Transliterator) {
                return (Transliterator)object2;
            }
            object = new TransliteratorParser();
            try {
                ResourceEntry resourceEntry = (ResourceEntry)object2;
                ((TransliteratorParser)object).parse(resourceEntry.resource, resourceEntry.direction);
            }
            catch (ClassCastException classCastException) {
                LocaleEntry localeEntry = (LocaleEntry)object2;
                ((TransliteratorParser)object).parse(localeEntry.rule, localeEntry.direction);
            }
            if (((TransliteratorParser)object).idBlockVector.size() == 0 && ((TransliteratorParser)object).dataVector.size() == 0) {
                objectArray[0] = new AliasEntry("Any-Null");
                continue;
            }
            if (((TransliteratorParser)object).idBlockVector.size() == 0 && ((TransliteratorParser)object).dataVector.size() == 1) {
                objectArray[0] = ((TransliteratorParser)object).dataVector.get(0);
                continue;
            }
            if (((TransliteratorParser)object).idBlockVector.size() == 1 && ((TransliteratorParser)object).dataVector.size() == 0) {
                if (((TransliteratorParser)object).compoundFilter != null) {
                    objectArray[0] = new AliasEntry(((TransliteratorParser)object).compoundFilter.toPattern(false) + ";" + ((TransliteratorParser)object).idBlockVector.get(0));
                    continue;
                }
                objectArray[0] = new AliasEntry(((TransliteratorParser)object).idBlockVector.get(0));
                continue;
            }
            objectArray[0] = new CompoundRBTEntry(string, ((TransliteratorParser)object).idBlockVector, ((TransliteratorParser)object).dataVector, ((TransliteratorParser)object).compoundFilter);
        }
    }

    private static class IDEnumeration
    implements Enumeration<String> {
        Enumeration<CaseInsensitiveString> en;

        public IDEnumeration(Enumeration<CaseInsensitiveString> enumeration) {
            this.en = enumeration;
        }

        @Override
        public boolean hasMoreElements() {
            return this.en != null && this.en.hasMoreElements();
        }

        @Override
        public String nextElement() {
            return this.en.nextElement().getString();
        }
    }

    static class CompoundRBTEntry {
        private String ID;
        private List<String> idBlockVector;
        private List<RuleBasedTransliterator.Data> dataVector;
        private UnicodeSet compoundFilter;

        public CompoundRBTEntry(String string, List<String> list, List<RuleBasedTransliterator.Data> list2, UnicodeSet unicodeSet) {
            this.ID = string;
            this.idBlockVector = list;
            this.dataVector = list2;
            this.compoundFilter = unicodeSet;
        }

        public Transliterator getInstance() {
            ArrayList<Transliterator> arrayList = new ArrayList<Transliterator>();
            int n2 = 1;
            int n3 = Math.max(this.idBlockVector.size(), this.dataVector.size());
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object;
                if (i2 < this.idBlockVector.size() && ((String)(object = this.idBlockVector.get(i2))).length() > 0) {
                    arrayList.add(Transliterator.getInstance((String)object));
                }
                if (i2 >= this.dataVector.size()) continue;
                object = this.dataVector.get(i2);
                arrayList.add(new RuleBasedTransliterator("%Pass" + n2++, (RuleBasedTransliterator.Data)object, null));
            }
            CompoundTransliterator compoundTransliterator = new CompoundTransliterator(arrayList, n2 - 1);
            compoundTransliterator.setID(this.ID);
            if (this.compoundFilter != null) {
                compoundTransliterator.setFilter(this.compoundFilter);
            }
            return compoundTransliterator;
        }
    }

    static class AliasEntry {
        public String alias;

        public AliasEntry(String string) {
            this.alias = string;
        }
    }

    static class LocaleEntry {
        public String rule;
        public int direction;

        public LocaleEntry(String string, int n2) {
            this.rule = string;
            this.direction = n2;
        }
    }

    static class ResourceEntry {
        public String resource;
        public int direction;

        public ResourceEntry(String string, int n2) {
            this.resource = string;
            this.direction = n2;
        }
    }

    static class Spec {
        private String top;
        private String spec;
        private String nextSpec;
        private String scriptName;
        private boolean isSpecLocale;
        private boolean isNextLocale;
        private ICUResourceBundle res;

        public Spec(String string) {
            this.top = string;
            this.spec = null;
            this.scriptName = null;
            try {
                int n2 = UScript.getCodeFromName(this.top);
                int[] nArray = UScript.getCode(this.top);
                if (nArray != null) {
                    this.scriptName = UScript.getName(nArray[0]);
                    if (this.scriptName.equalsIgnoreCase(this.top)) {
                        this.scriptName = null;
                    }
                }
                this.isSpecLocale = false;
                this.res = null;
                if (n2 == -1) {
                    Locale locale = LocaleUtility.getLocaleFromName(this.top);
                    this.res = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/translit", locale);
                    if (this.res != null && LocaleUtility.isFallbackOf(this.res.getULocale().toString(), this.top)) {
                        this.isSpecLocale = true;
                    }
                }
            }
            catch (MissingResourceException missingResourceException) {
                this.scriptName = null;
            }
            this.reset();
        }

        public boolean hasFallback() {
            return this.nextSpec != null;
        }

        public void reset() {
            if (!Utility.sameObjects(this.spec, this.top)) {
                this.spec = this.top;
                this.isSpecLocale = this.res != null;
                this.setupNext();
            }
        }

        private void setupNext() {
            this.isNextLocale = false;
            if (this.isSpecLocale) {
                this.nextSpec = this.spec;
                int n2 = this.nextSpec.lastIndexOf(95);
                if (n2 > 0) {
                    this.nextSpec = this.spec.substring(0, n2);
                    this.isNextLocale = true;
                } else {
                    this.nextSpec = this.scriptName;
                }
            } else {
                this.nextSpec = !Utility.sameObjects(this.nextSpec, this.scriptName) ? this.scriptName : null;
            }
        }

        public String next() {
            this.spec = this.nextSpec;
            this.isSpecLocale = this.isNextLocale;
            this.setupNext();
            return this.spec;
        }

        public String get() {
            return this.spec;
        }

        public boolean isLocale() {
            return this.isSpecLocale;
        }

        public ResourceBundle getBundle() {
            if (this.res != null && this.res.getULocale().toString().equals(this.spec)) {
                return this.res;
            }
            return null;
        }

        public String getTop() {
            return this.top;
        }
    }
}

