/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RuleBasedTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeReplacer;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class StringReplacer
implements UnicodeReplacer {
    private String output;
    private int cursorPos;
    private boolean hasCursor;
    private boolean isComplex;
    private final RuleBasedTransliterator.Data data;

    public StringReplacer(String string, int n2, RuleBasedTransliterator.Data data) {
        this.output = string;
        this.cursorPos = n2;
        this.hasCursor = true;
        this.data = data;
        this.isComplex = true;
    }

    public StringReplacer(String string, RuleBasedTransliterator.Data data) {
        this.output = string;
        this.cursorPos = 0;
        this.hasCursor = false;
        this.data = data;
        this.isComplex = true;
    }

    @Override
    public int replace(Replaceable replaceable, int n2, int n3, int[] nArray) {
        int n4;
        int n5 = 0;
        if (!this.isComplex) {
            replaceable.replace(n2, n3, this.output);
            n4 = this.output.length();
            n5 = this.cursorPos;
        } else {
            int n6;
            int n7;
            StringBuffer stringBuffer = new StringBuffer();
            this.isComplex = false;
            int n8 = n7 = replaceable.length();
            if (n2 > 0) {
                n6 = UTF16.getCharCount(replaceable.char32At(n2 - 1));
                replaceable.copy(n2 - n6, n2, n7);
                n8 += n6;
            } else {
                replaceable.replace(n7, n7, "\uffff");
                ++n8;
            }
            n6 = n8;
            int n9 = 0;
            int n10 = 0;
            while (n10 < this.output.length()) {
                UnicodeReplacer unicodeReplacer;
                int n11;
                int n12;
                if (n10 == this.cursorPos) {
                    n5 = stringBuffer.length() + n6 - n8;
                }
                if ((n12 = n10 + UTF16.getCharCount(n11 = UTF16.charAt(this.output, n10))) == this.output.length()) {
                    n9 = UTF16.getCharCount(replaceable.char32At(n3));
                    replaceable.copy(n3, n3 + n9, n6);
                }
                if ((unicodeReplacer = this.data.lookupReplacer(n11)) == null) {
                    UTF16.append(stringBuffer, n11);
                } else {
                    this.isComplex = true;
                    if (stringBuffer.length() > 0) {
                        replaceable.replace(n6, n6, stringBuffer.toString());
                        n6 += stringBuffer.length();
                        stringBuffer.setLength(0);
                    }
                    int n13 = unicodeReplacer.replace(replaceable, n6, n6, nArray);
                    n6 += n13;
                }
                n10 = n12;
            }
            if (stringBuffer.length() > 0) {
                replaceable.replace(n6, n6, stringBuffer.toString());
                n6 += stringBuffer.length();
            }
            if (n10 == this.cursorPos) {
                n5 = n6 - n8;
            }
            n4 = n6 - n8;
            replaceable.copy(n8, n6, n2);
            replaceable.replace(n7 + n4, n6 + n9 + n4, "");
            replaceable.replace(n2 + n4, n3 + n4, "");
        }
        if (this.hasCursor) {
            if (this.cursorPos < 0) {
                int n14;
                n5 = n2;
                for (n14 = this.cursorPos; n14 < 0 && n5 > 0; n5 -= UTF16.getCharCount(replaceable.char32At(n5 - 1)), ++n14) {
                }
                n5 += n14;
            } else if (this.cursorPos > this.output.length()) {
                int n15;
                n5 = n2 + n4;
                for (n15 = this.cursorPos - this.output.length(); n15 > 0 && n5 < replaceable.length(); n5 += UTF16.getCharCount(replaceable.char32At(n5)), --n15) {
                }
                n5 += n15;
            } else {
                n5 += n2;
            }
            nArray[0] = n5;
        }
        return n4;
    }

    @Override
    public String toReplacerPattern(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = this.cursorPos;
        if (this.hasCursor && n2 < 0) {
            while (n2++ < 0) {
                Utility.appendToRule(stringBuffer, 64, true, bl2, stringBuffer2);
            }
        }
        for (int i2 = 0; i2 < this.output.length(); ++i2) {
            char c2;
            UnicodeReplacer unicodeReplacer;
            if (this.hasCursor && i2 == n2) {
                Utility.appendToRule(stringBuffer, 124, true, bl2, stringBuffer2);
            }
            if ((unicodeReplacer = this.data.lookupReplacer(c2 = this.output.charAt(i2))) == null) {
                Utility.appendToRule(stringBuffer, c2, false, bl2, stringBuffer2);
                continue;
            }
            StringBuffer stringBuffer3 = new StringBuffer(" ");
            stringBuffer3.append(unicodeReplacer.toReplacerPattern(bl2));
            stringBuffer3.append(' ');
            Utility.appendToRule(stringBuffer, stringBuffer3.toString(), true, bl2, stringBuffer2);
        }
        if (this.hasCursor && n2 > this.output.length()) {
            n2 -= this.output.length();
            while (n2-- > 0) {
                Utility.appendToRule(stringBuffer, 64, true, bl2, stringBuffer2);
            }
            Utility.appendToRule(stringBuffer, 124, true, bl2, stringBuffer2);
        }
        Utility.appendToRule(stringBuffer, -1, true, bl2, stringBuffer2);
        return stringBuffer.toString();
    }

    @Override
    public void addReplacementSetTo(UnicodeSet unicodeSet) {
        int n2;
        for (int i2 = 0; i2 < this.output.length(); i2 += UTF16.getCharCount(n2)) {
            n2 = UTF16.charAt(this.output, i2);
            UnicodeReplacer unicodeReplacer = this.data.lookupReplacer(n2);
            if (unicodeReplacer == null) {
                unicodeSet.add(n2);
                continue;
            }
            unicodeReplacer.addReplacementSetTo(unicodeSet);
        }
    }
}

