/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.UUID;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.DateNumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.DayPeriodRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleFormatterImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.BreakIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DateFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DateFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DisplayContext;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.MessageFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberingSystem;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.TimeZoneFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BasicTimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Calendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.HebrewCalendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Output;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZoneTransition;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public class SimpleDateFormat
extends DateFormat {
    private static final long serialVersionUID = 4774881970558875024L;
    static final int currentSerialVersion = 2;
    static boolean DelayedHebrewMonthCheck = false;
    private static final int[] CALENDAR_FIELD_TO_LEVEL = new int[]{0, 10, 20, 20, 30, 30, 20, 30, 30, 40, 50, 50, 60, 70, 80, 0, 0, 10, 30, 10, 0, 40, 0, 0};
    private static final int[] PATTERN_CHAR_TO_LEVEL = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 40, -1, -1, 20, 30, 30, 0, 50, -1, -1, 50, 20, 20, -1, 0, -1, 20, -1, 80, -1, 10, 0, 30, 0, 10, 0, -1, -1, -1, -1, -1, -1, 40, -1, 30, 30, 30, -1, 0, 50, -1, -1, 50, -1, 60, -1, -1, -1, 20, 10, 70, -1, 10, 0, 20, 0, 10, 0, -1, -1, -1, -1, -1};
    private static final boolean[] PATTERN_CHAR_IS_SYNTAX = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    private static final int HEBREW_CAL_CUR_MILLENIUM_START_YEAR = 5000;
    private static final int HEBREW_CAL_CUR_MILLENIUM_END_YEAR = 6000;
    private int serialVersionOnStream = 2;
    private String pattern;
    private String override;
    private HashMap<String, NumberFormat> numberFormatters;
    private HashMap<Character, String> overrideMap;
    private DateFormatSymbols formatData;
    private transient ULocale locale;
    private Date defaultCenturyStart;
    private transient int defaultCenturyStartYear;
    private transient long defaultCenturyBase;
    private static final int millisPerHour = 3600000;
    private static final int ISOSpecialEra = -32000;
    private static final String SUPPRESS_NEGATIVE_PREFIX = "\uab00";
    private transient boolean useFastFormat;
    private volatile TimeZoneFormat tzFormat;
    private transient BreakIterator capitalizationBrkIter = null;
    private transient boolean hasMinute;
    private transient boolean hasSecond;
    private transient boolean hasHanYearChar;
    private static ULocale cachedDefaultLocale = null;
    private static String cachedDefaultPattern = null;
    private static final String FALLBACKPATTERN = "yy/MM/dd HH:mm";
    private static final int[] PATTERN_CHAR_TO_INDEX = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 22, 36, -1, 10, 9, 11, 0, 5, -1, -1, 16, 26, 2, -1, 31, -1, 27, -1, 8, -1, 30, 29, 13, 32, 18, 23, -1, -1, -1, -1, -1, -1, 14, 35, 25, 3, 19, -1, 21, 15, -1, -1, 4, -1, 6, -1, -1, -1, 28, 34, 7, -1, 20, 24, 12, 33, 1, 17, -1, -1, -1, -1, -1};
    private static final int[] PATTERN_INDEX_TO_CALENDAR_FIELD = new int[]{0, 1, 2, 5, 11, 11, 12, 13, 14, 7, 6, 8, 3, 4, 9, 10, 10, 15, 17, 18, 19, 20, 21, 15, 15, 18, 2, 2, 2, 15, 1, 15, 15, 15, 19, -1, -2};
    private static final int[] PATTERN_INDEX_TO_DATE_FORMAT_FIELD = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37};
    private static final DateFormat.Field[] PATTERN_INDEX_TO_DATE_FORMAT_ATTRIBUTE = new DateFormat.Field[]{DateFormat.Field.ERA, DateFormat.Field.YEAR, DateFormat.Field.MONTH, DateFormat.Field.DAY_OF_MONTH, DateFormat.Field.HOUR_OF_DAY1, DateFormat.Field.HOUR_OF_DAY0, DateFormat.Field.MINUTE, DateFormat.Field.SECOND, DateFormat.Field.MILLISECOND, DateFormat.Field.DAY_OF_WEEK, DateFormat.Field.DAY_OF_YEAR, DateFormat.Field.DAY_OF_WEEK_IN_MONTH, DateFormat.Field.WEEK_OF_YEAR, DateFormat.Field.WEEK_OF_MONTH, DateFormat.Field.AM_PM, DateFormat.Field.HOUR1, DateFormat.Field.HOUR0, DateFormat.Field.TIME_ZONE, DateFormat.Field.YEAR_WOY, DateFormat.Field.DOW_LOCAL, DateFormat.Field.EXTENDED_YEAR, DateFormat.Field.JULIAN_DAY, DateFormat.Field.MILLISECONDS_IN_DAY, DateFormat.Field.TIME_ZONE, DateFormat.Field.TIME_ZONE, DateFormat.Field.DAY_OF_WEEK, DateFormat.Field.MONTH, DateFormat.Field.QUARTER, DateFormat.Field.QUARTER, DateFormat.Field.TIME_ZONE, DateFormat.Field.YEAR, DateFormat.Field.TIME_ZONE, DateFormat.Field.TIME_ZONE, DateFormat.Field.TIME_ZONE, DateFormat.Field.RELATED_YEAR, DateFormat.Field.AM_PM_MIDNIGHT_NOON, DateFormat.Field.FLEXIBLE_DAY_PERIOD, DateFormat.Field.TIME_SEPARATOR};
    private static ICUCache<String, Object[]> PARSED_PATTERN_CACHE = new SimpleCache<String, Object[]>();
    private transient Object[] patternItems;
    private transient boolean useLocalZeroPaddingNumberFormat;
    private transient char[] decDigits;
    private transient char[] decimalBuf;
    private static final int DECIMAL_BUF_SIZE = 10;
    private static final String NUMERIC_FORMAT_CHARS = "ADdFgHhKkmrSsuWwYy";
    private static final String NUMERIC_FORMAT_CHARS2 = "ceLMQq";
    private static final long MAX_DAYLIGHT_DETECTION_RANGE = 946080000000L;
    static final UnicodeSet DATE_PATTERN_TYPE = new UnicodeSet("[GyYuUQqMLlwWd]").freeze();

    private static int getLevelFromChar(char c2) {
        return c2 < PATTERN_CHAR_TO_LEVEL.length ? PATTERN_CHAR_TO_LEVEL[c2 & 0xFF] : -1;
    }

    private static boolean isSyntaxChar(char c2) {
        return c2 < PATTERN_CHAR_IS_SYNTAX.length ? PATTERN_CHAR_IS_SYNTAX[c2 & 0xFF] : false;
    }

    public SimpleDateFormat() {
        this(SimpleDateFormat.getDefaultPattern(), null, null, null, null, true, null);
    }

    public SimpleDateFormat(String string) {
        this(string, null, null, null, null, true, null);
    }

    public SimpleDateFormat(String string, Locale locale) {
        this(string, null, null, null, ULocale.forLocale(locale), true, null);
    }

    public SimpleDateFormat(String string, ULocale uLocale) {
        this(string, null, null, null, uLocale, true, null);
    }

    public SimpleDateFormat(String string, String string2, ULocale uLocale) {
        this(string, null, null, null, uLocale, false, string2);
    }

    public SimpleDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        this(string, (DateFormatSymbols)dateFormatSymbols.clone(), null, null, null, true, null);
    }

    @Deprecated
    public SimpleDateFormat(String string, DateFormatSymbols dateFormatSymbols, ULocale uLocale) {
        this(string, (DateFormatSymbols)dateFormatSymbols.clone(), null, null, uLocale, true, null);
    }

    SimpleDateFormat(String string, DateFormatSymbols dateFormatSymbols, Calendar calendar, ULocale uLocale, boolean bl2, String string2) {
        this(string, (DateFormatSymbols)dateFormatSymbols.clone(), (Calendar)calendar.clone(), null, uLocale, bl2, string2);
    }

    private SimpleDateFormat(String string, DateFormatSymbols dateFormatSymbols, Calendar calendar, NumberFormat numberFormat, ULocale uLocale, boolean bl2, String string2) {
        this.pattern = string;
        this.formatData = dateFormatSymbols;
        this.calendar = calendar;
        this.numberFormat = numberFormat;
        this.locale = uLocale;
        this.useFastFormat = bl2;
        this.override = string2;
        this.initialize();
    }

    @Deprecated
    public static SimpleDateFormat getInstance(Calendar.FormatConfiguration formatConfiguration) {
        String string = formatConfiguration.getOverrideString();
        boolean bl2 = string != null && string.length() > 0;
        return new SimpleDateFormat(formatConfiguration.getPatternString(), formatConfiguration.getDateFormatSymbols(), formatConfiguration.getCalendar(), null, formatConfiguration.getLocale(), bl2, formatConfiguration.getOverrideString());
    }

    private void initialize() {
        if (this.locale == null) {
            this.locale = ULocale.getDefault(ULocale.Category.FORMAT);
        }
        if (this.formatData == null) {
            this.formatData = new DateFormatSymbols(this.locale);
        }
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance(this.locale);
        }
        if (this.numberFormat == null) {
            NumberingSystem numberingSystem = NumberingSystem.getInstance(this.locale);
            String string = numberingSystem.getDescription();
            if (numberingSystem.isAlgorithmic() || string.length() != 10) {
                this.numberFormat = NumberFormat.getInstance(this.locale);
            } else {
                String string2 = numberingSystem.getName();
                this.numberFormat = new DateNumberFormat(this.locale, string, string2);
            }
        }
        if (this.numberFormat instanceof DecimalFormat) {
            SimpleDateFormat.fixNumberFormatForDates(this.numberFormat);
        }
        this.defaultCenturyBase = System.currentTimeMillis();
        this.setLocale(this.calendar.getLocale(ULocale.VALID_LOCALE), this.calendar.getLocale(ULocale.ACTUAL_LOCALE));
        this.initLocalZeroPaddingNumberFormat();
        this.parsePattern();
        if (this.override == null && this.hasHanYearChar && this.calendar != null && this.calendar.getType().equals("japanese") && this.locale != null && this.locale.getLanguage().equals("ja")) {
            this.override = "y=jpanyear";
        }
        if (this.override != null) {
            this.initNumberFormatters(this.locale);
        }
    }

    private synchronized void initializeTimeZoneFormat(boolean bl2) {
        if (bl2 || this.tzFormat == null) {
            this.tzFormat = TimeZoneFormat.getInstance(this.locale);
            String string = null;
            if (this.numberFormat instanceof DecimalFormat) {
                DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)this.numberFormat).getDecimalFormatSymbols();
                String[] stringArray = decimalFormatSymbols.getDigitStringsLocal();
                StringBuilder stringBuilder = new StringBuilder();
                for (String string2 : stringArray) {
                    stringBuilder.append(string2);
                }
                string = stringBuilder.toString();
            } else if (this.numberFormat instanceof DateNumberFormat) {
                string = new String(((DateNumberFormat)this.numberFormat).getDigits());
            }
            if (string != null && !this.tzFormat.getGMTOffsetDigits().equals(string)) {
                if (this.tzFormat.isFrozen()) {
                    this.tzFormat = this.tzFormat.cloneAsThawed();
                }
                this.tzFormat.setGMTOffsetDigits(string);
            }
        }
    }

    private TimeZoneFormat tzFormat() {
        if (this.tzFormat == null) {
            this.initializeTimeZoneFormat(false);
        }
        return this.tzFormat;
    }

    private static synchronized String getDefaultPattern() {
        ULocale uLocale = ULocale.getDefault(ULocale.Category.FORMAT);
        if (!uLocale.equals(cachedDefaultLocale)) {
            cachedDefaultLocale = uLocale;
            Calendar calendar = Calendar.getInstance(cachedDefaultLocale);
            try {
                ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", cachedDefaultLocale);
                String string = "calendar/" + calendar.getType() + "/DateTimePatterns";
                ICUResourceBundle iCUResourceBundle2 = iCUResourceBundle.findWithFallback(string);
                if (iCUResourceBundle2 == null) {
                    iCUResourceBundle2 = iCUResourceBundle.findWithFallback("calendar/gregorian/DateTimePatterns");
                }
                if (iCUResourceBundle2 == null || iCUResourceBundle2.getSize() < 9) {
                    cachedDefaultPattern = FALLBACKPATTERN;
                } else {
                    String string2 = Calendar.getDateAtTimePattern(calendar, cachedDefaultLocale, 3);
                    cachedDefaultPattern = SimpleFormatterImpl.formatRawPattern(string2, 2, 2, iCUResourceBundle2.getString(3), iCUResourceBundle2.getString(7));
                }
            }
            catch (MissingResourceException missingResourceException) {
                cachedDefaultPattern = FALLBACKPATTERN;
            }
        }
        return cachedDefaultPattern;
    }

    private void parseAmbiguousDatesAsAfter(Date date) {
        this.defaultCenturyStart = date;
        this.calendar.setTime(date);
        this.defaultCenturyStartYear = this.calendar.get(1);
    }

    private void initializeDefaultCenturyStart(long l2) {
        this.defaultCenturyBase = l2;
        Calendar calendar = (Calendar)this.calendar.clone();
        calendar.setTimeInMillis(l2);
        calendar.add(1, -80);
        this.defaultCenturyStart = calendar.getTime();
        this.defaultCenturyStartYear = calendar.get(1);
    }

    private Date getDefaultCenturyStart() {
        if (this.defaultCenturyStart == null) {
            this.initializeDefaultCenturyStart(this.defaultCenturyBase);
        }
        return this.defaultCenturyStart;
    }

    private int getDefaultCenturyStartYear() {
        if (this.defaultCenturyStart == null) {
            this.initializeDefaultCenturyStart(this.defaultCenturyBase);
        }
        return this.defaultCenturyStartYear;
    }

    public void set2DigitYearStart(Date date) {
        this.parseAmbiguousDatesAsAfter(date);
    }

    public Date get2DigitYearStart() {
        return this.getDefaultCenturyStart();
    }

    @Override
    public void setContext(DisplayContext displayContext) {
        super.setContext(displayContext);
        if (this.capitalizationBrkIter == null && (displayContext == DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE || displayContext == DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU || displayContext == DisplayContext.CAPITALIZATION_FOR_STANDALONE)) {
            this.capitalizationBrkIter = BreakIterator.getSentenceInstance(this.locale);
        }
    }

    @Override
    public StringBuffer format(Calendar calendar, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format(calendar, stringBuffer, fieldPosition, null);
    }

    StringBuffer format(Calendar calendar, StringBuffer stringBuffer, FieldPosition fieldPosition, List<FieldPosition> list) {
        TimeZone timeZone = null;
        if (calendar != this.calendar && !calendar.getType().equals(this.calendar.getType())) {
            this.calendar.setTimeInMillis(calendar.getTimeInMillis());
            timeZone = this.calendar.getTimeZone();
            this.calendar.setTimeZone(calendar.getTimeZone());
            calendar = this.calendar;
        }
        StringBuffer stringBuffer2 = this.format(calendar, this.getContext(DisplayContext.Type.CAPITALIZATION), stringBuffer, fieldPosition, list);
        if (timeZone != null) {
            this.calendar.setTimeZone(timeZone);
        }
        return stringBuffer2;
    }

    private StringBuffer format(Calendar calendar, DisplayContext displayContext, StringBuffer stringBuffer, FieldPosition fieldPosition, List<FieldPosition> list) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        Object[] objectArray = this.getPatternItems();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            int n2;
            if (objectArray[i2] instanceof String) {
                stringBuffer.append((String)objectArray[i2]);
                continue;
            }
            PatternItem patternItem = (PatternItem)objectArray[i2];
            int n3 = 0;
            if (list != null) {
                n3 = stringBuffer.length();
            }
            if (this.useFastFormat) {
                this.subFormat(stringBuffer, patternItem.type, patternItem.length, stringBuffer.length(), i2, displayContext, fieldPosition, patternItem.type, calendar);
            } else {
                stringBuffer.append(this.subFormat(patternItem.type, patternItem.length, stringBuffer.length(), i2, displayContext, fieldPosition, patternItem.type, calendar));
            }
            if (list == null || (n2 = stringBuffer.length()) - n3 <= 0) continue;
            DateFormat.Field field = this.patternCharToDateFormatField(patternItem.type);
            FieldPosition fieldPosition2 = new FieldPosition(field);
            fieldPosition2.setBeginIndex(n3);
            fieldPosition2.setEndIndex(n2);
            list.add(fieldPosition2);
        }
        return stringBuffer;
    }

    private static int getIndexFromChar(char c2) {
        return c2 < PATTERN_CHAR_TO_INDEX.length ? PATTERN_CHAR_TO_INDEX[c2 & 0xFF] : -1;
    }

    protected DateFormat.Field patternCharToDateFormatField(char c2) {
        int n2 = SimpleDateFormat.getIndexFromChar(c2);
        if (n2 != -1) {
            return PATTERN_INDEX_TO_DATE_FORMAT_ATTRIBUTE[n2];
        }
        return null;
    }

    protected String subFormat(char c2, int n2, int n3, FieldPosition fieldPosition, DateFormatSymbols dateFormatSymbols, Calendar calendar) throws IllegalArgumentException {
        return this.subFormat(c2, n2, n3, 0, DisplayContext.CAPITALIZATION_NONE, fieldPosition, c2, calendar);
    }

    @Deprecated
    protected String subFormat(char c2, int n2, int n3, int n4, DisplayContext displayContext, FieldPosition fieldPosition, char c3, Calendar calendar) {
        StringBuffer stringBuffer = new StringBuffer();
        this.subFormat(stringBuffer, c2, n2, n3, n4, displayContext, fieldPosition, c3, calendar);
        return stringBuffer.toString();
    }

    @Deprecated
    protected void subFormat(StringBuffer stringBuffer, char c2, int n2, int n3, int n4, DisplayContext displayContext, FieldPosition fieldPosition, char c3, Calendar calendar) {
        int n5;
        int n6 = Integer.MAX_VALUE;
        int n7 = stringBuffer.length();
        TimeZone timeZone = calendar.getTimeZone();
        long l2 = calendar.getTimeInMillis();
        String string = null;
        int n8 = SimpleDateFormat.getIndexFromChar(c2);
        if (n8 == -1) {
            if (c2 == 'l') {
                return;
            }
            throw new IllegalArgumentException("Illegal pattern character '" + c2 + "' in \"" + this.pattern + '\"');
        }
        int n9 = PATTERN_INDEX_TO_CALENDAR_FIELD[n8];
        int n10 = 0;
        if (n9 >= 0) {
            n10 = n8 != 34 ? calendar.get(n9) : calendar.getRelatedYear();
        }
        NumberFormat numberFormat = this.getNumberFormat(c2);
        DateFormatSymbols.CapitalizationContextUsage capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.OTHER;
        switch (n8) {
            case 0: {
                if (calendar.getType().equals("chinese") || calendar.getType().equals("dangi")) {
                    this.zeroPaddingNumber(numberFormat, stringBuffer, n10, 1, 9);
                    break;
                }
                if (n2 == 5) {
                    SimpleDateFormat.safeAppend(this.formatData.narrowEras, n10, stringBuffer);
                    capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.ERA_NARROW;
                    break;
                }
                if (n2 == 4) {
                    SimpleDateFormat.safeAppend(this.formatData.eraNames, n10, stringBuffer);
                    capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.ERA_WIDE;
                    break;
                }
                SimpleDateFormat.safeAppend(this.formatData.eras, n10, stringBuffer);
                capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.ERA_ABBREV;
                break;
            }
            case 30: {
                if (this.formatData.shortYearNames != null && n10 <= this.formatData.shortYearNames.length) {
                    SimpleDateFormat.safeAppend(this.formatData.shortYearNames, n10 - 1, stringBuffer);
                    break;
                }
            }
            case 1: 
            case 18: {
                if (this.override != null && (this.override.compareTo("hebr") == 0 || this.override.indexOf("y=hebr") >= 0) && n10 > 5000 && n10 < 6000) {
                    n10 -= 5000;
                }
                if (n2 == 2) {
                    this.zeroPaddingNumber(numberFormat, stringBuffer, n10, 2, 2);
                    break;
                }
                this.zeroPaddingNumber(numberFormat, stringBuffer, n10, n2, Integer.MAX_VALUE);
                break;
            }
            case 2: 
            case 26: {
                if (calendar.getType().equals("hebrew")) {
                    n5 = HebrewCalendar.isLeapYear(calendar.get(1));
                    if (n5 != 0 && n10 == 6 && n2 >= 3) {
                        n10 = 13;
                    }
                    if (n5 == 0 && n10 >= 6 && n2 < 3) {
                        --n10;
                    }
                }
                int n11 = n5 = this.formatData.leapMonthPatterns != null && this.formatData.leapMonthPatterns.length >= 7 ? calendar.get(22) : 0;
                if (n2 == 5) {
                    if (n8 == 2) {
                        SimpleDateFormat.safeAppendWithMonthPattern(this.formatData.narrowMonths, n10, stringBuffer, n5 != 0 ? this.formatData.leapMonthPatterns[2] : null);
                    } else {
                        SimpleDateFormat.safeAppendWithMonthPattern(this.formatData.standaloneNarrowMonths, n10, stringBuffer, n5 != 0 ? this.formatData.leapMonthPatterns[5] : null);
                    }
                    capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.MONTH_NARROW;
                    break;
                }
                if (n2 == 4) {
                    if (n8 == 2) {
                        SimpleDateFormat.safeAppendWithMonthPattern(this.formatData.months, n10, stringBuffer, n5 != 0 ? this.formatData.leapMonthPatterns[0] : null);
                        capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.MONTH_FORMAT;
                        break;
                    }
                    SimpleDateFormat.safeAppendWithMonthPattern(this.formatData.standaloneMonths, n10, stringBuffer, n5 != 0 ? this.formatData.leapMonthPatterns[3] : null);
                    capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.MONTH_STANDALONE;
                    break;
                }
                if (n2 == 3) {
                    if (n8 == 2) {
                        SimpleDateFormat.safeAppendWithMonthPattern(this.formatData.shortMonths, n10, stringBuffer, n5 != 0 ? this.formatData.leapMonthPatterns[1] : null);
                        capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.MONTH_FORMAT;
                        break;
                    }
                    SimpleDateFormat.safeAppendWithMonthPattern(this.formatData.standaloneShortMonths, n10, stringBuffer, n5 != 0 ? this.formatData.leapMonthPatterns[4] : null);
                    capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.MONTH_STANDALONE;
                    break;
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                this.zeroPaddingNumber(numberFormat, stringBuffer2, n10 + 1, n2, Integer.MAX_VALUE);
                String[] stringArray = new String[]{stringBuffer2.toString()};
                SimpleDateFormat.safeAppendWithMonthPattern(stringArray, 0, stringBuffer, n5 != 0 ? this.formatData.leapMonthPatterns[6] : null);
                break;
            }
            case 4: {
                if (n10 == 0) {
                    this.zeroPaddingNumber(numberFormat, stringBuffer, calendar.getMaximum(11) + 1, n2, Integer.MAX_VALUE);
                    break;
                }
                this.zeroPaddingNumber(numberFormat, stringBuffer, n10, n2, Integer.MAX_VALUE);
                break;
            }
            case 8: {
                this.numberFormat.setMinimumIntegerDigits(Math.min(3, n2));
                this.numberFormat.setMaximumIntegerDigits(Integer.MAX_VALUE);
                if (n2 == 1) {
                    n10 /= 100;
                } else if (n2 == 2) {
                    n10 /= 10;
                }
                FieldPosition fieldPosition2 = new FieldPosition(-1);
                this.numberFormat.format(n10, stringBuffer, fieldPosition2);
                if (n2 <= 3) break;
                this.numberFormat.setMinimumIntegerDigits(n2 - 3);
                this.numberFormat.format(0L, stringBuffer, fieldPosition2);
                break;
            }
            case 19: {
                if (n2 < 3) {
                    this.zeroPaddingNumber(numberFormat, stringBuffer, n10, n2, Integer.MAX_VALUE);
                    break;
                }
                n10 = calendar.get(7);
            }
            case 9: {
                if (n2 == 5) {
                    SimpleDateFormat.safeAppend(this.formatData.narrowWeekdays, n10, stringBuffer);
                    capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.DAY_NARROW;
                    break;
                }
                if (n2 == 4) {
                    SimpleDateFormat.safeAppend(this.formatData.weekdays, n10, stringBuffer);
                    capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.DAY_FORMAT;
                    break;
                }
                if (n2 == 6 && this.formatData.shorterWeekdays != null) {
                    SimpleDateFormat.safeAppend(this.formatData.shorterWeekdays, n10, stringBuffer);
                    capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.DAY_FORMAT;
                    break;
                }
                SimpleDateFormat.safeAppend(this.formatData.shortWeekdays, n10, stringBuffer);
                capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.DAY_FORMAT;
                break;
            }
            case 14: {
                if (n2 < 5 || this.formatData.ampmsNarrow == null) {
                    SimpleDateFormat.safeAppend(this.formatData.ampms, n10, stringBuffer);
                    break;
                }
                SimpleDateFormat.safeAppend(this.formatData.ampmsNarrow, n10, stringBuffer);
                break;
            }
            case 15: {
                if (n10 == 0) {
                    this.zeroPaddingNumber(numberFormat, stringBuffer, calendar.getLeastMaximum(10) + 1, n2, Integer.MAX_VALUE);
                    break;
                }
                this.zeroPaddingNumber(numberFormat, stringBuffer, n10, n2, Integer.MAX_VALUE);
                break;
            }
            case 17: {
                if (n2 < 4) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.SPECIFIC_SHORT, timeZone, l2);
                    capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.METAZONE_SHORT;
                } else {
                    string = this.tzFormat().format(TimeZoneFormat.Style.SPECIFIC_LONG, timeZone, l2);
                    capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.METAZONE_LONG;
                }
                stringBuffer.append(string);
                break;
            }
            case 23: {
                string = n2 < 4 ? this.tzFormat().format(TimeZoneFormat.Style.ISO_BASIC_LOCAL_FULL, timeZone, l2) : (n2 == 5 ? this.tzFormat().format(TimeZoneFormat.Style.ISO_EXTENDED_FULL, timeZone, l2) : this.tzFormat().format(TimeZoneFormat.Style.LOCALIZED_GMT, timeZone, l2));
                stringBuffer.append(string);
                break;
            }
            case 24: {
                if (n2 == 1) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.GENERIC_SHORT, timeZone, l2);
                    capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.METAZONE_SHORT;
                } else if (n2 == 4) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.GENERIC_LONG, timeZone, l2);
                    capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.METAZONE_LONG;
                }
                stringBuffer.append(string);
                break;
            }
            case 29: {
                if (n2 == 1) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.ZONE_ID_SHORT, timeZone, l2);
                } else if (n2 == 2) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.ZONE_ID, timeZone, l2);
                } else if (n2 == 3) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.EXEMPLAR_LOCATION, timeZone, l2);
                } else if (n2 == 4) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.GENERIC_LOCATION, timeZone, l2);
                    capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.ZONE_LONG;
                }
                stringBuffer.append(string);
                break;
            }
            case 31: {
                if (n2 == 1) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.LOCALIZED_GMT_SHORT, timeZone, l2);
                } else if (n2 == 4) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.LOCALIZED_GMT, timeZone, l2);
                }
                stringBuffer.append(string);
                break;
            }
            case 32: {
                if (n2 == 1) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.ISO_BASIC_SHORT, timeZone, l2);
                } else if (n2 == 2) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.ISO_BASIC_FIXED, timeZone, l2);
                } else if (n2 == 3) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.ISO_EXTENDED_FIXED, timeZone, l2);
                } else if (n2 == 4) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.ISO_BASIC_FULL, timeZone, l2);
                } else if (n2 == 5) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.ISO_EXTENDED_FULL, timeZone, l2);
                }
                stringBuffer.append(string);
                break;
            }
            case 33: {
                if (n2 == 1) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.ISO_BASIC_LOCAL_SHORT, timeZone, l2);
                } else if (n2 == 2) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.ISO_BASIC_LOCAL_FIXED, timeZone, l2);
                } else if (n2 == 3) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.ISO_EXTENDED_LOCAL_FIXED, timeZone, l2);
                } else if (n2 == 4) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.ISO_BASIC_LOCAL_FULL, timeZone, l2);
                } else if (n2 == 5) {
                    string = this.tzFormat().format(TimeZoneFormat.Style.ISO_EXTENDED_LOCAL_FULL, timeZone, l2);
                }
                stringBuffer.append(string);
                break;
            }
            case 25: {
                if (n2 < 3) {
                    this.zeroPaddingNumber(numberFormat, stringBuffer, n10, 1, Integer.MAX_VALUE);
                    break;
                }
                n10 = calendar.get(7);
                if (n2 == 5) {
                    SimpleDateFormat.safeAppend(this.formatData.standaloneNarrowWeekdays, n10, stringBuffer);
                    capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.DAY_NARROW;
                    break;
                }
                if (n2 == 4) {
                    SimpleDateFormat.safeAppend(this.formatData.standaloneWeekdays, n10, stringBuffer);
                    capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.DAY_STANDALONE;
                    break;
                }
                if (n2 == 6 && this.formatData.standaloneShorterWeekdays != null) {
                    SimpleDateFormat.safeAppend(this.formatData.standaloneShorterWeekdays, n10, stringBuffer);
                    capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.DAY_STANDALONE;
                    break;
                }
                SimpleDateFormat.safeAppend(this.formatData.standaloneShortWeekdays, n10, stringBuffer);
                capitalizationContextUsage = DateFormatSymbols.CapitalizationContextUsage.DAY_STANDALONE;
                break;
            }
            case 27: {
                if (n2 >= 5) {
                    SimpleDateFormat.safeAppend(this.formatData.narrowQuarters, n10 / 3, stringBuffer);
                    break;
                }
                if (n2 == 4) {
                    SimpleDateFormat.safeAppend(this.formatData.quarters, n10 / 3, stringBuffer);
                    break;
                }
                if (n2 == 3) {
                    SimpleDateFormat.safeAppend(this.formatData.shortQuarters, n10 / 3, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(numberFormat, stringBuffer, n10 / 3 + 1, n2, Integer.MAX_VALUE);
                break;
            }
            case 28: {
                if (n2 >= 5) {
                    SimpleDateFormat.safeAppend(this.formatData.standaloneNarrowQuarters, n10 / 3, stringBuffer);
                    break;
                }
                if (n2 == 4) {
                    SimpleDateFormat.safeAppend(this.formatData.standaloneQuarters, n10 / 3, stringBuffer);
                    break;
                }
                if (n2 == 3) {
                    SimpleDateFormat.safeAppend(this.formatData.standaloneShortQuarters, n10 / 3, stringBuffer);
                    break;
                }
                this.zeroPaddingNumber(numberFormat, stringBuffer, n10 / 3 + 1, n2, Integer.MAX_VALUE);
                break;
            }
            case 35: {
                int n12 = calendar.get(11);
                String string2 = null;
                if (!(n12 != 12 || this.hasMinute && calendar.get(12) != 0 || this.hasSecond && calendar.get(13) != 0)) {
                    n10 = calendar.get(9);
                    string2 = n2 <= 3 ? this.formatData.abbreviatedDayPeriods[n10] : (n2 == 4 || n2 > 5 ? this.formatData.wideDayPeriods[n10] : this.formatData.narrowDayPeriods[n10]);
                }
                if (string2 == null) {
                    this.subFormat(stringBuffer, 'a', n2, n3, n4, displayContext, fieldPosition, 'b', calendar);
                    break;
                }
                stringBuffer.append(string2);
                break;
            }
            case 36: {
                int n13;
                DayPeriodRules dayPeriodRules = DayPeriodRules.getInstance(this.getLocale());
                if (dayPeriodRules == null) {
                    this.subFormat(stringBuffer, 'a', n2, n3, n4, displayContext, fieldPosition, 'B', calendar);
                    return;
                }
                int n14 = calendar.get(11);
                int n15 = 0;
                int n16 = 0;
                if (this.hasMinute) {
                    n15 = calendar.get(12);
                }
                if (this.hasSecond) {
                    n16 = calendar.get(13);
                }
                DayPeriodRules.DayPeriod dayPeriod = n14 == 0 && n15 == 0 && n16 == 0 && dayPeriodRules.hasMidnight() ? DayPeriodRules.DayPeriod.MIDNIGHT : (n14 == 12 && n15 == 0 && n16 == 0 && dayPeriodRules.hasNoon() ? DayPeriodRules.DayPeriod.NOON : dayPeriodRules.getDayPeriodForHour(n14));
                assert (dayPeriod != null);
                String string3 = null;
                if (dayPeriod != DayPeriodRules.DayPeriod.AM && dayPeriod != DayPeriodRules.DayPeriod.PM && dayPeriod != DayPeriodRules.DayPeriod.MIDNIGHT) {
                    n13 = dayPeriod.ordinal();
                    string3 = n2 <= 3 ? this.formatData.abbreviatedDayPeriods[n13] : (n2 == 4 || n2 > 5 ? this.formatData.wideDayPeriods[n13] : this.formatData.narrowDayPeriods[n13]);
                }
                if (string3 == null && (dayPeriod == DayPeriodRules.DayPeriod.MIDNIGHT || dayPeriod == DayPeriodRules.DayPeriod.NOON)) {
                    dayPeriod = dayPeriodRules.getDayPeriodForHour(n14);
                    n13 = dayPeriod.ordinal();
                    string3 = n2 <= 3 ? this.formatData.abbreviatedDayPeriods[n13] : (n2 == 4 || n2 > 5 ? this.formatData.wideDayPeriods[n13] : this.formatData.narrowDayPeriods[n13]);
                }
                if (dayPeriod == DayPeriodRules.DayPeriod.AM || dayPeriod == DayPeriodRules.DayPeriod.PM || string3 == null) {
                    this.subFormat(stringBuffer, 'a', n2, n3, n4, displayContext, fieldPosition, 'B', calendar);
                    return;
                }
                stringBuffer.append(string3);
                break;
            }
            case 37: {
                stringBuffer.append(this.formatData.getTimeSeparatorString());
                break;
            }
            default: {
                this.zeroPaddingNumber(numberFormat, stringBuffer, n10, n2, Integer.MAX_VALUE);
            }
        }
        if (n4 == 0 && displayContext != null && stringBuffer.length() > n7 && UCharacter.isLowerCase(stringBuffer.codePointAt(n7))) {
            n5 = 0;
            switch (displayContext) {
                case CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE: {
                    n5 = 1;
                    break;
                }
                case CAPITALIZATION_FOR_UI_LIST_OR_MENU: 
                case CAPITALIZATION_FOR_STANDALONE: {
                    if (this.formatData.capitalization == null) break;
                    boolean[] blArray = this.formatData.capitalization.get((Object)capitalizationContextUsage);
                    n5 = displayContext == DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU ? blArray[0] : blArray[1];
                    break;
                }
            }
            if (n5 != 0) {
                if (this.capitalizationBrkIter == null) {
                    this.capitalizationBrkIter = BreakIterator.getSentenceInstance(this.locale);
                }
                BreakIterator breakIterator = (BreakIterator)this.capitalizationBrkIter.clone();
                String string4 = stringBuffer.substring(n7);
                String string5 = UCharacter.toTitleCase(this.locale, string4, breakIterator, 768);
                stringBuffer.replace(n7, stringBuffer.length(), string5);
            }
        }
        n5 = SimpleDateFormat.getIndexFromChar(c3);
        if (fieldPosition.getBeginIndex() == fieldPosition.getEndIndex()) {
            if (fieldPosition.getField() == PATTERN_INDEX_TO_DATE_FORMAT_FIELD[n5]) {
                fieldPosition.setBeginIndex(n3);
                fieldPosition.setEndIndex(n3 + stringBuffer.length() - n7);
            } else if (fieldPosition.getFieldAttribute() == PATTERN_INDEX_TO_DATE_FORMAT_ATTRIBUTE[n5]) {
                fieldPosition.setBeginIndex(n3);
                fieldPosition.setEndIndex(n3 + stringBuffer.length() - n7);
            }
        }
    }

    private static void safeAppend(String[] stringArray, int n2, StringBuffer stringBuffer) {
        if (stringArray != null && n2 >= 0 && n2 < stringArray.length) {
            stringBuffer.append(stringArray[n2]);
        }
    }

    private static void safeAppendWithMonthPattern(String[] stringArray, int n2, StringBuffer stringBuffer, String string) {
        if (stringArray != null && n2 >= 0 && n2 < stringArray.length) {
            if (string == null) {
                stringBuffer.append(stringArray[n2]);
            } else {
                String string2 = SimpleFormatterImpl.formatRawPattern(string, 1, 1, stringArray[n2]);
                stringBuffer.append(string2);
            }
        }
    }

    private Object[] getPatternItems() {
        if (this.patternItems != null) {
            return this.patternItems;
        }
        this.patternItems = PARSED_PATTERN_CACHE.get(this.pattern);
        if (this.patternItems != null) {
            return this.patternItems;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder stringBuilder = new StringBuilder();
        char c2 = '\u0000';
        int n2 = 1;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i2 = 0; i2 < this.pattern.length(); ++i2) {
            char c3 = this.pattern.charAt(i2);
            if (c3 == '\'') {
                if (bl2) {
                    stringBuilder.append('\'');
                    bl2 = false;
                } else {
                    bl2 = true;
                    if (c2 != '\u0000') {
                        arrayList.add(new PatternItem(c2, n2));
                        c2 = '\u0000';
                    }
                }
                bl3 = !bl3;
                continue;
            }
            bl2 = false;
            if (bl3) {
                stringBuilder.append(c3);
                continue;
            }
            if (SimpleDateFormat.isSyntaxChar(c3)) {
                if (c3 == c2) {
                    ++n2;
                    continue;
                }
                if (c2 == '\u0000') {
                    if (stringBuilder.length() > 0) {
                        arrayList.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                    }
                } else {
                    arrayList.add(new PatternItem(c2, n2));
                }
                c2 = c3;
                n2 = 1;
                continue;
            }
            if (c2 != '\u0000') {
                arrayList.add(new PatternItem(c2, n2));
                c2 = '\u0000';
            }
            stringBuilder.append(c3);
        }
        if (c2 == '\u0000') {
            if (stringBuilder.length() > 0) {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
            }
        } else {
            arrayList.add(new PatternItem(c2, n2));
        }
        this.patternItems = arrayList.toArray(new Object[arrayList.size()]);
        PARSED_PATTERN_CACHE.put(this.pattern, this.patternItems);
        return this.patternItems;
    }

    @Deprecated
    protected void zeroPaddingNumber(NumberFormat numberFormat, StringBuffer stringBuffer, int n2, int n3, int n4) {
        if (this.useLocalZeroPaddingNumberFormat && n2 >= 0) {
            this.fastZeroPaddingNumber(stringBuffer, n2, n3, n4);
        } else {
            numberFormat.setMinimumIntegerDigits(n3);
            numberFormat.setMaximumIntegerDigits(n4);
            numberFormat.format(n2, stringBuffer, new FieldPosition(-1));
        }
    }

    @Override
    public void setNumberFormat(NumberFormat numberFormat) {
        super.setNumberFormat(numberFormat);
        this.initLocalZeroPaddingNumberFormat();
        this.initializeTimeZoneFormat(true);
        if (this.numberFormatters != null) {
            this.numberFormatters = null;
        }
        if (this.overrideMap != null) {
            this.overrideMap = null;
        }
    }

    private void initLocalZeroPaddingNumberFormat() {
        if (this.numberFormat instanceof DecimalFormat) {
            DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)this.numberFormat).getDecimalFormatSymbols();
            String[] stringArray = decimalFormatSymbols.getDigitStringsLocal();
            this.useLocalZeroPaddingNumberFormat = true;
            this.decDigits = new char[10];
            for (int i2 = 0; i2 < 10; ++i2) {
                if (stringArray[i2].length() > 1) {
                    this.useLocalZeroPaddingNumberFormat = false;
                    break;
                }
                this.decDigits[i2] = stringArray[i2].charAt(0);
            }
        } else if (this.numberFormat instanceof DateNumberFormat) {
            this.decDigits = ((DateNumberFormat)this.numberFormat).getDigits();
            this.useLocalZeroPaddingNumberFormat = true;
        } else {
            this.useLocalZeroPaddingNumberFormat = false;
        }
        if (this.useLocalZeroPaddingNumberFormat) {
            this.decimalBuf = new char[10];
        }
    }

    private void fastZeroPaddingNumber(StringBuffer stringBuffer, int n2, int n3, int n4) {
        int n5;
        int n6 = this.decimalBuf.length < n4 ? this.decimalBuf.length : n4;
        int n7 = n6 - 1;
        while (true) {
            this.decimalBuf[n7] = this.decDigits[n2 % 10];
            if (n7 == 0 || (n2 /= 10) == 0) break;
            --n7;
        }
        for (n5 = n3 - (n6 - n7); n5 > 0 && n7 > 0; --n5) {
            this.decimalBuf[--n7] = this.decDigits[0];
        }
        while (n5 > 0) {
            stringBuffer.append(this.decDigits[0]);
            --n5;
        }
        stringBuffer.append(this.decimalBuf, n7, n6 - n7);
    }

    protected String zeroPaddingNumber(long l2, int n2, int n3) {
        this.numberFormat.setMinimumIntegerDigits(n2);
        this.numberFormat.setMaximumIntegerDigits(n3);
        return this.numberFormat.format(l2);
    }

    private static final boolean isNumeric(char c2, int n2) {
        return NUMERIC_FORMAT_CHARS.indexOf(c2) >= 0 || n2 <= 2 && NUMERIC_FORMAT_CHARS2.indexOf(c2) >= 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void parse(String string, Calendar calendar, ParsePosition parsePosition) {
        Calendar calendar2;
        TimeZone timeZone;
        block55: {
            Object object;
            char c2;
            int n2;
            int n3;
            int n4;
            timeZone = null;
            calendar2 = null;
            if (calendar != this.calendar && !calendar.getType().equals(this.calendar.getType())) {
                this.calendar.setTimeInMillis(calendar.getTimeInMillis());
                timeZone = this.calendar.getTimeZone();
                this.calendar.setTimeZone(calendar.getTimeZone());
                calendar2 = calendar;
                calendar = this.calendar;
            }
            if ((n4 = parsePosition.getIndex()) < 0) {
                parsePosition.setErrorIndex(0);
                return;
            }
            int n5 = n4;
            Output<Object> output = new Output<Object>(null);
            Output<TimeZoneFormat.TimeType> output2 = new Output<TimeZoneFormat.TimeType>(TimeZoneFormat.TimeType.UNKNOWN);
            boolean[] blArray = new boolean[]{false};
            int n6 = -1;
            int n7 = 0;
            int n8 = 0;
            MessageFormat messageFormat = null;
            if (this.formatData.leapMonthPatterns != null && this.formatData.leapMonthPatterns.length >= 7) {
                messageFormat = new MessageFormat(this.formatData.leapMonthPatterns[6], this.locale);
            }
            Object[] objectArray = this.getPatternItems();
            int n9 = 0;
            while (n9 < objectArray.length) {
                block59: {
                    Object object2;
                    block57: {
                        int n10;
                        block60: {
                            block58: {
                                if (!(objectArray[n9] instanceof PatternItem)) break block57;
                                object2 = (PatternItem)objectArray[n9];
                                if (((PatternItem)object2).isNumeric && n6 == -1 && n9 + 1 < objectArray.length && objectArray[n9 + 1] instanceof PatternItem && ((PatternItem)objectArray[n9 + 1]).isNumeric) {
                                    n6 = n9;
                                    n7 = ((PatternItem)object2).length;
                                    n8 = n4;
                                }
                                if (n6 == -1) break block58;
                                n10 = ((PatternItem)object2).length;
                                if (n6 == n9) {
                                    n10 = n7;
                                }
                                if ((n4 = this.subParse(string, n4, ((PatternItem)object2).type, n10, true, false, blArray, calendar, messageFormat, output2)) < 0) {
                                    if (--n7 == 0) {
                                        parsePosition.setIndex(n5);
                                        parsePosition.setErrorIndex(n4);
                                        if (timeZone != null) {
                                            this.calendar.setTimeZone(timeZone);
                                        }
                                        return;
                                    }
                                    n9 = n6;
                                    n4 = n8;
                                    continue;
                                }
                                break block59;
                            }
                            if (((PatternItem)object2).type == 'l') break block59;
                            n6 = -1;
                            n10 = n4;
                            if ((n4 = this.subParse(string, n4, ((PatternItem)object2).type, ((PatternItem)object2).length, false, true, blArray, calendar, messageFormat, output2, output)) >= 0) break block59;
                            if (n4 != -32000) break block60;
                            n4 = n10;
                            if (n9 + 1 < objectArray.length) {
                                char c3;
                                String string2 = null;
                                try {
                                    string2 = (String)objectArray[n9 + 1];
                                }
                                catch (ClassCastException classCastException) {
                                    parsePosition.setIndex(n5);
                                    parsePosition.setErrorIndex(n10);
                                    if (timeZone != null) {
                                        this.calendar.setTimeZone(timeZone);
                                    }
                                    return;
                                }
                                if (string2 == null) {
                                    string2 = (String)objectArray[n9 + 1];
                                }
                                n3 = string2.length();
                                for (n2 = 0; n2 < n3 && (PatternProps.isWhiteSpace(c3 = string2.charAt(n2)) || UCharacter.isUWhiteSpace(c3)); ++n2) {
                                }
                                if (n2 == n3) {
                                    ++n9;
                                }
                            }
                            break block59;
                        }
                        parsePosition.setIndex(n5);
                        parsePosition.setErrorIndex(n10);
                        if (timeZone != null) {
                            this.calendar.setTimeZone(timeZone);
                        }
                        return;
                    }
                    n6 = -1;
                    object2 = new boolean[1];
                    n4 = this.matchLiteral(string, n4, objectArray, n9, (boolean[])object2);
                    if (object2[0] == false) {
                        parsePosition.setIndex(n5);
                        parsePosition.setErrorIndex(n4);
                        if (timeZone != null) {
                            this.calendar.setTimeZone(timeZone);
                        }
                        return;
                    }
                }
                ++n9;
            }
            if (n4 < string.length() && (c2 = string.charAt(n4)) == '.' && this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_ALLOW_WHITESPACE) && objectArray.length != 0 && (object = objectArray[objectArray.length - 1]) instanceof PatternItem && !((PatternItem)object).isNumeric) {
                ++n4;
            }
            if (output.value != null) {
                DayPeriodRules dayPeriodRules = DayPeriodRules.getInstance(this.getLocale());
                if (!calendar.isSet(10) && !calendar.isSet(11)) {
                    double d2 = dayPeriodRules.getMidPointForDayPeriod((DayPeriodRules.DayPeriod)((Object)output.value));
                    n2 = d2 - (double)(n3 = (int)d2) > 0.0 ? 30 : 0;
                    calendar.set(11, n3);
                    calendar.set(12, n2);
                } else {
                    int n11;
                    if (calendar.isSet(11)) {
                        n11 = calendar.get(11);
                    } else {
                        n11 = calendar.get(10);
                        if (n11 == 0) {
                            n11 = 12;
                        }
                    }
                    assert (0 <= n11 && n11 <= 23);
                    if (n11 == 0 || 13 <= n11 && n11 <= 23) {
                        calendar.set(11, n11);
                    } else {
                        double d3;
                        double d4;
                        double d5;
                        if (n11 == 12) {
                            n11 = 0;
                        }
                        if (-6.0 <= (d5 = (d4 = (double)n11 + (double)calendar.get(12) / 60.0) - (d3 = dayPeriodRules.getMidPointForDayPeriod((DayPeriodRules.DayPeriod)((Object)output.value)))) && d5 < 6.0) {
                            calendar.set(9, 0);
                        } else {
                            calendar.set(9, 1);
                        }
                    }
                }
            }
            parsePosition.setIndex(n4);
            try {
                Calendar calendar3;
                Date date;
                TimeZoneFormat.TimeType timeType = (TimeZoneFormat.TimeType)((Object)output2.value);
                if (!blArray[0] && timeType == TimeZoneFormat.TimeType.UNKNOWN) break block55;
                if (blArray[0] && (date = (calendar3 = (Calendar)calendar.clone()).getTime()).before(this.getDefaultCenturyStart())) {
                    calendar.set(1, this.getDefaultCenturyStartYear() + 100);
                }
                if (timeType == TimeZoneFormat.TimeType.UNKNOWN) break block55;
                Calendar calendar4 = (Calendar)calendar.clone();
                TimeZone timeZone2 = calendar4.getTimeZone();
                BasicTimeZone basicTimeZone = null;
                if (timeZone2 instanceof BasicTimeZone) {
                    basicTimeZone = (BasicTimeZone)timeZone2;
                }
                calendar4.set(15, 0);
                calendar4.set(16, 0);
                long l2 = calendar4.getTimeInMillis();
                int[] nArray = new int[2];
                if (basicTimeZone != null) {
                    if (timeType == TimeZoneFormat.TimeType.STANDARD) {
                        basicTimeZone.getOffsetFromLocal(l2, BasicTimeZone.LocalOption.STANDARD_FORMER, BasicTimeZone.LocalOption.STANDARD_LATTER, nArray);
                    } else {
                        basicTimeZone.getOffsetFromLocal(l2, BasicTimeZone.LocalOption.DAYLIGHT_FORMER, BasicTimeZone.LocalOption.DAYLIGHT_LATTER, nArray);
                    }
                } else {
                    timeZone2.getOffset(l2, true, nArray);
                    if (timeType == TimeZoneFormat.TimeType.STANDARD && nArray[1] != 0 || timeType == TimeZoneFormat.TimeType.DAYLIGHT && nArray[1] == 0) {
                        timeZone2.getOffset(l2 - 86400000L, true, nArray);
                    }
                }
                int n12 = nArray[1];
                if (timeType == TimeZoneFormat.TimeType.STANDARD) {
                    if (nArray[1] != 0) {
                        n12 = 0;
                    }
                } else if (nArray[1] == 0) {
                    if (basicTimeZone == null) {
                        n12 = timeZone2.getDSTSavings();
                    } else {
                        long l3;
                        long l4 = l3 = l2 + (long)nArray[0];
                        long l5 = l3 + 946080000000L;
                        TimeZoneTransition timeZoneTransition = null;
                        while (l4 < l5 && (timeZoneTransition = basicTimeZone.getNextTransition(l4, false)) != null && (n12 = timeZoneTransition.getTo().getDSTSavings()) == 0) {
                            l4 = timeZoneTransition.getTime();
                        }
                        if (n12 == 0) {
                            l4 = l3;
                            l5 = l3 - 946080000000L;
                            while (l4 > l5 && (timeZoneTransition = basicTimeZone.getPreviousTransition(l4, true)) != null && (n12 = timeZoneTransition.getFrom().getDSTSavings()) == 0) {
                                l4 = timeZoneTransition.getTime() - 1L;
                            }
                            if (n12 == 0) {
                                n12 = basicTimeZone.getDSTSavings();
                            }
                        }
                    }
                    if (n12 == 0) {
                        n12 = 3600000;
                    }
                }
                calendar.set(15, nArray[0]);
                calendar.set(16, n12);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                parsePosition.setErrorIndex(n4);
                parsePosition.setIndex(n5);
                if (timeZone != null) {
                    this.calendar.setTimeZone(timeZone);
                }
                return;
            }
        }
        if (calendar2 != null) {
            calendar2.setTimeZone(calendar.getTimeZone());
            calendar2.setTimeInMillis(calendar.getTimeInMillis());
        }
        if (timeZone != null) {
            this.calendar.setTimeZone(timeZone);
        }
    }

    private int matchLiteral(String string, int n2, Object[] objectArray, int n3, boolean[] blArray) {
        char c2;
        int n4 = n2;
        String string2 = (String)objectArray[n3];
        int n5 = string2.length();
        int n6 = string.length();
        int n7 = 0;
        while (n7 < n5 && n2 < n6) {
            char c3 = string2.charAt(n7);
            char c4 = string.charAt(n2);
            if ((PatternProps.isWhiteSpace(c3) || UCharacter.isUWhiteSpace(c3)) && (PatternProps.isWhiteSpace(c4) || UCharacter.isUWhiteSpace(c4))) {
                while (n7 + 1 < n5 && (PatternProps.isWhiteSpace(string2.charAt(n7 + 1)) || UCharacter.isUWhiteSpace(string2.charAt(n7 + 1)))) {
                    ++n7;
                }
                while (n2 + 1 < n6 && (PatternProps.isWhiteSpace(string.charAt(n2 + 1)) || UCharacter.isUWhiteSpace(string.charAt(n2 + 1)))) {
                    ++n2;
                }
            } else if (c3 != c4) {
                if (c4 == '.' && n2 == n4 && 0 < n3 && this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_ALLOW_WHITESPACE)) {
                    Object object = objectArray[n3 - 1];
                    if (!(object instanceof PatternItem) || (c2 = ((PatternItem)object).isNumeric) != '\u0000') break;
                    ++n2;
                    continue;
                }
                if ((c3 == ' ' || c3 == '.') && this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_ALLOW_WHITESPACE)) {
                    ++n7;
                    continue;
                }
                if (n2 == n4 || !this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_PARTIAL_LITERAL_MATCH)) break;
                ++n7;
                continue;
            }
            ++n7;
            ++n2;
        }
        boolean bl2 = blArray[0] = n7 == n5;
        if (!blArray[0] && this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_ALLOW_WHITESPACE) && 0 < n3 && n3 < objectArray.length - 1 && n4 < n6) {
            Object object = objectArray[n3 - 1];
            Object object2 = objectArray[n3 + 1];
            if (object instanceof PatternItem && object2 instanceof PatternItem) {
                char c5 = ((PatternItem)object).type;
                c2 = ((PatternItem)object2).type;
                if (DATE_PATTERN_TYPE.contains(c5) != DATE_PATTERN_TYPE.contains(c2)) {
                    char c6;
                    int n8;
                    for (n8 = n4; n8 < n6 && PatternProps.isWhiteSpace(c6 = string.charAt(n8)); ++n8) {
                    }
                    blArray[0] = n8 > n4;
                    n2 = n8;
                }
            }
        }
        return n2;
    }

    @Deprecated
    private int matchAlphaMonthStrings(String string, int n2, String[] stringArray, String[] stringArray2, Calendar calendar) {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int n7 = -1;
        for (n5 = 0; n5 < stringArray.length; ++n5) {
            n4 = stringArray[n5].length();
            n3 = 0;
            if (n4 <= n6 || (n3 = this.regionMatchesWithOptionalDot(string, n2, stringArray[n5], n4)) < 0) continue;
            n7 = n5;
            n6 = n3;
        }
        for (n5 = 0; n5 < stringArray2.length; ++n5) {
            n4 = stringArray2[n5].length();
            n3 = 0;
            if (n4 <= n6 || (n3 = this.regionMatchesWithOptionalDot(string, n2, stringArray2[n5], n4)) < 0) continue;
            n7 = n5;
            n6 = n3;
        }
        if (n7 >= 0) {
            calendar.set(2, n7);
            return n2 + n6;
        }
        return ~n2;
    }

    protected int matchString(String string, int n2, int n3, String[] stringArray, Calendar calendar) {
        return this.matchString(string, n2, n3, stringArray, null, calendar);
    }

    @Deprecated
    private int matchString(String string, int n2, int n3, String[] stringArray, String string2, Calendar calendar) {
        int n4 = 0;
        int n5 = stringArray.length;
        if (n3 == 7) {
            n4 = 1;
        }
        int n6 = 0;
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        while (n4 < n5) {
            String string3;
            int n10 = stringArray[n4].length();
            if (n10 > n6 && (n9 = this.regionMatchesWithOptionalDot(string, n2, stringArray[n4], n10)) >= 0) {
                n7 = n4;
                n6 = n9;
                n8 = 0;
            }
            if (string2 != null && (n10 = (string3 = SimpleFormatterImpl.formatRawPattern(string2, 1, 1, stringArray[n4])).length()) > n6 && (n9 = this.regionMatchesWithOptionalDot(string, n2, string3, n10)) >= 0) {
                n7 = n4;
                n6 = n9;
                n8 = 1;
            }
            ++n4;
        }
        if (n7 >= 0) {
            if (n3 >= 0) {
                if (n3 == 1) {
                    ++n7;
                }
                calendar.set(n3, n7);
                if (string2 != null) {
                    calendar.set(22, n8);
                }
            }
            return n2 + n6;
        }
        return ~n2;
    }

    private int regionMatchesWithOptionalDot(String string, int n2, String string2, int n3) {
        boolean bl2 = string.regionMatches(true, n2, string2, 0, n3);
        if (bl2) {
            return n3;
        }
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '.' && string.regionMatches(true, n2, string2, 0, n3 - 1)) {
            return n3 - 1;
        }
        return -1;
    }

    protected int matchQuarterString(String string, int n2, int n3, String[] stringArray, Calendar calendar) {
        int n4 = stringArray.length;
        int n5 = 0;
        int n6 = -1;
        int n7 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n8 = stringArray[i2].length();
            if (n8 <= n5 || (n7 = this.regionMatchesWithOptionalDot(string, n2, stringArray[i2], n8)) < 0) continue;
            n6 = i2;
            n5 = n7;
        }
        if (n6 >= 0) {
            calendar.set(n3, n6 * 3);
            return n2 + n5;
        }
        return -n2;
    }

    private int matchDayPeriodString(String string, int n2, String[] stringArray, int n3, Output<DayPeriodRules.DayPeriod> output) {
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n7;
            if (stringArray[i2] == null || (n7 = stringArray[i2].length()) <= n4 || (n6 = this.regionMatchesWithOptionalDot(string, n2, stringArray[i2], n7)) < 0) continue;
            n5 = i2;
            n4 = n6;
        }
        if (n5 >= 0) {
            output.value = DayPeriodRules.DayPeriod.VALUES[n5];
            return n2 + n4;
        }
        return -n2;
    }

    protected int subParse(String string, int n2, char c2, int n3, boolean bl2, boolean bl3, boolean[] blArray, Calendar calendar) {
        return this.subParse(string, n2, c2, n3, bl2, bl3, blArray, calendar, null, null);
    }

    private int subParse(String string, int n2, char c2, int n3, boolean bl2, boolean bl3, boolean[] blArray, Calendar calendar, MessageFormat messageFormat, Output<TimeZoneFormat.TimeType> output) {
        return this.subParse(string, n2, c2, n3, bl2, bl3, blArray, calendar, null, null, null);
    }

    @Deprecated
    private int subParse(String string, int n2, char c2, int n3, boolean bl2, boolean bl3, boolean[] blArray, Calendar calendar, MessageFormat messageFormat, Output<TimeZoneFormat.TimeType> output, Output<DayPeriodRules.DayPeriod> output2) {
        Object object;
        int n4;
        boolean bl4;
        Number number = null;
        NumberFormat numberFormat = null;
        int n5 = 0;
        ParsePosition parsePosition = new ParsePosition(0);
        int n6 = SimpleDateFormat.getIndexFromChar(c2);
        if (n6 == -1) {
            return ~n2;
        }
        numberFormat = this.getNumberFormat(c2);
        int n7 = PATTERN_INDEX_TO_CALENDAR_FIELD[n6];
        if (messageFormat != null) {
            messageFormat.setFormatByArgumentIndex(0, numberFormat);
        }
        boolean bl5 = bl4 = calendar.getType().equals("chinese") || calendar.getType().equals("dangi");
        while (true) {
            if (n2 >= string.length()) {
                return ~n2;
            }
            n4 = UTF16.charAt(string, n2);
            if (!UCharacter.isUWhiteSpace(n4) && !PatternProps.isWhiteSpace(n4)) break;
            n2 += UTF16.getCharCount(n4);
        }
        parsePosition.setIndex(n2);
        if (n6 == 4 || n6 == 15 || n6 == 2 && n3 <= 2 || n6 == 26 || n6 == 19 || n6 == 25 || n6 == 1 || n6 == 18 || n6 == 30 || n6 == 0 && bl4 || n6 == 27 || n6 == 28 || n6 == 8) {
            n4 = 0;
            if (messageFormat != null && (n6 == 2 || n6 == 26)) {
                object = messageFormat.parse(string, parsePosition);
                if (object != null && parsePosition.getIndex() > n2 && object[0] instanceof Number) {
                    n4 = 1;
                    number = (Number)object[0];
                    calendar.set(22, 1);
                } else {
                    parsePosition.setIndex(n2);
                    calendar.set(22, 0);
                }
            }
            if (n4 == 0) {
                if (bl2) {
                    if (n2 + n3 > string.length()) {
                        return ~n2;
                    }
                    number = this.parseInt(string, n3, parsePosition, bl3, numberFormat);
                } else {
                    number = this.parseInt(string, parsePosition, bl3, numberFormat);
                }
                if (number == null && !this.allowNumericFallback(n6)) {
                    return ~n2;
                }
            }
            if (number != null) {
                n5 = number.intValue();
            }
        }
        switch (n6) {
            case 0: {
                if (bl4) {
                    calendar.set(0, n5);
                    return parsePosition.getIndex();
                }
                n4 = 0;
                n4 = n3 == 5 ? this.matchString(string, n2, 0, this.formatData.narrowEras, null, calendar) : (n3 == 4 ? this.matchString(string, n2, 0, this.formatData.eraNames, null, calendar) : this.matchString(string, n2, 0, this.formatData.eras, null, calendar));
                if (n4 == ~n2) {
                    n4 = -32000;
                }
                return n4;
            }
            case 1: 
            case 18: {
                if (this.override != null && (this.override.compareTo("hebr") == 0 || this.override.indexOf("y=hebr") >= 0) && n5 < 1000) {
                    n5 += 5000;
                } else if (n3 == 2 && SimpleDateFormat.countDigits(string, n2, parsePosition.getIndex()) == 2 && calendar.haveDefaultCentury()) {
                    int n8 = this.getDefaultCenturyStartYear() % 100;
                    blArray[0] = n5 == n8;
                    n5 += this.getDefaultCenturyStartYear() / 100 * 100 + (n5 < n8 ? 100 : 0);
                }
                calendar.set(n7, n5);
                if (DelayedHebrewMonthCheck) {
                    if (!HebrewCalendar.isLeapYear(n5)) {
                        calendar.add(2, 1);
                    }
                    DelayedHebrewMonthCheck = false;
                }
                return parsePosition.getIndex();
            }
            case 30: {
                int n9;
                if (this.formatData.shortYearNames != null && (n9 = this.matchString(string, n2, 1, this.formatData.shortYearNames, null, calendar)) > 0) {
                    return n9;
                }
                if (number != null && (this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_ALLOW_NUMERIC) || this.formatData.shortYearNames == null || n5 > this.formatData.shortYearNames.length)) {
                    calendar.set(1, n5);
                    return parsePosition.getIndex();
                }
                return ~n2;
            }
            case 2: 
            case 26: {
                if (n3 <= 2 || number != null && this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_ALLOW_NUMERIC)) {
                    calendar.set(2, n5 - 1);
                    if (calendar.getType().equals("hebrew") && n5 >= 6) {
                        if (calendar.isSet(1)) {
                            if (!HebrewCalendar.isLeapYear(calendar.get(1))) {
                                calendar.set(2, n5);
                            }
                        } else {
                            DelayedHebrewMonthCheck = true;
                        }
                    }
                    return parsePosition.getIndex();
                }
                boolean bl6 = this.formatData.leapMonthPatterns != null && this.formatData.leapMonthPatterns.length >= 7;
                int n10 = 0;
                if (this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) && n3 >= 3 && n3 <= 4 && !bl6) {
                    int n11 = n10 = n6 == 2 ? this.matchAlphaMonthStrings(string, n2, this.formatData.months, this.formatData.shortMonths, calendar) : this.matchAlphaMonthStrings(string, n2, this.formatData.standaloneMonths, this.formatData.standaloneShortMonths, calendar);
                    if (n10 > 0) {
                        return n10;
                    }
                }
                if (this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 4) {
                    int n12 = n6 == 2 ? this.matchString(string, n2, 2, this.formatData.months, bl6 ? this.formatData.leapMonthPatterns[0] : null, calendar) : (n10 = this.matchString(string, n2, 2, this.formatData.standaloneMonths, bl6 ? this.formatData.leapMonthPatterns[3] : null, calendar));
                    if (n10 > 0) {
                        return n10;
                    }
                }
                if (this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 3) {
                    return n6 == 2 ? this.matchString(string, n2, 2, this.formatData.shortMonths, bl6 ? this.formatData.leapMonthPatterns[1] : null, calendar) : this.matchString(string, n2, 2, this.formatData.standaloneShortMonths, bl6 ? this.formatData.leapMonthPatterns[4] : null, calendar);
                }
                return n10;
            }
            case 4: {
                if (n5 == calendar.getMaximum(11) + 1) {
                    n5 = 0;
                }
                calendar.set(11, n5);
                return parsePosition.getIndex();
            }
            case 8: {
                int n13;
                if (n13 < 3) {
                    for (n13 = SimpleDateFormat.countDigits(string, n2, parsePosition.getIndex()); n13 < 3; ++n13) {
                        n5 *= 10;
                    }
                } else {
                    int n14 = 1;
                    while (n13 > 3) {
                        n14 *= 10;
                        --n13;
                    }
                    n5 /= n14;
                }
                calendar.set(14, n5);
                return parsePosition.getIndex();
            }
            case 19: {
                if (n3 <= 2 || number != null && this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_ALLOW_NUMERIC)) {
                    calendar.set(n7, n5);
                    return parsePosition.getIndex();
                }
            }
            case 9: {
                int n15 = 0;
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 4) && (n15 = this.matchString(string, n2, 7, this.formatData.weekdays, null, calendar)) > 0) {
                    return n15;
                }
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 3) && (n15 = this.matchString(string, n2, 7, this.formatData.shortWeekdays, null, calendar)) > 0) {
                    return n15;
                }
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 6) && this.formatData.shorterWeekdays != null && (n15 = this.matchString(string, n2, 7, this.formatData.shorterWeekdays, null, calendar)) > 0) {
                    return n15;
                }
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 5) && this.formatData.narrowWeekdays != null && (n15 = this.matchString(string, n2, 7, this.formatData.narrowWeekdays, null, calendar)) > 0) {
                    return n15;
                }
                return n15;
            }
            case 25: {
                if (n3 == 1 || number != null && this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_ALLOW_NUMERIC)) {
                    calendar.set(n7, n5);
                    return parsePosition.getIndex();
                }
                int n16 = 0;
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 4) && (n16 = this.matchString(string, n2, 7, this.formatData.standaloneWeekdays, null, calendar)) > 0) {
                    return n16;
                }
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 3) && (n16 = this.matchString(string, n2, 7, this.formatData.standaloneShortWeekdays, null, calendar)) > 0) {
                    return n16;
                }
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 6) && this.formatData.standaloneShorterWeekdays != null) {
                    return this.matchString(string, n2, 7, this.formatData.standaloneShorterWeekdays, null, calendar);
                }
                return n16;
            }
            case 14: {
                int n17 = 0;
                if ((this.formatData.ampmsNarrow == null || n3 < 5 || this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH)) && (n17 = this.matchString(string, n2, 9, this.formatData.ampms, null, calendar)) > 0) {
                    return n17;
                }
                if (this.formatData.ampmsNarrow != null && (n3 >= 5 || this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH)) && (n17 = this.matchString(string, n2, 9, this.formatData.ampmsNarrow, null, calendar)) > 0) {
                    return n17;
                }
                return ~n2;
            }
            case 15: {
                if (n5 == calendar.getLeastMaximum(10) + 1) {
                    n5 = 0;
                }
                calendar.set(10, n5);
                return parsePosition.getIndex();
            }
            case 17: {
                object = n3 < 4 ? TimeZoneFormat.Style.SPECIFIC_SHORT : TimeZoneFormat.Style.SPECIFIC_LONG;
                TimeZone timeZone = this.tzFormat().parse((TimeZoneFormat.Style)((Object)object), string, parsePosition, output);
                if (timeZone != null) {
                    calendar.setTimeZone(timeZone);
                    return parsePosition.getIndex();
                }
                return ~n2;
            }
            case 23: {
                object = n3 < 4 ? TimeZoneFormat.Style.ISO_BASIC_LOCAL_FULL : (n3 == 5 ? TimeZoneFormat.Style.ISO_EXTENDED_FULL : TimeZoneFormat.Style.LOCALIZED_GMT);
                TimeZone timeZone = this.tzFormat().parse((TimeZoneFormat.Style)((Object)object), string, parsePosition, output);
                if (timeZone != null) {
                    calendar.setTimeZone(timeZone);
                    return parsePosition.getIndex();
                }
                return ~n2;
            }
            case 24: {
                object = n3 < 4 ? TimeZoneFormat.Style.GENERIC_SHORT : TimeZoneFormat.Style.GENERIC_LONG;
                TimeZone timeZone = this.tzFormat().parse((TimeZoneFormat.Style)((Object)object), string, parsePosition, output);
                if (timeZone != null) {
                    calendar.setTimeZone(timeZone);
                    return parsePosition.getIndex();
                }
                return ~n2;
            }
            case 29: {
                object = null;
                switch (n3) {
                    case 1: {
                        object = TimeZoneFormat.Style.ZONE_ID_SHORT;
                        break;
                    }
                    case 2: {
                        object = TimeZoneFormat.Style.ZONE_ID;
                        break;
                    }
                    case 3: {
                        object = TimeZoneFormat.Style.EXEMPLAR_LOCATION;
                        break;
                    }
                    default: {
                        object = TimeZoneFormat.Style.GENERIC_LOCATION;
                    }
                }
                TimeZone timeZone = this.tzFormat().parse((TimeZoneFormat.Style)((Object)object), string, parsePosition, output);
                if (timeZone != null) {
                    calendar.setTimeZone(timeZone);
                    return parsePosition.getIndex();
                }
                return ~n2;
            }
            case 31: {
                object = n3 < 4 ? TimeZoneFormat.Style.LOCALIZED_GMT_SHORT : TimeZoneFormat.Style.LOCALIZED_GMT;
                TimeZone timeZone = this.tzFormat().parse((TimeZoneFormat.Style)((Object)object), string, parsePosition, output);
                if (timeZone != null) {
                    calendar.setTimeZone(timeZone);
                    return parsePosition.getIndex();
                }
                return ~n2;
            }
            case 32: {
                switch (n3) {
                    case 1: {
                        object = TimeZoneFormat.Style.ISO_BASIC_SHORT;
                        break;
                    }
                    case 2: {
                        object = TimeZoneFormat.Style.ISO_BASIC_FIXED;
                        break;
                    }
                    case 3: {
                        object = TimeZoneFormat.Style.ISO_EXTENDED_FIXED;
                        break;
                    }
                    case 4: {
                        object = TimeZoneFormat.Style.ISO_BASIC_FULL;
                        break;
                    }
                    default: {
                        object = TimeZoneFormat.Style.ISO_EXTENDED_FULL;
                    }
                }
                TimeZone timeZone = this.tzFormat().parse((TimeZoneFormat.Style)((Object)object), string, parsePosition, output);
                if (timeZone != null) {
                    calendar.setTimeZone(timeZone);
                    return parsePosition.getIndex();
                }
                return ~n2;
            }
            case 33: {
                switch (n3) {
                    case 1: {
                        object = TimeZoneFormat.Style.ISO_BASIC_LOCAL_SHORT;
                        break;
                    }
                    case 2: {
                        object = TimeZoneFormat.Style.ISO_BASIC_LOCAL_FIXED;
                        break;
                    }
                    case 3: {
                        object = TimeZoneFormat.Style.ISO_EXTENDED_LOCAL_FIXED;
                        break;
                    }
                    case 4: {
                        object = TimeZoneFormat.Style.ISO_BASIC_LOCAL_FULL;
                        break;
                    }
                    default: {
                        object = TimeZoneFormat.Style.ISO_EXTENDED_LOCAL_FULL;
                    }
                }
                TimeZone timeZone = this.tzFormat().parse((TimeZoneFormat.Style)((Object)object), string, parsePosition, output);
                if (timeZone != null) {
                    calendar.setTimeZone(timeZone);
                    return parsePosition.getIndex();
                }
                return ~n2;
            }
            case 27: {
                if (n3 <= 2 && number != null) {
                    calendar.set(2, (n5 - 1) * 3);
                    return parsePosition.getIndex();
                }
                int n18 = 0;
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 4) && (n18 = this.matchQuarterString(string, n2, 2, this.formatData.quarters, calendar)) > 0) {
                    return n18;
                }
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 3) && (n18 = this.matchQuarterString(string, n2, 2, this.formatData.shortQuarters, calendar)) > 0) {
                    return n18;
                }
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 5) && (n18 = this.matchQuarterString(string, n2, 2, this.formatData.narrowQuarters, calendar)) > 0) {
                    return n18;
                }
                if (this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_ALLOW_NUMERIC) && number != null) {
                    calendar.set(2, (n5 - 1) * 3);
                    return parsePosition.getIndex();
                }
                return n18;
            }
            case 28: {
                if (n3 <= 2 && number != null) {
                    calendar.set(2, (n5 - 1) * 3);
                    return parsePosition.getIndex();
                }
                int n19 = 0;
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 4) && (n19 = this.matchQuarterString(string, n2, 2, this.formatData.standaloneQuarters, calendar)) > 0) {
                    return n19;
                }
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 3) && (n19 = this.matchQuarterString(string, n2, 2, this.formatData.standaloneShortQuarters, calendar)) > 0) {
                    return n19;
                }
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 5) && (n19 = this.matchQuarterString(string, n2, 2, this.formatData.standaloneNarrowQuarters, calendar)) > 0) {
                    return n19;
                }
                if (this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_ALLOW_NUMERIC) && number != null) {
                    calendar.set(2, (n5 - 1) * 3);
                    return parsePosition.getIndex();
                }
                return n19;
            }
            case 37: {
                object = new ArrayList(3);
                ((ArrayList)object).add(this.formatData.getTimeSeparatorString());
                if (!this.formatData.getTimeSeparatorString().equals(":")) {
                    ((ArrayList)object).add(":");
                }
                if (this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_PARTIAL_LITERAL_MATCH) && !this.formatData.getTimeSeparatorString().equals(".")) {
                    ((ArrayList)object).add(".");
                }
                return this.matchString(string, n2, -1, ((ArrayList)object).toArray(new String[0]), calendar);
            }
            case 35: {
                int n20 = this.subParse(string, n2, 'a', n3, bl2, bl3, blArray, calendar, messageFormat, output, output2);
                if (n20 > 0) {
                    return n20;
                }
                int n21 = 0;
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 3) && (n21 = this.matchDayPeriodString(string, n2, this.formatData.abbreviatedDayPeriods, 2, output2)) > 0) {
                    return n21;
                }
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 4) && (n21 = this.matchDayPeriodString(string, n2, this.formatData.wideDayPeriods, 2, output2)) > 0) {
                    return n21;
                }
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 4) && (n21 = this.matchDayPeriodString(string, n2, this.formatData.narrowDayPeriods, 2, output2)) > 0) {
                    return n21;
                }
                return n21;
            }
            case 36: {
                int n22 = 0;
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 3) && (n22 = this.matchDayPeriodString(string, n2, this.formatData.abbreviatedDayPeriods, this.formatData.abbreviatedDayPeriods.length, output2)) > 0) {
                    return n22;
                }
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 4) && (n22 = this.matchDayPeriodString(string, n2, this.formatData.wideDayPeriods, this.formatData.wideDayPeriods.length, output2)) > 0) {
                    return n22;
                }
                if ((this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_MULTIPLE_PATTERNS_FOR_MATCH) || n3 == 4) && (n22 = this.matchDayPeriodString(string, n2, this.formatData.narrowDayPeriods, this.formatData.narrowDayPeriods.length, output2)) > 0) {
                    return n22;
                }
                return n22;
            }
        }
        if (bl2) {
            if (n2 + n3 > string.length()) {
                return -n2;
            }
            number = this.parseInt(string, n3, parsePosition, bl3, numberFormat);
        } else {
            number = this.parseInt(string, parsePosition, bl3, numberFormat);
        }
        if (bl2 && !this.isLenient() && parsePosition.getIndex() < n2 + n3) {
            return -n2;
        }
        if (number != null) {
            if (n6 != 34) {
                calendar.set(n7, number.intValue());
            } else {
                calendar.setRelatedYear(number.intValue());
            }
            return parsePosition.getIndex();
        }
        return ~n2;
    }

    private boolean allowNumericFallback(int n2) {
        return n2 == 26 || n2 == 19 || n2 == 25 || n2 == 30 || n2 == 27 || n2 == 28;
    }

    private Number parseInt(String string, ParsePosition parsePosition, boolean bl2, NumberFormat numberFormat) {
        return this.parseInt(string, -1, parsePosition, bl2, numberFormat);
    }

    private Number parseInt(String string, int n2, ParsePosition parsePosition, boolean bl2, NumberFormat numberFormat) {
        int n3;
        Number number;
        int n4 = parsePosition.getIndex();
        if (bl2) {
            number = numberFormat.parse(string, parsePosition);
        } else if (numberFormat instanceof DecimalFormat) {
            String string2 = ((DecimalFormat)numberFormat).getNegativePrefix();
            ((DecimalFormat)numberFormat).setNegativePrefix(SUPPRESS_NEGATIVE_PREFIX);
            number = numberFormat.parse(string, parsePosition);
            ((DecimalFormat)numberFormat).setNegativePrefix(string2);
        } else {
            boolean bl3 = numberFormat instanceof DateNumberFormat;
            if (bl3) {
                ((DateNumberFormat)numberFormat).setParsePositiveOnly(true);
            }
            number = numberFormat.parse(string, parsePosition);
            if (bl3) {
                ((DateNumberFormat)numberFormat).setParsePositiveOnly(false);
            }
        }
        if (n2 > 0 && (n3 = parsePosition.getIndex() - n4) > n2) {
            double d2 = number.doubleValue();
            n3 -= n2;
            while (n3 > 0) {
                d2 /= 10.0;
                --n3;
            }
            parsePosition.setIndex(n4 + n2);
            number = (int)d2;
        }
        return number;
    }

    private static int countDigits(String string, int n2, int n3) {
        int n4;
        int n5 = 0;
        for (int i2 = n2; i2 < n3; i2 += UCharacter.charCount(n4)) {
            n4 = string.codePointAt(i2);
            if (!UCharacter.isDigit(n4)) continue;
            ++n5;
        }
        return n5;
    }

    private String translatePattern(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n2;
            char c2 = string.charAt(i2);
            if (bl2) {
                if (c2 == '\'') {
                    bl2 = false;
                }
            } else if (c2 == '\'') {
                bl2 = true;
            } else if (SimpleDateFormat.isSyntaxChar(c2) && (n2 = string2.indexOf(c2)) != -1) {
                c2 = string3.charAt(n2);
            }
            stringBuilder.append(c2);
        }
        if (bl2) {
            throw new IllegalArgumentException("Unfinished quote in pattern");
        }
        return stringBuilder.toString();
    }

    public String toPattern() {
        return this.pattern;
    }

    public String toLocalizedPattern() {
        return this.translatePattern(this.pattern, "GyMdkHmsSEDFwWahKzYeugAZvcLQqVUOXxrbB", this.formatData.localPatternChars);
    }

    public void applyPattern(String string) {
        this.pattern = string;
        this.parsePattern();
        this.setLocale(null, null);
        this.patternItems = null;
        if (this.calendar != null && this.calendar.getType().equals("japanese") && this.locale != null && this.locale.getLanguage().equals("ja")) {
            if (this.override != null && this.override.equals("y=jpanyear") && !this.hasHanYearChar) {
                this.numberFormatters = null;
                this.overrideMap = null;
                this.override = null;
            } else if (this.override == null && this.hasHanYearChar) {
                this.numberFormatters = new HashMap();
                this.overrideMap = new HashMap();
                this.overrideMap.put(Character.valueOf('y'), "jpanyear");
                ULocale uLocale = new ULocale(this.locale.getBaseName() + "@numbers=jpanyear");
                NumberFormat numberFormat = NumberFormat.createInstance(uLocale, 0);
                numberFormat.setGroupingUsed(false);
                this.useLocalZeroPaddingNumberFormat = false;
                this.numberFormatters.put("jpanyear", numberFormat);
                this.override = "y=jpanyear";
            }
        }
    }

    public void applyLocalizedPattern(String string) {
        this.pattern = this.translatePattern(string, this.formatData.localPatternChars, "GyMdkHmsSEDFwWahKzYeugAZvcLQqVUOXxrbB");
        this.setLocale(null, null);
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return (DateFormatSymbols)this.formatData.clone();
    }

    public void setDateFormatSymbols(DateFormatSymbols dateFormatSymbols) {
        this.formatData = (DateFormatSymbols)dateFormatSymbols.clone();
    }

    protected DateFormatSymbols getSymbols() {
        return this.formatData;
    }

    public TimeZoneFormat getTimeZoneFormat() {
        return this.tzFormat().freeze();
    }

    public void setTimeZoneFormat(TimeZoneFormat timeZoneFormat) {
        this.tzFormat = timeZoneFormat.isFrozen() ? timeZoneFormat : timeZoneFormat.cloneAsThawed().freeze();
    }

    @Override
    public Object clone() {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)super.clone();
        simpleDateFormat.formatData = (DateFormatSymbols)this.formatData.clone();
        if (this.decimalBuf != null) {
            simpleDateFormat.decimalBuf = new char[10];
        }
        return simpleDateFormat;
    }

    @Override
    public int hashCode() {
        return this.pattern.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)object;
        return this.pattern.equals(simpleDateFormat.pattern) && this.formatData.equals(simpleDateFormat.formatData);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.defaultCenturyStart == null) {
            this.initializeDefaultCenturyStart(this.defaultCenturyBase);
        }
        this.initializeTimeZoneFormat(false);
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.getContext(DisplayContext.Type.CAPITALIZATION).value());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n2;
        objectInputStream.defaultReadObject();
        int n3 = n2 = this.serialVersionOnStream > 1 ? objectInputStream.readInt() : -1;
        if (this.serialVersionOnStream < 1) {
            this.defaultCenturyBase = System.currentTimeMillis();
        } else {
            this.parseAmbiguousDatesAsAfter(this.defaultCenturyStart);
        }
        this.serialVersionOnStream = 2;
        this.locale = this.getLocale(ULocale.VALID_LOCALE);
        if (this.locale == null) {
            this.locale = ULocale.getDefault(ULocale.Category.FORMAT);
        }
        this.initLocalZeroPaddingNumberFormat();
        this.setContext(DisplayContext.CAPITALIZATION_NONE);
        if (n2 >= 0) {
            for (DisplayContext displayContext : DisplayContext.values()) {
                if (displayContext.value() != n2) continue;
                this.setContext(displayContext);
                break;
            }
        }
        if (!this.getBooleanAttribute(DateFormat.BooleanAttribute.PARSE_PARTIAL_MATCH)) {
            this.setBooleanAttribute(DateFormat.BooleanAttribute.PARSE_PARTIAL_LITERAL_MATCH, false);
        }
        this.parsePattern();
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        Calendar calendar = this.calendar;
        if (object instanceof Calendar) {
            calendar = (Calendar)object;
        } else if (object instanceof Date) {
            this.calendar.setTime((Date)object);
        } else if (object instanceof Number) {
            this.calendar.setTimeInMillis(((Number)object).longValue());
        } else {
            throw new IllegalArgumentException("Cannot format given Object as a Date");
        }
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        ArrayList<FieldPosition> arrayList = new ArrayList<FieldPosition>();
        this.format(calendar, this.getContext(DisplayContext.Type.CAPITALIZATION), stringBuffer, fieldPosition, arrayList);
        AttributedString attributedString = new AttributedString(stringBuffer.toString());
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            FieldPosition fieldPosition2 = (FieldPosition)arrayList.get(i2);
            Format.Field field = fieldPosition2.getFieldAttribute();
            attributedString.addAttribute(field, field, fieldPosition2.getBeginIndex(), fieldPosition2.getEndIndex());
        }
        return attributedString.getIterator();
    }

    ULocale getLocale() {
        return this.locale;
    }

    boolean isFieldUnitIgnored(int n2) {
        return SimpleDateFormat.isFieldUnitIgnored(this.pattern, n2);
    }

    static boolean isFieldUnitIgnored(String string, int n2) {
        int n3;
        int n4 = CALENDAR_FIELD_TO_LEVEL[n2];
        boolean bl2 = false;
        char c2 = '\u0000';
        int n5 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c3 = string.charAt(i2);
            if (c3 != c2 && n5 > 0) {
                n3 = SimpleDateFormat.getLevelFromChar(c2);
                if (n4 <= n3) {
                    return false;
                }
                n5 = 0;
            }
            if (c3 == '\'') {
                if (i2 + 1 < string.length() && string.charAt(i2 + 1) == '\'') {
                    ++i2;
                    continue;
                }
                bl2 = !bl2;
                continue;
            }
            if (bl2 || !SimpleDateFormat.isSyntaxChar(c3)) continue;
            c2 = c3;
            ++n5;
        }
        return n5 <= 0 || n4 > (n3 = SimpleDateFormat.getLevelFromChar(c2));
    }

    @Deprecated
    public final StringBuffer intervalFormatByAlgorithm(Calendar calendar, Calendar calendar2, StringBuffer stringBuffer, FieldPosition fieldPosition) throws IllegalArgumentException {
        int n2;
        int n3;
        int n4;
        if (!calendar.isEquivalentTo(calendar2)) {
            throw new IllegalArgumentException("can not format on two different calendars");
        }
        Object[] objectArray = this.getPatternItems();
        int n5 = -1;
        int n6 = -1;
        try {
            for (n4 = 0; n4 < objectArray.length; ++n4) {
                if (!this.diffCalFieldValue(calendar, calendar2, objectArray, n4)) continue;
                n5 = n4;
                break;
            }
            if (n5 == -1) {
                return this.format(calendar, stringBuffer, fieldPosition);
            }
            for (n4 = objectArray.length - 1; n4 >= n5; --n4) {
                if (!this.diffCalFieldValue(calendar, calendar2, objectArray, n4)) continue;
                n6 = n4;
                break;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(illegalArgumentException.toString());
        }
        if (n5 == 0 && n6 == objectArray.length - 1) {
            this.format(calendar, stringBuffer, fieldPosition);
            stringBuffer.append(" \u2013 ");
            this.format(calendar2, stringBuffer, fieldPosition);
            return stringBuffer;
        }
        n4 = 1000;
        for (n3 = n5; n3 <= n6; ++n3) {
            if (objectArray[n3] instanceof String) continue;
            PatternItem patternItem = (PatternItem)objectArray[n3];
            char c2 = patternItem.type;
            int n7 = SimpleDateFormat.getIndexFromChar(c2);
            if (n7 == -1) {
                throw new IllegalArgumentException("Illegal pattern character '" + c2 + "' in \"" + this.pattern + '\"');
            }
            if (n7 >= n4) continue;
            n4 = n7;
        }
        try {
            for (n3 = 0; n3 < n5; ++n3) {
                if (!this.lowerLevel(objectArray, n3, n4)) continue;
                n5 = n3;
                break;
            }
            for (n3 = objectArray.length - 1; n3 > n6; --n3) {
                if (!this.lowerLevel(objectArray, n3, n4)) continue;
                n6 = n3;
                break;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(illegalArgumentException.toString());
        }
        if (n5 == 0 && n6 == objectArray.length - 1) {
            this.format(calendar, stringBuffer, fieldPosition);
            stringBuffer.append(" \u2013 ");
            this.format(calendar2, stringBuffer, fieldPosition);
            return stringBuffer;
        }
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        DisplayContext displayContext = this.getContext(DisplayContext.Type.CAPITALIZATION);
        for (n2 = 0; n2 <= n6; ++n2) {
            if (objectArray[n2] instanceof String) {
                stringBuffer.append((String)objectArray[n2]);
                continue;
            }
            PatternItem patternItem = (PatternItem)objectArray[n2];
            if (this.useFastFormat) {
                this.subFormat(stringBuffer, patternItem.type, patternItem.length, stringBuffer.length(), n2, displayContext, fieldPosition, patternItem.type, calendar);
                continue;
            }
            stringBuffer.append(this.subFormat(patternItem.type, patternItem.length, stringBuffer.length(), n2, displayContext, fieldPosition, patternItem.type, calendar));
        }
        stringBuffer.append(" \u2013 ");
        for (n2 = n5; n2 < objectArray.length; ++n2) {
            if (objectArray[n2] instanceof String) {
                stringBuffer.append((String)objectArray[n2]);
                continue;
            }
            PatternItem patternItem = (PatternItem)objectArray[n2];
            if (this.useFastFormat) {
                this.subFormat(stringBuffer, patternItem.type, patternItem.length, stringBuffer.length(), n2, displayContext, fieldPosition, patternItem.type, calendar2);
                continue;
            }
            stringBuffer.append(this.subFormat(patternItem.type, patternItem.length, stringBuffer.length(), n2, displayContext, fieldPosition, patternItem.type, calendar2));
        }
        return stringBuffer;
    }

    private boolean diffCalFieldValue(Calendar calendar, Calendar calendar2, Object[] objectArray, int n2) throws IllegalArgumentException {
        int n3;
        int n4;
        if (objectArray[n2] instanceof String) {
            return false;
        }
        PatternItem patternItem = (PatternItem)objectArray[n2];
        char c2 = patternItem.type;
        int n5 = SimpleDateFormat.getIndexFromChar(c2);
        if (n5 == -1) {
            throw new IllegalArgumentException("Illegal pattern character '" + c2 + "' in \"" + this.pattern + '\"');
        }
        int n6 = PATTERN_INDEX_TO_CALENDAR_FIELD[n5];
        return n6 >= 0 && (n4 = calendar.get(n6)) != (n3 = calendar2.get(n6));
    }

    private boolean lowerLevel(Object[] objectArray, int n2, int n3) throws IllegalArgumentException {
        if (objectArray[n2] instanceof String) {
            return false;
        }
        PatternItem patternItem = (PatternItem)objectArray[n2];
        char c2 = patternItem.type;
        int n4 = SimpleDateFormat.getLevelFromChar(c2);
        if (n4 == -1) {
            throw new IllegalArgumentException("Illegal pattern character '" + c2 + "' in \"" + this.pattern + '\"');
        }
        return n4 >= n3;
    }

    public void setNumberFormat(String string, NumberFormat numberFormat) {
        numberFormat.setGroupingUsed(false);
        String string2 = "$" + UUID.randomUUID().toString();
        if (this.numberFormatters == null) {
            this.numberFormatters = new HashMap();
        }
        if (this.overrideMap == null) {
            this.overrideMap = new HashMap();
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if ("GyMdkHmsSEDFwWahKzYeugAZvcLQqVUOXxrbB".indexOf(c2) == -1) {
                throw new IllegalArgumentException("Illegal field character '" + c2 + "' in setNumberFormat.");
            }
            this.overrideMap.put(Character.valueOf(c2), string2);
            this.numberFormatters.put(string2, numberFormat);
        }
        this.useLocalZeroPaddingNumberFormat = false;
    }

    public NumberFormat getNumberFormat(char c2) {
        Character c3 = Character.valueOf(c2);
        if (this.overrideMap != null && this.overrideMap.containsKey(c3)) {
            String string = this.overrideMap.get(c3).toString();
            NumberFormat numberFormat = this.numberFormatters.get(string);
            return numberFormat;
        }
        return this.numberFormat;
    }

    private void initNumberFormatters(ULocale uLocale) {
        this.numberFormatters = new HashMap();
        this.overrideMap = new HashMap();
        this.processOverrideString(uLocale, this.override);
    }

    private void processOverrideString(ULocale uLocale, String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        int n2 = 0;
        boolean bl2 = true;
        while (bl2) {
            boolean bl3;
            String string2;
            int n3;
            int n4 = string.indexOf(";", n2);
            if (n4 == -1) {
                bl2 = false;
                n3 = string.length();
            } else {
                n3 = n4;
            }
            String string3 = string.substring(n2, n3);
            int n5 = string3.indexOf("=");
            if (n5 == -1) {
                string2 = string3;
                bl3 = true;
            } else {
                string2 = string3.substring(n5 + 1);
                Character c2 = Character.valueOf(string3.charAt(0));
                this.overrideMap.put(c2, string2);
                bl3 = false;
            }
            ULocale uLocale2 = new ULocale(uLocale.getBaseName() + "@numbers=" + string2);
            NumberFormat numberFormat = NumberFormat.createInstance(uLocale2, 0);
            numberFormat.setGroupingUsed(false);
            if (bl3) {
                this.setNumberFormat(numberFormat);
            } else {
                this.useLocalZeroPaddingNumberFormat = false;
            }
            if (!bl3 && !this.numberFormatters.containsKey(string2)) {
                this.numberFormatters.put(string2, numberFormat);
            }
            n2 = n4 + 1;
        }
    }

    private void parsePattern() {
        this.hasMinute = false;
        this.hasSecond = false;
        this.hasHanYearChar = false;
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.pattern.length(); ++i2) {
            char c2 = this.pattern.charAt(i2);
            if (c2 == '\'') {
                boolean bl3 = bl2 = !bl2;
            }
            if (c2 == '\u5e74') {
                this.hasHanYearChar = true;
            }
            if (bl2) continue;
            if (c2 == 'm') {
                this.hasMinute = true;
            }
            if (c2 != 's') continue;
            this.hasSecond = true;
        }
    }

    private static class PatternItem {
        final char type;
        final int length;
        final boolean isNumeric;

        PatternItem(char c2, int n2) {
            this.type = c2;
            this.length = n2;
            this.isNumeric = SimpleDateFormat.isNumeric(c2, n2);
        }
    }

    private static enum ContextValue {
        UNKNOWN,
        CAPITALIZATION_FOR_MIDDLE_OF_SENTENCE,
        CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE,
        CAPITALIZATION_FOR_UI_LIST_OR_MENU,
        CAPITALIZATION_FOR_STANDALONE;

    }
}

