/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.text.AttributedCharacterIterator;
import java.util.Map;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StaticUnicodeSets;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public final class ScientificNumberFormatter {
    private final String preExponent;
    private final DecimalFormat fmt;
    private final Style style;
    private static final Style SUPER_SCRIPT = new SuperscriptStyle();

    public static ScientificNumberFormatter getSuperscriptInstance(ULocale uLocale) {
        return ScientificNumberFormatter.getInstanceForLocale(uLocale, SUPER_SCRIPT);
    }

    public static ScientificNumberFormatter getSuperscriptInstance(DecimalFormat decimalFormat) {
        return ScientificNumberFormatter.getInstance(decimalFormat, SUPER_SCRIPT);
    }

    public static ScientificNumberFormatter getMarkupInstance(ULocale uLocale, String string, String string2) {
        return ScientificNumberFormatter.getInstanceForLocale(uLocale, new MarkupStyle(string, string2));
    }

    public static ScientificNumberFormatter getMarkupInstance(DecimalFormat decimalFormat, String string, String string2) {
        return ScientificNumberFormatter.getInstance(decimalFormat, new MarkupStyle(string, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Object object) {
        DecimalFormat decimalFormat = this.fmt;
        synchronized (decimalFormat) {
            return this.style.format(this.fmt.formatToCharacterIterator(object), this.preExponent);
        }
    }

    private static String getPreExponent(DecimalFormatSymbols decimalFormatSymbols) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(decimalFormatSymbols.getExponentMultiplicationSign());
        char[] cArray = decimalFormatSymbols.getDigits();
        stringBuilder.append(cArray[1]).append(cArray[0]);
        return stringBuilder.toString();
    }

    private static ScientificNumberFormatter getInstance(DecimalFormat decimalFormat, Style style) {
        DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
        return new ScientificNumberFormatter((DecimalFormat)decimalFormat.clone(), ScientificNumberFormatter.getPreExponent(decimalFormatSymbols), style);
    }

    private static ScientificNumberFormatter getInstanceForLocale(ULocale uLocale, Style style) {
        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getScientificInstance(uLocale);
        return new ScientificNumberFormatter(decimalFormat, ScientificNumberFormatter.getPreExponent(decimalFormat.getDecimalFormatSymbols()), style);
    }

    private ScientificNumberFormatter(DecimalFormat decimalFormat, String string, Style style) {
        this.fmt = decimalFormat;
        this.preExponent = string;
        this.style = style;
    }

    private static class SuperscriptStyle
    extends Style {
        private static final char[] SUPERSCRIPT_DIGITS = new char[]{'\u2070', '\u00b9', '\u00b2', '\u00b3', '\u2074', '\u2075', '\u2076', '\u2077', '\u2078', '\u2079'};
        private static final char SUPERSCRIPT_PLUS_SIGN = '\u207a';
        private static final char SUPERSCRIPT_MINUS_SIGN = '\u207b';

        private SuperscriptStyle() {
        }

        @Override
        String format(AttributedCharacterIterator attributedCharacterIterator, String string) {
            int n2 = 0;
            StringBuilder stringBuilder = new StringBuilder();
            attributedCharacterIterator.first();
            while (attributedCharacterIterator.current() != '\uffff') {
                int n3;
                int n4;
                Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
                if (map.containsKey(NumberFormat.Field.EXPONENT_SYMBOL)) {
                    SuperscriptStyle.append(attributedCharacterIterator, n2, attributedCharacterIterator.getRunStart(NumberFormat.Field.EXPONENT_SYMBOL), stringBuilder);
                    n2 = attributedCharacterIterator.getRunLimit(NumberFormat.Field.EXPONENT_SYMBOL);
                    attributedCharacterIterator.setIndex(n2);
                    stringBuilder.append(string);
                    continue;
                }
                if (map.containsKey(NumberFormat.Field.EXPONENT_SIGN)) {
                    n4 = attributedCharacterIterator.getRunStart(NumberFormat.Field.EXPONENT_SIGN);
                    n3 = attributedCharacterIterator.getRunLimit(NumberFormat.Field.EXPONENT_SIGN);
                    int n5 = SuperscriptStyle.char32AtAndAdvance(attributedCharacterIterator);
                    if (StaticUnicodeSets.get(StaticUnicodeSets.Key.MINUS_SIGN).contains(n5)) {
                        SuperscriptStyle.append(attributedCharacterIterator, n2, n4, stringBuilder);
                        stringBuilder.append('\u207b');
                    } else if (StaticUnicodeSets.get(StaticUnicodeSets.Key.PLUS_SIGN).contains(n5)) {
                        SuperscriptStyle.append(attributedCharacterIterator, n2, n4, stringBuilder);
                        stringBuilder.append('\u207a');
                    } else {
                        throw new IllegalArgumentException();
                    }
                    n2 = n3;
                    attributedCharacterIterator.setIndex(n2);
                    continue;
                }
                if (map.containsKey(NumberFormat.Field.EXPONENT)) {
                    n4 = attributedCharacterIterator.getRunStart(NumberFormat.Field.EXPONENT);
                    n3 = attributedCharacterIterator.getRunLimit(NumberFormat.Field.EXPONENT);
                    SuperscriptStyle.append(attributedCharacterIterator, n2, n4, stringBuilder);
                    SuperscriptStyle.copyAsSuperscript(attributedCharacterIterator, n4, n3, stringBuilder);
                    n2 = n3;
                    attributedCharacterIterator.setIndex(n2);
                    continue;
                }
                attributedCharacterIterator.next();
            }
            SuperscriptStyle.append(attributedCharacterIterator, n2, attributedCharacterIterator.getEndIndex(), stringBuilder);
            return stringBuilder.toString();
        }

        private static void copyAsSuperscript(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3, StringBuilder stringBuilder) {
            int n4 = attributedCharacterIterator.getIndex();
            attributedCharacterIterator.setIndex(n2);
            while (attributedCharacterIterator.getIndex() < n3) {
                int n5 = SuperscriptStyle.char32AtAndAdvance(attributedCharacterIterator);
                int n6 = UCharacter.digit(n5);
                if (n6 < 0) {
                    throw new IllegalArgumentException();
                }
                stringBuilder.append(SUPERSCRIPT_DIGITS[n6]);
            }
            attributedCharacterIterator.setIndex(n4);
        }

        private static int char32AtAndAdvance(AttributedCharacterIterator attributedCharacterIterator) {
            char c2 = attributedCharacterIterator.current();
            char c3 = attributedCharacterIterator.next();
            if (UCharacter.isHighSurrogate(c2) && UCharacter.isLowSurrogate(c3)) {
                attributedCharacterIterator.next();
                return UCharacter.toCodePoint(c2, c3);
            }
            return c2;
        }
    }

    private static class MarkupStyle
    extends Style {
        private final String beginMarkup;
        private final String endMarkup;

        MarkupStyle(String string, String string2) {
            this.beginMarkup = string;
            this.endMarkup = string2;
        }

        @Override
        String format(AttributedCharacterIterator attributedCharacterIterator, String string) {
            int n2 = 0;
            StringBuilder stringBuilder = new StringBuilder();
            attributedCharacterIterator.first();
            while (attributedCharacterIterator.current() != '\uffff') {
                Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
                if (map.containsKey(NumberFormat.Field.EXPONENT_SYMBOL)) {
                    MarkupStyle.append(attributedCharacterIterator, n2, attributedCharacterIterator.getRunStart(NumberFormat.Field.EXPONENT_SYMBOL), stringBuilder);
                    n2 = attributedCharacterIterator.getRunLimit(NumberFormat.Field.EXPONENT_SYMBOL);
                    attributedCharacterIterator.setIndex(n2);
                    stringBuilder.append(string);
                    stringBuilder.append(this.beginMarkup);
                    continue;
                }
                if (map.containsKey(NumberFormat.Field.EXPONENT)) {
                    int n3 = attributedCharacterIterator.getRunLimit(NumberFormat.Field.EXPONENT);
                    MarkupStyle.append(attributedCharacterIterator, n2, n3, stringBuilder);
                    n2 = n3;
                    attributedCharacterIterator.setIndex(n2);
                    stringBuilder.append(this.endMarkup);
                    continue;
                }
                attributedCharacterIterator.next();
            }
            MarkupStyle.append(attributedCharacterIterator, n2, attributedCharacterIterator.getEndIndex(), stringBuilder);
            return stringBuilder.toString();
        }
    }

    private static abstract class Style {
        private Style() {
        }

        abstract String format(AttributedCharacterIterator var1, String var2);

        static void append(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3, StringBuilder stringBuilder) {
            int n4 = attributedCharacterIterator.getIndex();
            attributedCharacterIterator.setIndex(n2);
            for (int i2 = n2; i2 < n3; ++i2) {
                stringBuilder.append(attributedCharacterIterator.current());
                attributedCharacterIterator.next();
            }
            attributedCharacterIterator.setIndex(n4);
        }
    }
}

