/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUDebug;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.math.BigDecimal;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.BreakIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DisplayContext;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NFRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NFRuleSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RBNFPostProcessor;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RbnfLenientScanner;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RbnfLenientScannerProvider;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundleIterator;

public class RuleBasedNumberFormat
extends NumberFormat {
    static final long serialVersionUID = -7664252765575395068L;
    public static final int SPELLOUT = 1;
    public static final int ORDINAL = 2;
    @Deprecated
    public static final int DURATION = 3;
    public static final int NUMBERING_SYSTEM = 4;
    private transient NFRuleSet[] ruleSets = null;
    private transient Map<String, NFRuleSet> ruleSetsMap = null;
    private transient NFRuleSet defaultRuleSet = null;
    private ULocale locale = null;
    private int roundingMode = 7;
    private transient RbnfLenientScannerProvider scannerProvider = null;
    private transient boolean lookedForScanner;
    private transient DecimalFormatSymbols decimalFormatSymbols = null;
    private transient DecimalFormat decimalFormat = null;
    private transient NFRule defaultInfinityRule = null;
    private transient NFRule defaultNaNRule = null;
    private boolean lenientParse = false;
    private transient String lenientParseRules;
    private transient String postProcessRules;
    private transient RBNFPostProcessor postProcessor;
    private Map<String, String[]> ruleSetDisplayNames;
    private String[] publicRuleSetNames;
    private boolean capitalizationInfoIsSet = false;
    private boolean capitalizationForListOrMenu = false;
    private boolean capitalizationForStandAlone = false;
    private transient BreakIterator capitalizationBrkIter = null;
    private static final boolean DEBUG = ICUDebug.enabled("rbnf");
    private static final String[] rulenames = new String[]{"SpelloutRules", "OrdinalRules", "DurationRules", "NumberingSystemRules"};
    private static final String[] locnames = new String[]{"SpelloutLocalizations", "OrdinalLocalizations", "DurationLocalizations", "NumberingSystemLocalizations"};
    private static final BigDecimal MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigDecimal MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE);

    public RuleBasedNumberFormat(String string) {
        this.locale = ULocale.getDefault(ULocale.Category.FORMAT);
        this.init(string, null);
    }

    public RuleBasedNumberFormat(String string, String[][] stringArray) {
        this.locale = ULocale.getDefault(ULocale.Category.FORMAT);
        this.init(string, stringArray);
    }

    public RuleBasedNumberFormat(String string, Locale locale) {
        this(string, ULocale.forLocale(locale));
    }

    public RuleBasedNumberFormat(String string, ULocale uLocale) {
        this.locale = uLocale;
        this.init(string, null);
    }

    public RuleBasedNumberFormat(String string, String[][] stringArray, ULocale uLocale) {
        this.locale = uLocale;
        this.init(string, stringArray);
    }

    public RuleBasedNumberFormat(Locale locale, int n2) {
        this(ULocale.forLocale(locale), n2);
    }

    public RuleBasedNumberFormat(ULocale uLocale, int n2) {
        ICUResourceBundle iCUResourceBundle;
        this.locale = uLocale;
        ICUResourceBundle iCUResourceBundle2 = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/rbnf", uLocale);
        ULocale uLocale2 = iCUResourceBundle2.getULocale();
        this.setLocale(uLocale2, uLocale2);
        StringBuilder stringBuilder = new StringBuilder();
        String[][] stringArray = null;
        try {
            iCUResourceBundle = iCUResourceBundle2.getWithFallback("RBNFRules/" + rulenames[n2 - 1]);
            UResourceBundleIterator uResourceBundleIterator = iCUResourceBundle.getIterator();
            while (uResourceBundleIterator.hasNext()) {
                stringBuilder.append(uResourceBundleIterator.nextString());
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if ((iCUResourceBundle = iCUResourceBundle2.findTopLevel(locnames[n2 - 1])) != null) {
            stringArray = new String[iCUResourceBundle.getSize()][];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = iCUResourceBundle.get(i2).getStringArray();
            }
        }
        this.init(stringBuilder.toString(), stringArray);
    }

    public RuleBasedNumberFormat(int n2) {
        this(ULocale.getDefault(ULocale.Category.FORMAT), n2);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof RuleBasedNumberFormat)) {
            return false;
        }
        RuleBasedNumberFormat ruleBasedNumberFormat = (RuleBasedNumberFormat)object;
        if (!this.locale.equals(ruleBasedNumberFormat.locale) || this.lenientParse != ruleBasedNumberFormat.lenientParse) {
            return false;
        }
        if (this.ruleSets.length != ruleBasedNumberFormat.ruleSets.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.ruleSets.length; ++i2) {
            if (this.ruleSets[i2].equals(ruleBasedNumberFormat.ruleSets[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (NFRuleSet nFRuleSet : this.ruleSets) {
            stringBuilder.append(nFRuleSet.toString());
        }
        return stringBuilder.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.toString());
        objectOutputStream.writeObject(this.locale);
        objectOutputStream.writeInt(this.roundingMode);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        ULocale uLocale;
        String string = objectInputStream.readUTF();
        try {
            uLocale = (ULocale)objectInputStream.readObject();
        }
        catch (Exception exception) {
            uLocale = ULocale.getDefault(ULocale.Category.FORMAT);
        }
        try {
            this.roundingMode = objectInputStream.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RuleBasedNumberFormat ruleBasedNumberFormat = new RuleBasedNumberFormat(string, uLocale);
        this.ruleSets = ruleBasedNumberFormat.ruleSets;
        this.ruleSetsMap = ruleBasedNumberFormat.ruleSetsMap;
        this.defaultRuleSet = ruleBasedNumberFormat.defaultRuleSet;
        this.publicRuleSetNames = ruleBasedNumberFormat.publicRuleSetNames;
        this.decimalFormatSymbols = ruleBasedNumberFormat.decimalFormatSymbols;
        this.decimalFormat = ruleBasedNumberFormat.decimalFormat;
        this.locale = ruleBasedNumberFormat.locale;
        this.defaultInfinityRule = ruleBasedNumberFormat.defaultInfinityRule;
        this.defaultNaNRule = ruleBasedNumberFormat.defaultNaNRule;
    }

    public String[] getRuleSetNames() {
        return (String[])this.publicRuleSetNames.clone();
    }

    public ULocale[] getRuleSetDisplayNameLocales() {
        if (this.ruleSetDisplayNames != null) {
            Set<String> set = this.ruleSetDisplayNames.keySet();
            String[] stringArray = set.toArray(new String[set.size()]);
            Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
            ULocale[] uLocaleArray = new ULocale[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                uLocaleArray[i2] = new ULocale(stringArray[i2]);
            }
            return uLocaleArray;
        }
        return null;
    }

    private String[] getNameListForLocale(ULocale uLocale) {
        if (uLocale != null && this.ruleSetDisplayNames != null) {
            String[] stringArray;
            for (String string : stringArray = new String[]{uLocale.getBaseName(), ULocale.getDefault(ULocale.Category.DISPLAY).getBaseName()}) {
                while (string.length() > 0) {
                    String[] stringArray2 = this.ruleSetDisplayNames.get(string);
                    if (stringArray2 != null) {
                        return stringArray2;
                    }
                    string = ULocale.getFallback(string);
                }
            }
        }
        return null;
    }

    public String[] getRuleSetDisplayNames(ULocale uLocale) {
        String[] stringArray = this.getNameListForLocale(uLocale);
        if (stringArray != null) {
            return (String[])stringArray.clone();
        }
        stringArray = this.getRuleSetNames();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = stringArray[i2].substring(1);
        }
        return stringArray;
    }

    public String[] getRuleSetDisplayNames() {
        return this.getRuleSetDisplayNames(ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    public String getRuleSetDisplayName(String string, ULocale uLocale) {
        String[] stringArray = this.publicRuleSetNames;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equals(string)) continue;
            String[] stringArray2 = this.getNameListForLocale(uLocale);
            if (stringArray2 != null) {
                return stringArray2[i2];
            }
            return stringArray[i2].substring(1);
        }
        throw new IllegalArgumentException("unrecognized rule set name: " + string);
    }

    public String getRuleSetDisplayName(String string) {
        return this.getRuleSetDisplayName(string, ULocale.getDefault(ULocale.Category.DISPLAY));
    }

    public String format(double d2, String string) throws IllegalArgumentException {
        if (string.startsWith("%%")) {
            throw new IllegalArgumentException("Can't use internal rule set");
        }
        return this.adjustForContext(this.format(d2, this.findRuleSet(string)));
    }

    public String format(long l2, String string) throws IllegalArgumentException {
        if (string.startsWith("%%")) {
            throw new IllegalArgumentException("Can't use internal rule set");
        }
        return this.adjustForContext(this.format(l2, this.findRuleSet(string)));
    }

    @Override
    public StringBuffer format(double d2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (stringBuffer.length() == 0) {
            stringBuffer.append(this.adjustForContext(this.format(d2, this.defaultRuleSet)));
        } else {
            stringBuffer.append(this.format(d2, this.defaultRuleSet));
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer format(long l2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (stringBuffer.length() == 0) {
            stringBuffer.append(this.adjustForContext(this.format(l2, this.defaultRuleSet)));
        } else {
            stringBuffer.append(this.format(l2, this.defaultRuleSet));
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer format(BigInteger bigInteger, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format(new BigDecimal(bigInteger), stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(java.math.BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format(new BigDecimal(bigDecimal), stringBuffer, fieldPosition);
    }

    @Override
    public StringBuffer format(BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (MIN_VALUE.compareTo(bigDecimal) > 0 || MAX_VALUE.compareTo(bigDecimal) < 0) {
            return this.getDecimalFormat().format(bigDecimal, stringBuffer, fieldPosition);
        }
        if (bigDecimal.scale() == 0) {
            return this.format(bigDecimal.longValue(), stringBuffer, fieldPosition);
        }
        return this.format(bigDecimal.doubleValue(), stringBuffer, fieldPosition);
    }

    @Override
    public Number parse(String string, ParsePosition parsePosition) {
        String string2 = string.substring(parsePosition.getIndex());
        ParsePosition parsePosition2 = new ParsePosition(0);
        Number number = null;
        Number number2 = NFRule.ZERO;
        ParsePosition parsePosition3 = new ParsePosition(parsePosition2.getIndex());
        for (int i2 = this.ruleSets.length - 1; i2 >= 0; --i2) {
            if (!this.ruleSets[i2].isPublic() || !this.ruleSets[i2].isParseable()) continue;
            number = this.ruleSets[i2].parse(string2, parsePosition2, Double.MAX_VALUE, 0);
            if (parsePosition2.getIndex() > parsePosition3.getIndex()) {
                number2 = number;
                parsePosition3.setIndex(parsePosition2.getIndex());
            }
            if (parsePosition3.getIndex() == string2.length()) break;
            parsePosition2.setIndex(0);
        }
        parsePosition.setIndex(parsePosition.getIndex() + parsePosition3.getIndex());
        return number2;
    }

    public void setLenientParseMode(boolean bl2) {
        this.lenientParse = bl2;
    }

    public boolean lenientParseEnabled() {
        return this.lenientParse;
    }

    public void setLenientScannerProvider(RbnfLenientScannerProvider rbnfLenientScannerProvider) {
        this.scannerProvider = rbnfLenientScannerProvider;
    }

    public RbnfLenientScannerProvider getLenientScannerProvider() {
        if (this.scannerProvider == null && this.lenientParse && !this.lookedForScanner) {
            try {
                this.lookedForScanner = true;
                Class<?> clazz = Class.forName("macromedia.jdbc.db2.externals.com.ibm.icu.impl.text.RbnfScannerProviderImpl");
                RbnfLenientScannerProvider rbnfLenientScannerProvider = (RbnfLenientScannerProvider)clazz.newInstance();
                this.setLenientScannerProvider(rbnfLenientScannerProvider);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.scannerProvider;
    }

    public void setDefaultRuleSet(String string) {
        if (string == null) {
            if (this.publicRuleSetNames.length > 0) {
                this.defaultRuleSet = this.findRuleSet(this.publicRuleSetNames[0]);
            } else {
                this.defaultRuleSet = null;
                int n2 = this.ruleSets.length;
                while (--n2 >= 0) {
                    String string2 = this.ruleSets[n2].getName();
                    if (!string2.equals("%spellout-numbering") && !string2.equals("%digits-ordinal") && !string2.equals("%duration")) continue;
                    this.defaultRuleSet = this.ruleSets[n2];
                    return;
                }
                n2 = this.ruleSets.length;
                while (--n2 >= 0) {
                    if (!this.ruleSets[n2].isPublic()) continue;
                    this.defaultRuleSet = this.ruleSets[n2];
                    break;
                }
            }
        } else {
            if (string.startsWith("%%")) {
                throw new IllegalArgumentException("cannot use private rule set: " + string);
            }
            this.defaultRuleSet = this.findRuleSet(string);
        }
    }

    public String getDefaultRuleSetName() {
        if (this.defaultRuleSet != null && this.defaultRuleSet.isPublic()) {
            return this.defaultRuleSet.getName();
        }
        return "";
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        if (decimalFormatSymbols != null) {
            this.decimalFormatSymbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
            if (this.decimalFormat != null) {
                this.decimalFormat.setDecimalFormatSymbols(this.decimalFormatSymbols);
            }
            if (this.defaultInfinityRule != null) {
                this.defaultInfinityRule = null;
                this.getDefaultInfinityRule();
            }
            if (this.defaultNaNRule != null) {
                this.defaultNaNRule = null;
                this.getDefaultNaNRule();
            }
            for (NFRuleSet nFRuleSet : this.ruleSets) {
                nFRuleSet.setDecimalFormatSymbols(this.decimalFormatSymbols);
            }
        }
    }

    @Override
    public void setContext(DisplayContext displayContext) {
        super.setContext(displayContext);
        if (!(this.capitalizationInfoIsSet || displayContext != DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU && displayContext != DisplayContext.CAPITALIZATION_FOR_STANDALONE)) {
            this.initCapitalizationContextInfo(this.locale);
            this.capitalizationInfoIsSet = true;
        }
        if (this.capitalizationBrkIter == null && (displayContext == DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE || displayContext == DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU && this.capitalizationForListOrMenu || displayContext == DisplayContext.CAPITALIZATION_FOR_STANDALONE && this.capitalizationForStandAlone)) {
            this.capitalizationBrkIter = BreakIterator.getSentenceInstance(this.locale);
        }
    }

    @Override
    public int getRoundingMode() {
        return this.roundingMode;
    }

    @Override
    public void setRoundingMode(int n2) {
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("Invalid rounding mode: " + n2);
        }
        this.roundingMode = n2;
    }

    NFRuleSet getDefaultRuleSet() {
        return this.defaultRuleSet;
    }

    RbnfLenientScanner getLenientScanner() {
        RbnfLenientScannerProvider rbnfLenientScannerProvider;
        if (this.lenientParse && (rbnfLenientScannerProvider = this.getLenientScannerProvider()) != null) {
            return rbnfLenientScannerProvider.get(this.locale, this.lenientParseRules);
        }
        return null;
    }

    DecimalFormatSymbols getDecimalFormatSymbols() {
        if (this.decimalFormatSymbols == null) {
            this.decimalFormatSymbols = new DecimalFormatSymbols(this.locale);
        }
        return this.decimalFormatSymbols;
    }

    DecimalFormat getDecimalFormat() {
        if (this.decimalFormat == null) {
            String string = RuleBasedNumberFormat.getPattern(this.locale, 0);
            this.decimalFormat = new DecimalFormat(string, this.getDecimalFormatSymbols());
        }
        return this.decimalFormat;
    }

    PluralFormat createPluralFormat(PluralRules.PluralType pluralType, String string) {
        return new PluralFormat(this.locale, pluralType, string, this.getDecimalFormat());
    }

    NFRule getDefaultInfinityRule() {
        if (this.defaultInfinityRule == null) {
            this.defaultInfinityRule = new NFRule(this, "Inf: " + this.getDecimalFormatSymbols().getInfinity());
        }
        return this.defaultInfinityRule;
    }

    NFRule getDefaultNaNRule() {
        if (this.defaultNaNRule == null) {
            this.defaultNaNRule = new NFRule(this, "NaN: " + this.getDecimalFormatSymbols().getNaN());
        }
        return this.defaultNaNRule;
    }

    private String extractSpecial(StringBuilder stringBuilder, String string) {
        String string2 = null;
        int n2 = stringBuilder.indexOf(string);
        if (n2 != -1 && (n2 == 0 || stringBuilder.charAt(n2 - 1) == ';')) {
            int n3;
            int n4 = stringBuilder.indexOf(";%", n2);
            if (n4 == -1) {
                n4 = stringBuilder.length() - 1;
            }
            for (n3 = n2 + string.length(); n3 < n4 && PatternProps.isWhiteSpace(stringBuilder.charAt(n3)); ++n3) {
            }
            string2 = stringBuilder.substring(n3, n4);
            stringBuilder.delete(n2, n4 + 1);
        }
        return string2;
    }

    private void init(String string, String[][] stringArray) {
        int n2;
        this.initLocalizations(stringArray);
        StringBuilder stringBuilder = this.stripWhitespace(string);
        this.lenientParseRules = this.extractSpecial(stringBuilder, "%%lenient-parse:");
        this.postProcessRules = this.extractSpecial(stringBuilder, "%%post-process:");
        int n3 = 1;
        int n4 = 0;
        while ((n4 = stringBuilder.indexOf(";%", n4)) != -1) {
            ++n3;
            n4 += 2;
        }
        this.ruleSets = new NFRuleSet[n3];
        this.ruleSetsMap = new HashMap<String, NFRuleSet>(n3 * 2 + 1);
        this.defaultRuleSet = null;
        int n5 = 0;
        String[] stringArray2 = new String[n3];
        int n6 = 0;
        for (int i2 = 0; i2 < this.ruleSets.length; ++i2) {
            NFRuleSet nFRuleSet;
            n4 = stringBuilder.indexOf(";%", n6);
            if (n4 < 0) {
                n4 = stringBuilder.length() - 1;
            }
            stringArray2[i2] = stringBuilder.substring(n6, n4 + 1);
            this.ruleSets[i2] = nFRuleSet = new NFRuleSet(this, stringArray2, i2);
            String string2 = nFRuleSet.getName();
            this.ruleSetsMap.put(string2, nFRuleSet);
            if (!string2.startsWith("%%")) {
                ++n5;
                if (this.defaultRuleSet == null && string2.equals("%spellout-numbering") || string2.equals("%digits-ordinal") || string2.equals("%duration")) {
                    this.defaultRuleSet = nFRuleSet;
                }
            }
            n6 = n4 + 1;
        }
        if (this.defaultRuleSet == null) {
            for (int i3 = this.ruleSets.length - 1; i3 >= 0; --i3) {
                if (this.ruleSets[i3].getName().startsWith("%%")) continue;
                this.defaultRuleSet = this.ruleSets[i3];
                break;
            }
        }
        if (this.defaultRuleSet == null) {
            this.defaultRuleSet = this.ruleSets[this.ruleSets.length - 1];
        }
        for (int i4 = 0; i4 < this.ruleSets.length; ++i4) {
            this.ruleSets[i4].parseRules(stringArray2[i4]);
        }
        String[] stringArray3 = new String[n5];
        n5 = 0;
        for (n2 = this.ruleSets.length - 1; n2 >= 0; --n2) {
            if (this.ruleSets[n2].getName().startsWith("%%")) continue;
            stringArray3[n5++] = this.ruleSets[n2].getName();
        }
        if (this.publicRuleSetNames != null) {
            block5: for (n2 = 0; n2 < this.publicRuleSetNames.length; ++n2) {
                String string3 = this.publicRuleSetNames[n2];
                for (int i5 = 0; i5 < stringArray3.length; ++i5) {
                    if (string3.equals(stringArray3[i5])) continue block5;
                }
                throw new IllegalArgumentException("did not find public rule set: " + string3);
            }
            this.defaultRuleSet = this.findRuleSet(this.publicRuleSetNames[0]);
        } else {
            this.publicRuleSetNames = stringArray3;
        }
    }

    private void initLocalizations(String[][] stringArray) {
        if (stringArray != null) {
            this.publicRuleSetNames = (String[])stringArray[0].clone();
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                String[] stringArray2 = stringArray[i2];
                String string = stringArray2[0];
                String[] stringArray3 = new String[stringArray2.length - 1];
                if (stringArray3.length != this.publicRuleSetNames.length) {
                    throw new IllegalArgumentException("public name length: " + this.publicRuleSetNames.length + " != localized names[" + i2 + "] length: " + stringArray3.length);
                }
                System.arraycopy(stringArray2, 1, stringArray3, 0, stringArray3.length);
                hashMap.put(string, stringArray3);
            }
            if (!hashMap.isEmpty()) {
                this.ruleSetDisplayNames = hashMap;
            }
        }
    }

    private void initCapitalizationContextInfo(ULocale uLocale) {
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", uLocale);
        try {
            ICUResourceBundle iCUResourceBundle2 = iCUResourceBundle.getWithFallback("contextTransforms/number-spellout");
            int[] nArray = iCUResourceBundle2.getIntVector();
            if (nArray.length >= 2) {
                this.capitalizationForListOrMenu = nArray[0] != 0;
                this.capitalizationForStandAlone = nArray[1] != 0;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private StringBuilder stripWhitespace(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            while (n3 < n2 && PatternProps.isWhiteSpace(string.charAt(n3))) {
                ++n3;
            }
            if (n3 < n2 && string.charAt(n3) == ';') {
                ++n3;
                continue;
            }
            int n4 = string.indexOf(59, n3);
            if (n4 == -1) {
                stringBuilder.append(string.substring(n3));
                break;
            }
            if (n4 >= n2) break;
            stringBuilder.append(string.substring(n3, n4 + 1));
            n3 = n4 + 1;
        }
        return stringBuilder;
    }

    private String format(double d2, NFRuleSet nFRuleSet) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getRoundingMode() != 7 && !Double.isNaN(d2) && !Double.isInfinite(d2)) {
            d2 = new BigDecimal(Double.toString(d2)).setScale(this.getMaximumFractionDigits(), this.roundingMode).doubleValue();
        }
        nFRuleSet.format(d2, stringBuilder, 0, 0);
        this.postProcess(stringBuilder, nFRuleSet);
        return stringBuilder.toString();
    }

    private String format(long l2, NFRuleSet nFRuleSet) {
        StringBuilder stringBuilder = new StringBuilder();
        if (l2 == Long.MIN_VALUE) {
            stringBuilder.append(this.getDecimalFormat().format(Long.MIN_VALUE));
        } else {
            nFRuleSet.format(l2, stringBuilder, 0, 0);
        }
        this.postProcess(stringBuilder, nFRuleSet);
        return stringBuilder.toString();
    }

    private void postProcess(StringBuilder stringBuilder, NFRuleSet nFRuleSet) {
        if (this.postProcessRules != null) {
            if (this.postProcessor == null) {
                int n2 = this.postProcessRules.indexOf(";");
                if (n2 == -1) {
                    n2 = this.postProcessRules.length();
                }
                String string = this.postProcessRules.substring(0, n2).trim();
                try {
                    Class<?> clazz = Class.forName(string);
                    this.postProcessor = (RBNFPostProcessor)clazz.newInstance();
                    this.postProcessor.init(this, this.postProcessRules);
                }
                catch (Exception exception) {
                    if (DEBUG) {
                        System.out.println("could not locate " + string + ", error " + exception.getClass().getName() + ", " + exception.getMessage());
                    }
                    this.postProcessor = null;
                    this.postProcessRules = null;
                    return;
                }
            }
            this.postProcessor.process(stringBuilder, nFRuleSet);
        }
    }

    private String adjustForContext(String string) {
        DisplayContext displayContext = this.getContext(DisplayContext.Type.CAPITALIZATION);
        if (displayContext != DisplayContext.CAPITALIZATION_NONE && string != null && string.length() > 0 && UCharacter.isLowerCase(string.codePointAt(0)) && (displayContext == DisplayContext.CAPITALIZATION_FOR_BEGINNING_OF_SENTENCE || displayContext == DisplayContext.CAPITALIZATION_FOR_UI_LIST_OR_MENU && this.capitalizationForListOrMenu || displayContext == DisplayContext.CAPITALIZATION_FOR_STANDALONE && this.capitalizationForStandAlone)) {
            if (this.capitalizationBrkIter == null) {
                this.capitalizationBrkIter = BreakIterator.getSentenceInstance(this.locale);
            }
            return UCharacter.toTitleCase(this.locale, string, this.capitalizationBrkIter, 768);
        }
        return string;
    }

    NFRuleSet findRuleSet(String string) throws IllegalArgumentException {
        NFRuleSet nFRuleSet = this.ruleSetsMap.get(string);
        if (nFRuleSet == null) {
            throw new IllegalArgumentException("No rule set named " + string);
        }
        return nFRuleSet;
    }
}

