/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Assert;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.RBBIDataWrapper;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RBBINode;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RBBIRuleBuilder;

class RBBITableBuilder {
    private RBBIRuleBuilder fRB;
    private int fRootIx;
    private List<RBBIStateDescriptor> fDStates;
    private List<short[]> fSafeTable;
    private static final int MAX_STATE_FOR_8BITS_TABLE = 255;
    int[] fLookAheadRuleMap;
    int fLASlotsInUse = 1;

    RBBITableBuilder(RBBIRuleBuilder rBBIRuleBuilder, int n2) {
        this.fRootIx = n2;
        this.fRB = rBBIRuleBuilder;
        this.fDStates = new ArrayList<RBBIStateDescriptor>();
    }

    void buildForwardTable() {
        RBBINode rBBINode;
        RBBINode rBBINode2;
        if (this.fRB.fTreeRoots[this.fRootIx] == null) {
            return;
        }
        this.fRB.fTreeRoots[this.fRootIx] = this.fRB.fTreeRoots[this.fRootIx].flattenVariables(0);
        if (this.fRB.fDebugEnv != null && this.fRB.fDebugEnv.indexOf("ftree") >= 0) {
            System.out.println("Parse tree after flattening variable references.");
            this.fRB.fTreeRoots[this.fRootIx].printTree(true);
        }
        if (this.fRB.fSetBuilder.sawBOF()) {
            rBBINode2 = new RBBINode(8);
            rBBINode2.fLeftChild = rBBINode = new RBBINode(3);
            rBBINode2.fRightChild = this.fRB.fTreeRoots[this.fRootIx];
            rBBINode.fParent = rBBINode2;
            rBBINode.fVal = 2;
            this.fRB.fTreeRoots[this.fRootIx] = rBBINode2;
        }
        rBBINode2 = new RBBINode(8);
        rBBINode2.fLeftChild = this.fRB.fTreeRoots[this.fRootIx];
        this.fRB.fTreeRoots[this.fRootIx].fParent = rBBINode2;
        rBBINode = rBBINode2.fRightChild = new RBBINode(6);
        rBBINode2.fRightChild.fParent = rBBINode2;
        this.fRB.fTreeRoots[this.fRootIx] = rBBINode2;
        this.fRB.fTreeRoots[this.fRootIx].flattenSets();
        if (this.fRB.fDebugEnv != null && this.fRB.fDebugEnv.indexOf("stree") >= 0) {
            System.out.println("Parse tree after flattening Unicode Set references.");
            this.fRB.fTreeRoots[this.fRootIx].printTree(true);
        }
        this.calcNullable(this.fRB.fTreeRoots[this.fRootIx]);
        this.calcFirstPos(this.fRB.fTreeRoots[this.fRootIx]);
        this.calcLastPos(this.fRB.fTreeRoots[this.fRootIx]);
        this.calcFollowPos(this.fRB.fTreeRoots[this.fRootIx]);
        if (this.fRB.fDebugEnv != null && this.fRB.fDebugEnv.indexOf("pos") >= 0) {
            System.out.print("\n");
            this.printPosSets(this.fRB.fTreeRoots[this.fRootIx]);
        }
        if (this.fRB.fChainRules) {
            this.calcChainedFollowPos(this.fRB.fTreeRoots[this.fRootIx], rBBINode);
        }
        if (this.fRB.fSetBuilder.sawBOF()) {
            this.bofFixup();
        }
        this.buildStateTable();
        this.mapLookAheadRules();
        this.flagAcceptingStates();
        this.flagLookAheadStates();
        this.flagTaggedStates();
        this.mergeRuleStatusVals();
    }

    void calcNullable(RBBINode rBBINode) {
        if (rBBINode == null) {
            return;
        }
        if (rBBINode.fType == 0 || rBBINode.fType == 6) {
            rBBINode.fNullable = false;
            return;
        }
        if (rBBINode.fType == 4 || rBBINode.fType == 5) {
            rBBINode.fNullable = true;
            return;
        }
        this.calcNullable(rBBINode.fLeftChild);
        this.calcNullable(rBBINode.fRightChild);
        rBBINode.fNullable = rBBINode.fType == 9 ? rBBINode.fLeftChild.fNullable || rBBINode.fRightChild.fNullable : (rBBINode.fType == 8 ? rBBINode.fLeftChild.fNullable && rBBINode.fRightChild.fNullable : rBBINode.fType == 10 || rBBINode.fType == 12);
    }

    void calcFirstPos(RBBINode rBBINode) {
        if (rBBINode == null) {
            return;
        }
        if (rBBINode.fType == 3 || rBBINode.fType == 6 || rBBINode.fType == 4 || rBBINode.fType == 5) {
            rBBINode.fFirstPosSet.add(rBBINode);
            return;
        }
        this.calcFirstPos(rBBINode.fLeftChild);
        this.calcFirstPos(rBBINode.fRightChild);
        if (rBBINode.fType == 9) {
            rBBINode.fFirstPosSet.addAll(rBBINode.fLeftChild.fFirstPosSet);
            rBBINode.fFirstPosSet.addAll(rBBINode.fRightChild.fFirstPosSet);
        } else if (rBBINode.fType == 8) {
            rBBINode.fFirstPosSet.addAll(rBBINode.fLeftChild.fFirstPosSet);
            if (rBBINode.fLeftChild.fNullable) {
                rBBINode.fFirstPosSet.addAll(rBBINode.fRightChild.fFirstPosSet);
            }
        } else if (rBBINode.fType == 10 || rBBINode.fType == 12 || rBBINode.fType == 11) {
            rBBINode.fFirstPosSet.addAll(rBBINode.fLeftChild.fFirstPosSet);
        }
    }

    void calcLastPos(RBBINode rBBINode) {
        if (rBBINode == null) {
            return;
        }
        if (rBBINode.fType == 3 || rBBINode.fType == 6 || rBBINode.fType == 4 || rBBINode.fType == 5) {
            rBBINode.fLastPosSet.add(rBBINode);
            return;
        }
        this.calcLastPos(rBBINode.fLeftChild);
        this.calcLastPos(rBBINode.fRightChild);
        if (rBBINode.fType == 9) {
            rBBINode.fLastPosSet.addAll(rBBINode.fLeftChild.fLastPosSet);
            rBBINode.fLastPosSet.addAll(rBBINode.fRightChild.fLastPosSet);
        } else if (rBBINode.fType == 8) {
            rBBINode.fLastPosSet.addAll(rBBINode.fRightChild.fLastPosSet);
            if (rBBINode.fRightChild.fNullable) {
                rBBINode.fLastPosSet.addAll(rBBINode.fLeftChild.fLastPosSet);
            }
        } else if (rBBINode.fType == 10 || rBBINode.fType == 12 || rBBINode.fType == 11) {
            rBBINode.fLastPosSet.addAll(rBBINode.fLeftChild.fLastPosSet);
        }
    }

    void calcFollowPos(RBBINode rBBINode) {
        if (rBBINode == null || rBBINode.fType == 3 || rBBINode.fType == 6) {
            return;
        }
        this.calcFollowPos(rBBINode.fLeftChild);
        this.calcFollowPos(rBBINode.fRightChild);
        if (rBBINode.fType == 8) {
            for (RBBINode rBBINode2 : rBBINode.fLeftChild.fLastPosSet) {
                rBBINode2.fFollowPos.addAll(rBBINode.fRightChild.fFirstPosSet);
            }
        }
        if (rBBINode.fType == 10 || rBBINode.fType == 11) {
            for (RBBINode rBBINode2 : rBBINode.fLastPosSet) {
                rBBINode2.fFollowPos.addAll(rBBINode.fFirstPosSet);
            }
        }
    }

    void addRuleRootNodes(List<RBBINode> list, RBBINode rBBINode) {
        if (rBBINode == null) {
            return;
        }
        if (rBBINode.fRuleRoot) {
            list.add(rBBINode);
            return;
        }
        this.addRuleRootNodes(list, rBBINode.fLeftChild);
        this.addRuleRootNodes(list, rBBINode.fRightChild);
    }

    void calcChainedFollowPos(RBBINode rBBINode, RBBINode rBBINode2) {
        ArrayList<RBBINode> arrayList = new ArrayList<RBBINode>();
        rBBINode.findNodes(arrayList, 3);
        ArrayList<RBBINode> arrayList2 = new ArrayList<RBBINode>();
        this.addRuleRootNodes(arrayList2, rBBINode);
        HashSet<RBBINode> hashSet = new HashSet<RBBINode>();
        for (RBBINode rBBINode3 : arrayList2) {
            if (!rBBINode3.fChainIn) continue;
            hashSet.addAll(rBBINode3.fFirstPosSet);
        }
        for (RBBINode rBBINode3 : arrayList) {
            if (!rBBINode3.fFollowPos.contains(rBBINode2)) continue;
            for (RBBINode rBBINode4 : hashSet) {
                if (rBBINode4.fType != 3 || rBBINode3.fVal != rBBINode4.fVal) continue;
                rBBINode3.fFollowPos.addAll(rBBINode4.fFollowPos);
            }
        }
    }

    void bofFixup() {
        RBBINode rBBINode = this.fRB.fTreeRoots[this.fRootIx].fLeftChild.fLeftChild;
        Assert.assrt(rBBINode.fType == 3);
        Assert.assrt(rBBINode.fVal == 2);
        Set<RBBINode> set = this.fRB.fTreeRoots[this.fRootIx].fLeftChild.fRightChild.fFirstPosSet;
        for (RBBINode rBBINode2 : set) {
            if (rBBINode2.fType != 3 || rBBINode2.fVal != rBBINode.fVal) continue;
            rBBINode.fFollowPos.addAll(rBBINode2.fFollowPos);
        }
    }

    void buildStateTable() {
        int n2 = this.fRB.fSetBuilder.getNumCharCategories() - 1;
        RBBIStateDescriptor rBBIStateDescriptor = new RBBIStateDescriptor(n2);
        this.fDStates.add(rBBIStateDescriptor);
        RBBIStateDescriptor rBBIStateDescriptor2 = new RBBIStateDescriptor(n2);
        rBBIStateDescriptor2.fPositions.addAll(this.fRB.fTreeRoots[this.fRootIx].fFirstPosSet);
        this.fDStates.add(rBBIStateDescriptor2);
        block0: while (true) {
            RBBIStateDescriptor rBBIStateDescriptor3 = null;
            for (int i2 = 1; i2 < this.fDStates.size(); ++i2) {
                RBBIStateDescriptor rBBIStateDescriptor4 = this.fDStates.get(i2);
                if (rBBIStateDescriptor4.fMarked) continue;
                rBBIStateDescriptor3 = rBBIStateDescriptor4;
                break;
            }
            if (rBBIStateDescriptor3 == null) break;
            rBBIStateDescriptor3.fMarked = true;
            int n3 = 1;
            while (true) {
                if (n3 > n2) continue block0;
                Set<RBBINode> set = null;
                for (RBBINode rBBINode : rBBIStateDescriptor3.fPositions) {
                    if (rBBINode.fType != 3 || rBBINode.fVal != n3) continue;
                    if (set == null) {
                        set = new HashSet<RBBINode>();
                    }
                    set.addAll(rBBINode.fFollowPos);
                }
                int n4 = 0;
                boolean bl2 = false;
                if (set != null) {
                    RBBIStateDescriptor rBBIStateDescriptor5;
                    Assert.assrt(set.size() > 0);
                    for (int i3 = 0; i3 < this.fDStates.size(); ++i3) {
                        rBBIStateDescriptor5 = this.fDStates.get(i3);
                        if (!set.equals(rBBIStateDescriptor5.fPositions)) continue;
                        set = rBBIStateDescriptor5.fPositions;
                        n4 = i3;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        rBBIStateDescriptor5 = new RBBIStateDescriptor(n2);
                        rBBIStateDescriptor5.fPositions = set;
                        this.fDStates.add(rBBIStateDescriptor5);
                        n4 = this.fDStates.size() - 1;
                    }
                    rBBIStateDescriptor3.fDtran[n3] = n4;
                }
                ++n3;
            }
            break;
        }
    }

    void mapLookAheadRules() {
        this.fLookAheadRuleMap = new int[this.fRB.fScanner.numRules() + 1];
        for (RBBIStateDescriptor rBBIStateDescriptor : this.fDStates) {
            int n2;
            int n3;
            int n4 = 0;
            boolean bl2 = false;
            for (RBBINode rBBINode : rBBIStateDescriptor.fPositions) {
                if (rBBINode.fType != 4) continue;
                bl2 = true;
                n3 = rBBINode.fVal;
                assert (n3 < this.fLookAheadRuleMap.length);
                assert (n3 > 0);
                n2 = this.fLookAheadRuleMap[n3];
                if (n2 == 0) continue;
                if (n4 == 0) {
                    n4 = n2;
                    continue;
                }
                assert (n2 == n4);
            }
            if (!bl2) continue;
            if (n4 == 0) {
                n4 = ++this.fLASlotsInUse;
            }
            for (RBBINode rBBINode : rBBIStateDescriptor.fPositions) {
                if (rBBINode.fType != 4) continue;
                n3 = rBBINode.fVal;
                n2 = this.fLookAheadRuleMap[n3];
                assert (n2 == 0 || n2 == n4);
                this.fLookAheadRuleMap[n3] = n4;
            }
        }
    }

    void flagAcceptingStates() {
        ArrayList<RBBINode> arrayList = new ArrayList<RBBINode>();
        this.fRB.fTreeRoots[this.fRootIx].findNodes(arrayList, 6);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            RBBINode rBBINode = (RBBINode)arrayList.get(i2);
            for (int i3 = 0; i3 < this.fDStates.size(); ++i3) {
                RBBIStateDescriptor rBBIStateDescriptor = this.fDStates.get(i3);
                if (!rBBIStateDescriptor.fPositions.contains(rBBINode)) continue;
                if (rBBIStateDescriptor.fAccepting == 0) {
                    rBBIStateDescriptor.fAccepting = this.fLookAheadRuleMap[rBBINode.fVal];
                    if (rBBIStateDescriptor.fAccepting == 0) {
                        rBBIStateDescriptor.fAccepting = 1;
                    }
                }
                if (rBBIStateDescriptor.fAccepting != 1 || rBBINode.fVal == 0) continue;
                rBBIStateDescriptor.fAccepting = this.fLookAheadRuleMap[rBBINode.fVal];
            }
        }
    }

    void flagLookAheadStates() {
        ArrayList<RBBINode> arrayList = new ArrayList<RBBINode>();
        this.fRB.fTreeRoots[this.fRootIx].findNodes(arrayList, 4);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            RBBINode rBBINode = (RBBINode)arrayList.get(i2);
            for (int i3 = 0; i3 < this.fDStates.size(); ++i3) {
                RBBIStateDescriptor rBBIStateDescriptor = this.fDStates.get(i3);
                if (!rBBIStateDescriptor.fPositions.contains(rBBINode)) continue;
                int n2 = this.fLookAheadRuleMap[rBBINode.fVal];
                assert (rBBIStateDescriptor.fLookAhead == 0 || rBBIStateDescriptor.fLookAhead == n2);
                rBBIStateDescriptor.fLookAhead = n2;
            }
        }
    }

    void flagTaggedStates() {
        ArrayList<RBBINode> arrayList = new ArrayList<RBBINode>();
        this.fRB.fTreeRoots[this.fRootIx].findNodes(arrayList, 5);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            RBBINode rBBINode = (RBBINode)arrayList.get(i2);
            for (int i3 = 0; i3 < this.fDStates.size(); ++i3) {
                RBBIStateDescriptor rBBIStateDescriptor = this.fDStates.get(i3);
                if (!rBBIStateDescriptor.fPositions.contains(rBBINode)) continue;
                rBBIStateDescriptor.fTagVals.add(rBBINode.fVal);
            }
        }
    }

    void mergeRuleStatusVals() {
        SortedSet<Integer> sortedSet;
        Object object;
        if (this.fRB.fRuleStatusVals.size() == 0) {
            this.fRB.fRuleStatusVals.add(1);
            this.fRB.fRuleStatusVals.add(0);
            object = new TreeSet();
            this.fRB.fStatusSets.put((Set<Integer>)object, 0);
            sortedSet = new TreeSet<Integer>();
            sortedSet.add(0);
            this.fRB.fStatusSets.put(sortedSet, 0);
        }
        for (int i2 = 0; i2 < this.fDStates.size(); ++i2) {
            object = this.fDStates.get(i2);
            sortedSet = ((RBBIStateDescriptor)object).fTagVals;
            Integer n2 = this.fRB.fStatusSets.get(sortedSet);
            if (n2 == null) {
                n2 = this.fRB.fRuleStatusVals.size();
                this.fRB.fStatusSets.put(sortedSet, n2);
                this.fRB.fRuleStatusVals.add(sortedSet.size());
                this.fRB.fRuleStatusVals.addAll(sortedSet);
            }
            ((RBBIStateDescriptor)object).fTagsIdx = n2;
        }
    }

    void printPosSets(RBBINode rBBINode) {
        if (rBBINode == null) {
            return;
        }
        RBBINode.printNode(rBBINode);
        System.out.print("         Nullable:  " + rBBINode.fNullable);
        System.out.print("         firstpos:  ");
        this.printSet(rBBINode.fFirstPosSet);
        System.out.print("         lastpos:   ");
        this.printSet(rBBINode.fLastPosSet);
        System.out.print("         followpos: ");
        this.printSet(rBBINode.fFollowPos);
        this.printPosSets(rBBINode.fLeftChild);
        this.printPosSets(rBBINode.fRightChild);
    }

    boolean findDuplCharClassFrom(RBBIRuleBuilder.IntPair intPair) {
        int n2 = this.fDStates.size();
        int n3 = this.fRB.fSetBuilder.getNumCharCategories();
        int n4 = 0;
        int n5 = 0;
        while (intPair.first < n3 - 1) {
            int n6 = intPair.first < this.fRB.fSetBuilder.getDictCategoriesStart() ? this.fRB.fSetBuilder.getDictCategoriesStart() : n3;
            intPair.second = intPair.first + 1;
            while (intPair.second < n6) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    RBBIStateDescriptor rBBIStateDescriptor = this.fDStates.get(i2);
                    n4 = rBBIStateDescriptor.fDtran[intPair.first];
                    n5 = rBBIStateDescriptor.fDtran[intPair.second];
                    if (n4 != n5) break;
                }
                if (n4 == n5) {
                    return true;
                }
                ++intPair.second;
            }
            ++intPair.first;
        }
        return false;
    }

    void removeColumn(int n2) {
        int n3 = this.fDStates.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            RBBIStateDescriptor rBBIStateDescriptor = this.fDStates.get(i2);
            assert (n2 < rBBIStateDescriptor.fDtran.length);
            int[] nArray = Arrays.copyOf(rBBIStateDescriptor.fDtran, rBBIStateDescriptor.fDtran.length - 1);
            System.arraycopy(rBBIStateDescriptor.fDtran, n2 + 1, nArray, n2, nArray.length - n2);
            rBBIStateDescriptor.fDtran = nArray;
        }
    }

    boolean findDuplicateState(RBBIRuleBuilder.IntPair intPair) {
        int n2 = this.fDStates.size();
        int n3 = this.fRB.fSetBuilder.getNumCharCategories();
        while (intPair.first < n2 - 1) {
            RBBIStateDescriptor rBBIStateDescriptor = this.fDStates.get(intPair.first);
            intPair.second = intPair.first + 1;
            while (intPair.second < n2) {
                RBBIStateDescriptor rBBIStateDescriptor2 = this.fDStates.get(intPair.second);
                if (rBBIStateDescriptor.fAccepting == rBBIStateDescriptor2.fAccepting && rBBIStateDescriptor.fLookAhead == rBBIStateDescriptor2.fLookAhead && rBBIStateDescriptor.fTagsIdx == rBBIStateDescriptor2.fTagsIdx) {
                    boolean bl2 = true;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        int n4 = rBBIStateDescriptor.fDtran[i2];
                        int n5 = rBBIStateDescriptor2.fDtran[i2];
                        if (n4 == n5 || (n4 == intPair.first || n4 == intPair.second) && (n5 == intPair.first || n5 == intPair.second)) continue;
                        bl2 = false;
                        break;
                    }
                    if (bl2) {
                        return true;
                    }
                }
                ++intPair.second;
            }
            ++intPair.first;
        }
        return false;
    }

    boolean findDuplicateSafeState(RBBIRuleBuilder.IntPair intPair) {
        int n2 = this.fSafeTable.size();
        while (intPair.first < n2 - 1) {
            short[] sArray = this.fSafeTable.get(intPair.first);
            intPair.second = intPair.first + 1;
            while (intPair.second < n2) {
                short[] sArray2 = this.fSafeTable.get(intPair.second);
                boolean bl2 = true;
                int n3 = sArray.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    short s2 = sArray[i2];
                    short s3 = sArray2[i2];
                    if (s2 == s3 || (s2 == intPair.first || s2 == intPair.second) && (s3 == intPair.first || s3 == intPair.second)) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    return true;
                }
                ++intPair.second;
            }
            ++intPair.first;
        }
        return false;
    }

    void removeState(RBBIRuleBuilder.IntPair intPair) {
        int n2 = intPair.first;
        int n3 = intPair.second;
        assert (n2 < n3);
        assert (n3 < this.fDStates.size());
        this.fDStates.remove(n3);
        int n4 = this.fDStates.size();
        int n5 = this.fRB.fSetBuilder.getNumCharCategories();
        for (int i2 = 0; i2 < n4; ++i2) {
            RBBIStateDescriptor rBBIStateDescriptor = this.fDStates.get(i2);
            for (int i3 = 0; i3 < n5; ++i3) {
                int n6;
                int n7 = n6 = rBBIStateDescriptor.fDtran[i3];
                if (n6 == n3) {
                    n7 = n2;
                } else if (n6 > n3) {
                    n7 = n6 - 1;
                }
                rBBIStateDescriptor.fDtran[i3] = n7;
            }
        }
    }

    void removeSafeState(RBBIRuleBuilder.IntPair intPair) {
        int n2 = intPair.first;
        int n3 = intPair.second;
        assert (n2 < n3);
        assert (n3 < this.fSafeTable.size());
        this.fSafeTable.remove(n3);
        int n4 = this.fSafeTable.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            short[] sArray = this.fSafeTable.get(i2);
            for (int i3 = 0; i3 < sArray.length; ++i3) {
                int n5;
                int n6 = n5 = sArray[i3];
                if (n5 == n3) {
                    n6 = n2;
                } else if (n5 > n3) {
                    n6 = n5 - 1;
                }
                sArray[i3] = (short)n6;
            }
        }
    }

    int removeDuplicateStates() {
        RBBIRuleBuilder.IntPair intPair = new RBBIRuleBuilder.IntPair(3, 0);
        int n2 = 0;
        while (this.findDuplicateState(intPair)) {
            this.removeState(intPair);
            ++n2;
        }
        return n2;
    }

    int getTableSize() {
        if (this.fRB.fTreeRoots[this.fRootIx] == null) {
            return 0;
        }
        int n2 = RBBIDataWrapper.RBBIStateTable.fHeaderSize;
        int n3 = this.fDStates.size();
        int n4 = this.fRB.fSetBuilder.getNumCharCategories();
        boolean bl2 = n3 <= 255;
        int n5 = (bl2 ? 1 : 2) * (3 + n4);
        n2 += n3 * n5;
        n2 = n2 + 7 & 0xFFFFFFF8;
        return n2;
    }

    RBBIDataWrapper.RBBIStateTable exportTable() {
        int n2;
        RBBIDataWrapper.RBBIStateTable rBBIStateTable = new RBBIDataWrapper.RBBIStateTable();
        if (this.fRB.fTreeRoots[this.fRootIx] == null) {
            return rBBIStateTable;
        }
        Assert.assrt(this.fRB.fSetBuilder.getNumCharCategories() < Short.MAX_VALUE && this.fDStates.size() < Short.MAX_VALUE);
        rBBIStateTable.fNumStates = this.fDStates.size();
        rBBIStateTable.fDictCategoriesStart = this.fRB.fSetBuilder.getDictCategoriesStart();
        rBBIStateTable.fLookAheadResultsSize = this.fLASlotsInUse == 1 ? 0 : this.fLASlotsInUse + 1;
        boolean bl2 = rBBIStateTable.fNumStates <= 255;
        int n3 = 3 + this.fRB.fSetBuilder.getNumCharCategories();
        if (bl2) {
            n2 = this.getTableSize() - RBBIDataWrapper.RBBIStateTable.fHeaderSize;
            rBBIStateTable.fTable = new char[n2];
            rBBIStateTable.fRowLen = n3;
        } else {
            n2 = (this.getTableSize() - RBBIDataWrapper.RBBIStateTable.fHeaderSize) / 2;
            rBBIStateTable.fTable = new char[n2];
            rBBIStateTable.fRowLen = n3 * 2;
        }
        if (this.fRB.fLookAheadHardBreak) {
            rBBIStateTable.fFlags |= 1;
        }
        if (this.fRB.fSetBuilder.sawBOF()) {
            rBBIStateTable.fFlags |= 2;
        }
        if (bl2) {
            rBBIStateTable.fFlags |= 4;
        }
        int n4 = this.fRB.fSetBuilder.getNumCharCategories();
        for (int i2 = 0; i2 < rBBIStateTable.fNumStates; ++i2) {
            RBBIStateDescriptor rBBIStateDescriptor = this.fDStates.get(i2);
            int n5 = i2 * n3;
            if (bl2) {
                Assert.assrt(0 <= rBBIStateDescriptor.fAccepting && rBBIStateDescriptor.fAccepting <= 255);
                Assert.assrt(0 <= rBBIStateDescriptor.fLookAhead && rBBIStateDescriptor.fLookAhead <= 255);
            } else {
                Assert.assrt(0 <= rBBIStateDescriptor.fAccepting && rBBIStateDescriptor.fAccepting <= 65535);
                Assert.assrt(0 <= rBBIStateDescriptor.fLookAhead && rBBIStateDescriptor.fLookAhead <= 65535);
            }
            rBBIStateTable.fTable[n5 + 0] = (char)rBBIStateDescriptor.fAccepting;
            rBBIStateTable.fTable[n5 + 1] = (char)rBBIStateDescriptor.fLookAhead;
            rBBIStateTable.fTable[n5 + 2] = (char)rBBIStateDescriptor.fTagsIdx;
            for (int i3 = 0; i3 < n4; ++i3) {
                if (bl2) {
                    Assert.assrt(0 <= rBBIStateDescriptor.fDtran[i3] && rBBIStateDescriptor.fDtran[i3] <= 255);
                }
                rBBIStateTable.fTable[n5 + 3 + i3] = (char)rBBIStateDescriptor.fDtran[i3];
            }
        }
        return rBBIStateTable;
    }

    void buildSafeReverseTable() {
        int n2;
        int n3;
        int n4;
        int n5;
        StringBuilder stringBuilder = new StringBuilder();
        int n6 = this.fRB.fSetBuilder.getNumCharCategories();
        int n7 = this.fDStates.size();
        for (n5 = 0; n5 < n6; ++n5) {
            for (n4 = 0; n4 < n6; ++n4) {
                n3 = -1;
                n2 = 0;
                for (int i2 = 1; i2 < n7; ++i2) {
                    RBBIStateDescriptor rBBIStateDescriptor = this.fDStates.get(i2);
                    int n8 = rBBIStateDescriptor.fDtran[n5];
                    RBBIStateDescriptor rBBIStateDescriptor2 = this.fDStates.get(n8);
                    n2 = rBBIStateDescriptor2.fDtran[n4];
                    if (n3 < 0) {
                        n3 = n2;
                        continue;
                    }
                    if (n3 != n2) break;
                }
                if (n3 != n2) continue;
                stringBuilder.append((char)n5);
                stringBuilder.append((char)n4);
            }
        }
        assert (this.fSafeTable == null);
        this.fSafeTable = new ArrayList<short[]>();
        for (n5 = 0; n5 < n6 + 2; ++n5) {
            this.fSafeTable.add(new short[n6]);
        }
        short[] sArray = this.fSafeTable.get(1);
        for (n4 = 0; n4 < n6; ++n4) {
            sArray[n4] = (short)(n4 + 2);
        }
        for (n4 = 2; n4 < n6 + 2; ++n4) {
            System.arraycopy(sArray, 0, this.fSafeTable.get(n4), 0, sArray.length);
        }
        for (n4 = 0; n4 < stringBuilder.length(); n4 += 2) {
            n3 = stringBuilder.charAt(n4);
            n2 = stringBuilder.charAt(n4 + 1);
            short[] sArray2 = this.fSafeTable.get(n2 + 2);
            sArray2[n3] = 0;
        }
        RBBIRuleBuilder.IntPair intPair = new RBBIRuleBuilder.IntPair(1, 0);
        while (this.findDuplicateSafeState(intPair)) {
            this.removeSafeState(intPair);
        }
    }

    int getSafeTableSize() {
        if (this.fSafeTable == null) {
            return 0;
        }
        int n2 = RBBIDataWrapper.RBBIStateTable.fHeaderSize;
        int n3 = this.fSafeTable.size();
        int n4 = this.fSafeTable.get(0).length;
        boolean bl2 = n3 <= 255;
        int n5 = (bl2 ? 1 : 2) * (3 + n4);
        n2 += n3 * n5;
        n2 = n2 + 7 & 0xFFFFFFF8;
        return n2;
    }

    RBBIDataWrapper.RBBIStateTable exportSafeTable() {
        RBBIDataWrapper.RBBIStateTable rBBIStateTable = new RBBIDataWrapper.RBBIStateTable();
        rBBIStateTable.fNumStates = this.fSafeTable.size();
        boolean bl2 = rBBIStateTable.fNumStates <= 255;
        int n2 = this.fSafeTable.get(0).length;
        int n3 = 3 + n2;
        int n4 = this.getSafeTableSize() - RBBIDataWrapper.RBBIStateTable.fHeaderSize;
        if (bl2) {
            rBBIStateTable.fFlags |= 4;
            rBBIStateTable.fTable = new char[n4];
            rBBIStateTable.fRowLen = n3;
        } else {
            rBBIStateTable.fTable = new char[n4 /= 2];
            rBBIStateTable.fRowLen = n3 * 2;
        }
        for (int i2 = 0; i2 < rBBIStateTable.fNumStates; ++i2) {
            short[] sArray = this.fSafeTable.get(i2);
            int n5 = i2 * n3;
            for (int i3 = 0; i3 < n2; ++i3) {
                if (bl2) {
                    Assert.assrt(sArray[i3] <= 255);
                }
                rBBIStateTable.fTable[n5 + 3 + i3] = (char)sArray[i3];
            }
        }
        return rBBIStateTable;
    }

    void printSet(Collection<RBBINode> collection) {
        for (RBBINode rBBINode : collection) {
            RBBINode.printInt(rBBINode.fSerialNum, 8);
        }
        System.out.println();
    }

    void printStates() {
        int n2;
        System.out.print("state |           i n p u t     s y m b o l s \n");
        System.out.print("      | Acc  LA    Tag");
        for (n2 = 0; n2 < this.fRB.fSetBuilder.getNumCharCategories(); ++n2) {
            RBBINode.printInt(n2, 4);
        }
        System.out.print("\n");
        System.out.print("      |---------------");
        for (n2 = 0; n2 < this.fRB.fSetBuilder.getNumCharCategories(); ++n2) {
            System.out.print("----");
        }
        System.out.print("\n");
        for (int i2 = 0; i2 < this.fDStates.size(); ++i2) {
            RBBIStateDescriptor rBBIStateDescriptor = this.fDStates.get(i2);
            RBBINode.printInt(i2, 5);
            System.out.print(" | ");
            RBBINode.printInt(rBBIStateDescriptor.fAccepting, 3);
            RBBINode.printInt(rBBIStateDescriptor.fLookAhead, 4);
            RBBINode.printInt(rBBIStateDescriptor.fTagsIdx, 6);
            System.out.print(" ");
            for (n2 = 0; n2 < this.fRB.fSetBuilder.getNumCharCategories(); ++n2) {
                RBBINode.printInt(rBBIStateDescriptor.fDtran[n2], 4);
            }
            System.out.print("\n");
        }
        System.out.print("\n\n");
    }

    void printReverseTable() {
        int n2;
        System.out.printf("    Safe Reverse Table \n", new Object[0]);
        if (this.fSafeTable == null) {
            System.out.printf("   --- nullptr ---\n", new Object[0]);
            return;
        }
        int n3 = this.fSafeTable.get(0).length;
        System.out.printf("state |           i n p u t     s y m b o l s \n", new Object[0]);
        System.out.printf("      | Acc  LA    Tag", new Object[0]);
        for (n2 = 0; n2 < n3; ++n2) {
            System.out.printf(" %2d", n2);
        }
        System.out.printf("\n", new Object[0]);
        System.out.printf("      |---------------", new Object[0]);
        for (n2 = 0; n2 < n3; ++n2) {
            System.out.printf("---", new Object[0]);
        }
        System.out.printf("\n", new Object[0]);
        for (int i2 = 0; i2 < this.fSafeTable.size(); ++i2) {
            short[] sArray = this.fSafeTable.get(i2);
            System.out.printf("  %3d | ", i2);
            System.out.printf("%3d %3d %5d ", 0, 0, 0);
            for (n2 = 0; n2 < n3; ++n2) {
                System.out.printf(" %2d", sArray[n2]);
            }
            System.out.printf("\n", new Object[0]);
        }
        System.out.printf("\n\n", new Object[0]);
    }

    void printRuleStatusTable() {
        int n2 = 0;
        int n3 = 0;
        List<Integer> list = this.fRB.fRuleStatusVals;
        System.out.print("index |  tags \n");
        System.out.print("-------------------\n");
        while (n3 < list.size()) {
            n2 = n3;
            n3 = n2 + list.get(n2) + 1;
            RBBINode.printInt(n2, 7);
            for (int i2 = n2 + 1; i2 < n3; ++i2) {
                int n4 = list.get(i2);
                RBBINode.printInt(n4, 7);
            }
            System.out.print("\n");
        }
        System.out.print("\n\n");
    }

    static class RBBIStateDescriptor {
        boolean fMarked;
        int fAccepting;
        int fLookAhead;
        SortedSet<Integer> fTagVals = new TreeSet<Integer>();
        int fTagsIdx;
        Set<RBBINode> fPositions = new HashSet<RBBINode>();
        int[] fDtran;

        RBBIStateDescriptor(int n2) {
            this.fDtran = new int[n2 + 1];
        }
    }
}

