/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.text.ParsePosition;
import java.util.HashMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RBBINode;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RBBIRuleScanner;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.SymbolTable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class RBBISymbolTable
implements SymbolTable {
    HashMap<String, RBBISymbolTableEntry> fHashTable;
    RBBIRuleScanner fRuleScanner;
    String ffffString;
    UnicodeSet fCachedSetLookup;

    RBBISymbolTable(RBBIRuleScanner rBBIRuleScanner) {
        this.fRuleScanner = rBBIRuleScanner;
        this.fHashTable = new HashMap();
        this.ffffString = "\uffff";
    }

    @Override
    public char[] lookup(String string) {
        String string2;
        RBBISymbolTableEntry rBBISymbolTableEntry = this.fHashTable.get(string);
        if (rBBISymbolTableEntry == null) {
            return null;
        }
        RBBINode rBBINode = rBBISymbolTableEntry.val;
        while (rBBINode.fLeftChild.fType == 2) {
            rBBINode = rBBINode.fLeftChild;
        }
        RBBINode rBBINode2 = rBBINode.fLeftChild;
        if (rBBINode2.fType == 0) {
            RBBINode rBBINode3 = rBBINode2.fLeftChild;
            this.fCachedSetLookup = rBBINode3.fInputSet;
            string2 = this.ffffString;
        } else {
            this.fRuleScanner.error(66063);
            string2 = rBBINode2.fText;
            this.fCachedSetLookup = null;
        }
        return string2.toCharArray();
    }

    @Override
    public UnicodeMatcher lookupMatcher(int n2) {
        UnicodeSet unicodeSet = null;
        if (n2 == 65535) {
            unicodeSet = this.fCachedSetLookup;
            this.fCachedSetLookup = null;
        }
        return unicodeSet;
    }

    @Override
    public String parseReference(String string, ParsePosition parsePosition, int n2) {
        int n3;
        int n4;
        int n5;
        String string2 = "";
        for (n4 = n3 = parsePosition.getIndex(); n4 < n2; n4 += UTF16.getCharCount(n5)) {
            n5 = UTF16.charAt(string, n4);
            if (n4 == n3 && !UCharacter.isUnicodeIdentifierStart(n5) || !UCharacter.isUnicodeIdentifierPart(n5)) break;
        }
        if (n4 == n3) {
            return string2;
        }
        parsePosition.setIndex(n4);
        string2 = string.substring(n3, n4);
        return string2;
    }

    RBBINode lookupNode(String string) {
        RBBINode rBBINode = null;
        RBBISymbolTableEntry rBBISymbolTableEntry = this.fHashTable.get(string);
        if (rBBISymbolTableEntry != null) {
            rBBINode = rBBISymbolTableEntry.val;
        }
        return rBBINode;
    }

    void addEntry(String string, RBBINode rBBINode) {
        RBBISymbolTableEntry rBBISymbolTableEntry = this.fHashTable.get(string);
        if (rBBISymbolTableEntry != null) {
            this.fRuleScanner.error(66055);
            return;
        }
        rBBISymbolTableEntry = new RBBISymbolTableEntry();
        rBBISymbolTableEntry.key = string;
        rBBISymbolTableEntry.val = rBBINode;
        this.fHashTable.put(rBBISymbolTableEntry.key, rBBISymbolTableEntry);
    }

    void rbbiSymtablePrint() {
        RBBISymbolTableEntry rBBISymbolTableEntry;
        int n2;
        System.out.print("Variable Definitions\nName               Node Val     String Val\n----------------------------------------------------------------------\n");
        RBBISymbolTableEntry[] rBBISymbolTableEntryArray = this.fHashTable.values().toArray(new RBBISymbolTableEntry[0]);
        for (n2 = 0; n2 < rBBISymbolTableEntryArray.length; ++n2) {
            rBBISymbolTableEntry = rBBISymbolTableEntryArray[n2];
            System.out.print("  " + rBBISymbolTableEntry.key + "  ");
            System.out.print("  " + rBBISymbolTableEntry.val + "  ");
            System.out.print(rBBISymbolTableEntry.val.fLeftChild.fText);
            System.out.print("\n");
        }
        System.out.println("\nParsed Variable Definitions\n");
        for (n2 = 0; n2 < rBBISymbolTableEntryArray.length; ++n2) {
            rBBISymbolTableEntry = rBBISymbolTableEntryArray[n2];
            System.out.print(rBBISymbolTableEntry.key);
            rBBISymbolTableEntry.val.fLeftChild.printTree(true);
            System.out.print("\n");
        }
    }

    static class RBBISymbolTableEntry {
        String key;
        RBBINode val;

        RBBISymbolTableEntry() {
        }
    }
}

