/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Assert;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RBBINode;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RBBIRuleBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CodePointTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MutableCodePointTrie;

class RBBISetBuilder {
    RBBIRuleBuilder fRB;
    RangeDescriptor fRangeList;
    MutableCodePointTrie fTrie;
    CodePointTrie fFrozenTrie;
    int fGroupCount;
    int fDictCategoriesStart;
    boolean fSawBOF;
    private static final int MAX_CHAR_CATEGORIES_FOR_8BITS_TRIE = 255;

    RBBISetBuilder(RBBIRuleBuilder rBBIRuleBuilder) {
        this.fRB = rBBIRuleBuilder;
    }

    void buildRanges() {
        RangeDescriptor rangeDescriptor;
        Object object;
        if (this.fRB.fDebugEnv != null && this.fRB.fDebugEnv.indexOf("usets") >= 0) {
            this.printSets();
        }
        this.fRangeList = new RangeDescriptor();
        this.fRangeList.fStartChar = 0;
        this.fRangeList.fEndChar = 0x10FFFF;
        for (RBBINode rBBINode : this.fRB.fUSetNodes) {
            object = rBBINode.fInputSet;
            int n2 = ((UnicodeSet)object).getRangeCount();
            int n3 = 0;
            rangeDescriptor = this.fRangeList;
            while (n3 < n2) {
                int n4 = ((UnicodeSet)object).getRangeStart(n3);
                int n5 = ((UnicodeSet)object).getRangeEnd(n3);
                while (rangeDescriptor.fEndChar < n4) {
                    rangeDescriptor = rangeDescriptor.fNext;
                }
                if (rangeDescriptor.fStartChar < n4) {
                    rangeDescriptor.split(n4);
                    continue;
                }
                if (rangeDescriptor.fEndChar > n5) {
                    rangeDescriptor.split(n5 + 1);
                }
                if (rangeDescriptor.fIncludesSets.indexOf(rBBINode) == -1) {
                    rangeDescriptor.fIncludesSets.add(rBBINode);
                }
                if (n5 == rangeDescriptor.fEndChar) {
                    ++n3;
                }
                rangeDescriptor = rangeDescriptor.fNext;
            }
        }
        if (this.fRB.fDebugEnv != null && this.fRB.fDebugEnv.indexOf("range") >= 0) {
            this.printRanges();
        }
        int n6 = 0;
        rangeDescriptor = this.fRangeList;
        while (rangeDescriptor != null) {
            Object object2 = this.fRangeList;
            while (object2 != rangeDescriptor) {
                if (rangeDescriptor.fIncludesSets.equals(((RangeDescriptor)object2).fIncludesSets)) {
                    rangeDescriptor.fNum = ((RangeDescriptor)object2).fNum;
                    rangeDescriptor.fIncludesDict = ((RangeDescriptor)object2).fIncludesDict;
                    break;
                }
                object2 = ((RangeDescriptor)object2).fNext;
            }
            if (rangeDescriptor.fNum == 0) {
                rangeDescriptor.fFirstInGroup = true;
                if (rangeDescriptor.isDictionaryRange()) {
                    rangeDescriptor.fNum = ++n6;
                    rangeDescriptor.fIncludesDict = true;
                } else {
                    ++this.fGroupCount;
                    rangeDescriptor.fNum = this.fGroupCount + 2;
                    this.addValToSets(rangeDescriptor.fIncludesSets, this.fGroupCount + 2);
                }
            }
            rangeDescriptor = rangeDescriptor.fNext;
        }
        this.fDictCategoriesStart = this.fGroupCount + 3;
        rangeDescriptor = this.fRangeList;
        while (rangeDescriptor != null) {
            if (rangeDescriptor.fIncludesDict) {
                rangeDescriptor.fNum += this.fDictCategoriesStart - 1;
                if (rangeDescriptor.fFirstInGroup) {
                    this.addValToSets(rangeDescriptor.fIncludesSets, rangeDescriptor.fNum);
                }
            }
            rangeDescriptor = rangeDescriptor.fNext;
        }
        this.fGroupCount += n6;
        object = "eof";
        String string = "bof";
        for (RBBINode rBBINode : this.fRB.fUSetNodes) {
            UnicodeSet unicodeSet = rBBINode.fInputSet;
            if (unicodeSet.contains((CharSequence)object)) {
                this.addValToSet(rBBINode, 1);
            }
            if (!unicodeSet.contains(string)) continue;
            this.addValToSet(rBBINode, 2);
            this.fSawBOF = true;
        }
        if (this.fRB.fDebugEnv != null && this.fRB.fDebugEnv.indexOf("rgroup") >= 0) {
            this.printRangeGroups();
        }
        if (this.fRB.fDebugEnv != null && this.fRB.fDebugEnv.indexOf("esets") >= 0) {
            this.printSets();
        }
    }

    void buildTrie() {
        this.fTrie = new MutableCodePointTrie(0, 0);
        RangeDescriptor rangeDescriptor = this.fRangeList;
        while (rangeDescriptor != null) {
            this.fTrie.setRange(rangeDescriptor.fStartChar, rangeDescriptor.fEndChar, rangeDescriptor.fNum);
            rangeDescriptor = rangeDescriptor.fNext;
        }
    }

    void mergeCategories(RBBIRuleBuilder.IntPair intPair) {
        assert (intPair.first >= 1);
        assert (intPair.second > intPair.first);
        assert (intPair.first < this.fDictCategoriesStart && intPair.second < this.fDictCategoriesStart || intPair.first >= this.fDictCategoriesStart && intPair.second >= this.fDictCategoriesStart);
        RangeDescriptor rangeDescriptor = this.fRangeList;
        while (rangeDescriptor != null) {
            int n2;
            if ((n2 = rangeDescriptor.fNum--) == intPair.second) {
                rangeDescriptor.fNum = intPair.first;
            } else if (n2 > intPair.second) {
                // empty if block
            }
            rangeDescriptor = rangeDescriptor.fNext;
        }
        --this.fGroupCount;
        if (intPair.second <= this.fDictCategoriesStart) {
            --this.fDictCategoriesStart;
        }
    }

    void freezeTrieIfNotYet() {
        if (this.fFrozenTrie == null) {
            boolean bl2 = this.getNumCharCategories() <= 255;
            this.fFrozenTrie = this.fTrie.buildImmutable(CodePointTrie.Type.FAST, bl2 ? CodePointTrie.ValueWidth.BITS_8 : CodePointTrie.ValueWidth.BITS_16);
            this.fTrie = null;
        }
    }

    int getTrieSize() {
        this.freezeTrieIfNotYet();
        return this.fFrozenTrie.toBinary(new ByteArrayOutputStream());
    }

    void serializeTrie(OutputStream outputStream) throws IOException {
        this.freezeTrieIfNotYet();
        this.fFrozenTrie.toBinary(outputStream);
    }

    void addValToSets(List<RBBINode> list, int n2) {
        for (RBBINode rBBINode : list) {
            this.addValToSet(rBBINode, n2);
        }
    }

    void addValToSet(RBBINode rBBINode, int n2) {
        RBBINode rBBINode2 = new RBBINode(3);
        rBBINode2.fVal = n2;
        if (rBBINode.fLeftChild == null) {
            rBBINode.fLeftChild = rBBINode2;
            rBBINode2.fParent = rBBINode;
        } else {
            RBBINode rBBINode3 = new RBBINode(9);
            rBBINode3.fLeftChild = rBBINode.fLeftChild;
            rBBINode3.fRightChild = rBBINode2;
            rBBINode3.fLeftChild.fParent = rBBINode3;
            rBBINode3.fRightChild.fParent = rBBINode3;
            rBBINode.fLeftChild = rBBINode3;
            rBBINode3.fParent = rBBINode;
        }
    }

    int getNumCharCategories() {
        return this.fGroupCount + 3;
    }

    int getDictCategoriesStart() {
        return this.fDictCategoriesStart;
    }

    boolean sawBOF() {
        return this.fSawBOF;
    }

    int getFirstChar(int n2) {
        int n3 = -1;
        RangeDescriptor rangeDescriptor = this.fRangeList;
        while (rangeDescriptor != null) {
            if (rangeDescriptor.fNum == n2) {
                n3 = rangeDescriptor.fStartChar;
                break;
            }
            rangeDescriptor = rangeDescriptor.fNext;
        }
        return n3;
    }

    void printRanges() {
        System.out.print("\n\n Nonoverlapping Ranges ...\n");
        RangeDescriptor rangeDescriptor = this.fRangeList;
        while (rangeDescriptor != null) {
            System.out.printf("%04x-%04x ", rangeDescriptor.fStartChar, rangeDescriptor.fEndChar);
            for (int i2 = 0; i2 < rangeDescriptor.fIncludesSets.size(); ++i2) {
                RBBINode rBBINode;
                RBBINode rBBINode2 = rangeDescriptor.fIncludesSets.get(i2);
                String string = "anon";
                RBBINode rBBINode3 = rBBINode2.fParent;
                if (rBBINode3 != null && (rBBINode = rBBINode3.fParent) != null && rBBINode.fType == 2) {
                    string = rBBINode.fText;
                }
                System.out.print(string);
                System.out.print("  ");
            }
            System.out.println("");
            rangeDescriptor = rangeDescriptor.fNext;
        }
    }

    void printRangeGroups() {
        System.out.print("\nRanges grouped by Unicode Set Membership...\n");
        RangeDescriptor rangeDescriptor = this.fRangeList;
        while (rangeDescriptor != null) {
            if (rangeDescriptor.fFirstInGroup) {
                Object object;
                int n2;
                int n3 = rangeDescriptor.fNum;
                if (n3 < 10) {
                    System.out.print(" ");
                }
                System.out.print(n3 + " ");
                if (n3 >= this.fDictCategoriesStart) {
                    System.out.print(" <DICT> ");
                }
                for (n2 = 0; n2 < rangeDescriptor.fIncludesSets.size(); ++n2) {
                    RBBINode rBBINode;
                    object = rangeDescriptor.fIncludesSets.get(n2);
                    String string = "anon";
                    RBBINode rBBINode2 = ((RBBINode)object).fParent;
                    if (rBBINode2 != null && (rBBINode = rBBINode2.fParent) != null && rBBINode.fType == 2) {
                        string = rBBINode.fText;
                    }
                    System.out.print(string);
                    System.out.print(" ");
                }
                n2 = 0;
                object = rangeDescriptor;
                while (object != null) {
                    if (((RangeDescriptor)object).fNum == rangeDescriptor.fNum) {
                        if (n2++ % 5 == 0) {
                            System.out.print("\n    ");
                        }
                        RBBINode.printHex(((RangeDescriptor)object).fStartChar, -1);
                        System.out.print("-");
                        RBBINode.printHex(((RangeDescriptor)object).fEndChar, 0);
                    }
                    object = ((RangeDescriptor)object).fNext;
                }
                System.out.print("\n");
            }
            rangeDescriptor = rangeDescriptor.fNext;
        }
        System.out.print("\n");
    }

    void printSets() {
        System.out.print("\n\nUnicode Sets List\n------------------\n");
        for (int i2 = 0; i2 < this.fRB.fUSetNodes.size(); ++i2) {
            RBBINode rBBINode;
            RBBINode rBBINode2 = this.fRB.fUSetNodes.get(i2);
            RBBINode.printInt(2, i2);
            String string = "anonymous";
            RBBINode rBBINode3 = rBBINode2.fParent;
            if (rBBINode3 != null && (rBBINode = rBBINode3.fParent) != null && rBBINode.fType == 2) {
                string = rBBINode.fText;
            }
            System.out.print("  " + string);
            System.out.print("   ");
            System.out.print(rBBINode2.fText);
            System.out.print("\n");
            if (rBBINode2.fLeftChild == null) continue;
            rBBINode2.fLeftChild.printTree(true);
        }
        System.out.print("\n");
    }

    static class RangeDescriptor {
        int fStartChar = 0;
        int fEndChar = 0;
        int fNum = 0;
        boolean fIncludesDict = false;
        boolean fFirstInGroup = false;
        List<RBBINode> fIncludesSets;
        RangeDescriptor fNext;

        RangeDescriptor() {
            this.fIncludesSets = new ArrayList<RBBINode>();
        }

        RangeDescriptor(RangeDescriptor rangeDescriptor) {
            this.fStartChar = rangeDescriptor.fStartChar;
            this.fEndChar = rangeDescriptor.fEndChar;
            this.fNum = rangeDescriptor.fNum;
            this.fIncludesDict = rangeDescriptor.fIncludesDict;
            this.fFirstInGroup = rangeDescriptor.fFirstInGroup;
            this.fIncludesSets = new ArrayList<RBBINode>(rangeDescriptor.fIncludesSets);
        }

        void split(int n2) {
            Assert.assrt(n2 > this.fStartChar && n2 <= this.fEndChar);
            RangeDescriptor rangeDescriptor = new RangeDescriptor(this);
            rangeDescriptor.fStartChar = n2;
            this.fEndChar = n2 - 1;
            rangeDescriptor.fNext = this.fNext;
            this.fNext = rangeDescriptor;
        }

        boolean isDictionaryRange() {
            for (int i2 = 0; i2 < this.fIncludesSets.size(); ++i2) {
                RBBINode rBBINode;
                RBBINode rBBINode2 = this.fIncludesSets.get(i2);
                String string = "";
                RBBINode rBBINode3 = rBBINode2.fParent;
                if (rBBINode3 != null && (rBBINode = rBBINode3.fParent) != null && rBBINode.fType == 2) {
                    string = rBBINode.fText;
                }
                if (!string.equals("dictionary")) continue;
                return true;
            }
            return false;
        }
    }
}

