/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Assert;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUDebug;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.RBBIDataWrapper;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RBBINode;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RBBIRuleScanner;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RBBISetBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RBBITableBuilder;

class RBBIRuleBuilder {
    String fDebugEnv;
    String fRules;
    StringBuilder fStrippedRules;
    RBBIRuleScanner fScanner;
    RBBINode[] fTreeRoots = new RBBINode[4];
    static final int fForwardTree = 0;
    static final int fReverseTree = 1;
    static final int fSafeFwdTree = 2;
    static final int fSafeRevTree = 3;
    int fDefaultTree = 0;
    boolean fChainRules;
    boolean fLookAheadHardBreak;
    RBBISetBuilder fSetBuilder;
    List<RBBINode> fUSetNodes;
    RBBITableBuilder fForwardTable;
    Map<Set<Integer>, Integer> fStatusSets = new HashMap<Set<Integer>, Integer>();
    List<Integer> fRuleStatusVals;
    static final int U_ILLEGAL_CHAR_FOUND = 12;
    static final int U_BRK_ERROR_START = 66048;
    static final int U_BRK_INTERNAL_ERROR = 66049;
    static final int U_BRK_HEX_DIGITS_EXPECTED = 66050;
    static final int U_BRK_SEMICOLON_EXPECTED = 66051;
    static final int U_BRK_RULE_SYNTAX = 66052;
    static final int U_BRK_UNCLOSED_SET = 66053;
    static final int U_BRK_ASSIGN_ERROR = 66054;
    static final int U_BRK_VARIABLE_REDFINITION = 66055;
    static final int U_BRK_MISMATCHED_PAREN = 66056;
    static final int U_BRK_NEW_LINE_IN_QUOTED_STRING = 66057;
    static final int U_BRK_UNDEFINED_VARIABLE = 66058;
    static final int U_BRK_INIT_ERROR = 66059;
    static final int U_BRK_RULE_EMPTY_SET = 66060;
    static final int U_BRK_UNRECOGNIZED_OPTION = 66061;
    static final int U_BRK_MALFORMED_RULE_TAG = 66062;
    static final int U_BRK_MALFORMED_SET = 66063;
    static final int U_BRK_ERROR_LIMIT = 66064;

    RBBIRuleBuilder(String string) {
        this.fDebugEnv = ICUDebug.enabled("rbbi") ? ICUDebug.value("rbbi") : null;
        this.fRules = string;
        this.fStrippedRules = new StringBuilder(string);
        this.fUSetNodes = new ArrayList<RBBINode>();
        this.fRuleStatusVals = new ArrayList<Integer>();
        this.fScanner = new RBBIRuleScanner(this);
        this.fSetBuilder = new RBBISetBuilder(this);
    }

    static final int align8(int n2) {
        return n2 + 7 & 0xFFFFFFF8;
    }

    void flattenData(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        String string = RBBIRuleScanner.stripRules(this.fStrippedRules.toString());
        int n2 = 80;
        int n3 = RBBIRuleBuilder.align8(this.fForwardTable.getTableSize());
        int n4 = RBBIRuleBuilder.align8(this.fForwardTable.getSafeTableSize());
        int n5 = RBBIRuleBuilder.align8(this.fSetBuilder.getTrieSize());
        int n6 = RBBIRuleBuilder.align8(this.fRuleStatusVals.size() * 4);
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        int n7 = RBBIRuleBuilder.align8(byArray.length + 1);
        int n8 = n2 + n3 + n4 + n6 + n5 + n7;
        int n9 = 0;
        ICUBinary.writeHeader(1114794784, 0x6000000, 0, dataOutputStream);
        int[] nArray = new int[20];
        nArray[0] = 45472;
        nArray[1] = 0x6000000;
        nArray[2] = n8;
        nArray[3] = this.fSetBuilder.getNumCharCategories();
        nArray[4] = n2;
        nArray[5] = n3;
        nArray[6] = nArray[4] + n3;
        nArray[7] = n4;
        nArray[8] = nArray[6] + nArray[7];
        nArray[9] = this.fSetBuilder.getTrieSize();
        nArray[12] = nArray[8] + n5;
        nArray[13] = n6;
        nArray[10] = nArray[12] + n6;
        nArray[11] = byArray.length;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            dataOutputStream.writeInt(nArray[i2]);
            n9 += 4;
        }
        RBBIDataWrapper.RBBIStateTable rBBIStateTable = this.fForwardTable.exportTable();
        assert (n9 == nArray[4]);
        n9 += rBBIStateTable.put(dataOutputStream);
        rBBIStateTable = this.fForwardTable.exportSafeTable();
        Assert.assrt(n9 == nArray[6]);
        Assert.assrt((n9 += rBBIStateTable.put(dataOutputStream)) == nArray[8]);
        this.fSetBuilder.serializeTrie(outputStream);
        n9 += nArray[9];
        while (n9 % 8 != 0) {
            dataOutputStream.write(0);
            ++n9;
        }
        Assert.assrt(n9 == nArray[12]);
        for (Integer n10 : this.fRuleStatusVals) {
            dataOutputStream.writeInt(n10);
            n9 += 4;
        }
        while (n9 % 8 != 0) {
            dataOutputStream.write(0);
            ++n9;
        }
        Assert.assrt(n9 == nArray[10]);
        dataOutputStream.write(byArray, 0, byArray.length);
        dataOutputStream.write(0);
        n9 += byArray.length + 1;
        while (n9 % 8 != 0) {
            dataOutputStream.write(0);
            ++n9;
        }
    }

    static void compileRules(String string, OutputStream outputStream) throws IOException {
        RBBIRuleBuilder rBBIRuleBuilder = new RBBIRuleBuilder(string);
        rBBIRuleBuilder.build(outputStream);
    }

    void build(OutputStream outputStream) throws IOException {
        this.fScanner.parse();
        this.fSetBuilder.buildRanges();
        this.fForwardTable = new RBBITableBuilder(this, 0);
        this.fForwardTable.buildForwardTable();
        this.optimizeTables();
        this.fForwardTable.buildSafeReverseTable();
        if (this.fDebugEnv != null && this.fDebugEnv.indexOf("states") >= 0) {
            this.fForwardTable.printStates();
            this.fForwardTable.printRuleStatusTable();
            this.fForwardTable.printReverseTable();
        }
        this.fSetBuilder.buildTrie();
        this.flattenData(outputStream);
    }

    void optimizeTables() {
        boolean bl2;
        do {
            bl2 = false;
            IntPair intPair = new IntPair(3, 0);
            while (this.fForwardTable.findDuplCharClassFrom(intPair)) {
                this.fSetBuilder.mergeCategories(intPair);
                this.fForwardTable.removeColumn(intPair.second);
                bl2 = true;
            }
            while (this.fForwardTable.removeDuplicateStates() > 0) {
                bl2 = true;
            }
        } while (bl2);
    }

    static class IntPair {
        int first = 0;
        int second = 0;

        IntPair() {
        }

        IntPair(int n2, int n3) {
            this.first = n2;
            this.second = n3;
        }
    }
}

