/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PluralRulesLoader;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.range.StandardPluralRanges;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.FormattedNumber;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.FormattedNumberRange;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRulesSerialProxy;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Output;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class PluralRules
implements Serializable {
    static final UnicodeSet ALLOWED_ID = new UnicodeSet("[a-z]").freeze();
    private static final String CATEGORY_SEPARATOR = ";  ";
    private static final long serialVersionUID = 1L;
    private final RuleList rules;
    private final transient Set<String> keywords;
    private final transient StandardPluralRanges standardPluralRanges;
    public static final String KEYWORD_ZERO = "zero";
    public static final String KEYWORD_ONE = "one";
    public static final String KEYWORD_TWO = "two";
    public static final String KEYWORD_FEW = "few";
    public static final String KEYWORD_MANY = "many";
    public static final String KEYWORD_OTHER = "other";
    public static final double NO_UNIQUE_VALUE = -0.00123456777;
    @Deprecated
    public static final DecimalQuantity NO_UNIQUE_VALUE_DECIMAL_QUANTITY = new DecimalQuantity_DualStorageBCD(-0.00123456777);
    private static final Constraint NO_CONSTRAINT = new Constraint(){
        private static final long serialVersionUID = 9163464945387899416L;

        @Override
        public boolean isFulfilled(IFixedDecimal iFixedDecimal) {
            return true;
        }

        @Override
        public boolean isLimited(SampleType sampleType) {
            return false;
        }

        public String toString() {
            return "";
        }
    };
    private static final Rule DEFAULT_RULE = new Rule("other", NO_CONSTRAINT, null, null);
    public static final PluralRules DEFAULT = new PluralRules(new RuleList().addRule(DEFAULT_RULE), StandardPluralRanges.DEFAULT);
    static final Pattern AT_SEPARATED = Pattern.compile("\\s*\\Q\\E@\\s*");
    static final Pattern OR_SEPARATED = Pattern.compile("\\s*or\\s*");
    static final Pattern AND_SEPARATED = Pattern.compile("\\s*and\\s*");
    static final Pattern COMMA_SEPARATED = Pattern.compile("\\s*,\\s*");
    static final Pattern DOTDOT_SEPARATED = Pattern.compile("\\s*\\Q..\\E\\s*");
    static final Pattern TILDE_SEPARATED = Pattern.compile("\\s*~\\s*");
    static final Pattern SEMI_SEPARATED = Pattern.compile("\\s*;\\s*");

    public static PluralRules parseDescription(String string) throws ParseException {
        return PluralRules.newInternal(string, null);
    }

    public static PluralRules createRules(String string) {
        try {
            return PluralRules.parseDescription(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Deprecated
    public static PluralRules newInternal(String string, StandardPluralRanges standardPluralRanges) throws ParseException {
        return (string = string.trim()).length() == 0 ? DEFAULT : new PluralRules(PluralRules.parseRuleChain(string), standardPluralRanges);
    }

    private static Constraint parseConstraint(String string) throws ParseException {
        Constraint constraint = null;
        String[] stringArray = OR_SEPARATED.split(string, 0);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Constraint constraint2 = null;
            String[] stringArray2 = AND_SEPARATED.split(stringArray[i2], 0);
            for (int i3 = 0; i3 < stringArray2.length; ++i3) {
                Operand operand;
                Constraint constraint3 = NO_CONSTRAINT;
                String string2 = stringArray2[i3].trim();
                String[] stringArray3 = SimpleTokenizer.split(string2);
                int n2 = 0;
                boolean bl2 = true;
                boolean bl3 = true;
                double d2 = 9.223372036854776E18;
                double d3 = -9.223372036854776E18;
                long[] lArray = null;
                int n3 = 0;
                String string3 = stringArray3[n3++];
                boolean bl4 = false;
                try {
                    operand = FixedDecimal.getOperand(string3);
                }
                catch (Exception exception) {
                    throw PluralRules.unexpected(string3, string2);
                }
                if (n3 < stringArray3.length) {
                    if ("mod".equals(string3 = stringArray3[n3++]) || "%".equals(string3)) {
                        n2 = Integer.parseInt(stringArray3[n3++]);
                        string3 = PluralRules.nextToken(stringArray3, n3++, string2);
                    }
                    if ("not".equals(string3)) {
                        bl2 = !bl2;
                        if ("=".equals(string3 = PluralRules.nextToken(stringArray3, n3++, string2))) {
                            throw PluralRules.unexpected(string3, string2);
                        }
                    } else if ("!".equals(string3)) {
                        bl2 = !bl2;
                        if (!"=".equals(string3 = PluralRules.nextToken(stringArray3, n3++, string2))) {
                            throw PluralRules.unexpected(string3, string2);
                        }
                    }
                    if ("is".equals(string3) || "in".equals(string3) || "=".equals(string3)) {
                        bl4 = "is".equals(string3);
                        if (bl4 && !bl2) {
                            throw PluralRules.unexpected(string3, string2);
                        }
                        string3 = PluralRules.nextToken(stringArray3, n3++, string2);
                    } else if ("within".equals(string3)) {
                        bl3 = false;
                        string3 = PluralRules.nextToken(stringArray3, n3++, string2);
                    } else {
                        throw PluralRules.unexpected(string3, string2);
                    }
                    if ("not".equals(string3)) {
                        if (!bl4 && !bl2) {
                            throw PluralRules.unexpected(string3, string2);
                        }
                        bl2 = !bl2;
                        string3 = PluralRules.nextToken(stringArray3, n3++, string2);
                    }
                    ArrayList<Long> arrayList = new ArrayList<Long>();
                    while (true) {
                        long l2;
                        long l3 = l2 = Long.parseLong(string3);
                        if (n3 < stringArray3.length) {
                            if ((string3 = PluralRules.nextToken(stringArray3, n3++, string2)).equals(".")) {
                                if (!(string3 = PluralRules.nextToken(stringArray3, n3++, string2)).equals(".")) {
                                    throw PluralRules.unexpected(string3, string2);
                                }
                                string3 = PluralRules.nextToken(stringArray3, n3++, string2);
                                l3 = Long.parseLong(string3);
                                if (n3 < stringArray3.length && !(string3 = PluralRules.nextToken(stringArray3, n3++, string2)).equals(",")) {
                                    throw PluralRules.unexpected(string3, string2);
                                }
                            } else if (!string3.equals(",")) {
                                throw PluralRules.unexpected(string3, string2);
                            }
                        }
                        if (l2 > l3) {
                            throw PluralRules.unexpected(l2 + "~" + l3, string2);
                        }
                        if (n2 != 0 && l3 >= (long)n2) {
                            throw PluralRules.unexpected(l3 + ">mod=" + n2, string2);
                        }
                        arrayList.add(l2);
                        arrayList.add(l3);
                        d2 = Math.min(d2, (double)l2);
                        d3 = Math.max(d3, (double)l3);
                        if (n3 >= stringArray3.length) break;
                        string3 = PluralRules.nextToken(stringArray3, n3++, string2);
                    }
                    if (string3.equals(",")) {
                        throw PluralRules.unexpected(string3, string2);
                    }
                    if (arrayList.size() == 2) {
                        lArray = null;
                    } else {
                        lArray = new long[arrayList.size()];
                        for (int i4 = 0; i4 < lArray.length; ++i4) {
                            lArray[i4] = (Long)arrayList.get(i4);
                        }
                    }
                    if (d2 != d3 && bl4 && !bl2) {
                        throw PluralRules.unexpected("is not <range>", string2);
                    }
                    constraint3 = new RangeConstraint(n2, bl2, operand, bl3, d2, d3, lArray);
                }
                constraint2 = constraint2 == null ? constraint3 : new AndConstraint(constraint2, constraint3);
            }
            constraint = constraint == null ? constraint2 : new OrConstraint(constraint, constraint2);
        }
        return constraint;
    }

    private static ParseException unexpected(String string, String string2) {
        return new ParseException("unexpected token '" + string + "' in '" + string2 + "'", -1);
    }

    private static String nextToken(String[] stringArray, int n2, String string) throws ParseException {
        if (n2 < stringArray.length) {
            return stringArray[n2];
        }
        throw new ParseException("missing token at end of '" + string + "'", -1);
    }

    private static Rule parseRule(String string) throws ParseException {
        if (string.length() == 0) {
            return DEFAULT_RULE;
        }
        int n2 = (string = string.toLowerCase(Locale.ENGLISH)).indexOf(58);
        if (n2 == -1) {
            throw new ParseException("missing ':' in rule description '" + string + "'", 0);
        }
        String string2 = string.substring(0, n2).trim();
        if (!PluralRules.isValidKeyword(string2)) {
            throw new ParseException("keyword '" + string2 + " is not valid", 0);
        }
        string = string.substring(n2 + 1).trim();
        String[] stringArray = AT_SEPARATED.split(string, 0);
        boolean bl2 = false;
        DecimalQuantitySamples decimalQuantitySamples = null;
        DecimalQuantitySamples decimalQuantitySamples2 = null;
        switch (stringArray.length) {
            case 1: {
                break;
            }
            case 2: {
                decimalQuantitySamples = DecimalQuantitySamples.parse(stringArray[1]);
                if (decimalQuantitySamples.sampleType != SampleType.DECIMAL) break;
                decimalQuantitySamples2 = decimalQuantitySamples;
                decimalQuantitySamples = null;
                break;
            }
            case 3: {
                decimalQuantitySamples = DecimalQuantitySamples.parse(stringArray[1]);
                decimalQuantitySamples2 = DecimalQuantitySamples.parse(stringArray[2]);
                if (decimalQuantitySamples.sampleType == SampleType.INTEGER && decimalQuantitySamples2.sampleType == SampleType.DECIMAL) break;
                throw new IllegalArgumentException("Must have @integer then @decimal in " + string);
            }
            default: {
                throw new IllegalArgumentException("Too many samples in " + string);
            }
        }
        if (bl2) {
            throw new IllegalArgumentException("Ill-formed samples\u2014'@' characters.");
        }
        boolean bl3 = string2.equals(KEYWORD_OTHER);
        if (bl3 != (stringArray[0].length() == 0)) {
            throw new IllegalArgumentException("The keyword 'other' must have no constraints, just samples.");
        }
        Constraint constraint = bl3 ? NO_CONSTRAINT : PluralRules.parseConstraint(stringArray[0]);
        return new Rule(string2, constraint, decimalQuantitySamples, decimalQuantitySamples2);
    }

    private static RuleList parseRuleChain(String string) throws ParseException {
        RuleList ruleList = new RuleList();
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        String[] stringArray = SEMI_SEPARATED.split(string, 0);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            Rule rule = PluralRules.parseRule(stringArray[i2].trim());
            RuleList ruleList2 = ruleList;
            ruleList2.hasExplicitBoundingInfo = ruleList2.hasExplicitBoundingInfo | (rule.integerSamples != null || rule.decimalSamples != null);
            ruleList.addRule(rule);
        }
        return ruleList.finish();
    }

    private static void addRange(StringBuilder stringBuilder, double d2, double d3, boolean bl2) {
        if (bl2) {
            stringBuilder.append(",");
        }
        if (d2 == d3) {
            stringBuilder.append(PluralRules.format(d2));
        } else {
            stringBuilder.append(PluralRules.format(d2) + ".." + PluralRules.format(d3));
        }
    }

    private static String format(double d2) {
        long l2 = (long)d2;
        return d2 == (double)l2 ? String.valueOf(l2) : String.valueOf(d2);
    }

    private boolean addConditional(Set<IFixedDecimal> set, Set<IFixedDecimal> set2, double d2) {
        boolean bl2;
        FixedDecimal fixedDecimal = new FixedDecimal(d2);
        if (!set.contains(fixedDecimal) && !set2.contains(fixedDecimal)) {
            set2.add(fixedDecimal);
            bl2 = true;
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public static PluralRules forLocale(ULocale uLocale) {
        return Factory.getDefaultFactory().forLocale(uLocale, PluralType.CARDINAL);
    }

    public static PluralRules forLocale(Locale locale) {
        return PluralRules.forLocale(ULocale.forLocale(locale));
    }

    public static PluralRules forLocale(ULocale uLocale, PluralType pluralType) {
        return Factory.getDefaultFactory().forLocale(uLocale, pluralType);
    }

    public static PluralRules forLocale(Locale locale, PluralType pluralType) {
        return PluralRules.forLocale(ULocale.forLocale(locale), pluralType);
    }

    private static boolean isValidKeyword(String string) {
        return ALLOWED_ID.containsAll(string);
    }

    private PluralRules(RuleList ruleList, StandardPluralRanges standardPluralRanges) {
        this.rules = ruleList;
        this.keywords = Collections.unmodifiableSet(ruleList.getKeywords());
        this.standardPluralRanges = standardPluralRanges;
    }

    public int hashCode() {
        return this.rules.hashCode();
    }

    public String select(double d2) {
        return this.rules.select(new FixedDecimal(d2));
    }

    public String select(FormattedNumber formattedNumber) {
        return this.rules.select(formattedNumber.getFixedDecimal());
    }

    public String select(FormattedNumberRange formattedNumberRange) {
        if (this.standardPluralRanges == null) {
            throw new UnsupportedOperationException("Plural ranges are unavailable on this instance");
        }
        StandardPlural standardPlural = StandardPlural.fromString(this.select(formattedNumberRange.getFirstFixedDecimal()));
        StandardPlural standardPlural2 = StandardPlural.fromString(this.select(formattedNumberRange.getSecondFixedDecimal()));
        StandardPlural standardPlural3 = this.standardPluralRanges.resolve(standardPlural, standardPlural2);
        return standardPlural3.getKeyword();
    }

    @Deprecated
    public String select(double d2, int n2, long l2) {
        return this.rules.select(new FixedDecimal(d2, n2, l2));
    }

    @Deprecated
    public String select(IFixedDecimal iFixedDecimal) {
        return this.rules.select(iFixedDecimal);
    }

    @Deprecated
    public boolean matches(FixedDecimal fixedDecimal, String string) {
        return this.rules.select(fixedDecimal, string);
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }

    public double getUniqueKeywordValue(String string) {
        DecimalQuantity decimalQuantity = this.getUniqueKeywordDecimalQuantityValue(string);
        if (decimalQuantity.equals(NO_UNIQUE_VALUE_DECIMAL_QUANTITY)) {
            return -0.00123456777;
        }
        return decimalQuantity.toDouble();
    }

    @Deprecated
    public DecimalQuantity getUniqueKeywordDecimalQuantityValue(String string) {
        Collection<DecimalQuantity> collection = this.getAllKeywordDecimalQuantityValues(string);
        if (collection != null && collection.size() == 1) {
            return collection.iterator().next();
        }
        return NO_UNIQUE_VALUE_DECIMAL_QUANTITY;
    }

    public Collection<Double> getAllKeywordValues(String string) {
        Collection<DecimalQuantity> collection = this.getAllKeywordDecimalQuantityValues(string);
        if (collection == null) {
            return null;
        }
        LinkedHashSet<Double> linkedHashSet = new LinkedHashSet<Double>();
        for (DecimalQuantity decimalQuantity : collection) {
            linkedHashSet.add(decimalQuantity.toDouble());
        }
        return linkedHashSet;
    }

    @Deprecated
    public Collection<DecimalQuantity> getAllKeywordDecimalQuantityValues(String string) {
        return this.getAllKeywordValues(string, SampleType.INTEGER);
    }

    @Deprecated
    public Collection<DecimalQuantity> getAllKeywordValues(String string, SampleType sampleType) {
        if (!this.isLimited(string, sampleType)) {
            return null;
        }
        return this.getDecimalQuantitySamples(string, sampleType);
    }

    public Collection<Double> getSamples(String string) {
        return this.getSamples(string, SampleType.INTEGER);
    }

    @Deprecated
    public Collection<DecimalQuantity> getDecimalQuantitySamples(String string) {
        return this.getDecimalQuantitySamples(string, SampleType.INTEGER);
    }

    @Deprecated
    public Collection<Double> getSamples(String string, SampleType sampleType) {
        Collection<DecimalQuantity> collection = this.getDecimalQuantitySamples(string, sampleType);
        if (collection == null) {
            return null;
        }
        LinkedHashSet<Double> linkedHashSet = new LinkedHashSet<Double>();
        for (DecimalQuantity decimalQuantity : collection) {
            linkedHashSet.add(decimalQuantity.toDouble());
        }
        return linkedHashSet;
    }

    @Deprecated
    public Collection<DecimalQuantity> getDecimalQuantitySamples(String string, SampleType sampleType) {
        if (!this.keywords.contains(string)) {
            return null;
        }
        LinkedHashSet<DecimalQuantity> linkedHashSet = new LinkedHashSet<DecimalQuantity>();
        if (this.rules.hasExplicitBoundingInfo) {
            DecimalQuantitySamples decimalQuantitySamples = this.rules.getDecimalSamples(string, sampleType);
            return decimalQuantitySamples == null ? Collections.unmodifiableSet(linkedHashSet) : Collections.unmodifiableCollection(decimalQuantitySamples.addDecimalQuantitySamples(linkedHashSet));
        }
        int n2 = this.isLimited(string, sampleType) ? Integer.MAX_VALUE : 20;
        switch (sampleType) {
            case INTEGER: {
                for (int i2 = 0; i2 < 200 && this.addSample(string, new DecimalQuantity_DualStorageBCD(i2), n2, linkedHashSet); ++i2) {
                }
                this.addSample(string, new DecimalQuantity_DualStorageBCD(1000000), n2, linkedHashSet);
                break;
            }
            case DECIMAL: {
                for (int i3 = 0; i3 < 2000; ++i3) {
                    DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = new DecimalQuantity_DualStorageBCD(i3);
                    decimalQuantity_DualStorageBCD.adjustMagnitude(-1);
                    if (!this.addSample(string, decimalQuantity_DualStorageBCD, n2, linkedHashSet)) break;
                }
                this.addSample(string, DecimalQuantity_DualStorageBCD.fromExponentString("1000000.0"), n2, linkedHashSet);
            }
        }
        return linkedHashSet.size() == 0 ? null : Collections.unmodifiableSet(linkedHashSet);
    }

    private boolean addSample(String string, DecimalQuantity decimalQuantity, int n2, Set<DecimalQuantity> set) {
        String string2 = this.select(decimalQuantity);
        if (string2.equals(string)) {
            set.add(decimalQuantity);
            if (--n2 < 0) {
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public DecimalQuantitySamples getDecimalSamples(String string, SampleType sampleType) {
        return this.rules.getDecimalSamples(string, sampleType);
    }

    public static ULocale[] getAvailableULocales() {
        return Factory.getDefaultFactory().getAvailableULocales();
    }

    public static ULocale getFunctionalEquivalent(ULocale uLocale, boolean[] blArray) {
        return Factory.getDefaultFactory().getFunctionalEquivalent(uLocale, blArray);
    }

    public String toString() {
        return this.rules.toString();
    }

    public boolean equals(Object object) {
        return object instanceof PluralRules && this.equals((PluralRules)object);
    }

    public boolean equals(PluralRules pluralRules) {
        return pluralRules != null && this.toString().equals(pluralRules.toString());
    }

    public KeywordStatus getKeywordStatus(String string, int n2, Set<DecimalQuantity> set, Output<DecimalQuantity> output) {
        return this.getKeywordStatus(string, n2, set, output, SampleType.INTEGER);
    }

    @Deprecated
    public KeywordStatus getKeywordStatus(String string, int n2, Set<DecimalQuantity> set, Output<DecimalQuantity> output, SampleType sampleType) {
        if (output != null) {
            output.value = null;
        }
        if (!this.keywords.contains(string)) {
            return KeywordStatus.INVALID;
        }
        if (!this.isLimited(string, sampleType)) {
            return KeywordStatus.UNBOUNDED;
        }
        Collection<DecimalQuantity> collection = this.getDecimalQuantitySamples(string, sampleType);
        int n3 = collection.size();
        if (set == null) {
            set = Collections.emptySet();
        }
        if (n3 > set.size()) {
            if (n3 == 1) {
                if (output != null) {
                    output.value = collection.iterator().next();
                }
                return KeywordStatus.UNIQUE;
            }
            return KeywordStatus.BOUNDED;
        }
        ArrayList<DecimalQuantity> arrayList = new ArrayList<DecimalQuantity>(collection);
        for (DecimalQuantity decimalQuantity : set) {
            BigDecimal bigDecimal = decimalQuantity.toBigDecimal();
            BigDecimal bigDecimal2 = bigDecimal.subtract(new BigDecimal(n2));
            DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = new DecimalQuantity_DualStorageBCD(bigDecimal2);
            arrayList.remove(decimalQuantity_DualStorageBCD);
        }
        if (arrayList.size() == 0) {
            return KeywordStatus.SUPPRESSED;
        }
        if (output != null && arrayList.size() == 1) {
            output.value = arrayList.iterator().next();
        }
        return n3 == 1 ? KeywordStatus.UNIQUE : KeywordStatus.BOUNDED;
    }

    @Deprecated
    public String getRules(String string) {
        return this.rules.getRules(string);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        throw new NotSerializableException();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new PluralRulesSerialProxy(this.toString());
    }

    @Deprecated
    public int compareTo(PluralRules pluralRules) {
        return this.toString().compareTo(pluralRules.toString());
    }

    Boolean isLimited(String string) {
        return this.rules.isLimited(string, SampleType.INTEGER);
    }

    @Deprecated
    public boolean isLimited(String string, SampleType sampleType) {
        return this.rules.isLimited(string, sampleType);
    }

    @Deprecated
    public boolean computeLimited(String string, SampleType sampleType) {
        return this.rules.computeLimited(string, sampleType);
    }

    public static enum KeywordStatus {
        INVALID,
        SUPPRESSED,
        UNIQUE,
        BOUNDED,
        UNBOUNDED;

    }

    private static class RuleList
    implements Serializable {
        private boolean hasExplicitBoundingInfo = false;
        private static final long serialVersionUID = 1L;
        private final List<Rule> rules = new ArrayList<Rule>();

        private RuleList() {
        }

        public RuleList addRule(Rule rule) {
            String string = rule.getKeyword();
            for (Rule rule2 : this.rules) {
                if (!string.equals(rule2.getKeyword())) continue;
                throw new IllegalArgumentException("Duplicate keyword: " + string);
            }
            this.rules.add(rule);
            return this;
        }

        public RuleList finish() throws ParseException {
            Rule rule = null;
            Iterator<Rule> iterator = this.rules.iterator();
            while (iterator.hasNext()) {
                Rule rule2 = iterator.next();
                if (!PluralRules.KEYWORD_OTHER.equals(rule2.getKeyword())) continue;
                rule = rule2;
                iterator.remove();
            }
            if (rule == null) {
                rule = PluralRules.parseRule("other:");
            }
            this.rules.add(rule);
            return this;
        }

        private Rule selectRule(IFixedDecimal iFixedDecimal) {
            for (Rule rule : this.rules) {
                if (!rule.appliesTo(iFixedDecimal)) continue;
                return rule;
            }
            return null;
        }

        public String select(IFixedDecimal iFixedDecimal) {
            if (iFixedDecimal.isInfinite() || iFixedDecimal.isNaN()) {
                return PluralRules.KEYWORD_OTHER;
            }
            Rule rule = this.selectRule(iFixedDecimal);
            return rule.getKeyword();
        }

        public Set<String> getKeywords() {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (Rule rule : this.rules) {
                linkedHashSet.add(rule.getKeyword());
            }
            return linkedHashSet;
        }

        public boolean isLimited(String string, SampleType sampleType) {
            if (this.hasExplicitBoundingInfo) {
                DecimalQuantitySamples decimalQuantitySamples = this.getDecimalSamples(string, sampleType);
                return decimalQuantitySamples == null ? true : decimalQuantitySamples.bounded;
            }
            return this.computeLimited(string, sampleType);
        }

        public boolean computeLimited(String string, SampleType sampleType) {
            boolean bl2 = false;
            for (Rule rule : this.rules) {
                if (!string.equals(rule.getKeyword())) continue;
                if (!rule.isLimited(sampleType)) {
                    return false;
                }
                bl2 = true;
            }
            return bl2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Rule rule : this.rules) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(PluralRules.CATEGORY_SEPARATOR);
                }
                stringBuilder.append(rule);
            }
            return stringBuilder.toString();
        }

        public String getRules(String string) {
            for (Rule rule : this.rules) {
                if (!rule.getKeyword().equals(string)) continue;
                return rule.getConstraint();
            }
            return null;
        }

        public boolean select(IFixedDecimal iFixedDecimal, String string) {
            for (Rule rule : this.rules) {
                if (!rule.getKeyword().equals(string) || !rule.appliesTo(iFixedDecimal)) continue;
                return true;
            }
            return false;
        }

        public DecimalQuantitySamples getDecimalSamples(String string, SampleType sampleType) {
            for (Rule rule : this.rules) {
                if (!rule.getKeyword().equals(string)) continue;
                return sampleType == SampleType.INTEGER ? rule.integerSamples : rule.decimalSamples;
            }
            return null;
        }
    }

    private static class Rule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String keyword;
        private final Constraint constraint;
        private final DecimalQuantitySamples integerSamples;
        private final DecimalQuantitySamples decimalSamples;

        public Rule(String string, Constraint constraint, DecimalQuantitySamples decimalQuantitySamples, DecimalQuantitySamples decimalQuantitySamples2) {
            this.keyword = string;
            this.constraint = constraint;
            this.integerSamples = decimalQuantitySamples;
            this.decimalSamples = decimalQuantitySamples2;
        }

        public Rule and(Constraint constraint) {
            return new Rule(this.keyword, new AndConstraint(this.constraint, constraint), this.integerSamples, this.decimalSamples);
        }

        public Rule or(Constraint constraint) {
            return new Rule(this.keyword, new OrConstraint(this.constraint, constraint), this.integerSamples, this.decimalSamples);
        }

        public String getKeyword() {
            return this.keyword;
        }

        public boolean appliesTo(IFixedDecimal iFixedDecimal) {
            return this.constraint.isFulfilled(iFixedDecimal);
        }

        public boolean isLimited(SampleType sampleType) {
            return this.constraint.isLimited(sampleType);
        }

        public String toString() {
            return this.keyword + ": " + this.constraint.toString() + (this.integerSamples == null ? "" : " " + this.integerSamples.toString()) + (this.decimalSamples == null ? "" : " " + this.decimalSamples.toString());
        }

        public int hashCode() {
            return this.keyword.hashCode() ^ this.constraint.hashCode();
        }

        public String getConstraint() {
            return this.constraint.toString();
        }
    }

    private static class OrConstraint
    extends BinaryConstraint {
        private static final long serialVersionUID = 1405488568664762222L;

        OrConstraint(Constraint constraint, Constraint constraint2) {
            super(constraint, constraint2);
        }

        @Override
        public boolean isFulfilled(IFixedDecimal iFixedDecimal) {
            return this.a.isFulfilled(iFixedDecimal) || this.b.isFulfilled(iFixedDecimal);
        }

        @Override
        public boolean isLimited(SampleType sampleType) {
            return this.a.isLimited(sampleType) && this.b.isLimited(sampleType);
        }

        public String toString() {
            return this.a.toString() + " or " + this.b.toString();
        }
    }

    private static class AndConstraint
    extends BinaryConstraint {
        private static final long serialVersionUID = 7766999779862263523L;

        AndConstraint(Constraint constraint, Constraint constraint2) {
            super(constraint, constraint2);
        }

        @Override
        public boolean isFulfilled(IFixedDecimal iFixedDecimal) {
            return this.a.isFulfilled(iFixedDecimal) && this.b.isFulfilled(iFixedDecimal);
        }

        @Override
        public boolean isLimited(SampleType sampleType) {
            return this.a.isLimited(sampleType) || this.b.isLimited(sampleType);
        }

        public String toString() {
            return this.a.toString() + " and " + this.b.toString();
        }
    }

    private static abstract class BinaryConstraint
    implements Constraint,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected final Constraint a;
        protected final Constraint b;

        protected BinaryConstraint(Constraint constraint, Constraint constraint2) {
            this.a = constraint;
            this.b = constraint2;
        }
    }

    private static class RangeConstraint
    implements Constraint,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int mod;
        private final boolean inRange;
        private final boolean integersOnly;
        private final double lowerBound;
        private final double upperBound;
        private final long[] range_list;
        private final Operand operand;

        RangeConstraint(int n2, boolean bl2, Operand operand, boolean bl3, double d2, double d3, long[] lArray) {
            this.mod = n2;
            this.inRange = bl2;
            this.integersOnly = bl3;
            this.lowerBound = d2;
            this.upperBound = d3;
            this.range_list = lArray;
            this.operand = operand;
        }

        @Override
        public boolean isFulfilled(IFixedDecimal iFixedDecimal) {
            boolean bl2;
            double d2 = iFixedDecimal.getPluralOperand(this.operand);
            if (this.integersOnly && d2 - (double)((long)d2) != 0.0 || this.operand == Operand.j && iFixedDecimal.getPluralOperand(Operand.v) != 0.0) {
                return !this.inRange;
            }
            if (this.mod != 0) {
                d2 %= (double)this.mod;
            }
            boolean bl3 = bl2 = d2 >= this.lowerBound && d2 <= this.upperBound;
            if (bl2 && this.range_list != null) {
                bl2 = false;
                for (int i2 = 0; !bl2 && i2 < this.range_list.length; i2 += 2) {
                    bl2 = d2 >= (double)this.range_list[i2] && d2 <= (double)this.range_list[i2 + 1];
                }
            }
            return this.inRange == bl2;
        }

        @Override
        public boolean isLimited(SampleType sampleType) {
            boolean bl2 = this.lowerBound == this.upperBound && this.lowerBound == 0.0;
            boolean bl3 = (this.operand == Operand.v || this.operand == Operand.w || this.operand == Operand.f || this.operand == Operand.t) && this.inRange != bl2;
            switch (sampleType) {
                case INTEGER: {
                    return bl3 || (this.operand == Operand.n || this.operand == Operand.i || this.operand == Operand.j) && this.mod == 0 && this.inRange;
                }
                case DECIMAL: {
                    return !(bl3 && this.operand != Operand.n && this.operand != Operand.j || !this.integersOnly && this.lowerBound != this.upperBound || this.mod != 0 || !this.inRange);
                }
            }
            return false;
        }

        public String toString() {
            boolean bl2;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((Object)this.operand);
            if (this.mod != 0) {
                stringBuilder.append(" % ").append(this.mod);
            }
            boolean bl3 = bl2 = this.lowerBound != this.upperBound;
            stringBuilder.append(!bl2 ? (this.inRange ? " = " : " != ") : (this.integersOnly ? (this.inRange ? " = " : " != ") : (this.inRange ? " within " : " not within ")));
            if (this.range_list != null) {
                for (int i2 = 0; i2 < this.range_list.length; i2 += 2) {
                    PluralRules.addRange(stringBuilder, this.range_list[i2], this.range_list[i2 + 1], i2 != 0);
                }
            } else {
                PluralRules.addRange(stringBuilder, this.lowerBound, this.upperBound, false);
            }
            return stringBuilder.toString();
        }
    }

    static class SimpleTokenizer {
        static final UnicodeSet BREAK_AND_IGNORE = new UnicodeSet(9, 10, 12, 13, 32, 32).freeze();
        static final UnicodeSet BREAK_AND_KEEP = new UnicodeSet(33, 33, 37, 37, 44, 44, 46, 46, 61, 61).freeze();

        SimpleTokenizer() {
        }

        static String[] split(String string) {
            int n2 = -1;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (BREAK_AND_IGNORE.contains(c2)) {
                    if (n2 < 0) continue;
                    arrayList.add(string.substring(n2, i2));
                    n2 = -1;
                    continue;
                }
                if (BREAK_AND_KEEP.contains(c2)) {
                    if (n2 >= 0) {
                        arrayList.add(string.substring(n2, i2));
                    }
                    arrayList.add(string.substring(i2, i2 + 1));
                    n2 = -1;
                    continue;
                }
                if (n2 >= 0) continue;
                n2 = i2;
            }
            if (n2 >= 0) {
                arrayList.add(string.substring(n2));
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
    }

    private static interface Constraint
    extends Serializable {
        public boolean isFulfilled(IFixedDecimal var1);

        public boolean isLimited(SampleType var1);
    }

    @Deprecated
    public static class DecimalQuantitySamples {
        @Deprecated
        public final SampleType sampleType;
        @Deprecated
        public final Set<DecimalQuantitySamplesRange> samples;
        @Deprecated
        public final boolean bounded;

        private DecimalQuantitySamples(SampleType sampleType, Set<DecimalQuantitySamplesRange> set, boolean bl2) {
            this.sampleType = sampleType;
            this.samples = set;
            this.bounded = bl2;
        }

        static DecimalQuantitySamples parse(String string) {
            SampleType sampleType;
            boolean bl2 = true;
            boolean bl3 = false;
            LinkedHashSet<DecimalQuantitySamplesRange> linkedHashSet = new LinkedHashSet<DecimalQuantitySamplesRange>();
            if (string.startsWith("integer")) {
                sampleType = SampleType.INTEGER;
            } else if (string.startsWith("decimal")) {
                sampleType = SampleType.DECIMAL;
            } else {
                throw new IllegalArgumentException("Samples must start with 'integer' or 'decimal'");
            }
            string = string.substring(7).trim();
            block4: for (String string2 : COMMA_SEPARATED.split(string, 0)) {
                if (string2.equals("\u2026") || string2.equals("...")) {
                    bl2 = false;
                    bl3 = true;
                    continue;
                }
                if (bl3) {
                    throw new IllegalArgumentException("Can only have \u2026 at the end of samples: " + string2);
                }
                String[] stringArray = TILDE_SEPARATED.split(string2, 0);
                switch (stringArray.length) {
                    case 1: {
                        DecimalQuantity decimalQuantity = DecimalQuantity_DualStorageBCD.fromExponentString(stringArray[0]);
                        DecimalQuantitySamples.checkDecimal(sampleType, decimalQuantity);
                        linkedHashSet.add(new DecimalQuantitySamplesRange(decimalQuantity, decimalQuantity));
                        continue block4;
                    }
                    case 2: {
                        DecimalQuantity decimalQuantity = DecimalQuantity_DualStorageBCD.fromExponentString(stringArray[0]);
                        DecimalQuantity decimalQuantity2 = DecimalQuantity_DualStorageBCD.fromExponentString(stringArray[1]);
                        DecimalQuantitySamples.checkDecimal(sampleType, decimalQuantity);
                        DecimalQuantitySamples.checkDecimal(sampleType, decimalQuantity2);
                        linkedHashSet.add(new DecimalQuantitySamplesRange(decimalQuantity, decimalQuantity2));
                        continue block4;
                    }
                    default: {
                        throw new IllegalArgumentException("Ill-formed number range: " + string2);
                    }
                }
            }
            return new DecimalQuantitySamples(sampleType, Collections.unmodifiableSet(linkedHashSet), bl2);
        }

        private static void checkDecimal(SampleType sampleType, DecimalQuantity decimalQuantity) {
            if (sampleType == SampleType.INTEGER && decimalQuantity.getPluralOperand(Operand.v) != 0.0 || sampleType == SampleType.DECIMAL && decimalQuantity.getPluralOperand(Operand.v) == 0.0 && decimalQuantity.getPluralOperand(Operand.e) == 0.0) {
                throw new IllegalArgumentException("Ill-formed number range: " + decimalQuantity);
            }
        }

        @Deprecated
        public Collection<Double> addSamples(Collection<Double> collection) {
            this.addSamples(collection, null);
            return collection;
        }

        @Deprecated
        public Collection<DecimalQuantity> addDecimalQuantitySamples(Collection<DecimalQuantity> collection) {
            this.addSamples(null, collection);
            return collection;
        }

        @Deprecated
        public void addSamples(Collection<Double> collection, Collection<DecimalQuantity> collection2) {
            if (collection == null && collection2 == null || collection != null && collection2 != null) {
                return;
            }
            boolean bl2 = collection != null;
            for (DecimalQuantitySamplesRange decimalQuantitySamplesRange : this.samples) {
                DecimalQuantity decimalQuantity = decimalQuantitySamplesRange.start;
                DecimalQuantity decimalQuantity2 = decimalQuantitySamplesRange.end;
                int n2 = decimalQuantity.getLowerDisplayMagnitude();
                int n3 = decimalQuantity.getExponent();
                int n4 = n2 + n3;
                BigDecimal bigDecimal = BigDecimal.ONE.movePointRight(n4);
                DecimalQuantity decimalQuantity3 = decimalQuantity.createCopy();
                while (decimalQuantity3.toDouble() <= decimalQuantity2.toDouble()) {
                    if (bl2) {
                        double d2 = decimalQuantity3.toDouble();
                        if (d2 != Math.floor(d2) && decimalQuantity3.getPluralOperand(Operand.v) > 0.0) {
                            collection.add(d2);
                        }
                    } else {
                        collection2.add(decimalQuantity3);
                    }
                    BigDecimal bigDecimal2 = decimalQuantity3.toBigDecimal();
                    BigDecimal bigDecimal3 = bigDecimal2.add(bigDecimal);
                    decimalQuantity3 = new DecimalQuantity_DualStorageBCD(bigDecimal3);
                    decimalQuantity3.setMinFraction(-n2);
                    decimalQuantity3.adjustMagnitude(-n3);
                    decimalQuantity3.adjustExponent(n3);
                }
            }
        }

        @Deprecated
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("@").append(this.sampleType.toString().toLowerCase(Locale.ENGLISH));
            boolean bl2 = true;
            for (DecimalQuantitySamplesRange decimalQuantitySamplesRange : this.samples) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(",");
                }
                stringBuilder.append(' ').append(decimalQuantitySamplesRange);
            }
            if (!this.bounded) {
                stringBuilder.append(", \u2026");
            }
            return stringBuilder.toString();
        }

        @Deprecated
        public Set<DecimalQuantitySamplesRange> getSamples() {
            return this.samples;
        }

        @Deprecated
        public void getStartEndSamples(Set<DecimalQuantity> set) {
            for (DecimalQuantitySamplesRange decimalQuantitySamplesRange : this.samples) {
                set.add(decimalQuantitySamplesRange.start);
                set.add(decimalQuantitySamplesRange.end);
            }
        }
    }

    @Deprecated
    public static class DecimalQuantitySamplesRange {
        @Deprecated
        public final DecimalQuantity start;
        @Deprecated
        public final DecimalQuantity end;

        @Deprecated
        public DecimalQuantitySamplesRange(DecimalQuantity decimalQuantity, DecimalQuantity decimalQuantity2) {
            if (decimalQuantity.getPluralOperand(Operand.v) != decimalQuantity2.getPluralOperand(Operand.v)) {
                throw new IllegalArgumentException("Ranges must have the same number of visible decimals: " + decimalQuantity + "~" + decimalQuantity2);
            }
            this.start = decimalQuantity;
            this.end = decimalQuantity2;
        }

        @Deprecated
        public String toString() {
            return this.start.toExponentString() + (this.end == this.start ? "" : "~" + this.end.toExponentString());
        }
    }

    @Deprecated
    public static enum SampleType {
        INTEGER,
        DECIMAL;

    }

    @Deprecated
    public static class FixedDecimal
    extends Number
    implements IFixedDecimal,
    Comparable<FixedDecimal> {
        private static final long serialVersionUID = -4756200506571685661L;
        final double source;
        final int visibleDecimalDigitCount;
        final int visibleDecimalDigitCountWithoutTrailingZeros;
        final long decimalDigits;
        final long decimalDigitsWithoutTrailingZeros;
        final long integerValue;
        final boolean hasIntegerValue;
        final boolean isNegative;
        final int exponent;
        private final int baseFactor;
        static final long MAX = 1000000000000000000L;
        private static final long MAX_INTEGER_PART = 1000000000L;

        @Deprecated
        public double getSource() {
            return this.source;
        }

        @Deprecated
        public int getVisibleDecimalDigitCount() {
            return this.visibleDecimalDigitCount;
        }

        @Deprecated
        public int getVisibleDecimalDigitCountWithoutTrailingZeros() {
            return this.visibleDecimalDigitCountWithoutTrailingZeros;
        }

        @Deprecated
        public long getDecimalDigits() {
            return this.decimalDigits;
        }

        @Deprecated
        public long getDecimalDigitsWithoutTrailingZeros() {
            return this.decimalDigitsWithoutTrailingZeros;
        }

        @Deprecated
        public long getIntegerValue() {
            return this.integerValue;
        }

        @Override
        @Deprecated
        public boolean isHasIntegerValue() {
            return this.hasIntegerValue;
        }

        @Deprecated
        public boolean isNegative() {
            return this.isNegative;
        }

        @Deprecated
        public int getBaseFactor() {
            return this.baseFactor;
        }

        @Deprecated
        public FixedDecimal(double d2, int n2, long l2, int n3, int n4) {
            this.isNegative = d2 < 0.0;
            this.source = this.isNegative ? -d2 : d2;
            this.visibleDecimalDigitCount = n2;
            this.decimalDigits = l2;
            this.integerValue = d2 > 1.0E18 ? 1000000000000000000L : (long)this.source;
            int n5 = n3;
            if (n5 == 0) {
                n5 = n4;
            }
            this.exponent = n5;
            boolean bl2 = this.hasIntegerValue = this.source == (double)this.integerValue;
            if (l2 == 0L) {
                this.decimalDigitsWithoutTrailingZeros = 0L;
                this.visibleDecimalDigitCountWithoutTrailingZeros = 0;
            } else {
                long l3 = l2;
                int n6 = n2;
                while (l3 % 10L == 0L) {
                    l3 /= 10L;
                    --n6;
                }
                this.decimalDigitsWithoutTrailingZeros = l3;
                this.visibleDecimalDigitCountWithoutTrailingZeros = n6;
            }
            this.baseFactor = (int)Math.pow(10.0, n2);
        }

        @Deprecated
        public FixedDecimal(double d2, int n2, long l2, int n3) {
            this(d2, n2, l2, n3, n3);
        }

        @Deprecated
        public FixedDecimal(double d2, int n2, long l2) {
            this(d2, n2, l2, 0);
        }

        @Deprecated
        public static FixedDecimal createWithExponent(double d2, int n2, int n3) {
            return new FixedDecimal(d2, n2, FixedDecimal.getFractionalDigits(d2, n2), n3);
        }

        @Deprecated
        public FixedDecimal(double d2, int n2) {
            this(d2, n2, FixedDecimal.getFractionalDigits(d2, n2));
        }

        private static int getFractionalDigits(double d2, int n2) {
            if (n2 == 0) {
                return 0;
            }
            if (d2 < 0.0) {
                d2 = -d2;
            }
            int n3 = (int)Math.pow(10.0, n2);
            long l2 = Math.round(d2 * (double)n3);
            return (int)(l2 % (long)n3);
        }

        @Deprecated
        public FixedDecimal(double d2) {
            this(d2, FixedDecimal.decimals(d2));
        }

        @Deprecated
        public FixedDecimal(long l2) {
            this(l2, 0);
        }

        @Deprecated
        public static int decimals(double d2) {
            String string;
            int n2;
            int n3;
            int n4;
            int n5;
            if (Double.isInfinite(d2) || Double.isNaN(d2)) {
                return 0;
            }
            if (d2 < 0.0) {
                d2 = -d2;
            }
            if (d2 == Math.floor(d2)) {
                return 0;
            }
            if (d2 < 1.0E9) {
                long l2 = (long)(d2 * 1000000.0) % 1000000L;
                int n6 = 10;
                for (int i2 = 6; i2 > 0; --i2) {
                    if (l2 % (long)n6 != 0L) {
                        return i2;
                    }
                    n6 *= 10;
                }
                return 0;
            }
            String string2 = String.format(Locale.ENGLISH, "%1.15e", d2);
            if (string2.charAt(n5 = (n4 = string2.lastIndexOf(101)) + 1) == '+') {
                ++n5;
            }
            if ((n3 = n4 - 2 - (n2 = Integer.parseInt(string = string2.substring(n5)))) < 0) {
                return 0;
            }
            int n7 = n4 - 1;
            while (n3 > 0 && string2.charAt(n7) == '0') {
                --n3;
                --n7;
            }
            return n3;
        }

        @Deprecated
        private FixedDecimal(FixedDecimal fixedDecimal) {
            this.source = fixedDecimal.source;
            this.visibleDecimalDigitCount = fixedDecimal.visibleDecimalDigitCount;
            this.visibleDecimalDigitCountWithoutTrailingZeros = fixedDecimal.visibleDecimalDigitCountWithoutTrailingZeros;
            this.decimalDigits = fixedDecimal.decimalDigits;
            this.decimalDigitsWithoutTrailingZeros = fixedDecimal.decimalDigitsWithoutTrailingZeros;
            this.integerValue = fixedDecimal.integerValue;
            this.hasIntegerValue = fixedDecimal.hasIntegerValue;
            this.isNegative = fixedDecimal.isNegative;
            this.exponent = fixedDecimal.exponent;
            this.baseFactor = fixedDecimal.baseFactor;
        }

        @Override
        @Deprecated
        public double getPluralOperand(Operand operand) {
            switch (operand) {
                case n: {
                    return this.exponent == 0 ? this.source : this.source * Math.pow(10.0, this.exponent);
                }
                case i: {
                    return this.intValue();
                }
                case f: {
                    return this.decimalDigits;
                }
                case t: {
                    return this.decimalDigitsWithoutTrailingZeros;
                }
                case v: {
                    return this.visibleDecimalDigitCount;
                }
                case w: {
                    return this.visibleDecimalDigitCountWithoutTrailingZeros;
                }
                case e: {
                    return this.exponent;
                }
                case c: {
                    return this.exponent;
                }
            }
            return this.doubleValue();
        }

        @Deprecated
        public static Operand getOperand(String string) {
            return Operand.valueOf(string);
        }

        @Override
        @Deprecated
        public int compareTo(FixedDecimal fixedDecimal) {
            if (this.exponent != fixedDecimal.exponent) {
                return this.doubleValue() < fixedDecimal.doubleValue() ? -1 : 1;
            }
            if (this.integerValue != fixedDecimal.integerValue) {
                return this.integerValue < fixedDecimal.integerValue ? -1 : 1;
            }
            if (this.source != fixedDecimal.source) {
                return this.source < fixedDecimal.source ? -1 : 1;
            }
            if (this.visibleDecimalDigitCount != fixedDecimal.visibleDecimalDigitCount) {
                return this.visibleDecimalDigitCount < fixedDecimal.visibleDecimalDigitCount ? -1 : 1;
            }
            long l2 = this.decimalDigits - fixedDecimal.decimalDigits;
            if (l2 != 0L) {
                return l2 < 0L ? -1 : 1;
            }
            return 0;
        }

        @Deprecated
        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof FixedDecimal)) {
                return false;
            }
            FixedDecimal fixedDecimal = (FixedDecimal)object;
            return this.source == fixedDecimal.source && this.visibleDecimalDigitCount == fixedDecimal.visibleDecimalDigitCount && this.decimalDigits == fixedDecimal.decimalDigits && this.exponent == fixedDecimal.exponent;
        }

        @Deprecated
        public int hashCode() {
            return (int)(this.decimalDigits + (long)(37 * (this.visibleDecimalDigitCount + (int)(37.0 * this.source))));
        }

        @Deprecated
        public String toString() {
            String string = String.format(Locale.ROOT, "%." + this.visibleDecimalDigitCount + "f", this.source);
            if (this.exponent != 0) {
                return string + "e" + this.exponent;
            }
            return string;
        }

        @Deprecated
        public boolean hasIntegerValue() {
            return this.hasIntegerValue;
        }

        @Override
        @Deprecated
        public int intValue() {
            return (int)this.longValue();
        }

        @Override
        @Deprecated
        public long longValue() {
            if (this.exponent == 0) {
                return this.integerValue;
            }
            return (long)(Math.pow(10.0, this.exponent) * (double)this.integerValue);
        }

        @Override
        @Deprecated
        public float floatValue() {
            return (float)(this.source * Math.pow(10.0, this.exponent));
        }

        @Override
        @Deprecated
        public double doubleValue() {
            return (this.isNegative ? -this.source : this.source) * Math.pow(10.0, this.exponent);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            throw new NotSerializableException();
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            throw new NotSerializableException();
        }

        @Override
        @Deprecated
        public boolean isNaN() {
            return Double.isNaN(this.source);
        }

        @Override
        @Deprecated
        public boolean isInfinite() {
            return Double.isInfinite(this.source);
        }
    }

    @Deprecated
    public static interface IFixedDecimal {
        @Deprecated
        public double getPluralOperand(Operand var1);

        @Deprecated
        public boolean isNaN();

        @Deprecated
        public boolean isInfinite();

        @Deprecated
        public boolean isHasIntegerValue();
    }

    @Deprecated
    public static enum Operand {
        n,
        i,
        f,
        t,
        v,
        w,
        e,
        c,
        j;

    }

    public static enum PluralType {
        CARDINAL,
        ORDINAL;

    }

    @Deprecated
    public static abstract class Factory {
        @Deprecated
        protected Factory() {
        }

        @Deprecated
        public abstract PluralRules forLocale(ULocale var1, PluralType var2);

        @Deprecated
        public final PluralRules forLocale(ULocale uLocale) {
            return this.forLocale(uLocale, PluralType.CARDINAL);
        }

        @Deprecated
        public abstract ULocale[] getAvailableULocales();

        @Deprecated
        public abstract ULocale getFunctionalEquivalent(ULocale var1, boolean[] var2);

        @Deprecated
        public static PluralRulesLoader getDefaultFactory() {
            return PluralRulesLoader.loader;
        }

        @Deprecated
        public abstract boolean hasOverride(ULocale var1);
    }
}

