/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.FormattedNumber;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.LocalizedNumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.MessagePattern;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RbnfLenientScanner;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class PluralFormat
extends UFormat {
    private static final long serialVersionUID = 1L;
    private ULocale ulocale = null;
    private PluralRules pluralRules = null;
    private String pattern = null;
    private transient MessagePattern msgPattern;
    private Map<String, String> parsedValues = null;
    private NumberFormat numberFormat = null;
    private transient double offset = 0.0;
    private transient PluralSelectorAdapter pluralRulesWrapper = new PluralSelectorAdapter();

    public PluralFormat() {
        this.init(null, PluralRules.PluralType.CARDINAL, ULocale.getDefault(ULocale.Category.FORMAT), null);
    }

    public PluralFormat(ULocale uLocale) {
        this.init(null, PluralRules.PluralType.CARDINAL, uLocale, null);
    }

    public PluralFormat(Locale locale) {
        this(ULocale.forLocale(locale));
    }

    public PluralFormat(PluralRules pluralRules) {
        this.init(pluralRules, PluralRules.PluralType.CARDINAL, ULocale.getDefault(ULocale.Category.FORMAT), null);
    }

    public PluralFormat(ULocale uLocale, PluralRules pluralRules) {
        this.init(pluralRules, PluralRules.PluralType.CARDINAL, uLocale, null);
    }

    public PluralFormat(Locale locale, PluralRules pluralRules) {
        this(ULocale.forLocale(locale), pluralRules);
    }

    public PluralFormat(ULocale uLocale, PluralRules.PluralType pluralType) {
        this.init(null, pluralType, uLocale, null);
    }

    public PluralFormat(Locale locale, PluralRules.PluralType pluralType) {
        this(ULocale.forLocale(locale), pluralType);
    }

    public PluralFormat(String string) {
        this.init(null, PluralRules.PluralType.CARDINAL, ULocale.getDefault(ULocale.Category.FORMAT), null);
        this.applyPattern(string);
    }

    public PluralFormat(ULocale uLocale, String string) {
        this.init(null, PluralRules.PluralType.CARDINAL, uLocale, null);
        this.applyPattern(string);
    }

    public PluralFormat(PluralRules pluralRules, String string) {
        this.init(pluralRules, PluralRules.PluralType.CARDINAL, ULocale.getDefault(ULocale.Category.FORMAT), null);
        this.applyPattern(string);
    }

    public PluralFormat(ULocale uLocale, PluralRules pluralRules, String string) {
        this.init(pluralRules, PluralRules.PluralType.CARDINAL, uLocale, null);
        this.applyPattern(string);
    }

    public PluralFormat(ULocale uLocale, PluralRules.PluralType pluralType, String string) {
        this.init(null, pluralType, uLocale, null);
        this.applyPattern(string);
    }

    PluralFormat(ULocale uLocale, PluralRules.PluralType pluralType, String string, NumberFormat numberFormat) {
        this.init(null, pluralType, uLocale, numberFormat);
        this.applyPattern(string);
    }

    private void init(PluralRules pluralRules, PluralRules.PluralType pluralType, ULocale uLocale, NumberFormat numberFormat) {
        this.ulocale = uLocale;
        this.pluralRules = pluralRules == null ? PluralRules.forLocale(this.ulocale, pluralType) : pluralRules;
        this.resetPattern();
        this.numberFormat = numberFormat == null ? NumberFormat.getInstance(this.ulocale) : numberFormat;
    }

    private void resetPattern() {
        this.pattern = null;
        if (this.msgPattern != null) {
            this.msgPattern.clear();
        }
        this.offset = 0.0;
    }

    public void applyPattern(String string) {
        this.pattern = string;
        if (this.msgPattern == null) {
            this.msgPattern = new MessagePattern();
        }
        try {
            this.msgPattern.parsePluralStyle(string);
            this.offset = this.msgPattern.getPluralOffset(0);
        }
        catch (RuntimeException runtimeException) {
            this.resetPattern();
            throw runtimeException;
        }
    }

    public String toPattern() {
        return this.pattern;
    }

    static int findSubMessage(MessagePattern messagePattern, int n2, PluralSelector pluralSelector, Object object, double d2) {
        int n3 = messagePattern.countParts();
        MessagePattern.Part part = messagePattern.getPart(n2);
        double d3 = part.getType().hasNumericValue() ? messagePattern.getNumericValue(part) : 0.0;
        String string = null;
        boolean bl2 = false;
        int n4 = 0;
        do {
            int n5 = ++n2;
            ++n2;
            part = messagePattern.getPart(n5);
            MessagePattern.Part.Type type = part.getType();
            if (type == MessagePattern.Part.Type.ARG_LIMIT) break;
            assert (type == MessagePattern.Part.Type.ARG_SELECTOR);
            if (messagePattern.getPartType(n2).hasNumericValue()) {
                if (d2 == messagePattern.getNumericValue(part = messagePattern.getPart(n2++))) {
                    return n2;
                }
            } else if (!bl2) {
                if (messagePattern.partSubstringMatches(part, "other")) {
                    if (n4 == 0) {
                        n4 = n2;
                        if (string != null && string.equals("other")) {
                            bl2 = true;
                        }
                    }
                } else {
                    if (string == null) {
                        string = pluralSelector.select(object, d2 - d3);
                        if (n4 != 0 && string.equals("other")) {
                            bl2 = true;
                        }
                    }
                    if (!bl2 && messagePattern.partSubstringMatches(part, string)) {
                        n4 = n2;
                        bl2 = true;
                    }
                }
            }
            n2 = messagePattern.getLimitPartIndex(n2);
        } while (++n2 < n3);
        return n4;
    }

    public final String format(double d2) {
        return this.format(d2, d2);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException("'" + object + "' is not a Number");
        }
        Number number = (Number)object;
        stringBuffer.append(this.format(number, number.doubleValue()));
        return stringBuffer;
    }

    private String format(Number number, double d2) {
        PluralRules.IFixedDecimal iFixedDecimal;
        String string;
        CharSequence charSequence;
        if (this.msgPattern == null || this.msgPattern.countParts() == 0) {
            return this.numberFormat.format(number);
        }
        double d3 = d2 - this.offset;
        if (this.numberFormat instanceof DecimalFormat) {
            LocalizedNumberFormatter localizedNumberFormatter = ((DecimalFormat)this.numberFormat).toNumberFormatter();
            charSequence = this.offset == 0.0 ? localizedNumberFormatter.format(number) : localizedNumberFormatter.format(d3);
            string = ((FormattedNumber)charSequence).toString();
            iFixedDecimal = ((FormattedNumber)charSequence).getFixedDecimal();
        } else {
            string = this.offset == 0.0 ? this.numberFormat.format(number) : this.numberFormat.format(d3);
            iFixedDecimal = new PluralRules.FixedDecimal(d3);
        }
        int n2 = PluralFormat.findSubMessage(this.msgPattern, 0, this.pluralRulesWrapper, iFixedDecimal, d2);
        charSequence = null;
        int n3 = this.msgPattern.getPart(n2).getLimit();
        while (true) {
            MessagePattern.Part part = this.msgPattern.getPart(++n2);
            MessagePattern.Part.Type type = part.getType();
            int n4 = part.getIndex();
            if (type == MessagePattern.Part.Type.MSG_LIMIT) {
                if (charSequence == null) {
                    return this.pattern.substring(n3, n4);
                }
                return ((StringBuilder)charSequence).append(this.pattern, n3, n4).toString();
            }
            if (type == MessagePattern.Part.Type.REPLACE_NUMBER || type == MessagePattern.Part.Type.SKIP_SYNTAX && this.msgPattern.jdkAposMode()) {
                if (charSequence == null) {
                    charSequence = new StringBuilder();
                }
                ((StringBuilder)charSequence).append(this.pattern, n3, n4);
                if (type == MessagePattern.Part.Type.REPLACE_NUMBER) {
                    ((StringBuilder)charSequence).append(string);
                }
                n3 = part.getLimit();
                continue;
            }
            if (type != MessagePattern.Part.Type.ARG_START) continue;
            if (charSequence == null) {
                charSequence = new StringBuilder();
            }
            ((StringBuilder)charSequence).append(this.pattern, n3, n4);
            n3 = n4;
            n2 = this.msgPattern.getLimitPartIndex(n2);
            n4 = this.msgPattern.getPart(n2).getLimit();
            MessagePattern.appendReducedApostrophes(this.pattern, n3, n4, (StringBuilder)charSequence);
            n3 = n4;
        }
    }

    public Number parse(String string, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }

    String parseType(String string, RbnfLenientScanner rbnfLenientScanner, FieldPosition fieldPosition) {
        if (this.msgPattern == null || this.msgPattern.countParts() == 0) {
            fieldPosition.setBeginIndex(-1);
            fieldPosition.setEndIndex(-1);
            return null;
        }
        int n2 = 0;
        int n3 = this.msgPattern.countParts();
        int n4 = fieldPosition.getBeginIndex();
        if (n4 < 0) {
            n4 = 0;
        }
        String string2 = null;
        String string3 = null;
        int n5 = -1;
        while (n2 < n3) {
            int n6;
            MessagePattern.Part part;
            MessagePattern.Part part2;
            MessagePattern.Part part3;
            if ((part3 = this.msgPattern.getPart(n2++)).getType() != MessagePattern.Part.Type.ARG_SELECTOR || (part2 = this.msgPattern.getPart(n2++)).getType() != MessagePattern.Part.Type.MSG_START || (part = this.msgPattern.getPart(n2++)).getType() != MessagePattern.Part.Type.MSG_LIMIT) continue;
            String string4 = this.pattern.substring(part2.getLimit(), part.getIndex());
            if (rbnfLenientScanner != null) {
                int n7 = string.indexOf(string4, n4);
                if (n7 >= 0) {
                    n6 = n7;
                } else {
                    int[] nArray = rbnfLenientScanner.findText(string, string4, n4);
                    n6 = nArray[0];
                }
            } else {
                n6 = string.indexOf(string4, n4);
            }
            if (n6 < 0 || n6 < n5 || string3 != null && string4.length() <= string3.length()) continue;
            n5 = n6;
            string3 = string4;
            string2 = this.pattern.substring(part2.getLimit(), part.getIndex());
        }
        if (string2 != null) {
            fieldPosition.setBeginIndex(n5);
            fieldPosition.setEndIndex(n5 + string3.length());
            return string2;
        }
        fieldPosition.setBeginIndex(-1);
        fieldPosition.setEndIndex(-1);
        return null;
    }

    @Deprecated
    public void setLocale(ULocale uLocale) {
        if (uLocale == null) {
            uLocale = ULocale.getDefault(ULocale.Category.FORMAT);
        }
        this.init(null, PluralRules.PluralType.CARDINAL, uLocale, null);
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PluralFormat pluralFormat = (PluralFormat)object;
        return Objects.equals(this.ulocale, pluralFormat.ulocale) && Objects.equals(this.pluralRules, pluralFormat.pluralRules) && Objects.equals(this.msgPattern, pluralFormat.msgPattern) && Objects.equals(this.numberFormat, pluralFormat.numberFormat);
    }

    public boolean equals(PluralFormat pluralFormat) {
        return this.equals((Object)pluralFormat);
    }

    public int hashCode() {
        return this.pluralRules.hashCode() ^ this.parsedValues.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("locale=" + this.ulocale);
        stringBuilder.append(", rules='" + this.pluralRules + "'");
        stringBuilder.append(", pattern='" + this.pattern + "'");
        stringBuilder.append(", format='" + this.numberFormat + "'");
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.pluralRulesWrapper = new PluralSelectorAdapter();
        this.parsedValues = null;
        if (this.pattern != null) {
            this.applyPattern(this.pattern);
        }
    }

    private final class PluralSelectorAdapter
    implements PluralSelector {
        private PluralSelectorAdapter() {
        }

        @Override
        public String select(Object object, double d2) {
            PluralRules.IFixedDecimal iFixedDecimal = (PluralRules.IFixedDecimal)object;
            return PluralFormat.this.pluralRules.select(iFixedDecimal);
        }
    }

    static interface PluralSelector {
        public String select(Object var1, double var2);
    }
}

