/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.text.ParsePosition;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NFRuleSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NFSubstitution;

class NumeratorSubstitution
extends NFSubstitution {
    private final double denominator;
    private final boolean withZeros;

    NumeratorSubstitution(int n2, double d2, NFRuleSet nFRuleSet, String string) {
        super(n2, nFRuleSet, NumeratorSubstitution.fixdesc(string));
        this.denominator = d2;
        this.withZeros = string.endsWith("<<");
    }

    static String fixdesc(String string) {
        return string.endsWith("<<") ? string.substring(0, string.length() - 1) : string;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            NumeratorSubstitution numeratorSubstitution = (NumeratorSubstitution)object;
            return this.denominator == numeratorSubstitution.denominator && this.withZeros == numeratorSubstitution.withZeros;
        }
        return false;
    }

    @Override
    public void doSubstitution(double d2, StringBuilder stringBuilder, int n2, int n3) {
        double d3 = this.transformNumber(d2);
        if (this.withZeros && this.ruleSet != null) {
            long l2 = (long)d3;
            int n4 = stringBuilder.length();
            while (true) {
                long l3;
                l2 *= 10L;
                if (!((double)l3 < this.denominator)) break;
                stringBuilder.insert(n2 + this.pos, ' ');
                this.ruleSet.format(0L, stringBuilder, n2 + this.pos, n3);
            }
            n2 += stringBuilder.length() - n4;
        }
        if (d3 == Math.floor(d3) && this.ruleSet != null) {
            this.ruleSet.format((long)d3, stringBuilder, n2 + this.pos, n3);
        } else if (this.ruleSet != null) {
            this.ruleSet.format(d3, stringBuilder, n2 + this.pos, n3);
        } else {
            stringBuilder.insert(n2 + this.pos, this.numberFormat.format(d3));
        }
    }

    @Override
    public long transformNumber(long l2) {
        return Math.round((double)l2 * this.denominator);
    }

    @Override
    public double transformNumber(double d2) {
        return Math.round(d2 * this.denominator);
    }

    @Override
    public Number doParse(String string, ParsePosition parsePosition, double d2, double d3, boolean bl2, int n2) {
        Object object;
        int n3 = 0;
        if (this.withZeros) {
            object = string;
            ParsePosition parsePosition2 = new ParsePosition(1);
            while (((String)object).length() > 0 && parsePosition2.getIndex() != 0) {
                parsePosition2.setIndex(0);
                this.ruleSet.parse((String)object, parsePosition2, 1.0, n2).intValue();
                if (parsePosition2.getIndex() == 0) break;
                ++n3;
                parsePosition.setIndex(parsePosition.getIndex() + parsePosition2.getIndex());
                object = ((String)object).substring(parsePosition2.getIndex());
                while (((String)object).length() > 0 && ((String)object).charAt(0) == ' ') {
                    object = ((String)object).substring(1);
                    parsePosition.setIndex(parsePosition.getIndex() + 1);
                }
            }
            string = string.substring(parsePosition.getIndex());
            parsePosition.setIndex(0);
        }
        object = super.doParse(string, parsePosition, this.withZeros ? 1.0 : d2, d3, false, n2);
        if (this.withZeros) {
            long l2;
            long l3 = ((Number)object).longValue();
            for (l2 = 1L; l2 <= l3; l2 *= 10L) {
            }
            while (n3 > 0) {
                l2 *= 10L;
                --n3;
            }
            object = (double)l3 / (double)l2;
        }
        return object;
    }

    @Override
    public double composeRuleValue(double d2, double d3) {
        return d2 / d3;
    }

    @Override
    public double calcUpperBound(double d2) {
        return this.denominator;
    }

    @Override
    char tokenChar() {
        return '<';
    }
}

