/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Objects;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NFRule;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RuleBasedNumberFormat;

final class NFRuleSet {
    private final String name;
    private NFRule[] rules;
    final NFRule[] nonNumericalRules = new NFRule[6];
    LinkedList<NFRule> fractionRules;
    static final int NEGATIVE_RULE_INDEX = 0;
    static final int IMPROPER_FRACTION_RULE_INDEX = 1;
    static final int PROPER_FRACTION_RULE_INDEX = 2;
    static final int DEFAULT_RULE_INDEX = 3;
    static final int INFINITY_RULE_INDEX = 4;
    static final int NAN_RULE_INDEX = 5;
    final RuleBasedNumberFormat owner;
    private boolean isFractionRuleSet = false;
    private final boolean isParseable;
    private static final int RECURSION_LIMIT = 64;

    public NFRuleSet(RuleBasedNumberFormat ruleBasedNumberFormat, String[] stringArray, int n2) throws IllegalArgumentException {
        this.owner = ruleBasedNumberFormat;
        String string = stringArray[n2];
        if (string.length() == 0) {
            throw new IllegalArgumentException("Empty rule set description");
        }
        if (string.charAt(0) == '%') {
            int n3 = string.indexOf(58);
            if (n3 == -1) {
                throw new IllegalArgumentException("Rule set name doesn't end in colon");
            }
            String string2 = string.substring(0, n3);
            boolean bl2 = this.isParseable = !string2.endsWith("@noparse");
            if (!this.isParseable) {
                string2 = string2.substring(0, string2.length() - 8);
            }
            this.name = string2;
            while (n3 < string.length() && PatternProps.isWhiteSpace(string.charAt(++n3))) {
            }
            stringArray[n2] = string = string.substring(n3);
        } else {
            this.name = "%default";
            this.isParseable = true;
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Empty rule set description");
        }
    }

    public void parseRules(String string) {
        int n2;
        ArrayList<NFRule> arrayList = new ArrayList<NFRule>();
        NFRule nFRule = null;
        int n3 = 0;
        int n4 = string.length();
        do {
            if ((n2 = string.indexOf(59, n3)) < 0) {
                n2 = n4;
            }
            NFRule.makeRules(string.substring(n3, n2), this, nFRule, this.owner, arrayList);
            if (arrayList.isEmpty()) continue;
            nFRule = (NFRule)arrayList.get(arrayList.size() - 1);
        } while ((n3 = n2 + 1) < n4);
        long l2 = 0L;
        for (NFRule nFRule2 : arrayList) {
            long l3 = nFRule2.getBaseValue();
            if (l3 == 0L) {
                nFRule2.setBaseValue(l2);
            } else {
                if (l3 < l2) {
                    throw new IllegalArgumentException("Rules are not in order, base: " + l3 + " < " + l2);
                }
                l2 = l3;
            }
            if (this.isFractionRuleSet) continue;
            ++l2;
        }
        this.rules = new NFRule[arrayList.size()];
        arrayList.toArray(this.rules);
    }

    void setNonNumericalRule(NFRule nFRule) {
        long l2 = nFRule.getBaseValue();
        if (l2 == -1L) {
            this.nonNumericalRules[0] = nFRule;
        } else if (l2 == -2L) {
            this.setBestFractionRule(1, nFRule, true);
        } else if (l2 == -3L) {
            this.setBestFractionRule(2, nFRule, true);
        } else if (l2 == -4L) {
            this.setBestFractionRule(3, nFRule, true);
        } else if (l2 == -5L) {
            this.nonNumericalRules[4] = nFRule;
        } else if (l2 == -6L) {
            this.nonNumericalRules[5] = nFRule;
        }
    }

    private void setBestFractionRule(int n2, NFRule nFRule, boolean bl2) {
        NFRule nFRule2;
        if (bl2) {
            if (this.fractionRules == null) {
                this.fractionRules = new LinkedList();
            }
            this.fractionRules.add(nFRule);
        }
        if ((nFRule2 = this.nonNumericalRules[n2]) == null) {
            this.nonNumericalRules[n2] = nFRule;
        } else {
            DecimalFormatSymbols decimalFormatSymbols = this.owner.getDecimalFormatSymbols();
            if (decimalFormatSymbols.getDecimalSeparator() == nFRule.getDecimalPoint()) {
                this.nonNumericalRules[n2] = nFRule;
            }
        }
    }

    public void makeIntoFractionRuleSet() {
        this.isFractionRuleSet = true;
    }

    public boolean equals(Object object) {
        int n2;
        if (!(object instanceof NFRuleSet)) {
            return false;
        }
        NFRuleSet nFRuleSet = (NFRuleSet)object;
        if (!this.name.equals(nFRuleSet.name) || this.rules.length != nFRuleSet.rules.length || this.isFractionRuleSet != nFRuleSet.isFractionRuleSet) {
            return false;
        }
        for (n2 = 0; n2 < this.nonNumericalRules.length; ++n2) {
            if (Objects.equals(this.nonNumericalRules[n2], nFRuleSet.nonNumericalRules[n2])) continue;
            return false;
        }
        for (n2 = 0; n2 < this.rules.length; ++n2) {
            if (this.rules[n2].equals(nFRuleSet.rules[n2])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name).append(":\n");
        for (NFRule nFRule : this.rules) {
            stringBuilder.append(nFRule.toString()).append("\n");
        }
        for (NFRule nFRule : this.nonNumericalRules) {
            if (nFRule == null) continue;
            if (nFRule.getBaseValue() == -2L || nFRule.getBaseValue() == -3L || nFRule.getBaseValue() == -4L) {
                for (NFRule nFRule2 : this.fractionRules) {
                    if (nFRule2.getBaseValue() != nFRule.getBaseValue()) continue;
                    stringBuilder.append(nFRule2.toString()).append("\n");
                }
                continue;
            }
            stringBuilder.append(nFRule.toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    public boolean isFractionSet() {
        return this.isFractionRuleSet;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPublic() {
        return !this.name.startsWith("%%");
    }

    public boolean isParseable() {
        return this.isParseable;
    }

    public void format(long l2, StringBuilder stringBuilder, int n2, int n3) {
        if (n3 >= 64) {
            throw new IllegalStateException("Recursion limit exceeded when applying ruleSet " + this.name);
        }
        NFRule nFRule = this.findNormalRule(l2);
        nFRule.doFormat(l2, stringBuilder, n2, ++n3);
    }

    public void format(double d2, StringBuilder stringBuilder, int n2, int n3) {
        if (n3 >= 64) {
            throw new IllegalStateException("Recursion limit exceeded when applying ruleSet " + this.name);
        }
        NFRule nFRule = this.findRule(d2);
        nFRule.doFormat(d2, stringBuilder, n2, ++n3);
    }

    NFRule findRule(double d2) {
        if (this.isFractionRuleSet) {
            return this.findFractionRuleSetRule(d2);
        }
        if (Double.isNaN(d2)) {
            NFRule nFRule = this.nonNumericalRules[5];
            if (nFRule == null) {
                nFRule = this.owner.getDefaultNaNRule();
            }
            return nFRule;
        }
        if (d2 < 0.0) {
            if (this.nonNumericalRules[0] != null) {
                return this.nonNumericalRules[0];
            }
            d2 = -d2;
        }
        if (Double.isInfinite(d2)) {
            NFRule nFRule = this.nonNumericalRules[4];
            if (nFRule == null) {
                nFRule = this.owner.getDefaultInfinityRule();
            }
            return nFRule;
        }
        if (d2 != Math.floor(d2)) {
            if (d2 < 1.0 && this.nonNumericalRules[2] != null) {
                return this.nonNumericalRules[2];
            }
            if (this.nonNumericalRules[1] != null) {
                return this.nonNumericalRules[1];
            }
        }
        if (this.nonNumericalRules[3] != null) {
            return this.nonNumericalRules[3];
        }
        return this.findNormalRule(Math.round(d2));
    }

    private NFRule findNormalRule(long l2) {
        if (this.isFractionRuleSet) {
            return this.findFractionRuleSetRule(l2);
        }
        if (l2 < 0L) {
            if (this.nonNumericalRules[0] != null) {
                return this.nonNumericalRules[0];
            }
            l2 = -l2;
        }
        int n2 = 0;
        int n3 = this.rules.length;
        if (n3 > 0) {
            while (n2 < n3) {
                int n4 = n2 + n3 >>> 1;
                long l3 = this.rules[n4].getBaseValue();
                if (l3 == l2) {
                    return this.rules[n4];
                }
                if (l3 > l2) {
                    n3 = n4;
                    continue;
                }
                n2 = n4 + 1;
            }
            if (n3 == 0) {
                throw new IllegalStateException("The rule set " + this.name + " cannot format the value " + l2);
            }
            NFRule nFRule = this.rules[n3 - 1];
            if (nFRule.shouldRollBack(l2)) {
                if (n3 == 1) {
                    throw new IllegalStateException("The rule set " + this.name + " cannot roll back from the rule '" + nFRule + "'");
                }
                nFRule = this.rules[n3 - 2];
            }
            return nFRule;
        }
        return this.nonNumericalRules[3];
    }

    private NFRule findFractionRuleSetRule(double d2) {
        long l2 = this.rules[0].getBaseValue();
        for (int i2 = 1; i2 < this.rules.length; ++i2) {
            l2 = NFRuleSet.lcm(l2, this.rules[i2].getBaseValue());
        }
        long l3 = Math.round(d2 * (double)l2);
        long l4 = Long.MAX_VALUE;
        int n2 = 0;
        for (int i3 = 0; i3 < this.rules.length; ++i3) {
            long l5 = l3 * this.rules[i3].getBaseValue() % l2;
            if (l2 - l5 < l5) {
                l5 = l2 - l5;
            }
            if (l5 >= l4) continue;
            l4 = l5;
            n2 = i3;
            if (l4 == 0L) break;
        }
        if (n2 + 1 < this.rules.length && this.rules[n2 + 1].getBaseValue() == this.rules[n2].getBaseValue() && (Math.round(d2 * (double)this.rules[n2].getBaseValue()) < 1L || Math.round(d2 * (double)this.rules[n2].getBaseValue()) >= 2L)) {
            ++n2;
        }
        return this.rules[n2];
    }

    private static long lcm(long l2, long l3) {
        long l4 = l2;
        long l5 = l3;
        int n2 = 0;
        while ((l4 & 1L) == 0L && (l5 & 1L) == 0L) {
            ++n2;
            l4 >>= 1;
            l5 >>= 1;
        }
        long l6 = (l4 & 1L) == 1L ? -l5 : l4;
        while (l6 != 0L) {
            while ((l6 & 1L) == 0L) {
                l6 >>= 1;
            }
            if (l6 > 0L) {
                l4 = l6;
            } else {
                l5 = -l6;
            }
            l6 = l4 - l5;
        }
        long l7 = l4 << n2;
        return l2 / l7 * l3;
    }

    public Number parse(String string, ParsePosition parsePosition, double d2, int n2) {
        Number number;
        int n3;
        ParsePosition parsePosition2 = new ParsePosition(0);
        Number number2 = NFRule.ZERO;
        if (string.length() == 0) {
            return number2;
        }
        for (n3 = 0; n3 < this.nonNumericalRules.length; ++n3) {
            NFRule nFRule = this.nonNumericalRules[n3];
            if (nFRule == null || (n2 >> n3 & 1) != 0) continue;
            number = nFRule.doParse(string, parsePosition, false, d2, n2 |= 1 << n3);
            if (parsePosition.getIndex() > parsePosition2.getIndex()) {
                number2 = number;
                parsePosition2.setIndex(parsePosition.getIndex());
            }
            parsePosition.setIndex(0);
        }
        for (n3 = this.rules.length - 1; n3 >= 0 && parsePosition2.getIndex() < string.length(); --n3) {
            if (!this.isFractionRuleSet && (double)this.rules[n3].getBaseValue() >= d2) continue;
            number = this.rules[n3].doParse(string, parsePosition, this.isFractionRuleSet, d2, n2);
            if (parsePosition.getIndex() > parsePosition2.getIndex()) {
                number2 = number;
                parsePosition2.setIndex(parsePosition.getIndex());
            }
            parsePosition.setIndex(0);
        }
        parsePosition.setIndex(parsePosition2.getIndex());
        return number2;
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        for (NFRule nFRule : this.rules) {
            nFRule.setDecimalFormatSymbols(decimalFormatSymbols);
        }
        if (this.fractionRules != null) {
            for (int i2 = 1; i2 <= 3; ++i2) {
                if (this.nonNumericalRules[i2] == null) continue;
                for (NFRule nFRule : this.fractionRules) {
                    if (this.nonNumericalRules[i2].getBaseValue() != nFRule.getBaseValue()) continue;
                    this.setBestFractionRule(i2, nFRule, false);
                }
            }
        }
        for (NFRule nFRule : this.nonNumericalRules) {
            if (nFRule == null) continue;
            nFRule.setDecimalFormatSymbols(decimalFormatSymbols);
        }
    }
}

