/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.CharacterIterator;
import java.text.ChoiceFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DateFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.MessagePattern;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RuleBasedNumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.SelectFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.SimpleDateFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class MessageFormat
extends UFormat {
    static final long serialVersionUID = 7136212545847378652L;
    private transient ULocale ulocale;
    private transient MessagePattern msgPattern;
    private transient Map<Integer, Format> cachedFormatters;
    private transient Set<Integer> customFormatArgStarts;
    private transient DateFormat stockDateFormatter;
    private transient NumberFormat stockNumberFormatter;
    private transient PluralSelectorProvider pluralProvider;
    private transient PluralSelectorProvider ordinalProvider;
    private static final String[] typeList = new String[]{"number", "date", "time", "spellout", "ordinal", "duration"};
    private static final int TYPE_NUMBER = 0;
    private static final int TYPE_DATE = 1;
    private static final int TYPE_TIME = 2;
    private static final int TYPE_SPELLOUT = 3;
    private static final int TYPE_ORDINAL = 4;
    private static final int TYPE_DURATION = 5;
    private static final String[] modifierList = new String[]{"", "currency", "percent", "integer"};
    private static final int MODIFIER_EMPTY = 0;
    private static final int MODIFIER_CURRENCY = 1;
    private static final int MODIFIER_PERCENT = 2;
    private static final int MODIFIER_INTEGER = 3;
    private static final String[] dateModifierList = new String[]{"", "short", "medium", "long", "full"};
    private static final int DATE_MODIFIER_EMPTY = 0;
    private static final int DATE_MODIFIER_SHORT = 1;
    private static final int DATE_MODIFIER_MEDIUM = 2;
    private static final int DATE_MODIFIER_LONG = 3;
    private static final int DATE_MODIFIER_FULL = 4;
    private static final Locale rootLocale = new Locale("");
    private static final char SINGLE_QUOTE = '\'';
    private static final char CURLY_BRACE_LEFT = '{';
    private static final char CURLY_BRACE_RIGHT = '}';
    private static final int STATE_INITIAL = 0;
    private static final int STATE_SINGLE_QUOTE = 1;
    private static final int STATE_IN_QUOTE = 2;
    private static final int STATE_MSG_ELEMENT = 3;

    public MessageFormat(String string) {
        this.ulocale = ULocale.getDefault(ULocale.Category.FORMAT);
        this.applyPattern(string);
    }

    public MessageFormat(String string, Locale locale) {
        this(string, ULocale.forLocale(locale));
    }

    public MessageFormat(String string, ULocale uLocale) {
        this.ulocale = uLocale;
        this.applyPattern(string);
    }

    public void setLocale(Locale locale) {
        this.setLocale(ULocale.forLocale(locale));
    }

    public void setLocale(ULocale uLocale) {
        String string = this.toPattern();
        this.ulocale = uLocale;
        this.stockDateFormatter = null;
        this.stockNumberFormatter = null;
        this.pluralProvider = null;
        this.ordinalProvider = null;
        this.applyPattern(string);
    }

    public Locale getLocale() {
        return this.ulocale.toLocale();
    }

    public ULocale getULocale() {
        return this.ulocale;
    }

    public void applyPattern(String string) {
        try {
            if (this.msgPattern == null) {
                this.msgPattern = new MessagePattern(string);
            } else {
                this.msgPattern.parse(string);
            }
            this.cacheExplicitFormats();
        }
        catch (RuntimeException runtimeException) {
            this.resetPattern();
            throw runtimeException;
        }
    }

    public void applyPattern(String string, MessagePattern.ApostropheMode apostropheMode) {
        if (this.msgPattern == null) {
            this.msgPattern = new MessagePattern(apostropheMode);
        } else if (apostropheMode != this.msgPattern.getApostropheMode()) {
            this.msgPattern.clearPatternAndSetApostropheMode(apostropheMode);
        }
        this.applyPattern(string);
    }

    public MessagePattern.ApostropheMode getApostropheMode() {
        if (this.msgPattern == null) {
            this.msgPattern = new MessagePattern();
        }
        return this.msgPattern.getApostropheMode();
    }

    public String toPattern() {
        if (this.customFormatArgStarts != null) {
            throw new IllegalStateException("toPattern() is not supported after custom Format objects have been set via setFormat() or similar APIs");
        }
        if (this.msgPattern == null) {
            return "";
        }
        String string = this.msgPattern.getPatternString();
        return string == null ? "" : string;
    }

    private int nextTopLevelArgStart(int n2) {
        MessagePattern.Part.Type type;
        if (n2 != 0) {
            n2 = this.msgPattern.getLimitPartIndex(n2);
        }
        do {
            if ((type = this.msgPattern.getPartType(++n2)) != MessagePattern.Part.Type.ARG_START) continue;
            return n2;
        } while (type != MessagePattern.Part.Type.MSG_LIMIT);
        return -1;
    }

    private boolean argNameMatches(int n2, String string, int n3) {
        MessagePattern.Part part = this.msgPattern.getPart(n2);
        return part.getType() == MessagePattern.Part.Type.ARG_NAME ? this.msgPattern.partSubstringMatches(part, string) : part.getValue() == n3;
    }

    private String getArgName(int n2) {
        MessagePattern.Part part = this.msgPattern.getPart(n2);
        if (part.getType() == MessagePattern.Part.Type.ARG_NAME) {
            return this.msgPattern.getSubstring(part);
        }
        return Integer.toString(part.getValue());
    }

    public void setFormatsByArgumentIndex(Format[] formatArray) {
        if (this.msgPattern.hasNamedArguments()) {
            throw new IllegalArgumentException("This method is not available in MessageFormat objects that use alphanumeric argument names.");
        }
        int n2 = 0;
        while ((n2 = this.nextTopLevelArgStart(n2)) >= 0) {
            int n3 = this.msgPattern.getPart(n2 + 1).getValue();
            if (n3 >= formatArray.length) continue;
            this.setCustomArgStartFormat(n2, formatArray[n3]);
        }
    }

    public void setFormatsByArgumentName(Map<String, Format> map) {
        int n2 = 0;
        while ((n2 = this.nextTopLevelArgStart(n2)) >= 0) {
            String string = this.getArgName(n2 + 1);
            if (!map.containsKey(string)) continue;
            this.setCustomArgStartFormat(n2, map.get(string));
        }
    }

    public void setFormats(Format[] formatArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < formatArray.length && (n2 = this.nextTopLevelArgStart(n2)) >= 0; ++i2) {
            this.setCustomArgStartFormat(n2, formatArray[i2]);
        }
    }

    public void setFormatByArgumentIndex(int n2, Format format) {
        if (this.msgPattern.hasNamedArguments()) {
            throw new IllegalArgumentException("This method is not available in MessageFormat objects that use alphanumeric argument names.");
        }
        int n3 = 0;
        while ((n3 = this.nextTopLevelArgStart(n3)) >= 0) {
            if (this.msgPattern.getPart(n3 + 1).getValue() != n2) continue;
            this.setCustomArgStartFormat(n3, format);
        }
    }

    public void setFormatByArgumentName(String string, Format format) {
        int n2 = MessagePattern.validateArgumentName(string);
        if (n2 < -1) {
            return;
        }
        int n3 = 0;
        while ((n3 = this.nextTopLevelArgStart(n3)) >= 0) {
            if (!this.argNameMatches(n3 + 1, string, n2)) continue;
            this.setCustomArgStartFormat(n3, format);
        }
    }

    public void setFormat(int n2, Format format) {
        int n3 = 0;
        int n4 = 0;
        while ((n4 = this.nextTopLevelArgStart(n4)) >= 0) {
            if (n3 == n2) {
                this.setCustomArgStartFormat(n4, format);
                return;
            }
            ++n3;
        }
        throw new ArrayIndexOutOfBoundsException(n2);
    }

    public Format[] getFormatsByArgumentIndex() {
        if (this.msgPattern.hasNamedArguments()) {
            throw new IllegalArgumentException("This method is not available in MessageFormat objects that use alphanumeric argument names.");
        }
        ArrayList<Format> arrayList = new ArrayList<Format>();
        int n2 = 0;
        while ((n2 = this.nextTopLevelArgStart(n2)) >= 0) {
            int n3 = this.msgPattern.getPart(n2 + 1).getValue();
            while (n3 >= arrayList.size()) {
                arrayList.add(null);
            }
            arrayList.set(n3, this.cachedFormatters == null ? null : this.cachedFormatters.get(n2));
        }
        return arrayList.toArray(new Format[arrayList.size()]);
    }

    public Format[] getFormats() {
        ArrayList<Format> arrayList = new ArrayList<Format>();
        int n2 = 0;
        while ((n2 = this.nextTopLevelArgStart(n2)) >= 0) {
            arrayList.add(this.cachedFormatters == null ? null : this.cachedFormatters.get(n2));
        }
        return arrayList.toArray(new Format[arrayList.size()]);
    }

    public Set<String> getArgumentNames() {
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = 0;
        while ((n2 = this.nextTopLevelArgStart(n2)) >= 0) {
            hashSet.add(this.getArgName(n2 + 1));
        }
        return hashSet;
    }

    public Format getFormatByArgumentName(String string) {
        if (this.cachedFormatters == null) {
            return null;
        }
        int n2 = MessagePattern.validateArgumentName(string);
        if (n2 < -1) {
            return null;
        }
        int n3 = 0;
        while ((n3 = this.nextTopLevelArgStart(n3)) >= 0) {
            if (!this.argNameMatches(n3 + 1, string, n2)) continue;
            return this.cachedFormatters.get(n3);
        }
        return null;
    }

    public final StringBuffer format(Object[] objectArray, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.format(objectArray, null, new AppendableWrapper(stringBuffer), fieldPosition);
        return stringBuffer;
    }

    public final StringBuffer format(Map<String, Object> map, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.format(null, map, new AppendableWrapper(stringBuffer), fieldPosition);
        return stringBuffer;
    }

    public static String format(String string, Object ... objectArray) {
        MessageFormat messageFormat = new MessageFormat(string);
        return messageFormat.format(objectArray);
    }

    public static String format(String string, Map<String, Object> map) {
        MessageFormat messageFormat = new MessageFormat(string);
        return messageFormat.format(map);
    }

    public boolean usesNamedArguments() {
        return this.msgPattern.hasNamedArguments();
    }

    @Override
    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.format(object, new AppendableWrapper(stringBuffer), fieldPosition);
        return stringBuffer;
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        if (object == null) {
            throw new NullPointerException("formatToCharacterIterator must be passed non-null object");
        }
        StringBuilder stringBuilder = new StringBuilder();
        AppendableWrapper appendableWrapper = new AppendableWrapper(stringBuilder);
        appendableWrapper.useAttributes();
        this.format(object, appendableWrapper, null);
        AttributedString attributedString = new AttributedString(stringBuilder.toString());
        for (AttributeAndPosition attributeAndPosition : appendableWrapper.attributes) {
            attributedString.addAttribute(attributeAndPosition.key, attributeAndPosition.value, attributeAndPosition.start, attributeAndPosition.limit);
        }
        return attributedString.getIterator();
    }

    public Object[] parse(String string, ParsePosition parsePosition) {
        int n2;
        if (this.msgPattern.hasNamedArguments()) {
            throw new IllegalArgumentException("This method is not available in MessageFormat objects that use named argument.");
        }
        int n3 = -1;
        int n4 = 0;
        while ((n4 = this.nextTopLevelArgStart(n4)) >= 0) {
            n2 = this.msgPattern.getPart(n4 + 1).getValue();
            if (n2 <= n3) continue;
            n3 = n2;
        }
        Object[] objectArray = new Object[n3 + 1];
        n2 = parsePosition.getIndex();
        this.parse(0, string, parsePosition, objectArray, null);
        if (parsePosition.getIndex() == n2) {
            return null;
        }
        return objectArray;
    }

    public Map<String, Object> parseToMap(String string, ParsePosition parsePosition) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n2 = parsePosition.getIndex();
        this.parse(0, string, parsePosition, null, hashMap);
        if (parsePosition.getIndex() == n2) {
            return null;
        }
        return hashMap;
    }

    public Object[] parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Object[] objectArray = this.parse(string, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new ParseException("MessageFormat parse error!", parsePosition.getErrorIndex());
        }
        return objectArray;
    }

    private void parse(int n2, String string, ParsePosition parsePosition, Object[] objectArray, Map<String, Object> map) {
        if (string == null) {
            return;
        }
        String string2 = this.msgPattern.getPatternString();
        int n3 = this.msgPattern.getPart(n2).getLimit();
        int n4 = parsePosition.getIndex();
        ParsePosition parsePosition2 = new ParsePosition(0);
        int n5 = n2 + 1;
        while (true) {
            MessagePattern.Part part = this.msgPattern.getPart(n5);
            MessagePattern.Part.Type type = part.getType();
            int n6 = part.getIndex();
            int n7 = n6 - n3;
            if (n7 == 0 || string2.regionMatches(n3, string, n4, n7)) {
                n4 += n7;
                n3 += n7;
            } else {
                parsePosition.setErrorIndex(n4);
                return;
            }
            if (type == MessagePattern.Part.Type.MSG_LIMIT) {
                parsePosition.setIndex(n4);
                return;
            }
            if (type == MessagePattern.Part.Type.SKIP_SYNTAX || type == MessagePattern.Part.Type.INSERT_CHAR) {
                n3 = part.getLimit();
            } else {
                assert (type == MessagePattern.Part.Type.ARG_START) : "Unexpected Part " + part + " in parsed message.";
                int n8 = this.msgPattern.getLimitPartIndex(n5);
                MessagePattern.ArgType argType = part.getArgType();
                part = this.msgPattern.getPart(++n5);
                Object object = null;
                int n9 = 0;
                String string3 = null;
                if (objectArray != null) {
                    n9 = part.getValue();
                    object = n9;
                } else {
                    string3 = part.getType() == MessagePattern.Part.Type.ARG_NAME ? this.msgPattern.getSubstring(part) : Integer.toString(part.getValue());
                    object = string3;
                }
                Format format = null;
                boolean bl2 = false;
                Object object2 = null;
                if (this.cachedFormatters != null && (format = this.cachedFormatters.get(++n5 - 2)) != null) {
                    parsePosition2.setIndex(n4);
                    object2 = format.parseObject(string, parsePosition2);
                    if (parsePosition2.getIndex() == n4) {
                        parsePosition.setErrorIndex(n4);
                        return;
                    }
                    bl2 = true;
                    n4 = parsePosition2.getIndex();
                } else if (argType == MessagePattern.ArgType.NONE || this.cachedFormatters != null && this.cachedFormatters.containsKey(n5 - 2)) {
                    String string4 = this.getLiteralStringUntilNextArgument(n8);
                    int n10 = string4.length() != 0 ? string.indexOf(string4, n4) : string.length();
                    if (n10 < 0) {
                        parsePosition.setErrorIndex(n4);
                        return;
                    }
                    String string5 = string.substring(n4, n10);
                    if (!string5.equals("{" + object.toString() + "}")) {
                        bl2 = true;
                        object2 = string5;
                    }
                    n4 = n10;
                } else if (argType == MessagePattern.ArgType.CHOICE) {
                    parsePosition2.setIndex(n4);
                    double d2 = MessageFormat.parseChoiceArgument(this.msgPattern, n5, string, parsePosition2);
                    if (parsePosition2.getIndex() == n4) {
                        parsePosition.setErrorIndex(n4);
                        return;
                    }
                    object2 = d2;
                    bl2 = true;
                    n4 = parsePosition2.getIndex();
                } else {
                    if (argType.hasPluralStyle() || argType == MessagePattern.ArgType.SELECT) {
                        throw new UnsupportedOperationException("Parsing of plural/select/selectordinal argument is not supported.");
                    }
                    throw new IllegalStateException("unexpected argType " + (Object)((Object)argType));
                }
                if (bl2) {
                    if (objectArray != null) {
                        objectArray[n9] = object2;
                    } else if (map != null) {
                        map.put(string3, object2);
                    }
                }
                n3 = this.msgPattern.getPart(n8).getLimit();
                n5 = n8;
            }
            ++n5;
        }
    }

    public Map<String, Object> parseToMap(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.parse(0, string, parsePosition, null, hashMap);
        if (parsePosition.getIndex() == 0) {
            throw new ParseException("MessageFormat parse error!", parsePosition.getErrorIndex());
        }
        return hashMap;
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        if (!this.msgPattern.hasNamedArguments()) {
            return this.parse(string, parsePosition);
        }
        return this.parseToMap(string, parsePosition);
    }

    @Override
    public Object clone() {
        MessageFormat messageFormat = (MessageFormat)super.clone();
        if (this.customFormatArgStarts != null) {
            messageFormat.customFormatArgStarts = new HashSet<Integer>();
            for (Integer object : this.customFormatArgStarts) {
                messageFormat.customFormatArgStarts.add(object);
            }
        } else {
            messageFormat.customFormatArgStarts = null;
        }
        if (this.cachedFormatters != null) {
            messageFormat.cachedFormatters = new HashMap<Integer, Format>();
            for (Map.Entry entry : this.cachedFormatters.entrySet()) {
                messageFormat.cachedFormatters.put((Integer)entry.getKey(), (Format)entry.getValue());
            }
        } else {
            messageFormat.cachedFormatters = null;
        }
        messageFormat.msgPattern = this.msgPattern == null ? null : (MessagePattern)this.msgPattern.clone();
        messageFormat.stockDateFormatter = this.stockDateFormatter == null ? null : (DateFormat)this.stockDateFormatter.clone();
        messageFormat.stockNumberFormatter = this.stockNumberFormatter == null ? null : (NumberFormat)this.stockNumberFormatter.clone();
        messageFormat.pluralProvider = null;
        messageFormat.ordinalProvider = null;
        return messageFormat;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MessageFormat messageFormat = (MessageFormat)object;
        return Objects.equals(this.ulocale, messageFormat.ulocale) && Objects.equals(this.msgPattern, messageFormat.msgPattern) && Objects.equals(this.cachedFormatters, messageFormat.cachedFormatters) && Objects.equals(this.customFormatArgStarts, messageFormat.customFormatArgStarts);
    }

    public int hashCode() {
        return this.msgPattern.getPatternString().hashCode();
    }

    private DateFormat getStockDateFormatter() {
        if (this.stockDateFormatter == null) {
            this.stockDateFormatter = DateFormat.getDateTimeInstance(3, 3, this.ulocale);
        }
        return this.stockDateFormatter;
    }

    private NumberFormat getStockNumberFormatter() {
        if (this.stockNumberFormatter == null) {
            this.stockNumberFormatter = NumberFormat.getInstance(this.ulocale);
        }
        return this.stockNumberFormatter;
    }

    private void format(int n2, PluralSelectorContext pluralSelectorContext, Object[] objectArray, Map<String, Object> map, AppendableWrapper appendableWrapper, FieldPosition fieldPosition) {
        String string = this.msgPattern.getPatternString();
        int n3 = this.msgPattern.getPart(n2).getLimit();
        int n4 = n2 + 1;
        while (true) {
            MessagePattern.Part part = this.msgPattern.getPart(n4);
            MessagePattern.Part.Type type = part.getType();
            int n5 = part.getIndex();
            appendableWrapper.append(string, n3, n5);
            if (type == MessagePattern.Part.Type.MSG_LIMIT) {
                return;
            }
            n3 = part.getLimit();
            if (type == MessagePattern.Part.Type.REPLACE_NUMBER) {
                if (pluralSelectorContext.forReplaceNumber) {
                    appendableWrapper.formatAndAppend(pluralSelectorContext.formatter, pluralSelectorContext.number, pluralSelectorContext.numberString);
                } else {
                    appendableWrapper.formatAndAppend(this.getStockNumberFormatter(), pluralSelectorContext.number);
                }
            } else if (type == MessagePattern.Part.Type.ARG_START) {
                Serializable serializable;
                Object object;
                int n6;
                int n7 = this.msgPattern.getLimitPartIndex(n4);
                MessagePattern.ArgType argType = part.getArgType();
                part = this.msgPattern.getPart(++n4);
                boolean bl2 = false;
                Object object2 = null;
                String string2 = this.msgPattern.getSubstring(part);
                if (objectArray != null) {
                    n6 = part.getValue();
                    if (appendableWrapper.attributes != null) {
                        object2 = n6;
                    }
                    if (0 <= n6 && n6 < objectArray.length) {
                        object = objectArray[n6];
                    } else {
                        object = null;
                        bl2 = true;
                    }
                } else {
                    object2 = string2;
                    if (map != null) {
                        object = map.get(string2);
                        if (object == null) {
                            bl2 = !map.containsKey(string2);
                        }
                    } else {
                        object = null;
                        bl2 = true;
                    }
                }
                ++n4;
                n6 = appendableWrapper.length;
                Format format = null;
                if (bl2) {
                    appendableWrapper.append("{");
                    appendableWrapper.append(string2);
                    appendableWrapper.append("}");
                } else if (object == null) {
                    appendableWrapper.append("null");
                } else if (pluralSelectorContext != null && pluralSelectorContext.numberArgIndex == n4 - 2) {
                    if (pluralSelectorContext.offset == 0.0) {
                        appendableWrapper.formatAndAppend(pluralSelectorContext.formatter, pluralSelectorContext.number, pluralSelectorContext.numberString);
                    } else {
                        appendableWrapper.formatAndAppend(pluralSelectorContext.formatter, object);
                    }
                } else if (this.cachedFormatters != null && (format = this.cachedFormatters.get(n4 - 2)) != null) {
                    if (format instanceof ChoiceFormat || format instanceof PluralFormat || format instanceof SelectFormat) {
                        String string3 = format.format(object);
                        if (string3.indexOf(123) >= 0 || string3.indexOf(39) >= 0 && !this.msgPattern.jdkAposMode()) {
                            serializable = new MessageFormat(string3, this.ulocale);
                            super.format(0, null, objectArray, map, appendableWrapper, null);
                        } else if (appendableWrapper.attributes == null) {
                            appendableWrapper.append(string3);
                        } else {
                            appendableWrapper.formatAndAppend(format, object);
                        }
                    } else {
                        appendableWrapper.formatAndAppend(format, object);
                    }
                } else if (argType == MessagePattern.ArgType.NONE || this.cachedFormatters != null && this.cachedFormatters.containsKey(n4 - 2)) {
                    if (object instanceof Number) {
                        appendableWrapper.formatAndAppend(this.getStockNumberFormatter(), object);
                    } else if (object instanceof Date) {
                        appendableWrapper.formatAndAppend(this.getStockDateFormatter(), object);
                    } else {
                        appendableWrapper.append(object.toString());
                    }
                } else if (argType == MessagePattern.ArgType.CHOICE) {
                    if (!(object instanceof Number)) {
                        throw new IllegalArgumentException("'" + object + "' is not a Number");
                    }
                    double d2 = ((Number)object).doubleValue();
                    int n8 = MessageFormat.findChoiceSubMessage(this.msgPattern, n4, d2);
                    this.formatComplexSubMessage(n8, null, objectArray, map, appendableWrapper);
                } else if (argType.hasPluralStyle()) {
                    PluralSelectorProvider pluralSelectorProvider;
                    if (!(object instanceof Number)) {
                        throw new IllegalArgumentException("'" + object + "' is not a Number");
                    }
                    if (argType == MessagePattern.ArgType.PLURAL) {
                        if (this.pluralProvider == null) {
                            this.pluralProvider = new PluralSelectorProvider(this, PluralRules.PluralType.CARDINAL);
                        }
                        pluralSelectorProvider = this.pluralProvider;
                    } else {
                        if (this.ordinalProvider == null) {
                            this.ordinalProvider = new PluralSelectorProvider(this, PluralRules.PluralType.ORDINAL);
                        }
                        pluralSelectorProvider = this.ordinalProvider;
                    }
                    serializable = (Number)object;
                    double d3 = this.msgPattern.getPluralOffset(n4);
                    PluralSelectorContext pluralSelectorContext2 = new PluralSelectorContext(n4, string2, (Number)serializable, d3);
                    int n9 = PluralFormat.findSubMessage(this.msgPattern, n4, pluralSelectorProvider, pluralSelectorContext2, ((Number)serializable).doubleValue());
                    this.formatComplexSubMessage(n9, pluralSelectorContext2, objectArray, map, appendableWrapper);
                } else if (argType == MessagePattern.ArgType.SELECT) {
                    int n10 = SelectFormat.findSubMessage(this.msgPattern, n4, object.toString());
                    this.formatComplexSubMessage(n10, null, objectArray, map, appendableWrapper);
                } else {
                    throw new IllegalStateException("unexpected argType " + (Object)((Object)argType));
                }
                fieldPosition = this.updateMetaData(appendableWrapper, n6, fieldPosition, object2);
                n3 = this.msgPattern.getPart(n7).getLimit();
                n4 = n7;
            }
            ++n4;
        }
    }

    private void formatComplexSubMessage(int n2, PluralSelectorContext pluralSelectorContext, Object[] objectArray, Map<String, Object> map, AppendableWrapper appendableWrapper) {
        String string;
        if (!this.msgPattern.jdkAposMode()) {
            this.format(n2, pluralSelectorContext, objectArray, map, appendableWrapper, null);
            return;
        }
        String string2 = this.msgPattern.getPatternString();
        StringBuilder stringBuilder = null;
        int n3 = this.msgPattern.getPart(n2).getLimit();
        int n4 = n2;
        while (true) {
            MessagePattern.Part part = this.msgPattern.getPart(++n4);
            MessagePattern.Part.Type type = part.getType();
            int n5 = part.getIndex();
            if (type == MessagePattern.Part.Type.MSG_LIMIT) {
                if (stringBuilder == null) {
                    string = string2.substring(n3, n5);
                    break;
                }
                string = stringBuilder.append(string2, n3, n5).toString();
                break;
            }
            if (type == MessagePattern.Part.Type.REPLACE_NUMBER || type == MessagePattern.Part.Type.SKIP_SYNTAX) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                }
                stringBuilder.append(string2, n3, n5);
                if (type == MessagePattern.Part.Type.REPLACE_NUMBER) {
                    if (pluralSelectorContext.forReplaceNumber) {
                        stringBuilder.append(pluralSelectorContext.numberString);
                    } else {
                        stringBuilder.append(this.getStockNumberFormatter().format(pluralSelectorContext.number));
                    }
                }
                n3 = part.getLimit();
                continue;
            }
            if (type != MessagePattern.Part.Type.ARG_START) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(string2, n3, n5);
            n3 = n5;
            n4 = this.msgPattern.getLimitPartIndex(n4);
            n5 = this.msgPattern.getPart(n4).getLimit();
            MessagePattern.appendReducedApostrophes(string2, n3, n5, stringBuilder);
            n3 = n5;
        }
        if (string.indexOf(123) >= 0) {
            MessageFormat messageFormat = new MessageFormat("", this.ulocale);
            messageFormat.applyPattern(string, MessagePattern.ApostropheMode.DOUBLE_REQUIRED);
            messageFormat.format(0, null, objectArray, map, appendableWrapper, null);
        } else {
            appendableWrapper.append(string);
        }
    }

    private String getLiteralStringUntilNextArgument(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.msgPattern.getPatternString();
        int n3 = this.msgPattern.getPart(n2).getLimit();
        int n4 = n2 + 1;
        while (true) {
            MessagePattern.Part part = this.msgPattern.getPart(n4);
            MessagePattern.Part.Type type = part.getType();
            int n5 = part.getIndex();
            stringBuilder.append(string, n3, n5);
            if (type == MessagePattern.Part.Type.ARG_START || type == MessagePattern.Part.Type.MSG_LIMIT) {
                return stringBuilder.toString();
            }
            assert (type == MessagePattern.Part.Type.SKIP_SYNTAX || type == MessagePattern.Part.Type.INSERT_CHAR) : "Unexpected Part " + part + " in parsed message.";
            n3 = part.getLimit();
            ++n4;
        }
    }

    private FieldPosition updateMetaData(AppendableWrapper appendableWrapper, int n2, FieldPosition fieldPosition, Object object) {
        if (appendableWrapper.attributes != null && n2 < appendableWrapper.length) {
            appendableWrapper.attributes.add(new AttributeAndPosition(object, n2, appendableWrapper.length));
        }
        if (fieldPosition != null && Field.ARGUMENT.equals(fieldPosition.getFieldAttribute())) {
            fieldPosition.setBeginIndex(n2);
            fieldPosition.setEndIndex(appendableWrapper.length);
            return null;
        }
        return fieldPosition;
    }

    private static int findChoiceSubMessage(MessagePattern messagePattern, int n2, double d2) {
        int n3;
        double d3;
        int n4;
        char c2;
        int n5 = messagePattern.countParts();
        n2 += 2;
        do {
            MessagePattern.Part part;
            MessagePattern.Part.Type type;
            n3 = n2;
            n2 = messagePattern.getLimitPartIndex(n2);
            if (++n2 >= n5 || (type = (part = messagePattern.getPart(n2++)).getType()) == MessagePattern.Part.Type.ARG_LIMIT) break;
            assert (type.hasNumericValue());
            d3 = messagePattern.getNumericValue(part);
            n4 = messagePattern.getPatternIndex(n2++);
        } while (!((c2 = messagePattern.getPatternString().charAt(n4)) == '<' ? !(d2 > d3) : !(d2 >= d3)));
        return n3;
    }

    private static double parseChoiceArgument(MessagePattern messagePattern, int n2, String string, ParsePosition parsePosition) {
        int n3;
        int n4 = n3 = parsePosition.getIndex();
        double d2 = Double.NaN;
        double d3 = 0.0;
        while (messagePattern.getPartType(n2) != MessagePattern.Part.Type.ARG_LIMIT) {
            int n5;
            int n6;
            int n7;
            d3 = messagePattern.getNumericValue(messagePattern.getPart(n2));
            if ((n7 = MessageFormat.matchStringUntilLimitPart(messagePattern, n2 += 2, n6 = messagePattern.getLimitPartIndex(n2), string, n3)) >= 0 && (n5 = n3 + n7) > n4) {
                n4 = n5;
                d2 = d3;
                if (n4 == string.length()) break;
            }
            n2 = n6 + 1;
        }
        if (n4 == n3) {
            parsePosition.setErrorIndex(n3);
        } else {
            parsePosition.setIndex(n4);
        }
        return d2;
    }

    private static int matchStringUntilLimitPart(MessagePattern messagePattern, int n2, int n3, String string, int n4) {
        int n5 = 0;
        String string2 = messagePattern.getPatternString();
        int n6 = messagePattern.getPart(n2).getLimit();
        while (true) {
            MessagePattern.Part part = messagePattern.getPart(++n2);
            if (n2 != n3 && part.getType() != MessagePattern.Part.Type.SKIP_SYNTAX) continue;
            int n7 = part.getIndex();
            int n8 = n7 - n6;
            if (n8 != 0 && !string.regionMatches(n4, string2, n6, n8)) {
                return -1;
            }
            n5 += n8;
            if (n2 == n3) {
                return n5;
            }
            n6 = part.getLimit();
        }
    }

    private int findOtherSubMessage(int n2) {
        int n3 = this.msgPattern.countParts();
        MessagePattern.Part part = this.msgPattern.getPart(n2);
        if (part.getType().hasNumericValue()) {
            // empty if block
        }
        do {
            int n4 = ++n2;
            ++n2;
            part = this.msgPattern.getPart(n4);
            MessagePattern.Part.Type type = part.getType();
            if (type == MessagePattern.Part.Type.ARG_LIMIT) break;
            assert (type == MessagePattern.Part.Type.ARG_SELECTOR);
            if (this.msgPattern.partSubstringMatches(part, "other")) {
                return n2;
            }
            if (this.msgPattern.getPartType(n2).hasNumericValue()) {
                ++n2;
            }
            n2 = this.msgPattern.getLimitPartIndex(n2);
        } while (++n2 < n3);
        return 0;
    }

    private int findFirstPluralNumberArg(int n2, String string) {
        int n3 = n2 + 1;
        MessagePattern.Part part;
        MessagePattern.Part.Type type;
        while ((type = (part = this.msgPattern.getPart(n3)).getType()) != MessagePattern.Part.Type.MSG_LIMIT) {
            if (type == MessagePattern.Part.Type.REPLACE_NUMBER) {
                return -1;
            }
            if (type == MessagePattern.Part.Type.ARG_START) {
                MessagePattern.ArgType argType = part.getArgType();
                if (string.length() != 0 && (argType == MessagePattern.ArgType.NONE || argType == MessagePattern.ArgType.SIMPLE) && this.msgPattern.partSubstringMatches(part = this.msgPattern.getPart(n3 + 1), string)) {
                    return n3;
                }
                n3 = this.msgPattern.getLimitPartIndex(n3);
            }
            ++n3;
        }
        return 0;
    }

    private void format(Object object, AppendableWrapper appendableWrapper, FieldPosition fieldPosition) {
        if (object == null || object instanceof Map) {
            this.format(null, (Map)object, appendableWrapper, fieldPosition);
        } else {
            this.format((Object[])object, null, appendableWrapper, fieldPosition);
        }
    }

    private void format(Object[] objectArray, Map<String, Object> map, AppendableWrapper appendableWrapper, FieldPosition fieldPosition) {
        if (objectArray != null && this.msgPattern.hasNamedArguments()) {
            throw new IllegalArgumentException("This method is not available in MessageFormat objects that use alphanumeric argument names.");
        }
        this.format(0, null, objectArray, map, appendableWrapper, fieldPosition);
    }

    private void resetPattern() {
        if (this.msgPattern != null) {
            this.msgPattern.clear();
        }
        if (this.cachedFormatters != null) {
            this.cachedFormatters.clear();
        }
        this.customFormatArgStarts = null;
    }

    Format dateTimeFormatForPatternOrSkeleton(String string) {
        int n2 = PatternProps.skipWhiteSpace(string, 0);
        if (string.regionMatches(n2, "::", 0, 2)) {
            return DateFormat.getInstanceForSkeleton(string.substring(n2 + 2), this.ulocale);
        }
        return new SimpleDateFormat(string, this.ulocale);
    }

    private Format createAppropriateFormat(String string, String string2) {
        Format format = null;
        int n2 = MessageFormat.findKeyword(string, typeList);
        block3 : switch (n2) {
            case 0: {
                switch (MessageFormat.findKeyword(string2, modifierList)) {
                    case 0: {
                        format = NumberFormat.getInstance(this.ulocale);
                        break block3;
                    }
                    case 1: {
                        format = NumberFormat.getCurrencyInstance(this.ulocale);
                        break block3;
                    }
                    case 2: {
                        format = NumberFormat.getPercentInstance(this.ulocale);
                        break block3;
                    }
                    case 3: {
                        format = NumberFormat.getIntegerInstance(this.ulocale);
                        break block3;
                    }
                }
                int n3 = PatternProps.skipWhiteSpace(string2, 0);
                if (string2.regionMatches(n3, "::", 0, 2)) {
                    format = NumberFormatter.forSkeleton(string2.substring(n3 + 2)).locale(this.ulocale).toFormat();
                    break;
                }
                format = new DecimalFormat(string2, new DecimalFormatSymbols(this.ulocale));
                break;
            }
            case 1: {
                switch (MessageFormat.findKeyword(string2, dateModifierList)) {
                    case 0: {
                        format = DateFormat.getDateInstance(2, this.ulocale);
                        break block3;
                    }
                    case 1: {
                        format = DateFormat.getDateInstance(3, this.ulocale);
                        break block3;
                    }
                    case 2: {
                        format = DateFormat.getDateInstance(2, this.ulocale);
                        break block3;
                    }
                    case 3: {
                        format = DateFormat.getDateInstance(1, this.ulocale);
                        break block3;
                    }
                    case 4: {
                        format = DateFormat.getDateInstance(0, this.ulocale);
                        break block3;
                    }
                }
                format = this.dateTimeFormatForPatternOrSkeleton(string2);
                break;
            }
            case 2: {
                switch (MessageFormat.findKeyword(string2, dateModifierList)) {
                    case 0: {
                        format = DateFormat.getTimeInstance(2, this.ulocale);
                        break block3;
                    }
                    case 1: {
                        format = DateFormat.getTimeInstance(3, this.ulocale);
                        break block3;
                    }
                    case 2: {
                        format = DateFormat.getTimeInstance(2, this.ulocale);
                        break block3;
                    }
                    case 3: {
                        format = DateFormat.getTimeInstance(1, this.ulocale);
                        break block3;
                    }
                    case 4: {
                        format = DateFormat.getTimeInstance(0, this.ulocale);
                        break block3;
                    }
                }
                format = this.dateTimeFormatForPatternOrSkeleton(string2);
                break;
            }
            case 3: {
                RuleBasedNumberFormat ruleBasedNumberFormat = new RuleBasedNumberFormat(this.ulocale, 1);
                String string3 = string2.trim();
                if (string3.length() != 0) {
                    try {
                        ruleBasedNumberFormat.setDefaultRuleSet(string3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                format = ruleBasedNumberFormat;
                break;
            }
            case 4: {
                RuleBasedNumberFormat ruleBasedNumberFormat = new RuleBasedNumberFormat(this.ulocale, 2);
                String string4 = string2.trim();
                if (string4.length() != 0) {
                    try {
                        ruleBasedNumberFormat.setDefaultRuleSet(string4);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                format = ruleBasedNumberFormat;
                break;
            }
            case 5: {
                RuleBasedNumberFormat ruleBasedNumberFormat = new RuleBasedNumberFormat(this.ulocale, 3);
                String string5 = string2.trim();
                if (string5.length() != 0) {
                    try {
                        ruleBasedNumberFormat.setDefaultRuleSet(string5);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                format = ruleBasedNumberFormat;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown format type \"" + string + "\"");
            }
        }
        return format;
    }

    private static final int findKeyword(String string, String[] stringArray) {
        string = PatternProps.trimWhiteSpace(string).toLowerCase(rootLocale);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!string.equals(stringArray[i2])) continue;
            return i2;
        }
        return -1;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.ulocale.toLanguageTag());
        if (this.msgPattern == null) {
            this.msgPattern = new MessagePattern();
        }
        objectOutputStream.writeObject((Object)this.msgPattern.getApostropheMode());
        objectOutputStream.writeObject(this.msgPattern.getPatternString());
        if (this.customFormatArgStarts == null || this.customFormatArgStarts.isEmpty()) {
            objectOutputStream.writeInt(0);
        } else {
            objectOutputStream.writeInt(this.customFormatArgStarts.size());
            int n2 = 0;
            int n3 = 0;
            while ((n3 = this.nextTopLevelArgStart(n3)) >= 0) {
                if (this.customFormatArgStarts.contains(n3)) {
                    objectOutputStream.writeInt(n2);
                    objectOutputStream.writeObject(this.cachedFormatters.get(n3));
                }
                ++n2;
            }
        }
        objectOutputStream.writeInt(0);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n2;
        String string;
        objectInputStream.defaultReadObject();
        String string2 = (String)objectInputStream.readObject();
        this.ulocale = ULocale.forLanguageTag(string2);
        MessagePattern.ApostropheMode apostropheMode = (MessagePattern.ApostropheMode)((Object)objectInputStream.readObject());
        if (this.msgPattern == null || apostropheMode != this.msgPattern.getApostropheMode()) {
            this.msgPattern = new MessagePattern(apostropheMode);
        }
        if ((string = (String)objectInputStream.readObject()) != null) {
            this.applyPattern(string);
        }
        for (n2 = objectInputStream.readInt(); n2 > 0; --n2) {
            int n3 = objectInputStream.readInt();
            Format format = (Format)objectInputStream.readObject();
            this.setFormat(n3, format);
        }
        for (n2 = objectInputStream.readInt(); n2 > 0; --n2) {
            objectInputStream.readInt();
            objectInputStream.readObject();
        }
    }

    private void cacheExplicitFormats() {
        if (this.cachedFormatters != null) {
            this.cachedFormatters.clear();
        }
        this.customFormatArgStarts = null;
        int n2 = this.msgPattern.countParts() - 2;
        for (int i2 = 1; i2 < n2; ++i2) {
            MessagePattern.ArgType argType;
            MessagePattern.Part part = this.msgPattern.getPart(i2);
            if (part.getType() != MessagePattern.Part.Type.ARG_START || (argType = part.getArgType()) != MessagePattern.ArgType.SIMPLE) continue;
            int n3 = i2;
            i2 += 2;
            String string = this.msgPattern.getSubstring(this.msgPattern.getPart(i2++));
            String string2 = "";
            part = this.msgPattern.getPart(i2);
            if (part.getType() == MessagePattern.Part.Type.ARG_STYLE) {
                string2 = this.msgPattern.getSubstring(part);
                ++i2;
            }
            Format format = this.createAppropriateFormat(string, string2);
            this.setArgStartFormat(n3, format);
        }
    }

    private void setArgStartFormat(int n2, Format format) {
        if (this.cachedFormatters == null) {
            this.cachedFormatters = new HashMap<Integer, Format>();
        }
        this.cachedFormatters.put(n2, format);
    }

    private void setCustomArgStartFormat(int n2, Format format) {
        this.setArgStartFormat(n2, format);
        if (this.customFormatArgStarts == null) {
            this.customFormatArgStarts = new HashSet<Integer>();
        }
        this.customFormatArgStarts.add(n2);
    }

    public static String autoQuoteApostrophe(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        for (int i2 = 0; i2 < n4; ++i2) {
            char c2 = string.charAt(i2);
            block0 : switch (n2) {
                case 0: {
                    switch (c2) {
                        case '\'': {
                            n2 = 1;
                            break;
                        }
                        case '{': {
                            n2 = 3;
                            ++n3;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c2) {
                        case '\'': {
                            n2 = 0;
                            break block0;
                        }
                        case '{': 
                        case '}': {
                            n2 = 2;
                            break block0;
                        }
                    }
                    stringBuilder.append('\'');
                    n2 = 0;
                    break;
                }
                case 2: {
                    switch (c2) {
                        case '\'': {
                            n2 = 0;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (c2) {
                        case '{': {
                            ++n3;
                            break;
                        }
                        case '}': {
                            if (--n3 != 0) break;
                            n2 = 0;
                        }
                    }
                    break;
                }
            }
            stringBuilder.append(c2);
        }
        if (n2 == 1 || n2 == 2) {
            stringBuilder.append('\'');
        }
        return new String(stringBuilder);
    }

    private static final class AttributeAndPosition {
        private AttributedCharacterIterator.Attribute key;
        private Object value;
        private int start;
        private int limit;

        public AttributeAndPosition(Object object, int n2, int n3) {
            this.init(Field.ARGUMENT, object, n2, n3);
        }

        public AttributeAndPosition(AttributedCharacterIterator.Attribute attribute, Object object, int n2, int n3) {
            this.init(attribute, object, n2, n3);
        }

        public void init(AttributedCharacterIterator.Attribute attribute, Object object, int n2, int n3) {
            this.key = attribute;
            this.value = object;
            this.start = n2;
            this.limit = n3;
        }
    }

    private static final class AppendableWrapper {
        private Appendable app;
        private int length;
        private List<AttributeAndPosition> attributes;

        public AppendableWrapper(StringBuilder stringBuilder) {
            this.app = stringBuilder;
            this.length = stringBuilder.length();
            this.attributes = null;
        }

        public AppendableWrapper(StringBuffer stringBuffer) {
            this.app = stringBuffer;
            this.length = stringBuffer.length();
            this.attributes = null;
        }

        public void useAttributes() {
            this.attributes = new ArrayList<AttributeAndPosition>();
        }

        public void append(CharSequence charSequence) {
            try {
                this.app.append(charSequence);
                this.length += charSequence.length();
            }
            catch (IOException iOException) {
                throw new ICUUncheckedIOException(iOException);
            }
        }

        public void append(CharSequence charSequence, int n2, int n3) {
            try {
                this.app.append(charSequence, n2, n3);
                this.length += n3 - n2;
            }
            catch (IOException iOException) {
                throw new ICUUncheckedIOException(iOException);
            }
        }

        public void append(CharacterIterator characterIterator) {
            this.length += AppendableWrapper.append(this.app, characterIterator);
        }

        public static int append(Appendable appendable, CharacterIterator characterIterator) {
            try {
                int n2 = characterIterator.getBeginIndex();
                int n3 = characterIterator.getEndIndex();
                int n4 = n3 - n2;
                if (n2 < n3) {
                    appendable.append(characterIterator.first());
                    while (++n2 < n3) {
                        appendable.append(characterIterator.next());
                    }
                }
                return n4;
            }
            catch (IOException iOException) {
                throw new ICUUncheckedIOException(iOException);
            }
        }

        public void formatAndAppend(Format format, Object object) {
            if (this.attributes == null) {
                this.append(format.format(object));
            } else {
                AttributedCharacterIterator attributedCharacterIterator = format.formatToCharacterIterator(object);
                int n2 = this.length;
                this.append(attributedCharacterIterator);
                attributedCharacterIterator.first();
                int n3 = attributedCharacterIterator.getIndex();
                int n4 = attributedCharacterIterator.getEndIndex();
                int n5 = n2 - n3;
                while (n3 < n4) {
                    Map<AttributedCharacterIterator.Attribute, Object> map = attributedCharacterIterator.getAttributes();
                    int n6 = attributedCharacterIterator.getRunLimit();
                    if (map.size() != 0) {
                        for (Map.Entry<AttributedCharacterIterator.Attribute, Object> entry : map.entrySet()) {
                            this.attributes.add(new AttributeAndPosition(entry.getKey(), entry.getValue(), n5 + n3, n5 + n6));
                        }
                    }
                    n3 = n6;
                    attributedCharacterIterator.setIndex(n3);
                }
            }
        }

        public void formatAndAppend(Format format, Object object, String string) {
            if (this.attributes == null && string != null) {
                this.append(string);
            } else {
                this.formatAndAppend(format, object);
            }
        }
    }

    private static final class PluralSelectorProvider
    implements PluralFormat.PluralSelector {
        private MessageFormat msgFormat;
        private PluralRules rules;
        private PluralRules.PluralType type;

        public PluralSelectorProvider(MessageFormat messageFormat, PluralRules.PluralType pluralType) {
            this.msgFormat = messageFormat;
            this.type = pluralType;
        }

        @Override
        public String select(Object object, double d2) {
            if (this.rules == null) {
                this.rules = PluralRules.forLocale(this.msgFormat.ulocale, this.type);
            }
            PluralSelectorContext pluralSelectorContext = (PluralSelectorContext)object;
            int n2 = this.msgFormat.findOtherSubMessage(pluralSelectorContext.startIndex);
            pluralSelectorContext.numberArgIndex = this.msgFormat.findFirstPluralNumberArg(n2, pluralSelectorContext.argName);
            if (pluralSelectorContext.numberArgIndex > 0 && this.msgFormat.cachedFormatters != null) {
                pluralSelectorContext.formatter = (Format)this.msgFormat.cachedFormatters.get(pluralSelectorContext.numberArgIndex);
            }
            if (pluralSelectorContext.formatter == null) {
                pluralSelectorContext.formatter = this.msgFormat.getStockNumberFormatter();
                pluralSelectorContext.forReplaceNumber = true;
            }
            assert (pluralSelectorContext.number.doubleValue() == d2);
            pluralSelectorContext.numberString = pluralSelectorContext.formatter.format(pluralSelectorContext.number);
            if (pluralSelectorContext.formatter instanceof DecimalFormat) {
                PluralRules.IFixedDecimal iFixedDecimal = ((DecimalFormat)pluralSelectorContext.formatter).getFixedDecimal(d2);
                return this.rules.select(iFixedDecimal);
            }
            return this.rules.select(d2);
        }
    }

    private static final class PluralSelectorContext {
        int startIndex;
        String argName;
        Number number;
        double offset;
        int numberArgIndex;
        Format formatter;
        String numberString;
        boolean forReplaceNumber;

        private PluralSelectorContext(int n2, String string, Number number, double d2) {
            this.startIndex = n2;
            this.argName = string;
            this.number = d2 == 0.0 ? (Number)number : (Number)(number.doubleValue() - d2);
            this.offset = d2;
        }

        public String toString() {
            throw new AssertionError((Object)"PluralSelectorContext being formatted, rather than its number");
        }
    }

    public static class Field
    extends Format.Field {
        private static final long serialVersionUID = 7510380454602616157L;
        public static final Field ARGUMENT = new Field("message argument field");

        protected Field(String string) {
            super(string);
        }

        @Override
        protected Object readResolve() throws InvalidObjectException {
            if (this.getClass() != Field.class) {
                throw new InvalidObjectException("A subclass of MessageFormat.Field must implement readResolve.");
            }
            if (this.getName().equals(ARGUMENT.getName())) {
                return ARGUMENT;
            }
            throw new InvalidObjectException("Unknown attribute name.");
        }
    }
}

