/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.math.RoundingMode;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.DontCareFieldPosition;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedStringBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedValueStringBuilderImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleFormatterImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.LongNameHandler;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.RoundingUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.IntegerWidth;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.LocalizedNumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Precision;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CurrencyFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.ListFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberingSystem;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.TimeUnitFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Currency;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Measure;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MeasureUnit;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public class MeasureFormat
extends UFormat {
    static final long serialVersionUID = -7182021401701778240L;
    private final transient FormatWidth formatWidth;
    private final transient PluralRules rules;
    private final transient NumericFormatters numericFormatters;
    private final transient NumberFormat numberFormat;
    private final transient LocalizedNumberFormatter numberFormatter;
    private static final SimpleCache<ULocale, NumericFormatters> localeToNumericDurationFormatters = new SimpleCache();
    private static final Map<MeasureUnit, Integer> hmsTo012 = new HashMap<MeasureUnit, Integer>();
    private static final int MEASURE_FORMAT = 0;
    private static final int TIME_UNIT_FORMAT = 1;
    private static final int CURRENCY_FORMAT = 2;
    static final int NUMBER_FORMATTER_STANDARD = 1;
    static final int NUMBER_FORMATTER_CURRENCY = 2;
    static final int NUMBER_FORMATTER_INTEGER = 3;
    private transient NumberFormatterCacheEntry formatter1 = null;
    private transient NumberFormatterCacheEntry formatter2 = null;
    private transient NumberFormatterCacheEntry formatter3 = null;
    private static final Map<ULocale, String> localeIdToRangeFormat;

    public static MeasureFormat getInstance(ULocale uLocale, FormatWidth formatWidth) {
        return MeasureFormat.getInstance(uLocale, formatWidth, NumberFormat.getInstance(uLocale));
    }

    public static MeasureFormat getInstance(Locale locale, FormatWidth formatWidth) {
        return MeasureFormat.getInstance(ULocale.forLocale(locale), formatWidth);
    }

    public static MeasureFormat getInstance(ULocale uLocale, FormatWidth formatWidth, NumberFormat numberFormat) {
        return new MeasureFormat(uLocale, formatWidth, numberFormat, null, null);
    }

    public static MeasureFormat getInstance(Locale locale, FormatWidth formatWidth, NumberFormat numberFormat) {
        return MeasureFormat.getInstance(ULocale.forLocale(locale), formatWidth, numberFormat);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n2 = stringBuffer.length();
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            Measure[] measureArray = new Measure[collection.size()];
            int n3 = 0;
            for (Object e2 : collection) {
                if (!(e2 instanceof Measure)) {
                    throw new IllegalArgumentException(object.toString());
                }
                measureArray[n3++] = (Measure)e2;
            }
            this.formatMeasuresInternal(stringBuffer, fieldPosition, measureArray);
        } else if (object instanceof Measure[]) {
            this.formatMeasuresInternal(stringBuffer, fieldPosition, (Measure[])object);
        } else if (object instanceof Measure) {
            FormattedStringBuilder formattedStringBuilder = this.formatMeasure((Measure)object);
            FormattedValueStringBuilderImpl.nextFieldPosition(formattedStringBuilder, fieldPosition);
            Utility.appendTo(formattedStringBuilder, stringBuffer);
        } else {
            throw new IllegalArgumentException(object.toString());
        }
        if (n2 > 0 && fieldPosition.getEndIndex() != 0) {
            fieldPosition.setBeginIndex(fieldPosition.getBeginIndex() + n2);
            fieldPosition.setEndIndex(fieldPosition.getEndIndex() + n2);
        }
        return stringBuffer;
    }

    @Override
    public Measure parseObject(String string, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }

    public final String formatMeasures(Measure ... measureArray) {
        return this.formatMeasures(new StringBuilder(), DontCareFieldPosition.INSTANCE, measureArray).toString();
    }

    public StringBuilder formatMeasurePerUnit(Measure measure, MeasureUnit measureUnit, StringBuilder stringBuilder, FieldPosition fieldPosition) {
        DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = new DecimalQuantity_DualStorageBCD(measure.getNumber());
        FormattedStringBuilder formattedStringBuilder = new FormattedStringBuilder();
        this.getUnitFormatterFromCache(1, measure.getUnit(), measureUnit).formatImpl(decimalQuantity_DualStorageBCD, formattedStringBuilder);
        DecimalFormat.fieldPositionHelper(decimalQuantity_DualStorageBCD, formattedStringBuilder, fieldPosition, stringBuilder.length());
        Utility.appendTo(formattedStringBuilder, stringBuilder);
        return stringBuilder;
    }

    public StringBuilder formatMeasures(StringBuilder stringBuilder, FieldPosition fieldPosition, Measure ... measureArray) {
        int n2 = stringBuilder.length();
        this.formatMeasuresInternal(stringBuilder, fieldPosition, measureArray);
        if (n2 > 0 && fieldPosition.getEndIndex() > 0) {
            fieldPosition.setBeginIndex(fieldPosition.getBeginIndex() + n2);
            fieldPosition.setEndIndex(fieldPosition.getEndIndex() + n2);
        }
        return stringBuilder;
    }

    private void formatMeasuresInternal(Appendable appendable, FieldPosition fieldPosition, Measure ... measureArray) {
        Object object;
        if (measureArray.length == 0) {
            return;
        }
        if (measureArray.length == 1) {
            FormattedStringBuilder formattedStringBuilder = this.formatMeasure(measureArray[0]);
            FormattedValueStringBuilderImpl.nextFieldPosition(formattedStringBuilder, fieldPosition);
            Utility.appendTo(formattedStringBuilder, appendable);
            return;
        }
        if (this.formatWidth == FormatWidth.NUMERIC && (object = MeasureFormat.toHMS(measureArray)) != null) {
            this.formatNumeric((Number[])object, appendable);
            return;
        }
        object = ListFormatter.getInstance(this.getLocale(), ListFormatter.Type.UNITS, this.formatWidth.listWidth);
        if (fieldPosition != DontCareFieldPosition.INSTANCE) {
            this.formatMeasuresSlowTrack((ListFormatter)object, appendable, fieldPosition, measureArray);
            return;
        }
        String[] stringArray = new String[measureArray.length];
        for (int i2 = 0; i2 < measureArray.length; ++i2) {
            stringArray[i2] = i2 == measureArray.length - 1 ? this.formatMeasure(measureArray[i2]).toString() : this.formatMeasureInteger(measureArray[i2]).toString();
        }
        ListFormatter.FormattedListBuilder formattedListBuilder = ((ListFormatter)object).formatImpl(Arrays.asList(stringArray), false);
        formattedListBuilder.appendTo(appendable);
    }

    public String getUnitDisplayName(MeasureUnit measureUnit) {
        return LongNameHandler.getUnitDisplayName(this.getLocale(), measureUnit, this.formatWidth.unitWidth);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MeasureFormat)) {
            return false;
        }
        MeasureFormat measureFormat = (MeasureFormat)object;
        return this.getWidth() == measureFormat.getWidth() && this.getLocale().equals(measureFormat.getLocale()) && this.getNumberFormatInternal().equals(measureFormat.getNumberFormatInternal());
    }

    public final int hashCode() {
        return (this.getLocale().hashCode() * 31 + this.getNumberFormatInternal().hashCode()) * 31 + this.getWidth().hashCode();
    }

    public FormatWidth getWidth() {
        if (this.formatWidth == FormatWidth.DEFAULT_CURRENCY) {
            return FormatWidth.WIDE;
        }
        return this.formatWidth;
    }

    public final ULocale getLocale() {
        return this.getLocale(ULocale.VALID_LOCALE);
    }

    public NumberFormat getNumberFormat() {
        return (NumberFormat)this.numberFormat.clone();
    }

    NumberFormat getNumberFormatInternal() {
        return this.numberFormat;
    }

    public static MeasureFormat getCurrencyFormat(ULocale uLocale) {
        return new CurrencyFormat(uLocale);
    }

    public static MeasureFormat getCurrencyFormat(Locale locale) {
        return MeasureFormat.getCurrencyFormat(ULocale.forLocale(locale));
    }

    public static MeasureFormat getCurrencyFormat() {
        return MeasureFormat.getCurrencyFormat(ULocale.getDefault(ULocale.Category.FORMAT));
    }

    MeasureFormat withLocale(ULocale uLocale) {
        return MeasureFormat.getInstance(uLocale, this.getWidth());
    }

    MeasureFormat withNumberFormat(NumberFormat numberFormat) {
        return new MeasureFormat(this.getLocale(), this.formatWidth, numberFormat, this.rules, this.numericFormatters);
    }

    MeasureFormat(ULocale uLocale, FormatWidth formatWidth) {
        this(uLocale, formatWidth, null, null, null);
    }

    private MeasureFormat(ULocale uLocale, FormatWidth formatWidth, NumberFormat numberFormat, PluralRules pluralRules, NumericFormatters numericFormatters) {
        this.setLocale(uLocale, uLocale);
        this.formatWidth = formatWidth;
        if (pluralRules == null) {
            pluralRules = PluralRules.forLocale(uLocale);
        }
        this.rules = pluralRules;
        numberFormat = numberFormat == null ? NumberFormat.getInstance(uLocale) : (NumberFormat)numberFormat.clone();
        this.numberFormat = numberFormat;
        if (numericFormatters == null && formatWidth == FormatWidth.NUMERIC && (numericFormatters = localeToNumericDurationFormatters.get(uLocale)) == null) {
            numericFormatters = MeasureFormat.loadNumericFormatters(uLocale);
            localeToNumericDurationFormatters.put(uLocale, numericFormatters);
        }
        this.numericFormatters = numericFormatters;
        if (!(numberFormat instanceof DecimalFormat)) {
            throw new IllegalArgumentException();
        }
        this.numberFormatter = (LocalizedNumberFormatter)((DecimalFormat)numberFormat).toNumberFormatter().unitWidth(formatWidth.unitWidth);
    }

    MeasureFormat(ULocale uLocale, FormatWidth formatWidth, NumberFormat numberFormat, PluralRules pluralRules) {
        this(uLocale, formatWidth, numberFormat, pluralRules, null);
        if (formatWidth == FormatWidth.NUMERIC) {
            throw new IllegalArgumentException("The format width 'numeric' is not allowed by this constructor");
        }
    }

    private static NumericFormatters loadNumericFormatters(ULocale uLocale) {
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/unit", uLocale);
        return new NumericFormatters(MeasureFormat.loadNumericDurationFormat(iCUResourceBundle, "hm"), MeasureFormat.loadNumericDurationFormat(iCUResourceBundle, "ms"), MeasureFormat.loadNumericDurationFormat(iCUResourceBundle, "hms"));
    }

    private synchronized LocalizedNumberFormatter getUnitFormatterFromCache(int n2, MeasureUnit measureUnit, MeasureUnit measureUnit2) {
        LocalizedNumberFormatter localizedNumberFormatter;
        if (this.formatter1 != null) {
            if (this.formatter1.type == n2 && this.formatter1.unit == measureUnit && this.formatter1.perUnit == measureUnit2) {
                return this.formatter1.formatter;
            }
            if (this.formatter2 != null) {
                if (this.formatter2.type == n2 && this.formatter2.unit == measureUnit && this.formatter2.perUnit == measureUnit2) {
                    return this.formatter2.formatter;
                }
                if (this.formatter3 != null && this.formatter3.type == n2 && this.formatter3.unit == measureUnit && this.formatter3.perUnit == measureUnit2) {
                    return this.formatter3.formatter;
                }
            }
        }
        if (n2 == 1) {
            localizedNumberFormatter = (LocalizedNumberFormatter)((LocalizedNumberFormatter)((LocalizedNumberFormatter)this.getNumberFormatter().unit(measureUnit)).perUnit(measureUnit2)).unitWidth(this.formatWidth.unitWidth);
        } else if (n2 == 2) {
            localizedNumberFormatter = (LocalizedNumberFormatter)((LocalizedNumberFormatter)((LocalizedNumberFormatter)NumberFormatter.withLocale(this.getLocale()).unit(measureUnit)).perUnit(measureUnit2)).unitWidth(this.formatWidth.currencyWidth);
        } else {
            assert (n2 == 3);
            localizedNumberFormatter = (LocalizedNumberFormatter)((LocalizedNumberFormatter)((LocalizedNumberFormatter)((LocalizedNumberFormatter)this.getNumberFormatter().unit(measureUnit)).perUnit(measureUnit2)).unitWidth(this.formatWidth.unitWidth)).precision(Precision.integer().withMode(RoundingUtils.mathContextUnlimited(RoundingMode.DOWN)));
        }
        this.formatter3 = this.formatter2;
        this.formatter2 = this.formatter1;
        this.formatter1 = new NumberFormatterCacheEntry();
        this.formatter1.type = n2;
        this.formatter1.unit = measureUnit;
        this.formatter1.perUnit = measureUnit2;
        this.formatter1.formatter = localizedNumberFormatter;
        return localizedNumberFormatter;
    }

    synchronized void clearCache() {
        this.formatter1 = null;
        this.formatter2 = null;
        this.formatter3 = null;
    }

    LocalizedNumberFormatter getNumberFormatter() {
        return this.numberFormatter;
    }

    private FormattedStringBuilder formatMeasure(Measure measure) {
        MeasureUnit measureUnit = measure.getUnit();
        DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = new DecimalQuantity_DualStorageBCD(measure.getNumber());
        FormattedStringBuilder formattedStringBuilder = new FormattedStringBuilder();
        if (measureUnit instanceof Currency) {
            this.getUnitFormatterFromCache(2, measureUnit, null).formatImpl(decimalQuantity_DualStorageBCD, formattedStringBuilder);
        } else {
            this.getUnitFormatterFromCache(1, measureUnit, null).formatImpl(decimalQuantity_DualStorageBCD, formattedStringBuilder);
        }
        return formattedStringBuilder;
    }

    private FormattedStringBuilder formatMeasureInteger(Measure measure) {
        DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = new DecimalQuantity_DualStorageBCD(measure.getNumber());
        FormattedStringBuilder formattedStringBuilder = new FormattedStringBuilder();
        this.getUnitFormatterFromCache(3, measure.getUnit(), null).formatImpl(decimalQuantity_DualStorageBCD, formattedStringBuilder);
        return formattedStringBuilder;
    }

    private void formatMeasuresSlowTrack(ListFormatter listFormatter, Appendable appendable, FieldPosition fieldPosition, Measure ... measureArray) {
        String[] stringArray = new String[measureArray.length];
        FieldPosition fieldPosition2 = new FieldPosition(fieldPosition.getFieldAttribute(), fieldPosition.getField());
        int n2 = -1;
        for (int i2 = 0; i2 < measureArray.length; ++i2) {
            FormattedStringBuilder formattedStringBuilder = i2 == measureArray.length - 1 ? this.formatMeasure(measureArray[i2]) : this.formatMeasureInteger(measureArray[i2]);
            if (n2 == -1) {
                FormattedValueStringBuilderImpl.nextFieldPosition(formattedStringBuilder, fieldPosition2);
                if (fieldPosition2.getEndIndex() != 0) {
                    n2 = i2;
                }
            }
            stringArray[i2] = formattedStringBuilder.toString();
        }
        ListFormatter.FormattedListBuilder formattedListBuilder = listFormatter.formatImpl(Arrays.asList(stringArray), true);
        int n3 = formattedListBuilder.getOffset(n2);
        if (n3 != -1) {
            fieldPosition.setBeginIndex(fieldPosition2.getBeginIndex() + n3);
            fieldPosition.setEndIndex(fieldPosition2.getEndIndex() + n3);
        }
        formattedListBuilder.appendTo(appendable);
    }

    private static String loadNumericDurationFormat(ICUResourceBundle iCUResourceBundle, String string) {
        iCUResourceBundle = iCUResourceBundle.getWithFallback(String.format("durationUnits/%s", string));
        return iCUResourceBundle.getString().replace("h", "H");
    }

    private static Number[] toHMS(Measure[] measureArray) {
        Number[] numberArray = new Number[3];
        int n2 = -1;
        for (Measure measure : measureArray) {
            if (measure.getNumber().doubleValue() < 0.0) {
                return null;
            }
            Integer n3 = hmsTo012.get(measure.getUnit());
            if (n3 == null) {
                return null;
            }
            int n4 = n3;
            if (n4 <= n2) {
                return null;
            }
            n2 = n4;
            numberArray[n4] = measure.getNumber();
        }
        return numberArray;
    }

    private void formatNumeric(Number[] numberArray, Appendable appendable) {
        String string;
        if (numberArray[0] != null && numberArray[2] != null) {
            string = this.numericFormatters.getHourMinuteSecond();
            if (numberArray[1] == null) {
                numberArray[1] = 0;
            }
            numberArray[1] = Math.floor(numberArray[1].doubleValue());
            numberArray[0] = Math.floor(numberArray[0].doubleValue());
        } else if (numberArray[0] != null && numberArray[1] != null) {
            string = this.numericFormatters.getHourMinute();
            numberArray[0] = Math.floor(numberArray[0].doubleValue());
        } else if (numberArray[1] != null && numberArray[2] != null) {
            string = this.numericFormatters.getMinuteSecond();
            numberArray[1] = Math.floor(numberArray[1].doubleValue());
        } else {
            throw new IllegalStateException();
        }
        LocalizedNumberFormatter localizedNumberFormatter = (LocalizedNumberFormatter)this.numberFormatter.integerWidth(IntegerWidth.zeroFillTo(2));
        FormattedStringBuilder formattedStringBuilder = new FormattedStringBuilder();
        boolean bl2 = false;
        block11: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            Number number = 0;
            switch (c2) {
                case 'H': {
                    number = numberArray[0];
                    break;
                }
                case 'm': {
                    number = numberArray[1];
                    break;
                }
                case 's': {
                    number = numberArray[2];
                }
            }
            switch (c2) {
                case 'H': 
                case 'm': 
                case 's': {
                    if (bl2) {
                        formattedStringBuilder.appendChar16(c2, null);
                        continue block11;
                    }
                    if (i2 + 1 < string.length() && string.charAt(i2 + 1) == c2) {
                        formattedStringBuilder.append(localizedNumberFormatter.format(number), null);
                        ++i2;
                        continue block11;
                    }
                    formattedStringBuilder.append(this.numberFormatter.format(number), null);
                    continue block11;
                }
                case '\'': {
                    if (i2 + 1 < string.length() && string.charAt(i2 + 1) == c2) {
                        formattedStringBuilder.appendChar16(c2, null);
                        ++i2;
                        continue block11;
                    }
                    bl2 = !bl2;
                    continue block11;
                }
                default: {
                    formattedStringBuilder.appendChar16(c2, null);
                }
            }
        }
        try {
            appendable.append(formattedStringBuilder);
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    Object toTimeUnitProxy() {
        return new MeasureProxy(this.getLocale(), this.formatWidth, this.getNumberFormatInternal(), 1);
    }

    Object toCurrencyProxy() {
        return new MeasureProxy(this.getLocale(), this.formatWidth, this.getNumberFormatInternal(), 2);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new MeasureProxy(this.getLocale(), this.formatWidth, this.getNumberFormatInternal(), 0);
    }

    private static FormatWidth fromFormatWidthOrdinal(int n2) {
        FormatWidth[] formatWidthArray = FormatWidth.values();
        if (n2 < 0 || n2 >= formatWidthArray.length) {
            return FormatWidth.SHORT;
        }
        return formatWidthArray[n2];
    }

    @Deprecated
    public static String getRangeFormat(ULocale uLocale, FormatWidth formatWidth) {
        if (uLocale.getLanguage().equals("fr")) {
            return MeasureFormat.getRangeFormat(ULocale.ROOT, formatWidth);
        }
        String string = localeIdToRangeFormat.get(uLocale);
        if (string == null) {
            ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", uLocale);
            ULocale uLocale2 = iCUResourceBundle.getULocale();
            if (!uLocale.equals(uLocale2) && (string = localeIdToRangeFormat.get(uLocale)) != null) {
                localeIdToRangeFormat.put(uLocale, string);
                return string;
            }
            NumberingSystem numberingSystem = NumberingSystem.getInstance(uLocale);
            String string2 = null;
            try {
                string2 = iCUResourceBundle.getStringWithFallback("NumberElements/" + numberingSystem.getName() + "/miscPatterns/range");
            }
            catch (MissingResourceException missingResourceException) {
                string2 = iCUResourceBundle.getStringWithFallback("NumberElements/latn/patterns/range");
            }
            string = SimpleFormatterImpl.compileToStringMinMaxArguments(string2, new StringBuilder(), 2, 2);
            localeIdToRangeFormat.put(uLocale, string);
            if (!uLocale.equals(uLocale2)) {
                localeIdToRangeFormat.put(uLocale2, string);
            }
        }
        return string;
    }

    static {
        hmsTo012.put(MeasureUnit.HOUR, 0);
        hmsTo012.put(MeasureUnit.MINUTE, 1);
        hmsTo012.put(MeasureUnit.SECOND, 2);
        localeIdToRangeFormat = new ConcurrentHashMap<ULocale, String>();
    }

    static class MeasureProxy
    implements Externalizable {
        private static final long serialVersionUID = -6033308329886716770L;
        private ULocale locale;
        private FormatWidth formatWidth;
        private NumberFormat numberFormat;
        private int subClass;
        private HashMap<Object, Object> keyValues;

        public MeasureProxy(ULocale uLocale, FormatWidth formatWidth, NumberFormat numberFormat, int n2) {
            this.locale = uLocale;
            this.formatWidth = formatWidth;
            this.numberFormat = numberFormat;
            this.subClass = n2;
            this.keyValues = new HashMap();
        }

        public MeasureProxy() {
        }

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeByte(0);
            objectOutput.writeUTF(this.locale.toLanguageTag());
            objectOutput.writeByte(this.formatWidth.ordinal());
            objectOutput.writeObject(this.numberFormat);
            objectOutput.writeByte(this.subClass);
            objectOutput.writeObject(this.keyValues);
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            objectInput.readByte();
            this.locale = ULocale.forLanguageTag(objectInput.readUTF());
            this.formatWidth = MeasureFormat.fromFormatWidthOrdinal(objectInput.readByte() & 0xFF);
            this.numberFormat = (NumberFormat)objectInput.readObject();
            if (this.numberFormat == null) {
                throw new InvalidObjectException("Missing number format.");
            }
            this.subClass = objectInput.readByte() & 0xFF;
            this.keyValues = (HashMap)objectInput.readObject();
            if (this.keyValues == null) {
                throw new InvalidObjectException("Missing optional values map.");
            }
        }

        private TimeUnitFormat createTimeUnitFormat() throws InvalidObjectException {
            int n2;
            if (this.formatWidth == FormatWidth.WIDE) {
                n2 = 0;
            } else if (this.formatWidth == FormatWidth.SHORT) {
                n2 = 1;
            } else {
                throw new InvalidObjectException("Bad width: " + (Object)((Object)this.formatWidth));
            }
            TimeUnitFormat timeUnitFormat = new TimeUnitFormat(this.locale, n2);
            timeUnitFormat.setNumberFormat(this.numberFormat);
            return timeUnitFormat;
        }

        private Object readResolve() throws ObjectStreamException {
            switch (this.subClass) {
                case 0: {
                    return MeasureFormat.getInstance(this.locale, this.formatWidth, this.numberFormat);
                }
                case 1: {
                    return this.createTimeUnitFormat();
                }
                case 2: {
                    return MeasureFormat.getCurrencyFormat(this.locale);
                }
            }
            throw new InvalidObjectException("Unknown subclass: " + this.subClass);
        }
    }

    static class NumberFormatterCacheEntry {
        int type;
        MeasureUnit unit;
        MeasureUnit perUnit;
        LocalizedNumberFormatter formatter;

        NumberFormatterCacheEntry() {
        }
    }

    static class NumericFormatters {
        private String hourMinute;
        private String minuteSecond;
        private String hourMinuteSecond;

        public NumericFormatters(String string, String string2, String string3) {
            this.hourMinute = string;
            this.minuteSecond = string2;
            this.hourMinuteSecond = string3;
        }

        public String getHourMinute() {
            return this.hourMinute;
        }

        public String getMinuteSecond() {
            return this.minuteSecond;
        }

        public String getHourMinuteSecond() {
            return this.hourMinuteSecond;
        }
    }

    public static enum FormatWidth {
        WIDE(ListFormatter.Width.WIDE, NumberFormatter.UnitWidth.FULL_NAME, NumberFormatter.UnitWidth.FULL_NAME),
        SHORT(ListFormatter.Width.SHORT, NumberFormatter.UnitWidth.SHORT, NumberFormatter.UnitWidth.ISO_CODE),
        NARROW(ListFormatter.Width.NARROW, NumberFormatter.UnitWidth.NARROW, NumberFormatter.UnitWidth.SHORT),
        NUMERIC(ListFormatter.Width.NARROW, NumberFormatter.UnitWidth.NARROW, NumberFormatter.UnitWidth.SHORT),
        DEFAULT_CURRENCY(ListFormatter.Width.SHORT, NumberFormatter.UnitWidth.FULL_NAME, NumberFormatter.UnitWidth.SHORT);

        final ListFormatter.Width listWidth;
        final NumberFormatter.UnitWidth unitWidth;
        final NumberFormatter.UnitWidth currencyWidth;

        private FormatWidth(ListFormatter.Width width, NumberFormatter.UnitWidth unitWidth, NumberFormatter.UnitWidth unitWidth2) {
            this.listWidth = width;
            this.unitWidth = unitWidth;
            this.currencyWidth = unitWidth2;
        }
    }
}

