/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Set;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UResource;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DateIntervalFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Calendar;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Freezable;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUCloneNotSupportedException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public class DateIntervalInfo
implements Freezable<DateIntervalInfo>,
Serializable,
Cloneable {
    static final int currentSerialVersion = 1;
    static final String[] CALENDAR_FIELD_TO_PATTERN_LETTER = new String[]{"G", "y", "M", "w", "W", "d", "D", "E", "F", "a", "h", "H", "m", "s", "S", "z", " ", "Y", "e", "u", "g", "A", " ", " "};
    private static final long serialVersionUID = 1L;
    private static final int MINIMUM_SUPPORTED_CALENDAR_FIELD = 14;
    private static String CALENDAR_KEY = "calendar";
    private static String INTERVAL_FORMATS_KEY = "intervalFormats";
    private static String FALLBACK_STRING = "fallback";
    private static String LATEST_FIRST_PREFIX = "latestFirst:";
    private static String EARLIEST_FIRST_PREFIX = "earliestFirst:";
    private static final ICUCache<String, DateIntervalInfo> DIICACHE = new SimpleCache<String, DateIntervalInfo>();
    private String fFallbackIntervalPattern;
    private boolean fFirstDateInPtnIsLaterDate = false;
    private Map<String, Map<String, PatternInfo>> fIntervalPatterns = null;
    private volatile transient boolean frozen = false;
    private transient boolean fIntervalPatternsReadOnly = false;

    @Deprecated
    public DateIntervalInfo() {
        this.fIntervalPatterns = new HashMap<String, Map<String, PatternInfo>>();
        this.fFallbackIntervalPattern = "{0} \u2013 {1}";
    }

    public DateIntervalInfo(ULocale uLocale) {
        this.initializeData(uLocale);
    }

    public DateIntervalInfo(Locale locale) {
        this(ULocale.forLocale(locale));
    }

    private void initializeData(ULocale uLocale) {
        String string = uLocale.toString();
        DateIntervalInfo dateIntervalInfo = DIICACHE.get(string);
        if (dateIntervalInfo == null) {
            this.setup(uLocale);
            this.fIntervalPatternsReadOnly = true;
            DIICACHE.put(string, ((DateIntervalInfo)this.clone()).freeze());
        } else {
            this.initializeFromReadOnlyPatterns(dateIntervalInfo);
        }
    }

    private void initializeFromReadOnlyPatterns(DateIntervalInfo dateIntervalInfo) {
        this.fFallbackIntervalPattern = dateIntervalInfo.fFallbackIntervalPattern;
        this.fFirstDateInPtnIsLaterDate = dateIntervalInfo.fFirstDateInPtnIsLaterDate;
        this.fIntervalPatterns = dateIntervalInfo.fIntervalPatterns;
        this.fIntervalPatternsReadOnly = true;
    }

    private void setup(ULocale uLocale) {
        int n2 = 19;
        this.fIntervalPatterns = new HashMap<String, Map<String, PatternInfo>>(n2);
        this.fFallbackIntervalPattern = "{0} \u2013 {1}";
        try {
            Object object;
            String string = uLocale.getKeywordValue("calendar");
            if (string == null) {
                object = Calendar.getKeywordValuesForLocale("calendar", uLocale, true);
                string = object[0];
            }
            if (string == null) {
                string = "gregorian";
            }
            object = new DateIntervalSink(this);
            ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", uLocale);
            String string2 = iCUResourceBundle.getStringWithFallback(CALENDAR_KEY + "/" + string + "/" + INTERVAL_FORMATS_KEY + "/" + FALLBACK_STRING);
            this.setFallbackIntervalPattern(string2);
            HashSet<String> hashSet = new HashSet<String>();
            while (string != null) {
                if (hashSet.contains(string)) {
                    throw new ICUException("Loop in calendar type fallback: " + string);
                }
                hashSet.add(string);
                String string3 = CALENDAR_KEY + "/" + string;
                iCUResourceBundle.getAllItemsWithFallback(string3, (UResource.Sink)object);
                string = ((DateIntervalSink)object).getAndResetNextCalendarType();
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private static int splitPatternInto2Part(String string) {
        int n2;
        boolean bl2 = false;
        char c2 = '\u0000';
        int n3 = 0;
        int[] nArray = new int[58];
        int n4 = 65;
        boolean bl3 = false;
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c3 = string.charAt(n2);
            if (c3 != c2 && n3 > 0) {
                int n5 = nArray[c2 - n4];
                if (n5 != 0) {
                    bl3 = true;
                    break;
                }
                nArray[c2 - n4] = 1;
                n3 = 0;
            }
            if (c3 == '\'') {
                if (n2 + 1 < string.length() && string.charAt(n2 + 1) == '\'') {
                    ++n2;
                    continue;
                }
                bl2 = !bl2;
                continue;
            }
            if (bl2 || (c3 < 'a' || c3 > 'z') && (c3 < 'A' || c3 > 'Z')) continue;
            c2 = c3;
            ++n3;
        }
        if (n3 > 0 && !bl3 && nArray[c2 - n4] == 0) {
            n3 = 0;
        }
        return n2 - n3;
    }

    public void setIntervalPattern(String string, int n2, String string2) {
        if (this.frozen) {
            throw new UnsupportedOperationException("no modification is allowed after DII is frozen");
        }
        if (n2 > 14) {
            throw new IllegalArgumentException("calendar field is larger than MINIMUM_SUPPORTED_CALENDAR_FIELD");
        }
        if (this.fIntervalPatternsReadOnly) {
            this.fIntervalPatterns = DateIntervalInfo.cloneIntervalPatterns(this.fIntervalPatterns);
            this.fIntervalPatternsReadOnly = false;
        }
        PatternInfo patternInfo = this.setIntervalPatternInternally(string, CALENDAR_FIELD_TO_PATTERN_LETTER[n2], string2);
        if (n2 == 11) {
            this.setIntervalPattern(string, CALENDAR_FIELD_TO_PATTERN_LETTER[9], patternInfo);
            this.setIntervalPattern(string, CALENDAR_FIELD_TO_PATTERN_LETTER[10], patternInfo);
        } else if (n2 == 5 || n2 == 7) {
            this.setIntervalPattern(string, CALENDAR_FIELD_TO_PATTERN_LETTER[5], patternInfo);
        }
    }

    private PatternInfo setIntervalPatternInternally(String string, String string2, String string3) {
        int n2;
        Map<String, PatternInfo> map = this.fIntervalPatterns.get(string);
        boolean bl2 = false;
        if (map == null) {
            map = new HashMap<String, PatternInfo>();
            bl2 = true;
        }
        boolean bl3 = this.fFirstDateInPtnIsLaterDate;
        if (string3.startsWith(LATEST_FIRST_PREFIX)) {
            bl3 = true;
            n2 = LATEST_FIRST_PREFIX.length();
            string3 = string3.substring(n2, string3.length());
        } else if (string3.startsWith(EARLIEST_FIRST_PREFIX)) {
            bl3 = false;
            n2 = EARLIEST_FIRST_PREFIX.length();
            string3 = string3.substring(n2, string3.length());
        }
        PatternInfo patternInfo = DateIntervalInfo.genPatternInfo(string3, bl3);
        map.put(string2, patternInfo);
        if (bl2) {
            this.fIntervalPatterns.put(string, map);
        }
        return patternInfo;
    }

    private void setIntervalPattern(String string, String string2, PatternInfo patternInfo) {
        Map<String, PatternInfo> map = this.fIntervalPatterns.get(string);
        map.put(string2, patternInfo);
    }

    @Deprecated
    public static PatternInfo genPatternInfo(String string, boolean bl2) {
        int n2 = DateIntervalInfo.splitPatternInto2Part(string);
        String string2 = string.substring(0, n2);
        String string3 = null;
        if (n2 < string.length()) {
            string3 = string.substring(n2, string.length());
        }
        return new PatternInfo(string2, string3, bl2);
    }

    public PatternInfo getIntervalPattern(String string, int n2) {
        PatternInfo patternInfo;
        if (n2 > 14) {
            throw new IllegalArgumentException("no support for field less than MILLISECOND");
        }
        Map<String, PatternInfo> map = this.fIntervalPatterns.get(string);
        if (map != null && (patternInfo = map.get(CALENDAR_FIELD_TO_PATTERN_LETTER[n2])) != null) {
            return patternInfo;
        }
        return null;
    }

    public String getFallbackIntervalPattern() {
        return this.fFallbackIntervalPattern;
    }

    public void setFallbackIntervalPattern(String string) {
        if (this.frozen) {
            throw new UnsupportedOperationException("no modification is allowed after DII is frozen");
        }
        int n2 = string.indexOf("{0}");
        int n3 = string.indexOf("{1}");
        if (n2 == -1 || n3 == -1) {
            throw new IllegalArgumentException("no pattern {0} or pattern {1} in fallbackPattern");
        }
        if (n2 > n3) {
            this.fFirstDateInPtnIsLaterDate = true;
        }
        this.fFallbackIntervalPattern = string;
    }

    public boolean getDefaultOrder() {
        return this.fFirstDateInPtnIsLaterDate;
    }

    public Object clone() {
        if (this.frozen) {
            return this;
        }
        return this.cloneUnfrozenDII();
    }

    private Object cloneUnfrozenDII() {
        try {
            DateIntervalInfo dateIntervalInfo = (DateIntervalInfo)super.clone();
            dateIntervalInfo.fFallbackIntervalPattern = this.fFallbackIntervalPattern;
            dateIntervalInfo.fFirstDateInPtnIsLaterDate = this.fFirstDateInPtnIsLaterDate;
            if (this.fIntervalPatternsReadOnly) {
                dateIntervalInfo.fIntervalPatterns = this.fIntervalPatterns;
                dateIntervalInfo.fIntervalPatternsReadOnly = true;
            } else {
                dateIntervalInfo.fIntervalPatterns = DateIntervalInfo.cloneIntervalPatterns(this.fIntervalPatterns);
                dateIntervalInfo.fIntervalPatternsReadOnly = false;
            }
            dateIntervalInfo.frozen = false;
            return dateIntervalInfo;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ICUCloneNotSupportedException("clone is not supported", cloneNotSupportedException);
        }
    }

    private static Map<String, Map<String, PatternInfo>> cloneIntervalPatterns(Map<String, Map<String, PatternInfo>> map) {
        HashMap<String, Map<String, PatternInfo>> hashMap = new HashMap<String, Map<String, PatternInfo>>();
        for (Map.Entry<String, Map<String, PatternInfo>> entry : map.entrySet()) {
            String string = entry.getKey();
            Map<String, PatternInfo> map2 = entry.getValue();
            HashMap<String, PatternInfo> hashMap2 = new HashMap<String, PatternInfo>();
            for (Map.Entry<String, PatternInfo> entry2 : map2.entrySet()) {
                String string2 = entry2.getKey();
                PatternInfo patternInfo = entry2.getValue();
                hashMap2.put(string2, patternInfo);
            }
            hashMap.put(string, hashMap2);
        }
        return hashMap;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public DateIntervalInfo freeze() {
        this.fIntervalPatternsReadOnly = true;
        this.frozen = true;
        return this;
    }

    @Override
    public DateIntervalInfo cloneAsThawed() {
        DateIntervalInfo dateIntervalInfo = (DateIntervalInfo)this.cloneUnfrozenDII();
        return dateIntervalInfo;
    }

    static void parseSkeleton(String string, int[] nArray) {
        int n2 = 65;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int n3 = string.charAt(i2) - n2;
            nArray[n3] = nArray[n3] + 1;
        }
    }

    private static boolean stringNumeric(int n2, int n3, char c2) {
        return c2 == 'M' && (n2 <= 2 && n3 > 2 || n2 > 2 && n3 <= 2);
    }

    DateIntervalFormat.BestMatchInfo getBestSkeleton(String string) {
        String string2 = string;
        int[] nArray = new int[58];
        int[] nArray2 = new int[58];
        int n2 = 4096;
        int n3 = 256;
        int n4 = 65;
        boolean bl2 = false;
        if (string.indexOf(122) != -1 || string.indexOf(107) != -1 || string.indexOf(75) != -1 || string.indexOf(97) != -1 || string.indexOf(98) != -1) {
            string = string.replace('z', 'v');
            string = string.replace('k', 'H');
            string = string.replace('K', 'h');
            string = string.replace("a", "");
            string = string.replace("b", "");
            bl2 = true;
        }
        DateIntervalInfo.parseSkeleton(string, nArray);
        int n5 = Integer.MAX_VALUE;
        int n6 = 0;
        for (String string3 : this.fIntervalPatterns.keySet()) {
            int n7;
            for (n7 = 0; n7 < nArray2.length; ++n7) {
                nArray2[n7] = 0;
            }
            DateIntervalInfo.parseSkeleton(string3, nArray2);
            n7 = 0;
            int n8 = 1;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n9 = nArray[i2];
                int n10 = nArray2[i2];
                if (n9 == n10) continue;
                if (n9 == 0) {
                    n8 = -1;
                    n7 += 4096;
                    continue;
                }
                if (n10 == 0) {
                    n8 = -1;
                    n7 += 4096;
                    continue;
                }
                if (DateIntervalInfo.stringNumeric(n9, n10, (char)(i2 + 65))) {
                    n7 += 256;
                    continue;
                }
                n7 += Math.abs(n9 - n10);
            }
            if (n7 < n5) {
                string2 = string3;
                n5 = n7;
                n6 = n8;
            }
            if (n7 != 0) continue;
            n6 = 0;
            break;
        }
        if (bl2 && n6 != -1) {
            n6 = 2;
        }
        return new DateIntervalFormat.BestMatchInfo(string2, n6);
    }

    public boolean equals(Object object) {
        if (object instanceof DateIntervalInfo) {
            DateIntervalInfo dateIntervalInfo = (DateIntervalInfo)object;
            return this.fIntervalPatterns.equals(dateIntervalInfo.fIntervalPatterns);
        }
        return false;
    }

    public int hashCode() {
        return this.fIntervalPatterns.hashCode();
    }

    @Deprecated
    public Map<String, Set<String>> getPatterns() {
        LinkedHashMap<String, Set<String>> linkedHashMap = new LinkedHashMap<String, Set<String>>();
        for (Map.Entry<String, Map<String, PatternInfo>> entry : this.fIntervalPatterns.entrySet()) {
            linkedHashMap.put(entry.getKey(), new LinkedHashSet<String>(entry.getValue().keySet()));
        }
        return linkedHashMap;
    }

    @Deprecated
    public Map<String, Map<String, PatternInfo>> getRawPatterns() {
        LinkedHashMap<String, Map<String, PatternInfo>> linkedHashMap = new LinkedHashMap<String, Map<String, PatternInfo>>();
        for (Map.Entry<String, Map<String, PatternInfo>> entry : this.fIntervalPatterns.entrySet()) {
            linkedHashMap.put(entry.getKey(), new LinkedHashMap<String, PatternInfo>(entry.getValue()));
        }
        return linkedHashMap;
    }

    static /* synthetic */ String access$100() {
        return CALENDAR_KEY;
    }

    private static final class DateIntervalSink
    extends UResource.Sink {
        private static final String ACCEPTED_PATTERN_LETTERS = "GyMdahHmsS";
        DateIntervalInfo dateIntervalInfo;
        String nextCalendarType;
        private static final String DATE_INTERVAL_PATH_PREFIX = "/LOCALE/" + DateIntervalInfo.access$100() + "/";
        private static final String DATE_INTERVAL_PATH_SUFFIX = "/" + DateIntervalInfo.access$000();

        public DateIntervalSink(DateIntervalInfo dateIntervalInfo) {
            this.dateIntervalInfo = dateIntervalInfo;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            UResource.Table table = value.getTable();
            int n2 = 0;
            while (table.getKeyAndValue(n2, key, value)) {
                if (key.contentEquals(INTERVAL_FORMATS_KEY)) {
                    if (value.getType() == 3) {
                        this.nextCalendarType = this.getCalendarTypeFromPath(value.getAliasString());
                        break;
                    }
                    if (value.getType() == 2) {
                        UResource.Table table2 = value.getTable();
                        int n3 = 0;
                        while (table2.getKeyAndValue(n3, key, value)) {
                            if (value.getType() == 2) {
                                this.processSkeletonTable(key, value);
                            }
                            ++n3;
                        }
                        break;
                    }
                }
                ++n2;
            }
        }

        public void processSkeletonTable(UResource.Key key, UResource.Value value) {
            String string = key.toString();
            UResource.Table table = value.getTable();
            int n2 = 0;
            while (table.getKeyAndValue(n2, key, value)) {
                CharSequence charSequence;
                if (value.getType() == 0 && (charSequence = this.validateAndProcessPatternLetter(key)) != null) {
                    String string2 = charSequence.toString();
                    this.setIntervalPatternIfAbsent(string, string2, value);
                }
                ++n2;
            }
        }

        public String getAndResetNextCalendarType() {
            String string = this.nextCalendarType;
            this.nextCalendarType = null;
            return string;
        }

        private String getCalendarTypeFromPath(String string) {
            if (string.startsWith(DATE_INTERVAL_PATH_PREFIX) && string.endsWith(DATE_INTERVAL_PATH_SUFFIX)) {
                return string.substring(DATE_INTERVAL_PATH_PREFIX.length(), string.length() - DATE_INTERVAL_PATH_SUFFIX.length());
            }
            throw new ICUException("Malformed 'intervalFormat' alias path: " + string);
        }

        private CharSequence validateAndProcessPatternLetter(CharSequence charSequence) {
            if (charSequence.length() != 1) {
                return null;
            }
            char c2 = charSequence.charAt(0);
            if (ACCEPTED_PATTERN_LETTERS.indexOf(c2) < 0 && c2 != 'B') {
                return null;
            }
            if (c2 == CALENDAR_FIELD_TO_PATTERN_LETTER[11].charAt(0)) {
                charSequence = CALENDAR_FIELD_TO_PATTERN_LETTER[10];
            }
            if (c2 == 'B') {
                charSequence = CALENDAR_FIELD_TO_PATTERN_LETTER[9];
            }
            return charSequence;
        }

        private void setIntervalPatternIfAbsent(String string, String string2, UResource.Value value) {
            Map map = (Map)this.dateIntervalInfo.fIntervalPatterns.get(string);
            if (map == null || !map.containsKey(string2)) {
                this.dateIntervalInfo.setIntervalPatternInternally(string, string2, value.toString());
            }
        }
    }

    public static final class PatternInfo
    implements Serializable,
    Cloneable {
        static final int currentSerialVersion = 1;
        private static final long serialVersionUID = 1L;
        private final String fIntervalPatternFirstPart;
        private final String fIntervalPatternSecondPart;
        private final boolean fFirstDateInPtnIsLaterDate;

        public PatternInfo(String string, String string2, boolean bl2) {
            this.fIntervalPatternFirstPart = string;
            this.fIntervalPatternSecondPart = string2;
            this.fFirstDateInPtnIsLaterDate = bl2;
        }

        public String getFirstPart() {
            return this.fIntervalPatternFirstPart;
        }

        public String getSecondPart() {
            return this.fIntervalPatternSecondPart;
        }

        public boolean firstDateInPtnIsLaterDate() {
            return this.fFirstDateInPtnIsLaterDate;
        }

        public boolean equals(Object object) {
            if (object instanceof PatternInfo) {
                PatternInfo patternInfo = (PatternInfo)object;
                return Objects.equals(this.fIntervalPatternFirstPart, patternInfo.fIntervalPatternFirstPart) && Objects.equals(this.fIntervalPatternSecondPart, patternInfo.fIntervalPatternSecondPart) && this.fFirstDateInPtnIsLaterDate == patternInfo.fFirstDateInPtnIsLaterDate;
            }
            return false;
        }

        public int hashCode() {
            int n2;
            int n3 = n2 = this.fIntervalPatternFirstPart != null ? this.fIntervalPatternFirstPart.hashCode() : 0;
            if (this.fIntervalPatternSecondPart != null) {
                n2 ^= this.fIntervalPatternSecondPart.hashCode();
            }
            if (this.fFirstDateInPtnIsLaterDate) {
                n2 ^= 0xFFFFFFFF;
            }
            return n2;
        }

        public String toString() {
            return "{first=\u00ab" + this.fIntervalPatternFirstPart + "\u00bb, second=\u00ab" + this.fIntervalPatternSecondPart + "\u00bb, reversed:" + this.fFirstDateInPtnIsLaterDate + "}";
        }
    }
}

