/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import macromedia.jdbc.db2.externals.com.ibm.icu.text.RawCollationKey;

public final class CollationKey
implements Comparable<CollationKey> {
    private byte[] m_key_;
    private String m_source_;
    private int m_hashCode_;
    private int m_length_;
    private static final int MERGE_SEPERATOR_ = 2;

    public CollationKey(String string, byte[] byArray) {
        this(string, byArray, -1);
    }

    private CollationKey(String string, byte[] byArray, int n2) {
        this.m_source_ = string;
        this.m_key_ = byArray;
        this.m_hashCode_ = 0;
        this.m_length_ = n2;
    }

    public CollationKey(String string, RawCollationKey rawCollationKey) {
        this.m_source_ = string;
        this.m_length_ = rawCollationKey.size - 1;
        this.m_key_ = rawCollationKey.releaseBytes();
        assert (this.m_key_[this.m_length_] == 0);
        this.m_hashCode_ = 0;
    }

    public String getSourceString() {
        return this.m_source_;
    }

    public byte[] toByteArray() {
        int n2 = this.getLength() + 1;
        byte[] byArray = new byte[n2];
        System.arraycopy(this.m_key_, 0, byArray, 0, n2);
        return byArray;
    }

    @Override
    public int compareTo(CollationKey collationKey) {
        int n2 = 0;
        int n3;
        int n4;
        while ((n4 = this.m_key_[n2] & 0xFF) >= (n3 = collationKey.m_key_[n2] & 0xFF)) {
            if (n4 > n3) {
                return 1;
            }
            if (n4 == 0) {
                return 0;
            }
            ++n2;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CollationKey)) {
            return false;
        }
        return this.equals((CollationKey)object);
    }

    public boolean equals(CollationKey collationKey) {
        if (this == collationKey) {
            return true;
        }
        if (collationKey == null) {
            return false;
        }
        CollationKey collationKey2 = collationKey;
        int n2 = 0;
        while (true) {
            if (this.m_key_[n2] != collationKey2.m_key_[n2]) {
                return false;
            }
            if (this.m_key_[n2] == 0) break;
            ++n2;
        }
        return true;
    }

    public int hashCode() {
        if (this.m_hashCode_ == 0) {
            if (this.m_key_ == null) {
                this.m_hashCode_ = 1;
            } else {
                int n2 = this.m_key_.length >> 1;
                StringBuilder stringBuilder = new StringBuilder(n2);
                int n3 = 0;
                while (this.m_key_[n3] != 0 && this.m_key_[n3 + 1] != 0) {
                    stringBuilder.append((char)(this.m_key_[n3] << 8 | 0xFF & this.m_key_[n3 + 1]));
                    n3 += 2;
                }
                if (this.m_key_[n3] != 0) {
                    stringBuilder.append((char)(this.m_key_[n3] << 8));
                }
                this.m_hashCode_ = stringBuilder.toString().hashCode();
            }
        }
        return this.m_hashCode_;
    }

    public CollationKey getBound(int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        if (n3 > 0) {
            while (n4 < this.m_key_.length && this.m_key_[n4] != 0) {
                if (this.m_key_[n4++] != 1) continue;
                ++n5;
                if (--n3 != 0 && n4 != this.m_key_.length && this.m_key_[n4] != 0) continue;
                --n4;
                break;
            }
        }
        if (n3 > 0) {
            throw new IllegalArgumentException("Source collation key has only " + n5 + " strength level. Call getBound() again  with noOfLevels < " + n5);
        }
        byte[] byArray = new byte[n4 + n2 + 1];
        System.arraycopy(this.m_key_, 0, byArray, 0, n4);
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                byArray[n4++] = 2;
                break;
            }
            case 2: {
                byArray[n4++] = -1;
                byArray[n4++] = -1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal boundType argument");
            }
        }
        byArray[n4] = 0;
        return new CollationKey(null, byArray, n4);
    }

    public CollationKey merge(CollationKey collationKey) {
        if (collationKey == null || collationKey.getLength() == 0) {
            throw new IllegalArgumentException("CollationKey argument can not be null or of 0 length");
        }
        byte[] byArray = new byte[this.getLength() + collationKey.getLength() + 2];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (this.m_key_[n3] < 0 || this.m_key_[n3] >= 2) {
                byArray[n2++] = this.m_key_[n3++];
                continue;
            }
            byArray[n2++] = 2;
            while (collationKey.m_key_[n4] < 0 || collationKey.m_key_[n4] >= 2) {
                byArray[n2++] = collationKey.m_key_[n4++];
            }
            if (this.m_key_[n3] != 1 || collationKey.m_key_[n4] != 1) break;
            ++n3;
            ++n4;
            byArray[n2++] = 1;
        }
        int n5 = this.m_length_ - n3;
        if (n5 > 0) {
            System.arraycopy(this.m_key_, n3, byArray, n2, n5);
            n2 += n5;
        } else {
            n5 = collationKey.m_length_ - n4;
            if (n5 > 0) {
                System.arraycopy(collationKey.m_key_, n4, byArray, n2, n5);
                n2 += n5;
            }
        }
        byArray[n2] = 0;
        assert (n2 == byArray.length - 1);
        return new CollationKey(null, byArray, n2);
    }

    private int getLength() {
        if (this.m_length_ >= 0) {
            return this.m_length_;
        }
        int n2 = this.m_key_.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.m_key_[i2] != 0) continue;
            n2 = i2;
            break;
        }
        this.m_length_ = n2;
        return this.m_length_;
    }

    public static final class BoundMode {
        public static final int LOWER = 0;
        public static final int UPPER = 1;
        public static final int UPPER_LONG = 2;
        @Deprecated
        public static final int COUNT = 3;

        private BoundMode() {
        }
    }
}

