/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.text.CharacterIterator;
import java.util.HashMap;
import java.util.Map;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CharacterIteratorWrapper;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.ContractionsAndExpansions;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.FCDIterCollationIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.FCDUTF16CollationIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.IterCollationIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.UTF16CollationIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.UVector32;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.RuleBasedCollator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UCharacterIterator;

public final class CollationElementIterator {
    private CollationIterator iter_ = null;
    private RuleBasedCollator rbc_;
    private int otherHalf_;
    private byte dir_;
    private UVector32 offsets_;
    private String string_;
    public static final int NULLORDER = -1;
    public static final int IGNORABLE = 0;

    public static final int primaryOrder(int n2) {
        return n2 >>> 16 & 0xFFFF;
    }

    public static final int secondaryOrder(int n2) {
        return n2 >>> 8 & 0xFF;
    }

    public static final int tertiaryOrder(int n2) {
        return n2 & 0xFF;
    }

    private static final int getFirstHalf(long l2, int n2) {
        return (int)l2 & 0xFFFF0000 | n2 >> 16 & 0xFF00 | n2 >> 8 & 0xFF;
    }

    private static final int getSecondHalf(long l2, int n2) {
        return (int)l2 << 16 | n2 >> 8 & 0xFF00 | n2 & 0x3F;
    }

    private static final boolean ceNeedsTwoParts(long l2) {
        return (l2 & 0xFFFF00FF003FL) != 0L;
    }

    private CollationElementIterator(RuleBasedCollator ruleBasedCollator) {
        this.rbc_ = ruleBasedCollator;
        this.otherHalf_ = 0;
        this.dir_ = 0;
        this.offsets_ = null;
    }

    CollationElementIterator(String string, RuleBasedCollator ruleBasedCollator) {
        this(ruleBasedCollator);
        this.setText(string);
    }

    CollationElementIterator(CharacterIterator characterIterator, RuleBasedCollator ruleBasedCollator) {
        this(ruleBasedCollator);
        this.setText(characterIterator);
    }

    CollationElementIterator(UCharacterIterator uCharacterIterator, RuleBasedCollator ruleBasedCollator) {
        this(ruleBasedCollator);
        this.setText(uCharacterIterator);
    }

    public int getOffset() {
        if (this.dir_ < 0 && this.offsets_ != null && !this.offsets_.isEmpty()) {
            int n2 = this.iter_.getCEsLength();
            if (this.otherHalf_ != 0) {
                ++n2;
            }
            assert (n2 < this.offsets_.size());
            return this.offsets_.elementAti(n2);
        }
        return this.iter_.getOffset();
    }

    public int next() {
        if (this.dir_ > 1) {
            if (this.otherHalf_ != 0) {
                int n2 = this.otherHalf_;
                this.otherHalf_ = 0;
                return n2;
            }
        } else if (this.dir_ == 1) {
            this.dir_ = (byte)2;
        } else if (this.dir_ == 0) {
            this.dir_ = (byte)2;
        } else {
            throw new IllegalStateException("Illegal change of direction");
        }
        this.iter_.clearCEsIfNoneRemaining();
        long l2 = this.iter_.nextCE();
        if (l2 == 0x101000100L) {
            return -1;
        }
        long l3 = l2 >>> 32;
        int n3 = (int)l2;
        int n4 = CollationElementIterator.getFirstHalf(l3, n3);
        int n5 = CollationElementIterator.getSecondHalf(l3, n3);
        if (n5 != 0) {
            this.otherHalf_ = n5 | 0xC0;
        }
        return n4;
    }

    public int previous() {
        if (this.dir_ < 0) {
            if (this.otherHalf_ != 0) {
                int n2 = this.otherHalf_;
                this.otherHalf_ = 0;
                return n2;
            }
        } else if (this.dir_ == 0) {
            this.iter_.resetToOffset(this.string_.length());
            this.dir_ = (byte)-1;
        } else if (this.dir_ == 1) {
            this.dir_ = (byte)-1;
        } else {
            throw new IllegalStateException("Illegal change of direction");
        }
        if (this.offsets_ == null) {
            this.offsets_ = new UVector32();
        }
        int n3 = this.iter_.getCEsLength() == 0 ? this.iter_.getOffset() : 0;
        long l2 = this.iter_.previousCE(this.offsets_);
        if (l2 == 0x101000100L) {
            return -1;
        }
        long l3 = l2 >>> 32;
        int n4 = (int)l2;
        int n5 = CollationElementIterator.getFirstHalf(l3, n4);
        int n6 = CollationElementIterator.getSecondHalf(l3, n4);
        if (n6 != 0) {
            if (this.offsets_.isEmpty()) {
                this.offsets_.addElement(this.iter_.getOffset());
                this.offsets_.addElement(n3);
            }
            this.otherHalf_ = n5;
            return n6 | 0xC0;
        }
        return n5;
    }

    public void reset() {
        this.iter_.resetToOffset(0);
        this.otherHalf_ = 0;
        this.dir_ = 0;
    }

    public void setOffset(int n2) {
        if (0 < n2 && n2 < this.string_.length()) {
            int n3;
            int n4 = n2;
            while (this.rbc_.isUnsafe(n3 = this.string_.charAt(n4)) && (!Character.isHighSurrogate((char)n3) || this.rbc_.isUnsafe(this.string_.codePointAt(n4))) && --n4 > 0) {
            }
            if (n4 < n2) {
                n3 = n4;
                do {
                    this.iter_.resetToOffset(n3);
                    do {
                        this.iter_.nextCE();
                    } while ((n4 = this.iter_.getOffset()) == n3);
                    if (n4 > n2) continue;
                    n3 = n4;
                } while (n4 < n2);
                n2 = n3;
            }
        }
        this.iter_.resetToOffset(n2);
        this.otherHalf_ = 0;
        this.dir_ = 1;
    }

    public void setText(String string) {
        this.string_ = string;
        boolean bl2 = this.rbc_.settings.readOnly().isNumeric();
        UTF16CollationIterator uTF16CollationIterator = this.rbc_.settings.readOnly().dontCheckFCD() ? new UTF16CollationIterator(this.rbc_.data, bl2, this.string_, 0) : new FCDUTF16CollationIterator(this.rbc_.data, bl2, this.string_, 0);
        this.iter_ = uTF16CollationIterator;
        this.otherHalf_ = 0;
        this.dir_ = 0;
    }

    public void setText(UCharacterIterator uCharacterIterator) {
        UCharacterIterator uCharacterIterator2;
        this.string_ = uCharacterIterator.getText();
        try {
            uCharacterIterator2 = (UCharacterIterator)uCharacterIterator.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.setText(uCharacterIterator.getText());
            return;
        }
        uCharacterIterator2.setToStart();
        boolean bl2 = this.rbc_.settings.readOnly().isNumeric();
        IterCollationIterator iterCollationIterator = this.rbc_.settings.readOnly().dontCheckFCD() ? new IterCollationIterator(this.rbc_.data, bl2, uCharacterIterator2) : new FCDIterCollationIterator(this.rbc_.data, bl2, uCharacterIterator2, 0);
        this.iter_ = iterCollationIterator;
        this.otherHalf_ = 0;
        this.dir_ = 0;
    }

    public void setText(CharacterIterator characterIterator) {
        CharacterIteratorWrapper characterIteratorWrapper = new CharacterIteratorWrapper(characterIterator);
        characterIteratorWrapper.setToStart();
        this.string_ = characterIteratorWrapper.getText();
        boolean bl2 = this.rbc_.settings.readOnly().isNumeric();
        IterCollationIterator iterCollationIterator = this.rbc_.settings.readOnly().dontCheckFCD() ? new IterCollationIterator(this.rbc_.data, bl2, characterIteratorWrapper) : new FCDIterCollationIterator(this.rbc_.data, bl2, characterIteratorWrapper, 0);
        this.iter_ = iterCollationIterator;
        this.otherHalf_ = 0;
        this.dir_ = 0;
    }

    static final Map<Integer, Integer> computeMaxExpansions(CollationData collationData) {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        MaxExpSink maxExpSink = new MaxExpSink(hashMap);
        new ContractionsAndExpansions(null, null, maxExpSink, true).forData(collationData);
        return hashMap;
    }

    public int getMaxExpansion(int n2) {
        return CollationElementIterator.getMaxExpansion(this.rbc_.tailoring.maxExpansions, n2);
    }

    static int getMaxExpansion(Map<Integer, Integer> map, int n2) {
        Integer n3;
        if (n2 == 0) {
            return 1;
        }
        if (map != null && (n3 = map.get(n2)) != null) {
            return n3;
        }
        if ((n2 & 0xC0) == 192) {
            return 2;
        }
        return 1;
    }

    private byte normalizeDir() {
        return this.dir_ == 1 ? (byte)0 : this.dir_;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CollationElementIterator) {
            CollationElementIterator collationElementIterator = (CollationElementIterator)object;
            return this.rbc_.equals(collationElementIterator.rbc_) && this.otherHalf_ == collationElementIterator.otherHalf_ && this.normalizeDir() == collationElementIterator.normalizeDir() && this.string_.equals(collationElementIterator.string_) && this.iter_.equals(collationElementIterator.iter_);
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    @Deprecated
    public RuleBasedCollator getRuleBasedCollator() {
        return this.rbc_;
    }

    private static final class MaxExpSink
    implements ContractionsAndExpansions.CESink {
        private Map<Integer, Integer> maxExpansions;

        MaxExpSink(Map<Integer, Integer> map) {
            this.maxExpansions = map;
        }

        @Override
        public void handleCE(long l2) {
        }

        @Override
        public void handleExpansion(long[] lArray, int n2, int n3) {
            Integer n4;
            if (n3 <= 1) {
                return;
            }
            int n5 = 0;
            for (int i2 = 0; i2 < n3; ++i2) {
                n5 += CollationElementIterator.ceNeedsTwoParts(lArray[n2 + i2]) ? 2 : 1;
            }
            long l2 = lArray[n2 + n3 - 1];
            long l3 = l2 >>> 32;
            int n6 = (int)l2;
            int n7 = CollationElementIterator.getSecondHalf(l3, n6);
            if (n7 == 0) {
                n7 = CollationElementIterator.getFirstHalf(l3, n6);
                assert (n7 != 0);
            } else {
                n7 |= 0xC0;
            }
            if ((n4 = this.maxExpansions.get(n7)) == null || n5 > n4) {
                this.maxExpansions.put(n7, n5);
            }
        }
    }
}

