/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CharsetMatch;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CharsetRecog_2022;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CharsetRecog_UTF8;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CharsetRecog_Unicode;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CharsetRecog_mbcs;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CharsetRecog_sbcs;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CharsetRecognizer;

public class CharsetDetector {
    private static final int kBufSize = 8000;
    byte[] fInputBytes = new byte[8000];
    int fInputLen;
    short[] fByteStats = new short[256];
    boolean fC1Bytes = false;
    String fDeclaredEncoding;
    byte[] fRawInput;
    int fRawLength;
    InputStream fInputStream;
    private boolean fStripTags = false;
    private boolean[] fEnabledRecognizers;
    private static final List<CSRecognizerInfo> ALL_CS_RECOGNIZERS;

    public CharsetDetector setDeclaredEncoding(String string) {
        this.fDeclaredEncoding = string;
        return this;
    }

    public CharsetDetector setText(byte[] byArray) {
        this.fRawInput = byArray;
        this.fRawLength = byArray.length;
        return this;
    }

    public CharsetDetector setText(InputStream inputStream) throws IOException {
        int n2;
        this.fInputStream = inputStream;
        this.fInputStream.mark(8000);
        this.fRawInput = new byte[8000];
        this.fRawLength = 0;
        for (int i2 = 8000; i2 > 0 && (n2 = this.fInputStream.read(this.fRawInput, this.fRawLength, i2)) > 0; i2 -= n2) {
            this.fRawLength += n2;
        }
        this.fInputStream.reset();
        return this;
    }

    public CharsetMatch detect() {
        CharsetMatch[] charsetMatchArray = this.detectAll();
        if (charsetMatchArray == null || charsetMatchArray.length == 0) {
            return null;
        }
        return charsetMatchArray[0];
    }

    public CharsetMatch[] detectAll() {
        ArrayList<CharsetMatch> arrayList = new ArrayList<CharsetMatch>();
        this.MungeInput();
        for (int i2 = 0; i2 < ALL_CS_RECOGNIZERS.size(); ++i2) {
            CharsetMatch charsetMatch;
            boolean bl2;
            CSRecognizerInfo cSRecognizerInfo = ALL_CS_RECOGNIZERS.get(i2);
            boolean bl3 = bl2 = this.fEnabledRecognizers != null ? this.fEnabledRecognizers[i2] : cSRecognizerInfo.isDefaultEnabled;
            if (!bl2 || (charsetMatch = cSRecognizerInfo.recognizer.match(this)) == null) continue;
            arrayList.add(charsetMatch);
        }
        Collections.sort(arrayList);
        Collections.reverse(arrayList);
        CharsetMatch[] charsetMatchArray = new CharsetMatch[arrayList.size()];
        charsetMatchArray = arrayList.toArray(charsetMatchArray);
        return charsetMatchArray;
    }

    public Reader getReader(InputStream inputStream, String string) {
        this.fDeclaredEncoding = string;
        try {
            this.setText(inputStream);
            CharsetMatch charsetMatch = this.detect();
            if (charsetMatch == null) {
                return null;
            }
            return charsetMatch.getReader();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String getString(byte[] byArray, String string) {
        this.fDeclaredEncoding = string;
        try {
            this.setText(byArray);
            CharsetMatch charsetMatch = this.detect();
            if (charsetMatch == null) {
                return null;
            }
            return charsetMatch.getString(-1);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String[] getAllDetectableCharsets() {
        String[] stringArray = new String[ALL_CS_RECOGNIZERS.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = CharsetDetector.ALL_CS_RECOGNIZERS.get((int)i2).recognizer.getName();
        }
        return stringArray;
    }

    public boolean inputFilterEnabled() {
        return this.fStripTags;
    }

    public boolean enableInputFilter(boolean bl2) {
        boolean bl3 = this.fStripTags;
        this.fStripTags = bl2;
        return bl3;
    }

    private void MungeInput() {
        int n2;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        int n5 = 0;
        int n6 = 0;
        if (this.fStripTags) {
            for (n3 = 0; n3 < this.fRawLength && n4 < this.fInputBytes.length; ++n3) {
                byte by2 = this.fRawInput[n3];
                if (by2 == 60) {
                    if (bl2) {
                        ++n6;
                    }
                    bl2 = true;
                    ++n5;
                }
                if (!bl2) {
                    this.fInputBytes[n4++] = by2;
                }
                if (by2 != 62) continue;
                bl2 = false;
            }
            this.fInputLen = n4;
        }
        if (n5 < 5 || n5 / 5 < n6 || this.fInputLen < 100 && this.fRawLength > 600) {
            n2 = this.fRawLength;
            if (n2 > 8000) {
                n2 = 8000;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                this.fInputBytes[n3] = this.fRawInput[n3];
            }
            this.fInputLen = n3;
        }
        Arrays.fill(this.fByteStats, (short)0);
        for (n3 = 0; n3 < this.fInputLen; ++n3) {
            int n7 = n2 = this.fInputBytes[n3] & 0xFF;
            this.fByteStats[n7] = (short)(this.fByteStats[n7] + 1);
        }
        this.fC1Bytes = false;
        for (n2 = 128; n2 <= 159; ++n2) {
            if (this.fByteStats[n2] == 0) continue;
            this.fC1Bytes = true;
            break;
        }
    }

    @Deprecated
    public String[] getDetectableCharsets() {
        ArrayList<String> arrayList = new ArrayList<String>(ALL_CS_RECOGNIZERS.size());
        for (int i2 = 0; i2 < ALL_CS_RECOGNIZERS.size(); ++i2) {
            boolean bl2;
            CSRecognizerInfo cSRecognizerInfo = ALL_CS_RECOGNIZERS.get(i2);
            boolean bl3 = bl2 = this.fEnabledRecognizers == null ? cSRecognizerInfo.isDefaultEnabled : this.fEnabledRecognizers[i2];
            if (!bl2) continue;
            arrayList.add(cSRecognizerInfo.recognizer.getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Deprecated
    public CharsetDetector setDetectableCharset(String string, boolean bl2) {
        int n2;
        int n3 = -1;
        boolean bl3 = false;
        for (n2 = 0; n2 < ALL_CS_RECOGNIZERS.size(); ++n2) {
            CSRecognizerInfo cSRecognizerInfo = ALL_CS_RECOGNIZERS.get(n2);
            if (!cSRecognizerInfo.recognizer.getName().equals(string)) continue;
            n3 = n2;
            bl3 = cSRecognizerInfo.isDefaultEnabled == bl2;
            break;
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Invalid encoding: \"" + string + "\"");
        }
        if (this.fEnabledRecognizers == null && !bl3) {
            this.fEnabledRecognizers = new boolean[ALL_CS_RECOGNIZERS.size()];
            for (n2 = 0; n2 < ALL_CS_RECOGNIZERS.size(); ++n2) {
                this.fEnabledRecognizers[n2] = CharsetDetector.ALL_CS_RECOGNIZERS.get((int)n2).isDefaultEnabled;
            }
        }
        if (this.fEnabledRecognizers != null) {
            this.fEnabledRecognizers[n3] = bl2;
        }
        return this;
    }

    static {
        ArrayList<CSRecognizerInfo> arrayList = new ArrayList<CSRecognizerInfo>();
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_UTF8(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_Unicode.CharsetRecog_UTF_16_BE(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_Unicode.CharsetRecog_UTF_16_LE(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_Unicode.CharsetRecog_UTF_32_BE(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_Unicode.CharsetRecog_UTF_32_LE(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_mbcs.CharsetRecog_sjis(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_2022.CharsetRecog_2022JP(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_2022.CharsetRecog_2022CN(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_2022.CharsetRecog_2022KR(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_mbcs.CharsetRecog_gb_18030(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_mbcs.CharsetRecog_euc.CharsetRecog_euc_jp(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_mbcs.CharsetRecog_euc.CharsetRecog_euc_kr(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_mbcs.CharsetRecog_big5(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_8859_1(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_8859_2(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_8859_5_ru(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_8859_6_ar(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_8859_7_el(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_8859_8_I_he(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_8859_8_he(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_windows_1251(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_windows_1256(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_KOI8_R(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_8859_9_tr(), true));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_IBM424_he_rtl(), false));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_IBM424_he_ltr(), false));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_IBM420_ar_rtl(), false));
        arrayList.add(new CSRecognizerInfo(new CharsetRecog_sbcs.CharsetRecog_IBM420_ar_ltr(), false));
        ALL_CS_RECOGNIZERS = Collections.unmodifiableList(arrayList);
    }

    private static class CSRecognizerInfo {
        CharsetRecognizer recognizer;
        boolean isDefaultEnabled;

        CSRecognizerInfo(CharsetRecognizer charsetRecognizer, boolean bl2) {
            this.recognizer = charsetRecognizer;
            this.isDefaultEnabled = bl2;
        }
    }
}

