/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Norm2AllModes;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Normalizer2Impl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer2;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSetIterator;

public final class CanonicalIterator {
    private static int PERMUTE_DEPTH_LIMIT = 8;
    private static boolean PROGRESS = false;
    private static boolean SKIP_ZEROS = true;
    private final Normalizer2 nfd;
    private final Normalizer2Impl nfcImpl;
    private String source;
    private boolean done;
    private String[][] pieces;
    private int[] current;
    private transient StringBuilder buffer = new StringBuilder();
    private static final Set<String> SET_WITH_NULL_STRING = new HashSet<String>();

    public CanonicalIterator(String string) {
        Norm2AllModes norm2AllModes = Norm2AllModes.getNFCInstance();
        this.nfd = norm2AllModes.decomp;
        this.nfcImpl = norm2AllModes.impl.ensureCanonIterData();
        this.setSource(string);
    }

    public String getSource() {
        return this.source;
    }

    public void reset() {
        this.done = false;
        for (int i2 = 0; i2 < this.current.length; ++i2) {
            this.current[i2] = 0;
        }
    }

    public String next() {
        if (this.done) {
            return null;
        }
        this.buffer.setLength(0);
        for (int i2 = 0; i2 < this.pieces.length; ++i2) {
            this.buffer.append(this.pieces[i2][this.current[i2]]);
        }
        String string = this.buffer.toString();
        int n2 = this.current.length - 1;
        while (true) {
            if (n2 < 0) {
                this.done = true;
                break;
            }
            int n3 = n2;
            this.current[n3] = this.current[n3] + 1;
            if (this.current[n2] < this.pieces[n2].length) break;
            this.current[n2] = 0;
            --n2;
        }
        return string;
    }

    public void setSource(String string) {
        int n2;
        int n3;
        this.source = this.nfd.normalize(string);
        this.done = false;
        if (string.length() == 0) {
            this.pieces = new String[1][];
            this.current = new int[1];
            this.pieces[0] = new String[]{""};
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = 0;
        for (n2 = UTF16.findOffsetFromCodePoint(this.source, 1); n2 < this.source.length(); n2 += Character.charCount(n3)) {
            n3 = this.source.codePointAt(n2);
            if (!this.nfcImpl.isCanonSegmentStarter(n3)) continue;
            arrayList.add(this.source.substring(n4, n2));
            n4 = n2;
        }
        arrayList.add(this.source.substring(n4, n2));
        this.pieces = new String[arrayList.size()][];
        this.current = new int[arrayList.size()];
        for (n2 = 0; n2 < this.pieces.length; ++n2) {
            if (PROGRESS) {
                System.out.println("SEGMENT");
            }
            this.pieces[n2] = this.getEquivalents((String)arrayList.get(n2));
        }
    }

    @Deprecated
    public static void permute(String string, boolean bl2, Set<String> set) {
        CanonicalIterator.permute(string, bl2, set, 0);
    }

    @Deprecated
    private static void permute(String string, boolean bl2, Set<String> set, int n2) {
        int n3;
        if (n2 > PERMUTE_DEPTH_LIMIT) {
            throw new UnsupportedOperationException("Stack too deep:" + n2);
        }
        if (string.length() <= 2 && UTF16.countCodePoint(string) <= 1) {
            set.add(string);
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < string.length(); i2 += UTF16.getCharCount(n3)) {
            n3 = UTF16.charAt(string, i2);
            if (bl2 && i2 != 0 && UCharacter.getCombiningClass(n3) == 0) continue;
            hashSet.clear();
            CanonicalIterator.permute(string.substring(0, i2) + string.substring(i2 + UTF16.getCharCount(n3)), bl2, hashSet, n2 + 1);
            String string2 = UTF16.valueOf(string, i2);
            for (String string3 : hashSet) {
                String string4 = string2 + string3;
                set.add(string4);
            }
        }
    }

    private String[] getEquivalents(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Set<String> set = this.getEquivalents2(string);
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String stringArray2 : set) {
            hashSet2.clear();
            CanonicalIterator.permute(stringArray2, SKIP_ZEROS, hashSet2);
            for (String string2 : hashSet2) {
                if (Normalizer.compare(string2, string, 0) == 0) {
                    if (PROGRESS) {
                        System.out.println("Adding Permutation: " + Utility.hex(string2));
                    }
                    hashSet.add(string2);
                    continue;
                }
                if (!PROGRESS) continue;
                System.out.println("-Skipping Permutation: " + Utility.hex(string2));
            }
        }
        String[] stringArray = new String[hashSet.size()];
        hashSet.toArray(stringArray);
        return stringArray;
    }

    private Set<String> getEquivalents2(String string) {
        int n2;
        HashSet<String> hashSet = new HashSet<String>();
        if (PROGRESS) {
            System.out.println("Adding: " + Utility.hex(string));
        }
        hashSet.add(string);
        StringBuffer stringBuffer = new StringBuffer();
        UnicodeSet unicodeSet = new UnicodeSet();
        for (int i2 = 0; i2 < string.length(); i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            if (!this.nfcImpl.getCanonStartSet(n2, unicodeSet)) continue;
            UnicodeSetIterator unicodeSetIterator = new UnicodeSetIterator(unicodeSet);
            while (unicodeSetIterator.next()) {
                int n3 = unicodeSetIterator.codepoint;
                Set<String> set = this.extract(n3, string, i2, stringBuffer);
                if (set == null) continue;
                String string2 = string.substring(0, i2);
                string2 = string2 + UTF16.valueOf(n3);
                for (String string3 : set) {
                    hashSet.add(string2 + string3);
                }
            }
        }
        return hashSet;
    }

    private Set<String> extract(int n2, String string, int n3, StringBuffer stringBuffer) {
        int n4;
        String string2;
        if (PROGRESS) {
            System.out.println(" extract: " + Utility.hex(UTF16.valueOf(n2)) + ", " + Utility.hex(string.substring(n3)));
        }
        if ((string2 = this.nfcImpl.getDecomposition(n2)) == null) {
            string2 = UTF16.valueOf(n2);
        }
        boolean bl2 = false;
        int n5 = 0;
        int n6 = UTF16.charAt(string2, 0);
        n5 += UTF16.getCharCount(n6);
        stringBuffer.setLength(0);
        for (int i2 = n3; i2 < string.length(); i2 += UTF16.getCharCount(n4)) {
            n4 = UTF16.charAt(string, i2);
            if (n4 == n6) {
                if (PROGRESS) {
                    System.out.println("  matches: " + Utility.hex(UTF16.valueOf(n4)));
                }
                if (n5 == string2.length()) {
                    stringBuffer.append(string.substring(i2 + UTF16.getCharCount(n4)));
                    bl2 = true;
                    break;
                }
                n6 = UTF16.charAt(string2, n5);
                n5 += UTF16.getCharCount(n6);
                continue;
            }
            if (PROGRESS) {
                System.out.println("  buffer: " + Utility.hex(UTF16.valueOf(n4)));
            }
            UTF16.append(stringBuffer, n4);
        }
        if (!bl2) {
            return null;
        }
        if (PROGRESS) {
            System.out.println("Matches");
        }
        if (stringBuffer.length() == 0) {
            return SET_WITH_NULL_STRING;
        }
        String string3 = stringBuffer.toString();
        if (0 != Normalizer.compare(UTF16.valueOf(n2) + string3, string.substring(n3), 0)) {
            return null;
        }
        return this.getEquivalents2(string3);
    }

    static {
        SET_WITH_NULL_STRING.add("");
    }
}

