/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Bidi;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.BidiRun;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;

final class BidiWriter {
    static final char LRM_CHAR = '\u200e';
    static final char RLM_CHAR = '\u200f';
    static final int MASK_R_AL = 8194;

    BidiWriter() {
    }

    private static boolean IsCombining(int n2) {
        return (1 << n2 & 0x1C0) != 0;
    }

    private static String doWriteForward(String string, int n2) {
        switch (n2 & 0xA) {
            case 0: {
                return string;
            }
            case 2: {
                int n3;
                StringBuffer stringBuffer = new StringBuffer(string.length());
                int n4 = 0;
                do {
                    n3 = UTF16.charAt(string, n4);
                    UTF16.append(stringBuffer, UCharacter.getMirror(n3));
                } while ((n4 += UTF16.getCharCount(n3)) < string.length());
                return stringBuffer.toString();
            }
            case 8: {
                StringBuilder stringBuilder = new StringBuilder(string.length());
                int n5 = 0;
                do {
                    char c2;
                    if (Bidi.IsBidiControlChar(c2 = string.charAt(n5++))) continue;
                    stringBuilder.append(c2);
                } while (n5 < string.length());
                return stringBuilder.toString();
            }
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n6 = 0;
        do {
            int n7 = UTF16.charAt(string, n6);
            n6 += UTF16.getCharCount(n7);
            if (Bidi.IsBidiControlChar(n7)) continue;
            UTF16.append(stringBuffer, UCharacter.getMirror(n7));
        } while (n6 < string.length());
        return stringBuffer.toString();
    }

    private static String doWriteForward(char[] cArray, int n2, int n3, int n4) {
        return BidiWriter.doWriteForward(new String(cArray, n2, n3 - n2), n4);
    }

    static String writeReverse(String string, int n2) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        switch (n2 & 0xB) {
            case 0: {
                int n3 = string.length();
                do {
                    int n4 = n3;
                    n3 -= UTF16.getCharCount(UTF16.charAt(string, n3 - 1));
                    stringBuffer.append(string.substring(n3, n4));
                } while (n3 > 0);
                break;
            }
            case 1: {
                int n5 = string.length();
                do {
                    int n6;
                    int n7 = n5;
                    while ((n5 -= UTF16.getCharCount(n6 = UTF16.charAt(string, n5 - 1))) > 0 && BidiWriter.IsCombining(UCharacter.getType(n6))) {
                    }
                    stringBuffer.append(string.substring(n5, n7));
                } while (n5 > 0);
                break;
            }
            default: {
                int n8 = string.length();
                do {
                    int n9 = n8;
                    int n10 = UTF16.charAt(string, n8 - 1);
                    n8 -= UTF16.getCharCount(n10);
                    if ((n2 & 1) != 0) {
                        while (n8 > 0 && BidiWriter.IsCombining(UCharacter.getType(n10))) {
                            n10 = UTF16.charAt(string, n8 - 1);
                            n8 -= UTF16.getCharCount(n10);
                        }
                    }
                    if ((n2 & 8) != 0 && Bidi.IsBidiControlChar(n10)) continue;
                    int n11 = n8;
                    if ((n2 & 2) != 0) {
                        n10 = UCharacter.getMirror(n10);
                        UTF16.append(stringBuffer, n10);
                        n11 += UTF16.getCharCount(n10);
                    }
                    stringBuffer.append(string.substring(n11, n9));
                } while (n8 > 0);
            }
        }
        return stringBuffer.toString();
    }

    static String doWriteReverse(char[] cArray, int n2, int n3, int n4) {
        return BidiWriter.writeReverse(new String(cArray, n2, n3 - n2), n4);
    }

    static String writeReordered(Bidi bidi, int n2) {
        char[] cArray = bidi.text;
        int n3 = bidi.countRuns();
        if ((bidi.reorderingOptions & 1) != 0) {
            n2 |= 4;
            n2 &= 0xFFFFFFF7;
        }
        if ((bidi.reorderingOptions & 2) != 0) {
            n2 |= 8;
            n2 &= 0xFFFFFFFB;
        }
        if (bidi.reorderingMode != 4 && bidi.reorderingMode != 5 && bidi.reorderingMode != 6 && bidi.reorderingMode != 3) {
            n2 &= 0xFFFFFFFB;
        }
        StringBuilder stringBuilder = new StringBuilder((n2 & 4) != 0 ? bidi.length * 2 : bidi.length);
        if ((n2 & 0x10) == 0) {
            if ((n2 & 4) == 0) {
                for (int i2 = 0; i2 < n3; ++i2) {
                    BidiRun bidiRun = bidi.getVisualRun(i2);
                    if (bidiRun.isEvenRun()) {
                        stringBuilder.append(BidiWriter.doWriteForward(cArray, bidiRun.start, bidiRun.limit, n2 & 0xFFFFFFFD));
                        continue;
                    }
                    stringBuilder.append(BidiWriter.doWriteReverse(cArray, bidiRun.start, bidiRun.limit, n2));
                }
            } else {
                byte[] byArray = bidi.dirProps;
                for (int i3 = 0; i3 < n3; ++i3) {
                    char c2;
                    BidiRun bidiRun = bidi.getVisualRun(i3);
                    int n4 = 0;
                    n4 = bidi.runs[i3].insertRemove;
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (bidiRun.isEvenRun()) {
                        if (bidi.isInverse() && byArray[bidiRun.start] != 0) {
                            n4 |= 1;
                        }
                        if ((c2 = (n4 & 1) != 0 ? (char)'\u200e' : ((n4 & 4) != 0 ? (char)'\u200f' : '\u0000')) != '\u0000') {
                            stringBuilder.append(c2);
                        }
                        stringBuilder.append(BidiWriter.doWriteForward(cArray, bidiRun.start, bidiRun.limit, n2 & 0xFFFFFFFD));
                        if (bidi.isInverse() && byArray[bidiRun.limit - 1] != 0) {
                            n4 |= 2;
                        }
                        if ((c2 = (n4 & 2) != 0 ? (char)'\u200e' : ((n4 & 8) != 0 ? (char)'\u200f' : '\u0000')) == '\u0000') continue;
                        stringBuilder.append(c2);
                        continue;
                    }
                    if (bidi.isInverse() && !bidi.testDirPropFlagAt(8194, bidiRun.limit - 1)) {
                        n4 |= 4;
                    }
                    if ((c2 = (n4 & 1) != 0 ? (char)'\u200e' : ((n4 & 4) != 0 ? (char)'\u200f' : '\u0000')) != '\u0000') {
                        stringBuilder.append(c2);
                    }
                    stringBuilder.append(BidiWriter.doWriteReverse(cArray, bidiRun.start, bidiRun.limit, n2));
                    if (bidi.isInverse() && (0x2002 & Bidi.DirPropFlag(byArray[bidiRun.start])) == 0) {
                        n4 |= 8;
                    }
                    if ((c2 = (n4 & 2) != 0 ? (char)'\u200e' : ((n4 & 8) != 0 ? (char)'\u200f' : '\u0000')) == '\u0000') continue;
                    stringBuilder.append(c2);
                }
            }
        } else if ((n2 & 4) == 0) {
            int n5 = n3;
            while (--n5 >= 0) {
                BidiRun bidiRun = bidi.getVisualRun(n5);
                if (bidiRun.isEvenRun()) {
                    stringBuilder.append(BidiWriter.doWriteReverse(cArray, bidiRun.start, bidiRun.limit, n2 & 0xFFFFFFFD));
                    continue;
                }
                stringBuilder.append(BidiWriter.doWriteForward(cArray, bidiRun.start, bidiRun.limit, n2));
            }
        } else {
            byte[] byArray = bidi.dirProps;
            int n6 = n3;
            while (--n6 >= 0) {
                BidiRun bidiRun = bidi.getVisualRun(n6);
                if (bidiRun.isEvenRun()) {
                    if (byArray[bidiRun.limit - 1] != 0) {
                        stringBuilder.append('\u200e');
                    }
                    stringBuilder.append(BidiWriter.doWriteReverse(cArray, bidiRun.start, bidiRun.limit, n2 & 0xFFFFFFFD));
                    if (byArray[bidiRun.start] == 0) continue;
                    stringBuilder.append('\u200e');
                    continue;
                }
                if ((0x2002 & Bidi.DirPropFlag(byArray[bidiRun.start])) == 0) {
                    stringBuilder.append('\u200f');
                }
                stringBuilder.append(BidiWriter.doWriteForward(cArray, bidiRun.start, bidiRun.limit, n2));
                if ((0x2002 & Bidi.DirPropFlag(byArray[bidiRun.limit - 1])) != 0) continue;
                stringBuilder.append('\u200f');
            }
        }
        return stringBuilder.toString();
    }
}

