/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.text;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.concurrent.ConcurrentHashMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UScript;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CompoundTransliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Transliterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.TransliteratorIDParser;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeFilter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

class AnyTransliterator
extends Transliterator {
    static final char TARGET_SEP = '-';
    static final char VARIANT_SEP = '/';
    static final String ANY = "Any";
    static final String NULL_ID = "Null";
    static final String LATIN_PIVOT = "-Latin;Latin-";
    private ConcurrentHashMap<Integer, Transliterator> cache;
    private String target;
    private int targetScript;

    @Override
    protected void handleTransliterate(Replaceable replaceable, Transliterator.Position position, boolean bl2) {
        int n2 = position.start;
        int n3 = position.limit;
        ScriptRunIterator scriptRunIterator = new ScriptRunIterator(replaceable, position.contextStart, position.contextLimit);
        while (scriptRunIterator.next()) {
            if (scriptRunIterator.limit <= n2) continue;
            Transliterator transliterator = this.getTransliterator(scriptRunIterator.scriptCode);
            if (transliterator == null) {
                position.start = scriptRunIterator.limit;
                continue;
            }
            boolean bl3 = bl2 && scriptRunIterator.limit >= n3;
            position.start = Math.max(n2, scriptRunIterator.start);
            int n4 = position.limit = Math.min(n3, scriptRunIterator.limit);
            transliterator.filteredTransliterate(replaceable, position, bl3);
            int n5 = position.limit - n4;
            scriptRunIterator.adjustLimit(n5);
            if (scriptRunIterator.limit < (n3 += n5)) continue;
            break;
        }
        position.limit = n3;
    }

    private AnyTransliterator(String string, String string2, String string3, int n2) {
        super(string, null);
        this.targetScript = n2;
        this.cache = new ConcurrentHashMap();
        this.target = string2;
        if (string3.length() > 0) {
            this.target = string2 + '/' + string3;
        }
    }

    public AnyTransliterator(String string, UnicodeFilter unicodeFilter, String string2, int n2, Transliterator transliterator, ConcurrentHashMap<Integer, Transliterator> concurrentHashMap) {
        super(string, unicodeFilter);
        this.targetScript = n2;
        this.cache = concurrentHashMap;
        this.target = string2;
    }

    private Transliterator getTransliterator(int n2) {
        if (n2 == this.targetScript || n2 == -1) {
            if (this.isWide(this.targetScript)) {
                return null;
            }
            return WidthFix.INSTANCE;
        }
        Integer n3 = n2;
        Object object = this.cache.get(n3);
        if (object == null) {
            String string = UScript.getName(n2);
            String string2 = string + '-' + this.target;
            try {
                object = Transliterator.getInstance(string2, 0);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (object == null) {
                string2 = string + LATIN_PIVOT + this.target;
                try {
                    object = Transliterator.getInstance(string2, 0);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            if (object != null) {
                Object object2;
                if (!this.isWide(this.targetScript)) {
                    object2 = new ArrayList<Transliterator>();
                    object2.add(WidthFix.INSTANCE);
                    object2.add(object);
                    object = new CompoundTransliterator((List<Transliterator>)object2);
                }
                if ((object2 = this.cache.putIfAbsent(n3, (Transliterator)object)) != null) {
                    object = object2;
                }
            } else if (!this.isWide(this.targetScript)) {
                return WidthFix.INSTANCE;
            }
        }
        return object;
    }

    private boolean isWide(int n2) {
        return n2 == 5 || n2 == 17 || n2 == 18 || n2 == 20 || n2 == 22;
    }

    static void register() {
        HashMap hashMap = new HashMap();
        Enumeration<String> enumeration = Transliterator.getAvailableSources();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (string.equalsIgnoreCase(ANY)) continue;
            Enumeration<String> enumeration2 = Transliterator.getAvailableTargets(string);
            while (enumeration2.hasMoreElements()) {
                String string2 = enumeration2.nextElement();
                int n2 = AnyTransliterator.scriptNameToCode(string2);
                if (n2 == -1) continue;
                HashSet<String> hashSet = (HashSet<String>)hashMap.get(string2);
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                    hashMap.put(string2, hashSet);
                }
                Enumeration<String> enumeration3 = Transliterator.getAvailableVariants(string, string2);
                while (enumeration3.hasMoreElements()) {
                    String string3 = enumeration3.nextElement();
                    if (hashSet.contains(string3)) continue;
                    hashSet.add(string3);
                    String string4 = TransliteratorIDParser.STVtoID(ANY, string2, string3);
                    AnyTransliterator anyTransliterator = new AnyTransliterator(string4, string2, string3, n2);
                    Transliterator.registerInstance(anyTransliterator);
                    Transliterator.registerSpecialInverse(string2, NULL_ID, false);
                }
            }
        }
    }

    private static int scriptNameToCode(String string) {
        try {
            int[] nArray = UScript.getCode(string);
            return nArray != null ? nArray[0] : -1;
        }
        catch (MissingResourceException missingResourceException) {
            return -1;
        }
    }

    public Transliterator safeClone() {
        UnicodeFilter unicodeFilter = this.getFilter();
        if (unicodeFilter != null && unicodeFilter instanceof UnicodeSet) {
            unicodeFilter = new UnicodeSet((UnicodeSet)unicodeFilter);
        }
        return new AnyTransliterator(this.getID(), unicodeFilter, this.target, this.targetScript, null, this.cache);
    }

    @Override
    public void addSourceTargetSet(UnicodeSet unicodeSet, UnicodeSet unicodeSet2, UnicodeSet unicodeSet3) {
        UnicodeSet unicodeSet4 = this.getFilterAsUnicodeSet(unicodeSet);
        unicodeSet2.addAll(unicodeSet4);
        if (unicodeSet4.size() != 0) {
            unicodeSet3.addAll(0, 0x10FFFF);
        }
    }

    private static class ScriptRunIterator {
        private Replaceable text;
        private int textStart;
        private int textLimit;
        public int scriptCode;
        public int start;
        public int limit;

        public ScriptRunIterator(Replaceable replaceable, int n2, int n3) {
            this.text = replaceable;
            this.textStart = n2;
            this.textLimit = n3;
            this.limit = n2;
        }

        public boolean next() {
            int n2;
            int n3;
            this.scriptCode = -1;
            this.start = this.limit;
            if (this.start == this.textLimit) {
                return false;
            }
            while (this.start > this.textStart && ((n3 = UScript.getScript(n2 = this.text.char32At(this.start - 1))) == 0 || n3 == 1)) {
                --this.start;
            }
            while (this.limit < this.textLimit) {
                n2 = this.text.char32At(this.limit);
                n3 = UScript.getScript(n2);
                if (n3 != 0 && n3 != 1) {
                    if (this.scriptCode == -1) {
                        this.scriptCode = n3;
                    } else if (n3 != this.scriptCode) break;
                }
                ++this.limit;
            }
            return true;
        }

        public void adjustLimit(int n2) {
            this.limit += n2;
            this.textLimit += n2;
        }
    }

    private static class WidthFix {
        private static final String ID = "[[:dt=Nar:][:dt=Wide:]] nfkd";
        static final Transliterator INSTANCE = Transliterator.getInstance("[[:dt=Nar:][:dt=Wide:]] nfkd");

        private WidthFix() {
        }
    }
}

