/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.number;

import java.text.Format;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedStringBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.ConstantAffixModifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroPropsGenerator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Modifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MultiplierProducer;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Notation;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Precision;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberFormat;

public class ScientificNotation
extends Notation {
    int engineeringInterval;
    boolean requireMinInt;
    int minExponentDigits;
    NumberFormatter.SignDisplay exponentSignDisplay;

    ScientificNotation(int n2, boolean bl2, int n3, NumberFormatter.SignDisplay signDisplay) {
        this.engineeringInterval = n2;
        this.requireMinInt = bl2;
        this.minExponentDigits = n3;
        this.exponentSignDisplay = signDisplay;
    }

    public ScientificNotation withMinExponentDigits(int n2) {
        if (n2 >= 1 && n2 <= 999) {
            ScientificNotation scientificNotation = this.createCopy();
            scientificNotation.minExponentDigits = n2;
            return scientificNotation;
        }
        throw new IllegalArgumentException("Integer digits must be between 1 and 999 (inclusive)");
    }

    public ScientificNotation withExponentSignDisplay(NumberFormatter.SignDisplay signDisplay) {
        ScientificNotation scientificNotation = this.createCopy();
        scientificNotation.exponentSignDisplay = signDisplay;
        return scientificNotation;
    }

    ScientificNotation createCopy() {
        return new ScientificNotation(this.engineeringInterval, this.requireMinInt, this.minExponentDigits, this.exponentSignDisplay);
    }

    MicroPropsGenerator withLocaleData(DecimalFormatSymbols decimalFormatSymbols, boolean bl2, MicroPropsGenerator microPropsGenerator) {
        return new ScientificHandler(this, decimalFormatSymbols, bl2, microPropsGenerator);
    }

    private static class ScientificModifier
    implements Modifier {
        final int exponent;
        final ScientificHandler handler;

        ScientificModifier(int n2, ScientificHandler scientificHandler) {
            this.exponent = n2;
            this.handler = scientificHandler;
        }

        @Override
        public int apply(FormattedStringBuilder formattedStringBuilder, int n2, int n3) {
            return this.handler.doApply(this.exponent, formattedStringBuilder, n3);
        }

        @Override
        public int getPrefixLength() {
            return 0;
        }

        @Override
        public int getCodePointCount() {
            return 999;
        }

        @Override
        public boolean isStrong() {
            return true;
        }

        @Override
        public boolean containsField(Format.Field field) {
            assert (false);
            return false;
        }

        @Override
        public Modifier.Parameters getParameters() {
            return null;
        }

        @Override
        public boolean strictEquals(Modifier modifier) {
            if (!(modifier instanceof ScientificModifier)) {
                return false;
            }
            ScientificModifier scientificModifier = (ScientificModifier)modifier;
            return this.exponent == scientificModifier.exponent;
        }
    }

    private static class ScientificHandler
    implements MicroPropsGenerator,
    Modifier,
    MultiplierProducer {
        final ScientificNotation notation;
        final DecimalFormatSymbols symbols;
        final ScientificModifier[] precomputedMods;
        final MicroPropsGenerator parent;
        int exponent;

        private ScientificHandler(ScientificNotation scientificNotation, DecimalFormatSymbols decimalFormatSymbols, boolean bl2, MicroPropsGenerator microPropsGenerator) {
            this.notation = scientificNotation;
            this.symbols = decimalFormatSymbols;
            this.parent = microPropsGenerator;
            if (bl2) {
                this.precomputedMods = new ScientificModifier[25];
                for (int i2 = -12; i2 <= 12; ++i2) {
                    this.precomputedMods[i2 + 12] = new ScientificModifier(i2, this);
                }
            } else {
                this.precomputedMods = null;
            }
        }

        @Override
        public MicroProps processQuantity(DecimalQuantity decimalQuantity) {
            int n2;
            MicroProps microProps = this.parent.processQuantity(decimalQuantity);
            assert (microProps.rounder != null);
            if (decimalQuantity.isInfinite() || decimalQuantity.isNaN()) {
                microProps.modInner = ConstantAffixModifier.EMPTY;
                return microProps;
            }
            if (decimalQuantity.isZeroish()) {
                if (this.notation.requireMinInt && microProps.rounder instanceof Precision.SignificantRounderImpl) {
                    ((Precision.SignificantRounderImpl)microProps.rounder).apply(decimalQuantity, this.notation.engineeringInterval);
                    n2 = 0;
                } else {
                    microProps.rounder.apply(decimalQuantity);
                    n2 = 0;
                }
            } else {
                n2 = -microProps.rounder.chooseMultiplierAndApply(decimalQuantity, this);
            }
            if (this.precomputedMods != null && n2 >= -12 && n2 <= 12) {
                microProps.modInner = this.precomputedMods[n2 + 12];
            } else if (this.precomputedMods != null) {
                microProps.modInner = new ScientificModifier(n2, this);
            } else {
                this.exponent = n2;
                microProps.modInner = this;
            }
            decimalQuantity.adjustExponent(n2);
            microProps.rounder = null;
            return microProps;
        }

        @Override
        public int getMultiplier(int n2) {
            int n3 = this.notation.engineeringInterval;
            int n4 = this.notation.requireMinInt ? n3 : (n3 <= 1 ? 1 : (n2 % n3 + n3) % n3 + 1);
            return n4 - n2 - 1;
        }

        @Override
        public int getPrefixLength() {
            return 0;
        }

        @Override
        public int getCodePointCount() {
            return 999;
        }

        @Override
        public boolean isStrong() {
            return true;
        }

        @Override
        public boolean containsField(Format.Field field) {
            assert (false);
            return false;
        }

        @Override
        public Modifier.Parameters getParameters() {
            assert (false);
            return null;
        }

        @Override
        public boolean strictEquals(Modifier modifier) {
            assert (false);
            return false;
        }

        @Override
        public int apply(FormattedStringBuilder formattedStringBuilder, int n2, int n3) {
            return this.doApply(this.exponent, formattedStringBuilder, n3);
        }

        private int doApply(int n2, FormattedStringBuilder formattedStringBuilder, int n3) {
            int n4 = n3;
            n4 += formattedStringBuilder.insert(n4, this.symbols.getExponentSeparator(), NumberFormat.Field.EXPONENT_SYMBOL);
            if (n2 < 0 && this.notation.exponentSignDisplay != NumberFormatter.SignDisplay.NEVER) {
                n4 += formattedStringBuilder.insert(n4, this.symbols.getMinusSignString(), NumberFormat.Field.EXPONENT_SIGN);
            } else if (n2 >= 0 && this.notation.exponentSignDisplay == NumberFormatter.SignDisplay.ALWAYS) {
                n4 += formattedStringBuilder.insert(n4, this.symbols.getPlusSignString(), NumberFormat.Field.EXPONENT_SIGN);
            }
            int n5 = Math.abs(n2);
            for (int i2 = 0; i2 < this.notation.minExponentDigits || n5 > 0; ++i2, n5 /= 10) {
                int n6 = n5 % 10;
                String string = this.symbols.getDigitStringsLocal()[n6];
                n4 += formattedStringBuilder.insert(n4 - i2, string, NumberFormat.Field.EXPONENT);
            }
            return n4 - n3;
        }
    }
}

