/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.number;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Set;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CacheBase;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SoftCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StringSegment;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MacroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.RoundingUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.CompactNotation;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.FractionPrecision;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.IntegerWidth;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Notation;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Precision;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Scale;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.ScientificNotation;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.SimpleNotation;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.SkeletonSyntaxException;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.UnlocalizedNumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberingSystem;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BytesTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CharsTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CharsTrieBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Currency;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MeasureUnit;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.NoUnit;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.StringTrieBuilder;

class NumberSkeletonImpl {
    static final char WILDCARD_CHAR = '*';
    static final char ALT_WILDCARD_CHAR = '+';
    static final StemEnum[] STEM_ENUM_VALUES = StemEnum.values();
    static final String SERIALIZED_STEM_TRIE = NumberSkeletonImpl.buildStemTrie();
    private static final CacheBase<String, UnlocalizedNumberFormatter, Void> cache = new SoftCache<String, UnlocalizedNumberFormatter, Void>(){

        @Override
        protected UnlocalizedNumberFormatter createInstance(String string, Void void_) {
            return NumberSkeletonImpl.create(string);
        }
    };

    NumberSkeletonImpl() {
    }

    static boolean isWildcardChar(char c2) {
        return c2 == '*' || c2 == '+';
    }

    static String buildStemTrie() {
        CharsTrieBuilder charsTrieBuilder = new CharsTrieBuilder();
        charsTrieBuilder.add("compact-short", StemEnum.STEM_COMPACT_SHORT.ordinal());
        charsTrieBuilder.add("compact-long", StemEnum.STEM_COMPACT_LONG.ordinal());
        charsTrieBuilder.add("scientific", StemEnum.STEM_SCIENTIFIC.ordinal());
        charsTrieBuilder.add("engineering", StemEnum.STEM_ENGINEERING.ordinal());
        charsTrieBuilder.add("notation-simple", StemEnum.STEM_NOTATION_SIMPLE.ordinal());
        charsTrieBuilder.add("base-unit", StemEnum.STEM_BASE_UNIT.ordinal());
        charsTrieBuilder.add("percent", StemEnum.STEM_PERCENT.ordinal());
        charsTrieBuilder.add("permille", StemEnum.STEM_PERMILLE.ordinal());
        charsTrieBuilder.add("precision-integer", StemEnum.STEM_PRECISION_INTEGER.ordinal());
        charsTrieBuilder.add("precision-unlimited", StemEnum.STEM_PRECISION_UNLIMITED.ordinal());
        charsTrieBuilder.add("precision-currency-standard", StemEnum.STEM_PRECISION_CURRENCY_STANDARD.ordinal());
        charsTrieBuilder.add("precision-currency-cash", StemEnum.STEM_PRECISION_CURRENCY_CASH.ordinal());
        charsTrieBuilder.add("rounding-mode-ceiling", StemEnum.STEM_ROUNDING_MODE_CEILING.ordinal());
        charsTrieBuilder.add("rounding-mode-floor", StemEnum.STEM_ROUNDING_MODE_FLOOR.ordinal());
        charsTrieBuilder.add("rounding-mode-down", StemEnum.STEM_ROUNDING_MODE_DOWN.ordinal());
        charsTrieBuilder.add("rounding-mode-up", StemEnum.STEM_ROUNDING_MODE_UP.ordinal());
        charsTrieBuilder.add("rounding-mode-half-even", StemEnum.STEM_ROUNDING_MODE_HALF_EVEN.ordinal());
        charsTrieBuilder.add("rounding-mode-half-down", StemEnum.STEM_ROUNDING_MODE_HALF_DOWN.ordinal());
        charsTrieBuilder.add("rounding-mode-half-up", StemEnum.STEM_ROUNDING_MODE_HALF_UP.ordinal());
        charsTrieBuilder.add("rounding-mode-unnecessary", StemEnum.STEM_ROUNDING_MODE_UNNECESSARY.ordinal());
        charsTrieBuilder.add("integer-width-trunc", StemEnum.STEM_INTEGER_WIDTH_TRUNC.ordinal());
        charsTrieBuilder.add("group-off", StemEnum.STEM_GROUP_OFF.ordinal());
        charsTrieBuilder.add("group-min2", StemEnum.STEM_GROUP_MIN2.ordinal());
        charsTrieBuilder.add("group-auto", StemEnum.STEM_GROUP_AUTO.ordinal());
        charsTrieBuilder.add("group-on-aligned", StemEnum.STEM_GROUP_ON_ALIGNED.ordinal());
        charsTrieBuilder.add("group-thousands", StemEnum.STEM_GROUP_THOUSANDS.ordinal());
        charsTrieBuilder.add("latin", StemEnum.STEM_LATIN.ordinal());
        charsTrieBuilder.add("unit-width-narrow", StemEnum.STEM_UNIT_WIDTH_NARROW.ordinal());
        charsTrieBuilder.add("unit-width-short", StemEnum.STEM_UNIT_WIDTH_SHORT.ordinal());
        charsTrieBuilder.add("unit-width-full-name", StemEnum.STEM_UNIT_WIDTH_FULL_NAME.ordinal());
        charsTrieBuilder.add("unit-width-iso-code", StemEnum.STEM_UNIT_WIDTH_ISO_CODE.ordinal());
        charsTrieBuilder.add("unit-width-formal", StemEnum.STEM_UNIT_WIDTH_FORMAL.ordinal());
        charsTrieBuilder.add("unit-width-variant", StemEnum.STEM_UNIT_WIDTH_VARIANT.ordinal());
        charsTrieBuilder.add("unit-width-hidden", StemEnum.STEM_UNIT_WIDTH_HIDDEN.ordinal());
        charsTrieBuilder.add("sign-auto", StemEnum.STEM_SIGN_AUTO.ordinal());
        charsTrieBuilder.add("sign-always", StemEnum.STEM_SIGN_ALWAYS.ordinal());
        charsTrieBuilder.add("sign-never", StemEnum.STEM_SIGN_NEVER.ordinal());
        charsTrieBuilder.add("sign-accounting", StemEnum.STEM_SIGN_ACCOUNTING.ordinal());
        charsTrieBuilder.add("sign-accounting-always", StemEnum.STEM_SIGN_ACCOUNTING_ALWAYS.ordinal());
        charsTrieBuilder.add("sign-except-zero", StemEnum.STEM_SIGN_EXCEPT_ZERO.ordinal());
        charsTrieBuilder.add("sign-accounting-except-zero", StemEnum.STEM_SIGN_ACCOUNTING_EXCEPT_ZERO.ordinal());
        charsTrieBuilder.add("sign-negative", StemEnum.STEM_SIGN_NEGATIVE.ordinal());
        charsTrieBuilder.add("sign-accounting-negative", StemEnum.STEM_SIGN_ACCOUNTING_NEGATIVE.ordinal());
        charsTrieBuilder.add("decimal-auto", StemEnum.STEM_DECIMAL_AUTO.ordinal());
        charsTrieBuilder.add("decimal-always", StemEnum.STEM_DECIMAL_ALWAYS.ordinal());
        charsTrieBuilder.add("precision-increment", StemEnum.STEM_PRECISION_INCREMENT.ordinal());
        charsTrieBuilder.add("measure-unit", StemEnum.STEM_MEASURE_UNIT.ordinal());
        charsTrieBuilder.add("per-measure-unit", StemEnum.STEM_PER_MEASURE_UNIT.ordinal());
        charsTrieBuilder.add("unit", StemEnum.STEM_UNIT.ordinal());
        charsTrieBuilder.add("usage", StemEnum.STEM_UNIT_USAGE.ordinal());
        charsTrieBuilder.add("currency", StemEnum.STEM_CURRENCY.ordinal());
        charsTrieBuilder.add("integer-width", StemEnum.STEM_INTEGER_WIDTH.ordinal());
        charsTrieBuilder.add("numbering-system", StemEnum.STEM_NUMBERING_SYSTEM.ordinal());
        charsTrieBuilder.add("scale", StemEnum.STEM_SCALE.ordinal());
        charsTrieBuilder.add("K", StemEnum.STEM_COMPACT_SHORT.ordinal());
        charsTrieBuilder.add("KK", StemEnum.STEM_COMPACT_LONG.ordinal());
        charsTrieBuilder.add("%", StemEnum.STEM_PERCENT.ordinal());
        charsTrieBuilder.add("%x100", StemEnum.STEM_PERCENT_100.ordinal());
        charsTrieBuilder.add(",_", StemEnum.STEM_GROUP_OFF.ordinal());
        charsTrieBuilder.add(",?", StemEnum.STEM_GROUP_MIN2.ordinal());
        charsTrieBuilder.add(",!", StemEnum.STEM_GROUP_ON_ALIGNED.ordinal());
        charsTrieBuilder.add("+!", StemEnum.STEM_SIGN_ALWAYS.ordinal());
        charsTrieBuilder.add("+_", StemEnum.STEM_SIGN_NEVER.ordinal());
        charsTrieBuilder.add("()", StemEnum.STEM_SIGN_ACCOUNTING.ordinal());
        charsTrieBuilder.add("()!", StemEnum.STEM_SIGN_ACCOUNTING_ALWAYS.ordinal());
        charsTrieBuilder.add("+?", StemEnum.STEM_SIGN_EXCEPT_ZERO.ordinal());
        charsTrieBuilder.add("()?", StemEnum.STEM_SIGN_ACCOUNTING_EXCEPT_ZERO.ordinal());
        charsTrieBuilder.add("+-", StemEnum.STEM_SIGN_NEGATIVE.ordinal());
        charsTrieBuilder.add("()-", StemEnum.STEM_SIGN_ACCOUNTING_NEGATIVE.ordinal());
        return charsTrieBuilder.buildCharSequence(StringTrieBuilder.Option.FAST).toString();
    }

    public static UnlocalizedNumberFormatter getOrCreate(String string) {
        return cache.getInstance(string, null);
    }

    public static UnlocalizedNumberFormatter create(String string) {
        MacroProps macroProps = NumberSkeletonImpl.parseSkeleton(string);
        return (UnlocalizedNumberFormatter)NumberFormatter.with().macros(macroProps);
    }

    public static String generate(MacroProps macroProps) {
        StringBuilder stringBuilder = new StringBuilder();
        NumberSkeletonImpl.generateSkeleton(macroProps, stringBuilder);
        return stringBuilder.toString();
    }

    private static MacroProps parseSkeleton(String string) {
        string = string + " ";
        MacroProps macroProps = new MacroProps();
        StringSegment stringSegment = new StringSegment(string, false);
        CharsTrie charsTrie = new CharsTrie(SERIALIZED_STEM_TRIE, 0);
        ParseState parseState = ParseState.STATE_NULL;
        int n2 = 0;
        while (n2 < stringSegment.length()) {
            boolean bl2;
            int n3 = stringSegment.codePointAt(n2);
            boolean bl3 = PatternProps.isWhiteSpace(n3);
            boolean bl4 = bl2 = n3 == 47;
            if (!bl3 && !bl2) {
                n2 += Character.charCount(n3);
                if (parseState != ParseState.STATE_NULL) continue;
                charsTrie.nextForCodePoint(n3);
                continue;
            }
            if (n2 != 0) {
                stringSegment.setLength(n2);
                if (parseState == ParseState.STATE_NULL) {
                    parseState = NumberSkeletonImpl.parseStem(stringSegment, charsTrie, macroProps);
                    charsTrie.reset();
                } else {
                    parseState = NumberSkeletonImpl.parseOption(parseState, stringSegment, macroProps);
                }
                stringSegment.resetLength();
                stringSegment.adjustOffset(n2);
                n2 = 0;
            } else if (parseState != ParseState.STATE_NULL) {
                stringSegment.setLength(Character.charCount(n3));
                throw new SkeletonSyntaxException("Unexpected separator character", stringSegment);
            }
            if (bl2 && parseState == ParseState.STATE_NULL) {
                stringSegment.setLength(Character.charCount(n3));
                throw new SkeletonSyntaxException("Unexpected option separator", stringSegment);
            }
            if (bl3 && parseState != ParseState.STATE_NULL) {
                switch (parseState) {
                    case STATE_INCREMENT_PRECISION: 
                    case STATE_MEASURE_UNIT: 
                    case STATE_PER_MEASURE_UNIT: 
                    case STATE_IDENTIFIER_UNIT: 
                    case STATE_UNIT_USAGE: 
                    case STATE_CURRENCY_UNIT: 
                    case STATE_INTEGER_WIDTH: 
                    case STATE_NUMBERING_SYSTEM: 
                    case STATE_SCALE: {
                        stringSegment.setLength(Character.charCount(n3));
                        throw new SkeletonSyntaxException("Stem requires an option", stringSegment);
                    }
                }
                parseState = ParseState.STATE_NULL;
            }
            stringSegment.adjustOffset(Character.charCount(n3));
        }
        assert (parseState == ParseState.STATE_NULL);
        return macroProps;
    }

    private static ParseState parseStem(StringSegment stringSegment, CharsTrie charsTrie, MacroProps macroProps) {
        switch (stringSegment.charAt(0)) {
            case '.': {
                NumberSkeletonImpl.checkNull(macroProps.precision, stringSegment);
                BlueprintHelpers.parseFractionStem(stringSegment, macroProps);
                return ParseState.STATE_FRACTION_PRECISION;
            }
            case '@': {
                NumberSkeletonImpl.checkNull(macroProps.precision, stringSegment);
                BlueprintHelpers.parseDigitsStem(stringSegment, macroProps);
                return ParseState.STATE_PRECISION;
            }
            case 'E': {
                NumberSkeletonImpl.checkNull(macroProps.notation, stringSegment);
                BlueprintHelpers.parseScientificStem(stringSegment, macroProps);
                return ParseState.STATE_NULL;
            }
            case '0': {
                NumberSkeletonImpl.checkNull(macroProps.integerWidth, stringSegment);
                BlueprintHelpers.parseIntegerStem(stringSegment, macroProps);
                return ParseState.STATE_NULL;
            }
        }
        BytesTrie.Result result = charsTrie.current();
        if (result != BytesTrie.Result.INTERMEDIATE_VALUE && result != BytesTrie.Result.FINAL_VALUE) {
            throw new SkeletonSyntaxException("Unknown stem", stringSegment);
        }
        StemEnum stemEnum = STEM_ENUM_VALUES[charsTrie.getValue()];
        switch (stemEnum) {
            case STEM_COMPACT_SHORT: 
            case STEM_COMPACT_LONG: 
            case STEM_SCIENTIFIC: 
            case STEM_ENGINEERING: 
            case STEM_NOTATION_SIMPLE: {
                NumberSkeletonImpl.checkNull(macroProps.notation, stringSegment);
                macroProps.notation = StemToObject.notation(stemEnum);
                switch (stemEnum) {
                    case STEM_SCIENTIFIC: 
                    case STEM_ENGINEERING: {
                        return ParseState.STATE_SCIENTIFIC;
                    }
                }
                return ParseState.STATE_NULL;
            }
            case STEM_BASE_UNIT: 
            case STEM_PERCENT: 
            case STEM_PERMILLE: {
                NumberSkeletonImpl.checkNull(macroProps.unit, stringSegment);
                macroProps.unit = StemToObject.unit(stemEnum);
                return ParseState.STATE_NULL;
            }
            case STEM_PERCENT_100: {
                NumberSkeletonImpl.checkNull(macroProps.scale, stringSegment);
                NumberSkeletonImpl.checkNull(macroProps.unit, stringSegment);
                macroProps.scale = Scale.powerOfTen(2);
                macroProps.unit = NoUnit.PERCENT;
                return ParseState.STATE_NULL;
            }
            case STEM_PRECISION_INTEGER: 
            case STEM_PRECISION_UNLIMITED: 
            case STEM_PRECISION_CURRENCY_STANDARD: 
            case STEM_PRECISION_CURRENCY_CASH: {
                NumberSkeletonImpl.checkNull(macroProps.precision, stringSegment);
                macroProps.precision = StemToObject.precision(stemEnum);
                switch (stemEnum) {
                    case STEM_PRECISION_INTEGER: {
                        return ParseState.STATE_FRACTION_PRECISION;
                    }
                }
                return ParseState.STATE_PRECISION;
            }
            case STEM_ROUNDING_MODE_CEILING: 
            case STEM_ROUNDING_MODE_FLOOR: 
            case STEM_ROUNDING_MODE_DOWN: 
            case STEM_ROUNDING_MODE_UP: 
            case STEM_ROUNDING_MODE_HALF_EVEN: 
            case STEM_ROUNDING_MODE_HALF_DOWN: 
            case STEM_ROUNDING_MODE_HALF_UP: 
            case STEM_ROUNDING_MODE_UNNECESSARY: {
                NumberSkeletonImpl.checkNull((Object)macroProps.roundingMode, stringSegment);
                macroProps.roundingMode = StemToObject.roundingMode(stemEnum);
                return ParseState.STATE_NULL;
            }
            case STEM_INTEGER_WIDTH_TRUNC: {
                NumberSkeletonImpl.checkNull(macroProps.integerWidth, stringSegment);
                macroProps.integerWidth = IntegerWidth.zeroFillTo(0).truncateAt(0);
                return ParseState.STATE_NULL;
            }
            case STEM_GROUP_OFF: 
            case STEM_GROUP_MIN2: 
            case STEM_GROUP_AUTO: 
            case STEM_GROUP_ON_ALIGNED: 
            case STEM_GROUP_THOUSANDS: {
                NumberSkeletonImpl.checkNull(macroProps.grouping, stringSegment);
                macroProps.grouping = StemToObject.groupingStrategy(stemEnum);
                return ParseState.STATE_NULL;
            }
            case STEM_LATIN: {
                NumberSkeletonImpl.checkNull(macroProps.symbols, stringSegment);
                macroProps.symbols = NumberingSystem.LATIN;
                return ParseState.STATE_NULL;
            }
            case STEM_UNIT_WIDTH_NARROW: 
            case STEM_UNIT_WIDTH_SHORT: 
            case STEM_UNIT_WIDTH_FULL_NAME: 
            case STEM_UNIT_WIDTH_ISO_CODE: 
            case STEM_UNIT_WIDTH_FORMAL: 
            case STEM_UNIT_WIDTH_VARIANT: 
            case STEM_UNIT_WIDTH_HIDDEN: {
                NumberSkeletonImpl.checkNull((Object)macroProps.unitWidth, stringSegment);
                macroProps.unitWidth = StemToObject.unitWidth(stemEnum);
                return ParseState.STATE_NULL;
            }
            case STEM_SIGN_AUTO: 
            case STEM_SIGN_ALWAYS: 
            case STEM_SIGN_NEVER: 
            case STEM_SIGN_ACCOUNTING: 
            case STEM_SIGN_ACCOUNTING_ALWAYS: 
            case STEM_SIGN_EXCEPT_ZERO: 
            case STEM_SIGN_ACCOUNTING_EXCEPT_ZERO: 
            case STEM_SIGN_NEGATIVE: 
            case STEM_SIGN_ACCOUNTING_NEGATIVE: {
                NumberSkeletonImpl.checkNull((Object)macroProps.sign, stringSegment);
                macroProps.sign = StemToObject.signDisplay(stemEnum);
                return ParseState.STATE_NULL;
            }
            case STEM_DECIMAL_AUTO: 
            case STEM_DECIMAL_ALWAYS: {
                NumberSkeletonImpl.checkNull((Object)macroProps.decimal, stringSegment);
                macroProps.decimal = StemToObject.decimalSeparatorDisplay(stemEnum);
                return ParseState.STATE_NULL;
            }
            case STEM_PRECISION_INCREMENT: {
                NumberSkeletonImpl.checkNull(macroProps.precision, stringSegment);
                return ParseState.STATE_INCREMENT_PRECISION;
            }
            case STEM_MEASURE_UNIT: {
                NumberSkeletonImpl.checkNull(macroProps.unit, stringSegment);
                return ParseState.STATE_MEASURE_UNIT;
            }
            case STEM_PER_MEASURE_UNIT: {
                if (macroProps.unit instanceof Currency) {
                    throw new SkeletonSyntaxException("Duplicated setting", stringSegment);
                }
                NumberSkeletonImpl.checkNull(macroProps.perUnit, stringSegment);
                return ParseState.STATE_PER_MEASURE_UNIT;
            }
            case STEM_UNIT: {
                NumberSkeletonImpl.checkNull(macroProps.unit, stringSegment);
                NumberSkeletonImpl.checkNull(macroProps.perUnit, stringSegment);
                return ParseState.STATE_IDENTIFIER_UNIT;
            }
            case STEM_UNIT_USAGE: {
                NumberSkeletonImpl.checkNull(macroProps.usage, stringSegment);
                return ParseState.STATE_UNIT_USAGE;
            }
            case STEM_CURRENCY: {
                NumberSkeletonImpl.checkNull(macroProps.unit, stringSegment);
                NumberSkeletonImpl.checkNull(macroProps.perUnit, stringSegment);
                return ParseState.STATE_CURRENCY_UNIT;
            }
            case STEM_INTEGER_WIDTH: {
                NumberSkeletonImpl.checkNull(macroProps.integerWidth, stringSegment);
                return ParseState.STATE_INTEGER_WIDTH;
            }
            case STEM_NUMBERING_SYSTEM: {
                NumberSkeletonImpl.checkNull(macroProps.symbols, stringSegment);
                return ParseState.STATE_NUMBERING_SYSTEM;
            }
            case STEM_SCALE: {
                NumberSkeletonImpl.checkNull(macroProps.scale, stringSegment);
                return ParseState.STATE_SCALE;
            }
        }
        throw new AssertionError();
    }

    private static ParseState parseOption(ParseState parseState, StringSegment stringSegment, MacroProps macroProps) {
        switch (parseState) {
            case STATE_CURRENCY_UNIT: {
                BlueprintHelpers.parseCurrencyOption(stringSegment, macroProps);
                return ParseState.STATE_NULL;
            }
            case STATE_MEASURE_UNIT: {
                BlueprintHelpers.parseMeasureUnitOption(stringSegment, macroProps);
                return ParseState.STATE_NULL;
            }
            case STATE_PER_MEASURE_UNIT: {
                BlueprintHelpers.parseMeasurePerUnitOption(stringSegment, macroProps);
                return ParseState.STATE_NULL;
            }
            case STATE_IDENTIFIER_UNIT: {
                BlueprintHelpers.parseIdentifierUnitOption(stringSegment, macroProps);
                return ParseState.STATE_NULL;
            }
            case STATE_UNIT_USAGE: {
                BlueprintHelpers.parseUnitUsageOption(stringSegment, macroProps);
                return ParseState.STATE_NULL;
            }
            case STATE_INCREMENT_PRECISION: {
                BlueprintHelpers.parseIncrementOption(stringSegment, macroProps);
                return ParseState.STATE_PRECISION;
            }
            case STATE_INTEGER_WIDTH: {
                BlueprintHelpers.parseIntegerWidthOption(stringSegment, macroProps);
                return ParseState.STATE_NULL;
            }
            case STATE_NUMBERING_SYSTEM: {
                BlueprintHelpers.parseNumberingSystemOption(stringSegment, macroProps);
                return ParseState.STATE_NULL;
            }
            case STATE_SCALE: {
                BlueprintHelpers.parseScaleOption(stringSegment, macroProps);
                return ParseState.STATE_NULL;
            }
        }
        switch (parseState) {
            case STATE_SCIENTIFIC: {
                if (BlueprintHelpers.parseExponentWidthOption(stringSegment, macroProps)) {
                    return ParseState.STATE_SCIENTIFIC;
                }
                if (!BlueprintHelpers.parseExponentSignOption(stringSegment, macroProps)) break;
                return ParseState.STATE_SCIENTIFIC;
            }
        }
        switch (parseState) {
            case STATE_FRACTION_PRECISION: {
                if (BlueprintHelpers.parseFracSigOption(stringSegment, macroProps)) {
                    return ParseState.STATE_PRECISION;
                }
                parseState = ParseState.STATE_PRECISION;
                break;
            }
        }
        switch (parseState) {
            case STATE_PRECISION: {
                if (!BlueprintHelpers.parseTrailingZeroOption(stringSegment, macroProps)) break;
                return ParseState.STATE_NULL;
            }
        }
        throw new SkeletonSyntaxException("Invalid option", stringSegment);
    }

    private static void generateSkeleton(MacroProps macroProps, StringBuilder stringBuilder) {
        if (macroProps.notation != null && GeneratorHelpers.notation(macroProps, stringBuilder)) {
            stringBuilder.append(' ');
        }
        if (macroProps.unit != null && GeneratorHelpers.unit(macroProps, stringBuilder)) {
            stringBuilder.append(' ');
        }
        if (macroProps.usage != null && GeneratorHelpers.usage(macroProps, stringBuilder)) {
            stringBuilder.append(' ');
        }
        if (macroProps.precision != null && GeneratorHelpers.precision(macroProps, stringBuilder)) {
            stringBuilder.append(' ');
        }
        if (macroProps.roundingMode != null && GeneratorHelpers.roundingMode(macroProps, stringBuilder)) {
            stringBuilder.append(' ');
        }
        if (macroProps.grouping != null && GeneratorHelpers.grouping(macroProps, stringBuilder)) {
            stringBuilder.append(' ');
        }
        if (macroProps.integerWidth != null && GeneratorHelpers.integerWidth(macroProps, stringBuilder)) {
            stringBuilder.append(' ');
        }
        if (macroProps.symbols != null && GeneratorHelpers.symbols(macroProps, stringBuilder)) {
            stringBuilder.append(' ');
        }
        if (macroProps.unitWidth != null && GeneratorHelpers.unitWidth(macroProps, stringBuilder)) {
            stringBuilder.append(' ');
        }
        if (macroProps.sign != null && GeneratorHelpers.sign(macroProps, stringBuilder)) {
            stringBuilder.append(' ');
        }
        if (macroProps.decimal != null && GeneratorHelpers.decimal(macroProps, stringBuilder)) {
            stringBuilder.append(' ');
        }
        if (macroProps.scale != null && GeneratorHelpers.scale(macroProps, stringBuilder)) {
            stringBuilder.append(' ');
        }
        if (macroProps.padder != null) {
            throw new UnsupportedOperationException("Cannot generate number skeleton with custom padder");
        }
        if (macroProps.unitDisplayCase != null && !macroProps.unitDisplayCase.isEmpty()) {
            throw new UnsupportedOperationException("Cannot generate number skeleton with custom unit display case");
        }
        if (macroProps.affixProvider != null) {
            throw new UnsupportedOperationException("Cannot generate number skeleton with custom affix provider");
        }
        if (macroProps.rules != null) {
            throw new UnsupportedOperationException("Cannot generate number skeleton with custom plural rules");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
    }

    private static void checkNull(Object object, CharSequence charSequence) {
        if (object != null) {
            throw new SkeletonSyntaxException("Duplicated setting", charSequence);
        }
    }

    private static void appendMultiple(StringBuilder stringBuilder, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuilder.appendCodePoint(n2);
        }
    }

    static final class GeneratorHelpers {
        GeneratorHelpers() {
        }

        private static boolean notation(MacroProps macroProps, StringBuilder stringBuilder) {
            if (macroProps.notation instanceof CompactNotation) {
                if (macroProps.notation == Notation.compactLong()) {
                    stringBuilder.append("compact-long");
                    return true;
                }
                if (macroProps.notation == Notation.compactShort()) {
                    stringBuilder.append("compact-short");
                    return true;
                }
                throw new UnsupportedOperationException("Cannot generate number skeleton with custom compact data");
            }
            if (macroProps.notation instanceof ScientificNotation) {
                ScientificNotation scientificNotation = (ScientificNotation)macroProps.notation;
                if (scientificNotation.engineeringInterval == 3) {
                    stringBuilder.append("engineering");
                } else {
                    stringBuilder.append("scientific");
                }
                if (scientificNotation.minExponentDigits > 1) {
                    stringBuilder.append('/');
                    BlueprintHelpers.generateExponentWidthOption(scientificNotation.minExponentDigits, stringBuilder);
                }
                if (scientificNotation.exponentSignDisplay != NumberFormatter.SignDisplay.AUTO) {
                    stringBuilder.append('/');
                    EnumToStemString.signDisplay(scientificNotation.exponentSignDisplay, stringBuilder);
                }
                return true;
            }
            assert (macroProps.notation instanceof SimpleNotation);
            return false;
        }

        private static boolean unit(MacroProps macroProps, StringBuilder stringBuilder) {
            MeasureUnit measureUnit = macroProps.unit;
            if (macroProps.perUnit != null) {
                if (macroProps.unit instanceof Currency || macroProps.perUnit instanceof Currency) {
                    throw new UnsupportedOperationException("Cannot generate number skeleton with currency unit and per-unit");
                }
                measureUnit = measureUnit.product(macroProps.perUnit.reciprocal());
            }
            if (measureUnit instanceof Currency) {
                stringBuilder.append("currency/");
                BlueprintHelpers.generateCurrencyOption((Currency)measureUnit, stringBuilder);
                return true;
            }
            if (measureUnit.equals(MeasureUnit.PERCENT)) {
                stringBuilder.append("percent");
                return true;
            }
            if (measureUnit.equals(MeasureUnit.PERMILLE)) {
                stringBuilder.append("permille");
                return true;
            }
            stringBuilder.append("unit/");
            stringBuilder.append(measureUnit.getIdentifier());
            return true;
        }

        private static boolean usage(MacroProps macroProps, StringBuilder stringBuilder) {
            if (macroProps.usage != null && macroProps.usage.length() > 0) {
                stringBuilder.append("usage/");
                stringBuilder.append(macroProps.usage);
                return true;
            }
            return false;
        }

        private static boolean precision(MacroProps macroProps, StringBuilder stringBuilder) {
            if (macroProps.precision instanceof Precision.InfiniteRounderImpl) {
                stringBuilder.append("precision-unlimited");
            } else if (macroProps.precision instanceof Precision.FractionRounderImpl) {
                Precision.FractionRounderImpl fractionRounderImpl = (Precision.FractionRounderImpl)macroProps.precision;
                BlueprintHelpers.generateFractionStem(fractionRounderImpl.minFrac, fractionRounderImpl.maxFrac, stringBuilder);
            } else if (macroProps.precision instanceof Precision.SignificantRounderImpl) {
                Precision.SignificantRounderImpl significantRounderImpl = (Precision.SignificantRounderImpl)macroProps.precision;
                BlueprintHelpers.generateDigitsStem(significantRounderImpl.minSig, significantRounderImpl.maxSig, stringBuilder);
            } else if (macroProps.precision instanceof Precision.FracSigRounderImpl) {
                Precision.FracSigRounderImpl fracSigRounderImpl = (Precision.FracSigRounderImpl)macroProps.precision;
                BlueprintHelpers.generateFractionStem(fracSigRounderImpl.minFrac, fracSigRounderImpl.maxFrac, stringBuilder);
                stringBuilder.append('/');
                if (fracSigRounderImpl.retain) {
                    if (fracSigRounderImpl.priority == NumberFormatter.RoundingPriority.RELAXED) {
                        BlueprintHelpers.generateDigitsStem(fracSigRounderImpl.maxSig, -1, stringBuilder);
                    } else {
                        BlueprintHelpers.generateDigitsStem(1, fracSigRounderImpl.maxSig, stringBuilder);
                    }
                } else {
                    BlueprintHelpers.generateDigitsStem(fracSigRounderImpl.minSig, fracSigRounderImpl.maxSig, stringBuilder);
                    if (fracSigRounderImpl.priority == NumberFormatter.RoundingPriority.RELAXED) {
                        stringBuilder.append('r');
                    } else {
                        stringBuilder.append('s');
                    }
                }
            } else if (macroProps.precision instanceof Precision.IncrementRounderImpl) {
                Precision.IncrementRounderImpl incrementRounderImpl = (Precision.IncrementRounderImpl)macroProps.precision;
                stringBuilder.append("precision-increment/");
                BlueprintHelpers.generateIncrementOption(incrementRounderImpl.increment, stringBuilder);
            } else {
                assert (macroProps.precision instanceof Precision.CurrencyRounderImpl);
                Precision.CurrencyRounderImpl currencyRounderImpl = (Precision.CurrencyRounderImpl)macroProps.precision;
                if (currencyRounderImpl.usage == Currency.CurrencyUsage.STANDARD) {
                    stringBuilder.append("precision-currency-standard");
                } else {
                    stringBuilder.append("precision-currency-cash");
                }
            }
            if (macroProps.precision.trailingZeroDisplay == NumberFormatter.TrailingZeroDisplay.HIDE_IF_WHOLE) {
                stringBuilder.append("/w");
            }
            return true;
        }

        private static boolean roundingMode(MacroProps macroProps, StringBuilder stringBuilder) {
            if (macroProps.roundingMode == RoundingUtils.DEFAULT_ROUNDING_MODE) {
                return false;
            }
            EnumToStemString.roundingMode(macroProps.roundingMode, stringBuilder);
            return true;
        }

        private static boolean grouping(MacroProps macroProps, StringBuilder stringBuilder) {
            if (macroProps.grouping instanceof NumberFormatter.GroupingStrategy) {
                if (macroProps.grouping == NumberFormatter.GroupingStrategy.AUTO) {
                    return false;
                }
                EnumToStemString.groupingStrategy((NumberFormatter.GroupingStrategy)((Object)macroProps.grouping), stringBuilder);
                return true;
            }
            throw new UnsupportedOperationException("Cannot generate number skeleton with custom Grouper");
        }

        private static boolean integerWidth(MacroProps macroProps, StringBuilder stringBuilder) {
            if (macroProps.integerWidth.equals(IntegerWidth.DEFAULT)) {
                return false;
            }
            if (macroProps.integerWidth.minInt == 0 && macroProps.integerWidth.maxInt == 0) {
                stringBuilder.append("integer-width-trunc");
                return true;
            }
            stringBuilder.append("integer-width/");
            BlueprintHelpers.generateIntegerWidthOption(macroProps.integerWidth.minInt, macroProps.integerWidth.maxInt, stringBuilder);
            return true;
        }

        private static boolean symbols(MacroProps macroProps, StringBuilder stringBuilder) {
            if (macroProps.symbols instanceof NumberingSystem) {
                NumberingSystem numberingSystem = (NumberingSystem)macroProps.symbols;
                if (numberingSystem.getName().equals("latn")) {
                    stringBuilder.append("latin");
                } else {
                    stringBuilder.append("numbering-system/");
                    BlueprintHelpers.generateNumberingSystemOption(numberingSystem, stringBuilder);
                }
                return true;
            }
            assert (macroProps.symbols instanceof DecimalFormatSymbols);
            throw new UnsupportedOperationException("Cannot generate number skeleton with custom DecimalFormatSymbols");
        }

        private static boolean unitWidth(MacroProps macroProps, StringBuilder stringBuilder) {
            if (macroProps.unitWidth == NumberFormatter.UnitWidth.SHORT) {
                return false;
            }
            EnumToStemString.unitWidth(macroProps.unitWidth, stringBuilder);
            return true;
        }

        private static boolean sign(MacroProps macroProps, StringBuilder stringBuilder) {
            if (macroProps.sign == NumberFormatter.SignDisplay.AUTO) {
                return false;
            }
            EnumToStemString.signDisplay(macroProps.sign, stringBuilder);
            return true;
        }

        private static boolean decimal(MacroProps macroProps, StringBuilder stringBuilder) {
            if (macroProps.decimal == NumberFormatter.DecimalSeparatorDisplay.AUTO) {
                return false;
            }
            EnumToStemString.decimalSeparatorDisplay(macroProps.decimal, stringBuilder);
            return true;
        }

        private static boolean scale(MacroProps macroProps, StringBuilder stringBuilder) {
            if (!macroProps.scale.isValid()) {
                return false;
            }
            stringBuilder.append("scale/");
            BlueprintHelpers.generateScaleOption(macroProps.scale, stringBuilder);
            return true;
        }
    }

    static final class BlueprintHelpers {
        BlueprintHelpers() {
        }

        private static boolean parseExponentWidthOption(StringSegment stringSegment, MacroProps macroProps) {
            int n2;
            if (!NumberSkeletonImpl.isWildcardChar(stringSegment.charAt(0))) {
                return false;
            }
            int n3 = 0;
            for (n2 = 1; n2 < stringSegment.length() && stringSegment.charAt(n2) == 'e'; ++n2) {
                ++n3;
            }
            if (n2 < stringSegment.length()) {
                return false;
            }
            macroProps.notation = ((ScientificNotation)macroProps.notation).withMinExponentDigits(n3);
            return true;
        }

        private static void generateExponentWidthOption(int n2, StringBuilder stringBuilder) {
            stringBuilder.append('*');
            NumberSkeletonImpl.appendMultiple(stringBuilder, 101, n2);
        }

        private static boolean parseExponentSignOption(StringSegment stringSegment, MacroProps macroProps) {
            CharsTrie charsTrie = new CharsTrie(SERIALIZED_STEM_TRIE, 0);
            BytesTrie.Result result = charsTrie.next(stringSegment, 0, stringSegment.length());
            if (result != BytesTrie.Result.INTERMEDIATE_VALUE && result != BytesTrie.Result.FINAL_VALUE) {
                return false;
            }
            NumberFormatter.SignDisplay signDisplay = StemToObject.signDisplay(STEM_ENUM_VALUES[charsTrie.getValue()]);
            if (signDisplay == null) {
                return false;
            }
            macroProps.notation = ((ScientificNotation)macroProps.notation).withExponentSignDisplay(signDisplay);
            return true;
        }

        private static void parseCurrencyOption(StringSegment stringSegment, MacroProps macroProps) {
            Currency currency;
            String string = stringSegment.subSequence(0, stringSegment.length()).toString();
            try {
                currency = Currency.getInstance(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SkeletonSyntaxException("Invalid currency", stringSegment, illegalArgumentException);
            }
            macroProps.unit = currency;
        }

        private static void generateCurrencyOption(Currency currency, StringBuilder stringBuilder) {
            stringBuilder.append(currency.getCurrencyCode());
        }

        private static void parseMeasureUnitOption(StringSegment stringSegment, MacroProps macroProps) {
            int n2;
            for (n2 = 0; n2 < stringSegment.length() && stringSegment.charAt(n2) != '-'; ++n2) {
            }
            if (n2 == stringSegment.length()) {
                throw new SkeletonSyntaxException("Invalid measure unit option", stringSegment);
            }
            String string = stringSegment.subSequence(0, n2).toString();
            String string2 = stringSegment.subSequence(n2 + 1, stringSegment.length()).toString();
            Set<MeasureUnit> set = MeasureUnit.getAvailable(string);
            for (MeasureUnit measureUnit : set) {
                if (!string2.equals(measureUnit.getSubtype())) continue;
                macroProps.unit = measureUnit;
                return;
            }
            throw new SkeletonSyntaxException("Unknown measure unit", stringSegment);
        }

        private static void parseMeasurePerUnitOption(StringSegment stringSegment, MacroProps macroProps) {
            MeasureUnit measureUnit = macroProps.unit;
            BlueprintHelpers.parseMeasureUnitOption(stringSegment, macroProps);
            macroProps.perUnit = macroProps.unit;
            macroProps.unit = measureUnit;
        }

        private static void parseIdentifierUnitOption(StringSegment stringSegment, MacroProps macroProps) {
            try {
                macroProps.unit = MeasureUnit.forIdentifier(stringSegment.asString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SkeletonSyntaxException("Invalid unit stem", stringSegment);
            }
        }

        private static void parseUnitUsageOption(StringSegment stringSegment, MacroProps macroProps) {
            macroProps.usage = stringSegment.asString();
        }

        private static void parseFractionStem(StringSegment stringSegment, MacroProps macroProps) {
            int n2;
            int n3;
            assert (stringSegment.charAt(0) == '.');
            int n4 = 0;
            for (n3 = 1; n3 < stringSegment.length() && stringSegment.charAt(n3) == '0'; ++n3) {
                ++n4;
            }
            if (n3 < stringSegment.length()) {
                if (NumberSkeletonImpl.isWildcardChar(stringSegment.charAt(n3))) {
                    n2 = -1;
                    ++n3;
                } else {
                    n2 = n4;
                    while (n3 < stringSegment.length() && stringSegment.charAt(n3) == '#') {
                        ++n2;
                        ++n3;
                    }
                }
            } else {
                n2 = n4;
            }
            if (n3 < stringSegment.length()) {
                throw new SkeletonSyntaxException("Invalid fraction stem", stringSegment);
            }
            macroProps.precision = n2 == -1 ? (n4 == 0 ? Precision.unlimited() : Precision.minFraction(n4)) : Precision.minMaxFraction(n4, n2);
        }

        private static void generateFractionStem(int n2, int n3, StringBuilder stringBuilder) {
            if (n2 == 0 && n3 == 0) {
                stringBuilder.append("precision-integer");
                return;
            }
            stringBuilder.append('.');
            NumberSkeletonImpl.appendMultiple(stringBuilder, 48, n2);
            if (n3 == -1) {
                stringBuilder.append('*');
            } else {
                NumberSkeletonImpl.appendMultiple(stringBuilder, 35, n3 - n2);
            }
        }

        private static void parseDigitsStem(StringSegment stringSegment, MacroProps macroProps) {
            int n2;
            int n3;
            assert (stringSegment.charAt(0) == '@');
            int n4 = 0;
            for (n3 = 0; n3 < stringSegment.length() && stringSegment.charAt(n3) == '@'; ++n3) {
                ++n4;
            }
            if (n3 < stringSegment.length()) {
                if (NumberSkeletonImpl.isWildcardChar(stringSegment.charAt(n3))) {
                    n2 = -1;
                    ++n3;
                } else {
                    n2 = n4;
                    while (n3 < stringSegment.length() && stringSegment.charAt(n3) == '#') {
                        ++n2;
                        ++n3;
                    }
                }
            } else {
                n2 = n4;
            }
            if (n3 < stringSegment.length()) {
                throw new SkeletonSyntaxException("Invalid significant digits stem", stringSegment);
            }
            macroProps.precision = n2 == -1 ? Precision.minSignificantDigits(n4) : Precision.minMaxSignificantDigits(n4, n2);
        }

        private static void generateDigitsStem(int n2, int n3, StringBuilder stringBuilder) {
            NumberSkeletonImpl.appendMultiple(stringBuilder, 64, n2);
            if (n3 == -1) {
                stringBuilder.append('*');
            } else {
                NumberSkeletonImpl.appendMultiple(stringBuilder, 35, n3 - n2);
            }
        }

        private static void parseScientificStem(StringSegment stringSegment, MacroProps macroProps) {
            block6: {
                NumberFormatter.SignDisplay signDisplay;
                boolean bl2;
                int n2;
                block8: {
                    block10: {
                        block9: {
                            block7: {
                                assert (stringSegment.charAt(0) == 'E');
                                n2 = 1;
                                if (stringSegment.length() == n2) break block6;
                                bl2 = false;
                                if (stringSegment.charAt(n2) != 'E') break block7;
                                bl2 = true;
                                if (stringSegment.length() == ++n2) break block6;
                            }
                            signDisplay = NumberFormatter.SignDisplay.AUTO;
                            if (stringSegment.charAt(n2) != '+') break block8;
                            if (stringSegment.length() == ++n2) break block6;
                            if (stringSegment.charAt(n2) != '!') break block9;
                            signDisplay = NumberFormatter.SignDisplay.ALWAYS;
                            break block10;
                        }
                        if (stringSegment.charAt(n2) != '?') break block6;
                        signDisplay = NumberFormatter.SignDisplay.EXCEPT_ZERO;
                    }
                    if (stringSegment.length() == ++n2) break block6;
                }
                int n3 = 0;
                while (n2 < stringSegment.length()) {
                    if (stringSegment.charAt(n2) == '0') {
                        ++n3;
                        ++n2;
                        continue;
                    }
                    break block6;
                }
                macroProps.notation = (bl2 ? Notation.engineering() : Notation.scientific()).withExponentSignDisplay(signDisplay).withMinExponentDigits(n3);
                return;
            }
            throw new SkeletonSyntaxException("Invalid scientific stem", stringSegment);
        }

        private static void parseIntegerStem(StringSegment stringSegment, MacroProps macroProps) {
            int n2;
            assert (stringSegment.charAt(0) == '0');
            for (n2 = 1; n2 < stringSegment.length(); ++n2) {
                if (stringSegment.charAt(n2) == '0') continue;
                --n2;
                break;
            }
            if (n2 < stringSegment.length()) {
                throw new SkeletonSyntaxException("Invalid integer stem", stringSegment);
            }
            macroProps.integerWidth = IntegerWidth.zeroFillTo(n2);
        }

        private static boolean parseFracSigOption(StringSegment stringSegment, MacroProps macroProps) {
            int n2;
            int n3;
            if (stringSegment.charAt(0) != '@') {
                return false;
            }
            int n4 = 0;
            for (n3 = 0; n3 < stringSegment.length() && stringSegment.charAt(n3) == '@'; ++n3) {
                ++n4;
            }
            if (n3 < stringSegment.length()) {
                if (NumberSkeletonImpl.isWildcardChar(stringSegment.charAt(n3))) {
                    n2 = -1;
                    ++n3;
                } else {
                    n2 = n4;
                    while (n3 < stringSegment.length() && stringSegment.charAt(n3) == '#') {
                        ++n2;
                        ++n3;
                    }
                }
            } else {
                n2 = n4;
            }
            FractionPrecision fractionPrecision = (FractionPrecision)macroProps.precision;
            if (n3 < stringSegment.length()) {
                NumberFormatter.RoundingPriority roundingPriority;
                if (n2 == -1) {
                    throw new SkeletonSyntaxException("Invalid digits option: Wildcard character not allowed with the priority annotation", stringSegment);
                }
                if (stringSegment.codePointAt(n3) == 114) {
                    roundingPriority = NumberFormatter.RoundingPriority.RELAXED;
                    ++n3;
                } else if (stringSegment.codePointAt(n3) == 115) {
                    roundingPriority = NumberFormatter.RoundingPriority.STRICT;
                    ++n3;
                } else {
                    assert (n3 < stringSegment.length());
                    roundingPriority = NumberFormatter.RoundingPriority.RELAXED;
                }
                if (n3 < stringSegment.length()) {
                    throw new SkeletonSyntaxException("Invalid digits option for fraction rounder", stringSegment);
                }
                macroProps.precision = fractionPrecision.withSignificantDigits(n4, n2, roundingPriority);
            } else if (n2 == -1) {
                macroProps.precision = fractionPrecision.withMinDigits(n4);
            } else if (n4 == 1) {
                macroProps.precision = fractionPrecision.withMaxDigits(n2);
            } else {
                throw new SkeletonSyntaxException("Invalid digits option: Priority annotation required", stringSegment);
            }
            return true;
        }

        private static boolean parseTrailingZeroOption(StringSegment stringSegment, MacroProps macroProps) {
            if (stringSegment.contentEquals("w")) {
                macroProps.precision = macroProps.precision.trailingZeroDisplay(NumberFormatter.TrailingZeroDisplay.HIDE_IF_WHOLE);
                return true;
            }
            return false;
        }

        private static void parseIncrementOption(StringSegment stringSegment, MacroProps macroProps) {
            BigDecimal bigDecimal;
            String string = stringSegment.subSequence(0, stringSegment.length()).toString();
            try {
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SkeletonSyntaxException("Invalid rounding increment", stringSegment, numberFormatException);
            }
            macroProps.precision = Precision.increment(bigDecimal);
        }

        private static void generateIncrementOption(BigDecimal bigDecimal, StringBuilder stringBuilder) {
            stringBuilder.append(bigDecimal.toPlainString());
        }

        private static void parseIntegerWidthOption(StringSegment stringSegment, MacroProps macroProps) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            if (NumberSkeletonImpl.isWildcardChar(stringSegment.charAt(0))) {
                n2 = -1;
                ++n3;
            } else {
                n2 = 0;
            }
            while (n3 < stringSegment.length() && n2 != -1 && stringSegment.charAt(n3) == '#') {
                ++n2;
                ++n3;
            }
            if (n3 < stringSegment.length()) {
                while (n3 < stringSegment.length() && stringSegment.charAt(n3) == '0') {
                    ++n4;
                    ++n3;
                }
            }
            if (n2 != -1) {
                n2 += n4;
            }
            if (n3 < stringSegment.length()) {
                throw new SkeletonSyntaxException("Invalid integer width stem", stringSegment);
            }
            macroProps.integerWidth = n2 == -1 ? IntegerWidth.zeroFillTo(n4) : IntegerWidth.zeroFillTo(n4).truncateAt(n2);
        }

        private static void generateIntegerWidthOption(int n2, int n3, StringBuilder stringBuilder) {
            if (n3 == -1) {
                stringBuilder.append('*');
            } else {
                NumberSkeletonImpl.appendMultiple(stringBuilder, 35, n3 - n2);
            }
            NumberSkeletonImpl.appendMultiple(stringBuilder, 48, n2);
        }

        private static void parseNumberingSystemOption(StringSegment stringSegment, MacroProps macroProps) {
            String string = stringSegment.subSequence(0, stringSegment.length()).toString();
            NumberingSystem numberingSystem = NumberingSystem.getInstanceByName(string);
            if (numberingSystem == null) {
                throw new SkeletonSyntaxException("Unknown numbering system", stringSegment);
            }
            macroProps.symbols = numberingSystem;
        }

        private static void generateNumberingSystemOption(NumberingSystem numberingSystem, StringBuilder stringBuilder) {
            stringBuilder.append(numberingSystem.getName());
        }

        private static void parseScaleOption(StringSegment stringSegment, MacroProps macroProps) {
            BigDecimal bigDecimal;
            String string = stringSegment.subSequence(0, stringSegment.length()).toString();
            try {
                bigDecimal = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SkeletonSyntaxException("Invalid scale", stringSegment, numberFormatException);
            }
            macroProps.scale = Scale.byBigDecimal(bigDecimal);
        }

        private static void generateScaleOption(Scale scale, StringBuilder stringBuilder) {
            BigDecimal bigDecimal = scale.arbitrary;
            if (bigDecimal == null) {
                bigDecimal = BigDecimal.ONE;
            }
            bigDecimal = bigDecimal.scaleByPowerOfTen(scale.magnitude);
            stringBuilder.append(bigDecimal.toPlainString());
        }
    }

    static final class EnumToStemString {
        EnumToStemString() {
        }

        private static void roundingMode(RoundingMode roundingMode, StringBuilder stringBuilder) {
            switch (roundingMode) {
                case CEILING: {
                    stringBuilder.append("rounding-mode-ceiling");
                    break;
                }
                case FLOOR: {
                    stringBuilder.append("rounding-mode-floor");
                    break;
                }
                case DOWN: {
                    stringBuilder.append("rounding-mode-down");
                    break;
                }
                case UP: {
                    stringBuilder.append("rounding-mode-up");
                    break;
                }
                case HALF_EVEN: {
                    stringBuilder.append("rounding-mode-half-even");
                    break;
                }
                case HALF_DOWN: {
                    stringBuilder.append("rounding-mode-half-down");
                    break;
                }
                case HALF_UP: {
                    stringBuilder.append("rounding-mode-half-up");
                    break;
                }
                case UNNECESSARY: {
                    stringBuilder.append("rounding-mode-unnecessary");
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        private static void groupingStrategy(NumberFormatter.GroupingStrategy groupingStrategy, StringBuilder stringBuilder) {
            switch (groupingStrategy) {
                case OFF: {
                    stringBuilder.append("group-off");
                    break;
                }
                case MIN2: {
                    stringBuilder.append("group-min2");
                    break;
                }
                case AUTO: {
                    stringBuilder.append("group-auto");
                    break;
                }
                case ON_ALIGNED: {
                    stringBuilder.append("group-on-aligned");
                    break;
                }
                case THOUSANDS: {
                    stringBuilder.append("group-thousands");
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        private static void unitWidth(NumberFormatter.UnitWidth unitWidth, StringBuilder stringBuilder) {
            switch (unitWidth) {
                case NARROW: {
                    stringBuilder.append("unit-width-narrow");
                    break;
                }
                case SHORT: {
                    stringBuilder.append("unit-width-short");
                    break;
                }
                case FULL_NAME: {
                    stringBuilder.append("unit-width-full-name");
                    break;
                }
                case ISO_CODE: {
                    stringBuilder.append("unit-width-iso-code");
                    break;
                }
                case FORMAL: {
                    stringBuilder.append("unit-width-formal");
                    break;
                }
                case VARIANT: {
                    stringBuilder.append("unit-width-variant");
                    break;
                }
                case HIDDEN: {
                    stringBuilder.append("unit-width-hidden");
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        private static void signDisplay(NumberFormatter.SignDisplay signDisplay, StringBuilder stringBuilder) {
            switch (signDisplay) {
                case AUTO: {
                    stringBuilder.append("sign-auto");
                    break;
                }
                case ALWAYS: {
                    stringBuilder.append("sign-always");
                    break;
                }
                case NEVER: {
                    stringBuilder.append("sign-never");
                    break;
                }
                case ACCOUNTING: {
                    stringBuilder.append("sign-accounting");
                    break;
                }
                case ACCOUNTING_ALWAYS: {
                    stringBuilder.append("sign-accounting-always");
                    break;
                }
                case EXCEPT_ZERO: {
                    stringBuilder.append("sign-except-zero");
                    break;
                }
                case ACCOUNTING_EXCEPT_ZERO: {
                    stringBuilder.append("sign-accounting-except-zero");
                    break;
                }
                case NEGATIVE: {
                    stringBuilder.append("sign-negative");
                    break;
                }
                case ACCOUNTING_NEGATIVE: {
                    stringBuilder.append("sign-accounting-negative");
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        private static void decimalSeparatorDisplay(NumberFormatter.DecimalSeparatorDisplay decimalSeparatorDisplay, StringBuilder stringBuilder) {
            switch (decimalSeparatorDisplay) {
                case AUTO: {
                    stringBuilder.append("decimal-auto");
                    break;
                }
                case ALWAYS: {
                    stringBuilder.append("decimal-always");
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    static final class StemToObject {
        StemToObject() {
        }

        private static Notation notation(StemEnum stemEnum) {
            switch (stemEnum) {
                case STEM_COMPACT_SHORT: {
                    return Notation.compactShort();
                }
                case STEM_COMPACT_LONG: {
                    return Notation.compactLong();
                }
                case STEM_SCIENTIFIC: {
                    return Notation.scientific();
                }
                case STEM_ENGINEERING: {
                    return Notation.engineering();
                }
                case STEM_NOTATION_SIMPLE: {
                    return Notation.simple();
                }
            }
            throw new AssertionError();
        }

        private static MeasureUnit unit(StemEnum stemEnum) {
            switch (stemEnum) {
                case STEM_BASE_UNIT: {
                    return NoUnit.BASE;
                }
                case STEM_PERCENT: {
                    return NoUnit.PERCENT;
                }
                case STEM_PERMILLE: {
                    return NoUnit.PERMILLE;
                }
            }
            throw new AssertionError();
        }

        private static Precision precision(StemEnum stemEnum) {
            switch (stemEnum) {
                case STEM_PRECISION_INTEGER: {
                    return Precision.integer();
                }
                case STEM_PRECISION_UNLIMITED: {
                    return Precision.unlimited();
                }
                case STEM_PRECISION_CURRENCY_STANDARD: {
                    return Precision.currency(Currency.CurrencyUsage.STANDARD);
                }
                case STEM_PRECISION_CURRENCY_CASH: {
                    return Precision.currency(Currency.CurrencyUsage.CASH);
                }
            }
            throw new AssertionError();
        }

        private static RoundingMode roundingMode(StemEnum stemEnum) {
            switch (stemEnum) {
                case STEM_ROUNDING_MODE_CEILING: {
                    return RoundingMode.CEILING;
                }
                case STEM_ROUNDING_MODE_FLOOR: {
                    return RoundingMode.FLOOR;
                }
                case STEM_ROUNDING_MODE_DOWN: {
                    return RoundingMode.DOWN;
                }
                case STEM_ROUNDING_MODE_UP: {
                    return RoundingMode.UP;
                }
                case STEM_ROUNDING_MODE_HALF_EVEN: {
                    return RoundingMode.HALF_EVEN;
                }
                case STEM_ROUNDING_MODE_HALF_DOWN: {
                    return RoundingMode.HALF_DOWN;
                }
                case STEM_ROUNDING_MODE_HALF_UP: {
                    return RoundingMode.HALF_UP;
                }
                case STEM_ROUNDING_MODE_UNNECESSARY: {
                    return RoundingMode.UNNECESSARY;
                }
            }
            throw new AssertionError();
        }

        private static NumberFormatter.GroupingStrategy groupingStrategy(StemEnum stemEnum) {
            switch (stemEnum) {
                case STEM_GROUP_OFF: {
                    return NumberFormatter.GroupingStrategy.OFF;
                }
                case STEM_GROUP_MIN2: {
                    return NumberFormatter.GroupingStrategy.MIN2;
                }
                case STEM_GROUP_AUTO: {
                    return NumberFormatter.GroupingStrategy.AUTO;
                }
                case STEM_GROUP_ON_ALIGNED: {
                    return NumberFormatter.GroupingStrategy.ON_ALIGNED;
                }
                case STEM_GROUP_THOUSANDS: {
                    return NumberFormatter.GroupingStrategy.THOUSANDS;
                }
            }
            return null;
        }

        private static NumberFormatter.UnitWidth unitWidth(StemEnum stemEnum) {
            switch (stemEnum) {
                case STEM_UNIT_WIDTH_NARROW: {
                    return NumberFormatter.UnitWidth.NARROW;
                }
                case STEM_UNIT_WIDTH_SHORT: {
                    return NumberFormatter.UnitWidth.SHORT;
                }
                case STEM_UNIT_WIDTH_FULL_NAME: {
                    return NumberFormatter.UnitWidth.FULL_NAME;
                }
                case STEM_UNIT_WIDTH_ISO_CODE: {
                    return NumberFormatter.UnitWidth.ISO_CODE;
                }
                case STEM_UNIT_WIDTH_FORMAL: {
                    return NumberFormatter.UnitWidth.FORMAL;
                }
                case STEM_UNIT_WIDTH_VARIANT: {
                    return NumberFormatter.UnitWidth.VARIANT;
                }
                case STEM_UNIT_WIDTH_HIDDEN: {
                    return NumberFormatter.UnitWidth.HIDDEN;
                }
            }
            return null;
        }

        private static NumberFormatter.SignDisplay signDisplay(StemEnum stemEnum) {
            switch (stemEnum) {
                case STEM_SIGN_AUTO: {
                    return NumberFormatter.SignDisplay.AUTO;
                }
                case STEM_SIGN_ALWAYS: {
                    return NumberFormatter.SignDisplay.ALWAYS;
                }
                case STEM_SIGN_NEVER: {
                    return NumberFormatter.SignDisplay.NEVER;
                }
                case STEM_SIGN_ACCOUNTING: {
                    return NumberFormatter.SignDisplay.ACCOUNTING;
                }
                case STEM_SIGN_ACCOUNTING_ALWAYS: {
                    return NumberFormatter.SignDisplay.ACCOUNTING_ALWAYS;
                }
                case STEM_SIGN_EXCEPT_ZERO: {
                    return NumberFormatter.SignDisplay.EXCEPT_ZERO;
                }
                case STEM_SIGN_ACCOUNTING_EXCEPT_ZERO: {
                    return NumberFormatter.SignDisplay.ACCOUNTING_EXCEPT_ZERO;
                }
                case STEM_SIGN_NEGATIVE: {
                    return NumberFormatter.SignDisplay.NEGATIVE;
                }
                case STEM_SIGN_ACCOUNTING_NEGATIVE: {
                    return NumberFormatter.SignDisplay.ACCOUNTING_NEGATIVE;
                }
            }
            return null;
        }

        private static NumberFormatter.DecimalSeparatorDisplay decimalSeparatorDisplay(StemEnum stemEnum) {
            switch (stemEnum) {
                case STEM_DECIMAL_AUTO: {
                    return NumberFormatter.DecimalSeparatorDisplay.AUTO;
                }
                case STEM_DECIMAL_ALWAYS: {
                    return NumberFormatter.DecimalSeparatorDisplay.ALWAYS;
                }
            }
            return null;
        }
    }

    static enum StemEnum {
        STEM_COMPACT_SHORT,
        STEM_COMPACT_LONG,
        STEM_SCIENTIFIC,
        STEM_ENGINEERING,
        STEM_NOTATION_SIMPLE,
        STEM_BASE_UNIT,
        STEM_PERCENT,
        STEM_PERMILLE,
        STEM_PERCENT_100,
        STEM_PRECISION_INTEGER,
        STEM_PRECISION_UNLIMITED,
        STEM_PRECISION_CURRENCY_STANDARD,
        STEM_PRECISION_CURRENCY_CASH,
        STEM_ROUNDING_MODE_CEILING,
        STEM_ROUNDING_MODE_FLOOR,
        STEM_ROUNDING_MODE_DOWN,
        STEM_ROUNDING_MODE_UP,
        STEM_ROUNDING_MODE_HALF_EVEN,
        STEM_ROUNDING_MODE_HALF_DOWN,
        STEM_ROUNDING_MODE_HALF_UP,
        STEM_ROUNDING_MODE_UNNECESSARY,
        STEM_INTEGER_WIDTH_TRUNC,
        STEM_GROUP_OFF,
        STEM_GROUP_MIN2,
        STEM_GROUP_AUTO,
        STEM_GROUP_ON_ALIGNED,
        STEM_GROUP_THOUSANDS,
        STEM_LATIN,
        STEM_UNIT_WIDTH_NARROW,
        STEM_UNIT_WIDTH_SHORT,
        STEM_UNIT_WIDTH_FULL_NAME,
        STEM_UNIT_WIDTH_ISO_CODE,
        STEM_UNIT_WIDTH_FORMAL,
        STEM_UNIT_WIDTH_VARIANT,
        STEM_UNIT_WIDTH_HIDDEN,
        STEM_SIGN_AUTO,
        STEM_SIGN_ALWAYS,
        STEM_SIGN_NEVER,
        STEM_SIGN_ACCOUNTING,
        STEM_SIGN_ACCOUNTING_ALWAYS,
        STEM_SIGN_EXCEPT_ZERO,
        STEM_SIGN_ACCOUNTING_EXCEPT_ZERO,
        STEM_SIGN_NEGATIVE,
        STEM_SIGN_ACCOUNTING_NEGATIVE,
        STEM_DECIMAL_AUTO,
        STEM_DECIMAL_ALWAYS,
        STEM_PRECISION_INCREMENT,
        STEM_MEASURE_UNIT,
        STEM_PER_MEASURE_UNIT,
        STEM_UNIT,
        STEM_UNIT_USAGE,
        STEM_CURRENCY,
        STEM_INTEGER_WIDTH,
        STEM_NUMBERING_SYSTEM,
        STEM_SCALE;

    }

    static enum ParseState {
        STATE_NULL,
        STATE_SCIENTIFIC,
        STATE_FRACTION_PRECISION,
        STATE_PRECISION,
        STATE_INCREMENT_PRECISION,
        STATE_MEASURE_UNIT,
        STATE_PER_MEASURE_UNIT,
        STATE_IDENTIFIER_UNIT,
        STATE_UNIT_USAGE,
        STATE_CURRENCY_UNIT,
        STATE_INTEGER_WIDTH,
        STATE_NUMBERING_SYSTEM,
        STATE_SCALE;

    }
}

