/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.number;

import java.math.RoundingMode;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MacroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Padder;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.IntegerWidth;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Notation;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberSkeletonImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Precision;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Scale;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DisplayOptions;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberingSystem;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MeasureUnit;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public abstract class NumberFormatterSettings<T extends NumberFormatterSettings<?>> {
    static final int KEY_MACROS = 0;
    static final int KEY_LOCALE = 1;
    static final int KEY_NOTATION = 2;
    static final int KEY_UNIT = 3;
    static final int KEY_PRECISION = 4;
    static final int KEY_ROUNDING_MODE = 5;
    static final int KEY_GROUPING = 6;
    static final int KEY_PADDER = 7;
    static final int KEY_INTEGER = 8;
    static final int KEY_SYMBOLS = 9;
    static final int KEY_UNIT_WIDTH = 10;
    static final int KEY_SIGN = 11;
    static final int KEY_DECIMAL = 12;
    static final int KEY_SCALE = 13;
    static final int KEY_THRESHOLD = 14;
    static final int KEY_PER_UNIT = 15;
    static final int KEY_USAGE = 16;
    static final int KEY_UNIT_DISPLAY_CASE = 17;
    static final int KEY_MAX = 18;
    private final NumberFormatterSettings<?> parent;
    private final int key;
    private final Object value;
    private volatile MacroProps resolvedMacros;

    NumberFormatterSettings(NumberFormatterSettings<?> numberFormatterSettings, int n2, Object object) {
        this.parent = numberFormatterSettings;
        this.key = n2;
        this.value = object;
    }

    public T notation(Notation notation) {
        return this.create(2, notation);
    }

    public T unit(MeasureUnit measureUnit) {
        return this.create(3, measureUnit);
    }

    public T perUnit(MeasureUnit measureUnit) {
        return this.create(15, measureUnit);
    }

    public T precision(Precision precision) {
        return this.create(4, precision);
    }

    public T roundingMode(RoundingMode roundingMode) {
        return this.create(5, (Object)roundingMode);
    }

    public T grouping(NumberFormatter.GroupingStrategy groupingStrategy) {
        return this.create(6, (Object)groupingStrategy);
    }

    public T integerWidth(IntegerWidth integerWidth) {
        return this.create(8, integerWidth);
    }

    public T symbols(DecimalFormatSymbols decimalFormatSymbols) {
        decimalFormatSymbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
        return this.create(9, decimalFormatSymbols);
    }

    public T symbols(NumberingSystem numberingSystem) {
        return this.create(9, numberingSystem);
    }

    public T unitWidth(NumberFormatter.UnitWidth unitWidth) {
        return this.create(10, (Object)unitWidth);
    }

    public T sign(NumberFormatter.SignDisplay signDisplay) {
        return this.create(11, (Object)signDisplay);
    }

    public T decimal(NumberFormatter.DecimalSeparatorDisplay decimalSeparatorDisplay) {
        return this.create(12, (Object)decimalSeparatorDisplay);
    }

    public T scale(Scale scale) {
        return this.create(13, scale);
    }

    public T usage(String string) {
        if (string != null && string.isEmpty()) {
            return this.create(16, null);
        }
        return this.create(16, string);
    }

    public T displayOptions(DisplayOptions displayOptions) {
        if (displayOptions.getGrammaticalCase() == DisplayOptions.GrammaticalCase.UNDEFINED) {
            return this.create(17, null);
        }
        return this.create(17, displayOptions.getGrammaticalCase().getIdentifier());
    }

    @Deprecated
    public T unitDisplayCase(String string) {
        return this.create(17, string);
    }

    @Deprecated
    public T macros(MacroProps macroProps) {
        return this.create(0, macroProps);
    }

    @Deprecated
    public T padding(Padder padder) {
        return this.create(7, padder);
    }

    @Deprecated
    public T threshold(Long l2) {
        return this.create(14, l2);
    }

    public String toSkeleton() {
        return NumberSkeletonImpl.generate(this.resolve());
    }

    abstract T create(int var1, Object var2);

    MacroProps resolve() {
        if (this.resolvedMacros != null) {
            return this.resolvedMacros;
        }
        MacroProps macroProps = new MacroProps();
        long l2 = 0L;
        NumberFormatterSettings<?> numberFormatterSettings = this;
        while (numberFormatterSettings != null) {
            long l3 = 1L << numberFormatterSettings.key;
            if (0L != (l2 & l3)) {
                numberFormatterSettings = numberFormatterSettings.parent;
                continue;
            }
            l2 |= l3;
            switch (numberFormatterSettings.key) {
                case 0: {
                    macroProps.fallback((MacroProps)numberFormatterSettings.value);
                    break;
                }
                case 1: {
                    macroProps.loc = (ULocale)numberFormatterSettings.value;
                    break;
                }
                case 2: {
                    macroProps.notation = (Notation)numberFormatterSettings.value;
                    break;
                }
                case 3: {
                    macroProps.unit = (MeasureUnit)numberFormatterSettings.value;
                    break;
                }
                case 4: {
                    macroProps.precision = (Precision)numberFormatterSettings.value;
                    break;
                }
                case 5: {
                    macroProps.roundingMode = (RoundingMode)((Object)numberFormatterSettings.value);
                    break;
                }
                case 6: {
                    macroProps.grouping = numberFormatterSettings.value;
                    break;
                }
                case 7: {
                    macroProps.padder = (Padder)numberFormatterSettings.value;
                    break;
                }
                case 8: {
                    macroProps.integerWidth = (IntegerWidth)numberFormatterSettings.value;
                    break;
                }
                case 9: {
                    macroProps.symbols = numberFormatterSettings.value;
                    break;
                }
                case 10: {
                    macroProps.unitWidth = (NumberFormatter.UnitWidth)((Object)numberFormatterSettings.value);
                    break;
                }
                case 11: {
                    macroProps.sign = (NumberFormatter.SignDisplay)((Object)numberFormatterSettings.value);
                    break;
                }
                case 12: {
                    macroProps.decimal = (NumberFormatter.DecimalSeparatorDisplay)((Object)numberFormatterSettings.value);
                    break;
                }
                case 13: {
                    macroProps.scale = (Scale)numberFormatterSettings.value;
                    break;
                }
                case 14: {
                    macroProps.threshold = (Long)numberFormatterSettings.value;
                    break;
                }
                case 15: {
                    macroProps.perUnit = (MeasureUnit)numberFormatterSettings.value;
                    break;
                }
                case 16: {
                    macroProps.usage = (String)numberFormatterSettings.value;
                    break;
                }
                case 17: {
                    macroProps.unitDisplayCase = (String)numberFormatterSettings.value;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown key: " + numberFormatterSettings.key));
                }
            }
            numberFormatterSettings = numberFormatterSettings.parent;
        }
        this.resolvedMacros = macroProps;
        return macroProps;
    }

    public int hashCode() {
        return this.resolve().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof NumberFormatterSettings)) {
            return false;
        }
        return this.resolve().equals(((NumberFormatterSettings)object).resolve());
    }
}

