/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.number;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedStringBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.IllegalIcuArgumentException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.CompactData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.ConstantAffixModifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Grouper;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.LongNameHandler;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.LongNameMultiplexer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MacroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroPropsGenerator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MixedUnitLongNameHandler;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MultiplierFormatHandler;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MutablePatternModifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Padder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.PatternStringParser;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.RoundingUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.UnitConversionHandler;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.UsagePrefsHandler;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.CompactNotation;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.IntegerWidth;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Precision;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.ScientificNotation;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberingSystem;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Currency;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MeasureUnit;

class NumberFormatterImpl {
    private static final Currency DEFAULT_CURRENCY = Currency.getInstance("XXX");
    final MicroProps micros = new MicroProps(true);
    final MicroPropsGenerator microPropsGenerator;

    public NumberFormatterImpl(MacroProps macroProps) {
        this.microPropsGenerator = NumberFormatterImpl.macrosToMicroGenerator(macroProps, this.micros, true);
    }

    public static MicroProps formatStatic(MacroProps macroProps, DecimalQuantity decimalQuantity, FormattedStringBuilder formattedStringBuilder) {
        MicroProps microProps = NumberFormatterImpl.preProcessUnsafe(macroProps, decimalQuantity);
        int n2 = NumberFormatterImpl.writeNumber(microProps, decimalQuantity, formattedStringBuilder, 0);
        NumberFormatterImpl.writeAffixes(microProps, formattedStringBuilder, 0, n2);
        return microProps;
    }

    public static int getPrefixSuffixStatic(MacroProps macroProps, byte by2, StandardPlural standardPlural, FormattedStringBuilder formattedStringBuilder) {
        MicroProps microProps = new MicroProps(false);
        MicroPropsGenerator microPropsGenerator = NumberFormatterImpl.macrosToMicroGenerator(macroProps, microProps, false);
        return NumberFormatterImpl.getPrefixSuffixImpl(microPropsGenerator, by2, formattedStringBuilder);
    }

    public MicroProps format(DecimalQuantity decimalQuantity, FormattedStringBuilder formattedStringBuilder) {
        MicroProps microProps = this.preProcess(decimalQuantity);
        int n2 = NumberFormatterImpl.writeNumber(microProps, decimalQuantity, formattedStringBuilder, 0);
        NumberFormatterImpl.writeAffixes(microProps, formattedStringBuilder, 0, n2);
        return microProps;
    }

    public MicroProps preProcess(DecimalQuantity decimalQuantity) {
        MicroProps microProps = this.microPropsGenerator.processQuantity(decimalQuantity);
        if (microProps.integerWidth.maxInt == -1) {
            decimalQuantity.setMinInteger(microProps.integerWidth.minInt);
        } else {
            decimalQuantity.setMinInteger(microProps.integerWidth.minInt);
            decimalQuantity.applyMaxInteger(microProps.integerWidth.maxInt);
        }
        return microProps;
    }

    private static MicroProps preProcessUnsafe(MacroProps macroProps, DecimalQuantity decimalQuantity) {
        MicroProps microProps = new MicroProps(false);
        MicroPropsGenerator microPropsGenerator = NumberFormatterImpl.macrosToMicroGenerator(macroProps, microProps, false);
        microProps = microPropsGenerator.processQuantity(decimalQuantity);
        if (microProps.integerWidth.maxInt == -1) {
            decimalQuantity.setMinInteger(microProps.integerWidth.minInt);
        } else {
            decimalQuantity.setMinInteger(microProps.integerWidth.minInt);
            decimalQuantity.applyMaxInteger(microProps.integerWidth.maxInt);
        }
        return microProps;
    }

    public int getPrefixSuffix(byte by2, StandardPlural standardPlural, FormattedStringBuilder formattedStringBuilder) {
        return NumberFormatterImpl.getPrefixSuffixImpl(this.microPropsGenerator, by2, formattedStringBuilder);
    }

    private static int getPrefixSuffixImpl(MicroPropsGenerator microPropsGenerator, byte by2, FormattedStringBuilder formattedStringBuilder) {
        DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = new DecimalQuantity_DualStorageBCD(0);
        if (by2 < 0) {
            decimalQuantity_DualStorageBCD.negate();
        }
        MicroProps microProps = microPropsGenerator.processQuantity(decimalQuantity_DualStorageBCD);
        microProps.modMiddle.apply(formattedStringBuilder, 0, 0);
        return microProps.modMiddle.getPrefixLength();
    }

    public MicroProps getRawMicroProps() {
        return this.micros;
    }

    private static boolean unitIsCurrency(MeasureUnit measureUnit) {
        return measureUnit != null && "currency".equals(measureUnit.getType());
    }

    private static boolean unitIsBaseUnit(MeasureUnit measureUnit) {
        return measureUnit == null;
    }

    private static boolean unitIsPercent(MeasureUnit measureUnit) {
        return measureUnit != null && "percent".equals(measureUnit.getSubtype());
    }

    private static boolean unitIsPermille(MeasureUnit measureUnit) {
        return measureUnit != null && "permille".equals(measureUnit.getSubtype());
    }

    private static MicroPropsGenerator macrosToMicroGenerator(MacroProps macroProps, MicroProps microProps, boolean bl2) {
        Object object;
        MicroPropsGenerator microPropsGenerator = microProps;
        boolean bl3 = NumberFormatterImpl.unitIsCurrency(macroProps.unit);
        boolean bl4 = NumberFormatterImpl.unitIsBaseUnit(macroProps.unit);
        boolean bl5 = NumberFormatterImpl.unitIsPercent(macroProps.unit);
        boolean bl6 = NumberFormatterImpl.unitIsPermille(macroProps.unit);
        boolean bl7 = macroProps.notation instanceof CompactNotation;
        boolean bl8 = macroProps.sign == NumberFormatter.SignDisplay.ACCOUNTING || macroProps.sign == NumberFormatter.SignDisplay.ACCOUNTING_ALWAYS || macroProps.sign == NumberFormatter.SignDisplay.ACCOUNTING_EXCEPT_ZERO || macroProps.sign == NumberFormatter.SignDisplay.ACCOUNTING_NEGATIVE;
        Currency currency = bl3 ? (Currency)macroProps.unit : DEFAULT_CURRENCY;
        NumberFormatter.UnitWidth unitWidth = NumberFormatter.UnitWidth.SHORT;
        if (macroProps.unitWidth != null) {
            unitWidth = macroProps.unitWidth;
        }
        boolean bl9 = !bl3 && !bl4 && (unitWidth == NumberFormatter.UnitWidth.FULL_NAME || !bl5 && !bl6 || bl7);
        boolean bl10 = bl9 && macroProps.unit.getType() == null && macroProps.unit.getComplexity() == MeasureUnit.Complexity.MIXED;
        PluralRules pluralRules = macroProps.rules;
        NumberingSystem numberingSystem = macroProps.symbols instanceof NumberingSystem ? (NumberingSystem)macroProps.symbols : NumberingSystem.getInstance(macroProps.loc);
        microProps.nsName = numberingSystem.getName();
        microProps.gender = "";
        if (macroProps.symbols instanceof DecimalFormatSymbols) {
            microProps.symbols = (DecimalFormatSymbols)macroProps.symbols;
        } else {
            microProps.symbols = DecimalFormatSymbols.forNumberingSystem(macroProps.loc, numberingSystem);
            if (bl3) {
                microProps.symbols.setCurrency(currency);
            }
        }
        String string = null;
        if (bl3 && microProps.symbols.getCurrencyPattern() != null) {
            string = microProps.symbols.getCurrencyPattern();
        }
        if (string == null) {
            int n2 = bl9 ? 0 : (bl5 || bl6 ? 2 : (!bl3 || unitWidth == NumberFormatter.UnitWidth.FULL_NAME ? 0 : (bl8 ? 7 : 1)));
            string = NumberFormat.getPatternForStyleAndNumberingSystem(macroProps.loc, microProps.nsName, n2);
        }
        PatternStringParser.ParsedPatternInfo parsedPatternInfo = PatternStringParser.parseToPatternInfo(string);
        UsagePrefsHandler usagePrefsHandler = null;
        if (macroProps.usage != null) {
            if (!bl9) {
                throw new IllegalIcuArgumentException("We only support \"usage\" when the input unit is specified, and is a CLDR Unit.");
            }
            usagePrefsHandler = new UsagePrefsHandler(macroProps.loc, macroProps.unit, macroProps.usage, microPropsGenerator);
            microPropsGenerator = usagePrefsHandler;
        } else if (bl10) {
            microPropsGenerator = new UnitConversionHandler(macroProps.unit, microPropsGenerator);
        }
        if (macroProps.scale != null) {
            microPropsGenerator = new MultiplierFormatHandler(macroProps.scale, microPropsGenerator);
        }
        microProps.rounder = macroProps.precision != null ? macroProps.precision : (bl7 ? Precision.COMPACT_STRATEGY : (bl3 ? Precision.MONETARY_STANDARD : (macroProps.usage != null ? Precision.BOGUS_PRECISION : Precision.DEFAULT_MAX_FRAC_6)));
        if (macroProps.roundingMode != null) {
            microProps.rounder = microProps.rounder.withMode(RoundingUtils.mathContextUnlimited(macroProps.roundingMode));
        }
        microProps.rounder = microProps.rounder.withLocaleData(currency);
        microProps.grouping = macroProps.grouping instanceof Grouper ? (Grouper)macroProps.grouping : (macroProps.grouping instanceof NumberFormatter.GroupingStrategy ? Grouper.forStrategy((NumberFormatter.GroupingStrategy)((Object)macroProps.grouping)) : (bl7 ? Grouper.forStrategy(NumberFormatter.GroupingStrategy.MIN2) : Grouper.forStrategy(NumberFormatter.GroupingStrategy.AUTO)));
        microProps.grouping = microProps.grouping.withLocaleData(macroProps.loc, parsedPatternInfo);
        microProps.padding = macroProps.padder != null ? macroProps.padder : Padder.NONE;
        microProps.integerWidth = macroProps.integerWidth != null ? macroProps.integerWidth : IntegerWidth.DEFAULT;
        microProps.sign = macroProps.sign != null ? macroProps.sign : NumberFormatter.SignDisplay.AUTO;
        microProps.decimal = macroProps.decimal != null ? macroProps.decimal : NumberFormatter.DecimalSeparatorDisplay.AUTO;
        microProps.useCurrency = bl3;
        if (macroProps.notation instanceof ScientificNotation) {
            microPropsGenerator = ((ScientificNotation)macroProps.notation).withLocaleData(microProps.symbols, bl2, microPropsGenerator);
        } else {
            microProps.modInner = ConstantAffixModifier.EMPTY;
        }
        MutablePatternModifier mutablePatternModifier = new MutablePatternModifier(false);
        PatternStringParser.ParsedPatternInfo parsedPatternInfo2 = macroProps.affixProvider != null && (!bl7 || bl3 == macroProps.affixProvider.hasCurrencySign()) ? macroProps.affixProvider : parsedPatternInfo;
        mutablePatternModifier.setPatternInfo(parsedPatternInfo2, null);
        boolean bl11 = macroProps.approximately != null ? macroProps.approximately : false;
        mutablePatternModifier.setPatternAttributes(microProps.sign, bl6, bl11);
        if (mutablePatternModifier.needsPlurals()) {
            if (pluralRules == null) {
                pluralRules = PluralRules.forLocale(macroProps.loc);
            }
            mutablePatternModifier.setSymbols(microProps.symbols, currency, unitWidth, pluralRules);
        } else {
            mutablePatternModifier.setSymbols(microProps.symbols, currency, unitWidth, null);
        }
        MutablePatternModifier.ImmutablePatternModifier immutablePatternModifier = null;
        if (bl2) {
            immutablePatternModifier = mutablePatternModifier.createImmutable();
        }
        if (parsedPatternInfo2.currencyAsDecimal()) {
            microProps.currencyAsDecimal = mutablePatternModifier.getCurrencySymbolForUnitWidth();
        }
        if (bl9) {
            PluralRules pluralRules2;
            object = null;
            if (macroProps.unitDisplayCase != null) {
                object = macroProps.unitDisplayCase;
            }
            if (pluralRules == null) {
                pluralRules = PluralRules.forLocale(macroProps.loc);
            }
            PluralRules pluralRules3 = pluralRules2 = macroProps.rules != null ? macroProps.rules : PluralRules.forLocale(macroProps.loc);
            if (macroProps.usage != null) {
                assert (usagePrefsHandler != null);
                microPropsGenerator = LongNameMultiplexer.forMeasureUnits(macroProps.loc, usagePrefsHandler.getOutputUnits(), unitWidth, object, pluralRules2, microPropsGenerator);
            } else if (bl10) {
                microPropsGenerator = MixedUnitLongNameHandler.forMeasureUnit(macroProps.loc, macroProps.unit, unitWidth, object, pluralRules2, microPropsGenerator);
            } else {
                MeasureUnit measureUnit = macroProps.unit;
                if (macroProps.perUnit != null && (measureUnit = measureUnit.product(macroProps.perUnit.reciprocal())).getType() == null && (macroProps.unit.getType() == null || macroProps.perUnit.getType() == null)) {
                    throw new UnsupportedOperationException("perUnit() can only be used if unit and perUnit are both built-ins, or the combination is a built-in");
                }
                microPropsGenerator = LongNameHandler.forMeasureUnit(macroProps.loc, measureUnit, unitWidth, object, pluralRules2, microPropsGenerator);
            }
        } else if (bl3 && unitWidth == NumberFormatter.UnitWidth.FULL_NAME) {
            if (pluralRules == null) {
                pluralRules = PluralRules.forLocale(macroProps.loc);
            }
            microPropsGenerator = LongNameHandler.forCurrencyLongNames(macroProps.loc, currency, pluralRules, microPropsGenerator);
        } else {
            microProps.modOuter = ConstantAffixModifier.EMPTY;
        }
        if (bl7) {
            if (pluralRules == null) {
                pluralRules = PluralRules.forLocale(macroProps.loc);
            }
            object = macroProps.unit instanceof Currency && macroProps.unitWidth != NumberFormatter.UnitWidth.FULL_NAME ? CompactData.CompactType.CURRENCY : CompactData.CompactType.DECIMAL;
            microPropsGenerator = ((CompactNotation)macroProps.notation).withLocaleData(macroProps.loc, microProps.nsName, (CompactData.CompactType)((Object)object), pluralRules, mutablePatternModifier, bl2, microPropsGenerator);
        }
        microPropsGenerator = bl2 ? immutablePatternModifier.addToChain(microPropsGenerator) : mutablePatternModifier.addToChain(microPropsGenerator);
        return microPropsGenerator;
    }

    public static int writeAffixes(MicroProps microProps, FormattedStringBuilder formattedStringBuilder, int n2, int n3) {
        int n4 = microProps.modInner.apply(formattedStringBuilder, n2, n3);
        if (microProps.padding.isValid()) {
            microProps.padding.padAndApply(microProps.modMiddle, microProps.modOuter, formattedStringBuilder, n2, n3 + n4);
        } else {
            n4 += microProps.modMiddle.apply(formattedStringBuilder, n2, n3 + n4);
            n4 += microProps.modOuter.apply(formattedStringBuilder, n2, n3 + n4);
        }
        return n4;
    }

    public static int writeNumber(MicroProps microProps, DecimalQuantity decimalQuantity, FormattedStringBuilder formattedStringBuilder, int n2) {
        int n3 = 0;
        if (decimalQuantity.isInfinite()) {
            n3 += formattedStringBuilder.insert(n3 + n2, microProps.symbols.getInfinity(), NumberFormat.Field.INTEGER);
        } else if (decimalQuantity.isNaN()) {
            n3 += formattedStringBuilder.insert(n3 + n2, microProps.symbols.getNaN(), NumberFormat.Field.INTEGER);
        } else {
            n3 += NumberFormatterImpl.writeIntegerDigits(microProps, decimalQuantity, formattedStringBuilder, n3 + n2);
            if (decimalQuantity.getLowerDisplayMagnitude() < 0 || microProps.decimal == NumberFormatter.DecimalSeparatorDisplay.ALWAYS) {
                n3 = microProps.currencyAsDecimal != null ? (n3 += formattedStringBuilder.insert(n3 + n2, microProps.currencyAsDecimal, NumberFormat.Field.CURRENCY)) : (microProps.useCurrency ? (n3 += formattedStringBuilder.insert(n3 + n2, microProps.symbols.getMonetaryDecimalSeparatorString(), NumberFormat.Field.DECIMAL_SEPARATOR)) : (n3 += formattedStringBuilder.insert(n3 + n2, microProps.symbols.getDecimalSeparatorString(), NumberFormat.Field.DECIMAL_SEPARATOR)));
            }
            if ((n3 += NumberFormatterImpl.writeFractionDigits(microProps, decimalQuantity, formattedStringBuilder, n3 + n2)) == 0) {
                n3 = microProps.symbols.getCodePointZero() != -1 ? (n3 += formattedStringBuilder.insertCodePoint(n2, microProps.symbols.getCodePointZero(), NumberFormat.Field.INTEGER)) : (n3 += formattedStringBuilder.insert(n2, microProps.symbols.getDigitStringsLocal()[0], NumberFormat.Field.INTEGER));
            }
        }
        return n3;
    }

    private static int writeIntegerDigits(MicroProps microProps, DecimalQuantity decimalQuantity, FormattedStringBuilder formattedStringBuilder, int n2) {
        int n3 = 0;
        int n4 = decimalQuantity.getUpperDisplayMagnitude() + 1;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (microProps.grouping.groupAtPosition(i2, decimalQuantity)) {
                n3 += formattedStringBuilder.insert(n2, microProps.useCurrency ? microProps.symbols.getMonetaryGroupingSeparatorString() : microProps.symbols.getGroupingSeparatorString(), NumberFormat.Field.GROUPING_SEPARATOR);
            }
            byte by2 = decimalQuantity.getDigit(i2);
            if (microProps.symbols.getCodePointZero() != -1) {
                n3 += formattedStringBuilder.insertCodePoint(n2, microProps.symbols.getCodePointZero() + by2, NumberFormat.Field.INTEGER);
                continue;
            }
            n3 += formattedStringBuilder.insert(n2, microProps.symbols.getDigitStringsLocal()[by2], NumberFormat.Field.INTEGER);
        }
        return n3;
    }

    private static int writeFractionDigits(MicroProps microProps, DecimalQuantity decimalQuantity, FormattedStringBuilder formattedStringBuilder, int n2) {
        int n3 = 0;
        int n4 = -decimalQuantity.getLowerDisplayMagnitude();
        for (int i2 = 0; i2 < n4; ++i2) {
            byte by2 = decimalQuantity.getDigit(-i2 - 1);
            if (microProps.symbols.getCodePointZero() != -1) {
                n3 += formattedStringBuilder.insertCodePoint(n3 + n2, microProps.symbols.getCodePointZero() + by2, NumberFormat.Field.FRACTION);
                continue;
            }
            n3 += formattedStringBuilder.insert(n3 + n2, microProps.symbols.getDigitStringsLocal()[by2], NumberFormat.Field.FRACTION);
        }
        return n3;
    }
}

