/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.message2;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.InputSource;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.MFDataModel;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.MFDataModelValidator;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.MFParseException;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.StringUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.StringView;

@Deprecated
public class MFParser {
    private static final int EOF = -1;
    private final InputSource input;
    private static final Pattern RE_NUMBER_LITERAL = Pattern.compile("^-?(0|[1-9][0-9]*)(\\.[0-9]+)?([eE][+\\-]?[0-9]+)?");

    MFParser(String string) {
        this.input = new InputSource(string);
    }

    @Deprecated
    public static MFDataModel.Message parse(String string) throws MFParseException {
        return new MFParser(string).parseImpl();
    }

    private MFDataModel.Message parseImpl() throws MFParseException {
        MFDataModel.Message message;
        int n2 = this.input.peekChar();
        if (n2 == 46) {
            message = this.getComplexMessage();
        } else if (n2 == 123) {
            n2 = this.input.readCodePoint();
            n2 = this.input.peekChar();
            if (n2 == 123) {
                this.input.backup(1);
                MFDataModel.Pattern pattern = this.getQuotedPattern();
                message = new MFDataModel.PatternMessage(new ArrayList<MFDataModel.Declaration>(), pattern);
            } else {
                this.input.backup(1);
                MFDataModel.Pattern pattern = this.getPattern();
                message = new MFDataModel.PatternMessage(new ArrayList<MFDataModel.Declaration>(), pattern);
            }
        } else {
            MFDataModel.Pattern pattern = this.getPattern();
            message = new MFDataModel.PatternMessage(new ArrayList<MFDataModel.Declaration>(), pattern);
        }
        this.skipOptionalWhitespaces();
        this.checkCondition(this.input.atEnd(), "Content detected after the end of the message.");
        new MFDataModelValidator(message).validate();
        return message;
    }

    private MFDataModel.Pattern getPattern() throws MFParseException {
        MFDataModel.PatternPart patternPart;
        MFDataModel.Pattern pattern = new MFDataModel.Pattern();
        while ((patternPart = this.getPatternPart()) != null) {
            pattern.parts.add(patternPart);
        }
        return pattern;
    }

    private MFDataModel.PatternPart getPatternPart() throws MFParseException {
        int n2 = this.input.peekChar();
        switch (n2) {
            case -1: {
                return null;
            }
            case 125: {
                return null;
            }
            case 123: {
                MFDataModel.Expression expression = this.getPlaceholder();
                return expression;
            }
        }
        String string = this.getText();
        MFDataModel.StringPart stringPart = new MFDataModel.StringPart(string);
        return stringPart;
    }

    private String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        block5: while (true) {
            int n2 = this.input.readCodePoint();
            switch (n2) {
                case -1: {
                    return stringBuilder.toString();
                }
                case 92: {
                    n2 = this.input.readCodePoint();
                    if (n2 == 92 || n2 == 123 || n2 == 124 | n2 == 125) {
                        stringBuilder.appendCodePoint(n2);
                        continue block5;
                    }
                    stringBuilder.appendCodePoint(92);
                    stringBuilder.appendCodePoint(n2);
                    continue block5;
                }
                case 46: 
                case 64: 
                case 124: {
                    stringBuilder.appendCodePoint(n2);
                    continue block5;
                }
            }
            if (!StringUtils.isContentChar(n2) && !StringUtils.isWhitespace(n2)) break;
            stringBuilder.appendCodePoint(n2);
        }
        this.input.backup(1);
        return stringBuilder.toString();
    }

    private MFDataModel.Expression getPlaceholder() throws MFParseException {
        int n2 = this.input.peekChar();
        if (n2 != 123) {
            return null;
        }
        this.input.readCodePoint();
        this.skipOptionalWhitespaces();
        n2 = this.input.peekChar();
        MFDataModel.Expression expression = n2 == 35 || n2 == 47 ? this.getMarkup() : (n2 == 36 ? this.getVariableExpression() : (StringUtils.isFunctionSigil(n2) || StringUtils.isPrivateAnnotationSigil(n2) || StringUtils.isReservedAnnotationSigil(n2) ? this.getAnnotationExpression() : this.getLiteralExpression()));
        this.skipOptionalWhitespaces();
        n2 = this.input.readCodePoint();
        this.checkCondition(n2 == 125, "Unclosed placeholder");
        return expression;
    }

    private MFDataModel.Annotation getAnnotation() throws MFParseException {
        int n2 = this.input.getPosition();
        this.skipOptionalWhitespaces();
        int n3 = this.input.peekChar();
        switch (n3) {
            case 125: {
                return null;
            }
            case 58: {
                this.input.readCodePoint();
                String string = this.getIdentifier();
                this.checkCondition(string != null, "Annotation / function name missing");
                Map<String, MFDataModel.Option> map = this.getOptions();
                return new MFDataModel.FunctionAnnotation(string, map);
            }
        }
        if (StringUtils.isReservedAnnotationSigil(n3) || StringUtils.isPrivateAnnotationSigil(n3)) {
            n3 = this.input.readCodePoint();
            String string = (char)n3 + this.getIdentifier();
            String string2 = this.getReservedBody();
            return new MFDataModel.UnsupportedAnnotation(string + string2);
        }
        this.input.gotoPosition(n2);
        return null;
    }

    private MFDataModel.Annotation getMarkupAnnotation() throws MFParseException {
        this.skipOptionalWhitespaces();
        int n2 = this.input.peekChar();
        switch (n2) {
            case 125: {
                return null;
            }
            case 35: 
            case 47: {
                this.input.readCodePoint();
                String string = this.getIdentifier();
                this.checkCondition(string != null, "Annotation / function name missing");
                Map<String, MFDataModel.Option> map = this.getOptions();
                return new MFDataModel.FunctionAnnotation(string, map);
            }
        }
        return null;
    }

    private MFDataModel.Expression getLiteralExpression() throws MFParseException {
        MFDataModel.Literal literal = this.getLiteral();
        this.checkCondition(literal != null, "Literal expression expected.");
        MFDataModel.Annotation annotation = null;
        int n2 = this.skipWhitespaces();
        if (n2 > 0 && (annotation = this.getAnnotation()) == null) {
            this.input.backup(1);
        }
        List<MFDataModel.Attribute> list = this.getAttributes();
        return new MFDataModel.LiteralExpression(literal, annotation, list);
    }

    private MFDataModel.VariableExpression getVariableExpression() throws MFParseException {
        MFDataModel.VariableRef variableRef = this.getVariableRef();
        MFDataModel.Annotation annotation = this.getAnnotation();
        List<MFDataModel.Attribute> list = this.getAttributes();
        return new MFDataModel.VariableExpression(variableRef, annotation, list);
    }

    private MFDataModel.Expression getAnnotationExpression() throws MFParseException {
        MFDataModel.Annotation annotation = this.getAnnotation();
        List<MFDataModel.Attribute> list = this.getAttributes();
        if (annotation instanceof MFDataModel.FunctionAnnotation) {
            return new MFDataModel.FunctionExpression((MFDataModel.FunctionAnnotation)annotation, list);
        }
        if (annotation instanceof MFDataModel.UnsupportedAnnotation) {
            return new MFDataModel.UnsupportedExpression((MFDataModel.UnsupportedAnnotation)annotation, list);
        }
        this.error("Unexpected annotation : " + annotation);
        return null;
    }

    private MFDataModel.Markup getMarkup() throws MFParseException {
        int n2 = this.input.peekChar();
        this.checkCondition(n2 == 35 || n2 == 47, "Should not happen. Expecting a markup.");
        MFDataModel.Markup.Kind kind = n2 == 47 ? MFDataModel.Markup.Kind.CLOSE : MFDataModel.Markup.Kind.OPEN;
        MFDataModel.Annotation annotation = this.getMarkupAnnotation();
        List<MFDataModel.Attribute> list = this.getAttributes();
        n2 = this.input.peekChar();
        if (n2 == 47) {
            kind = MFDataModel.Markup.Kind.STANDALONE;
            this.input.readCodePoint();
        }
        if (annotation instanceof MFDataModel.FunctionAnnotation) {
            MFDataModel.FunctionAnnotation functionAnnotation = (MFDataModel.FunctionAnnotation)annotation;
            return new MFDataModel.Markup(kind, functionAnnotation.name, functionAnnotation.options, list);
        }
        return null;
    }

    private List<MFDataModel.Attribute> getAttributes() throws MFParseException {
        MFDataModel.Attribute attribute;
        ArrayList<MFDataModel.Attribute> arrayList = new ArrayList<MFDataModel.Attribute>();
        while ((attribute = this.getAttribute()) != null) {
            arrayList.add(attribute);
        }
        return arrayList;
    }

    private MFDataModel.Attribute getAttribute() throws MFParseException {
        int n2 = this.input.getPosition();
        if (this.skipWhitespaces() == 0) {
            this.input.gotoPosition(n2);
            return null;
        }
        int n3 = this.input.peekChar();
        if (n3 == 64) {
            this.input.readCodePoint();
            String string = this.getIdentifier();
            int n4 = this.skipWhitespaces();
            n3 = this.input.peekChar();
            MFDataModel.LiteralOrVariableRef literalOrVariableRef = null;
            if (n3 == 61) {
                this.input.readCodePoint();
                this.skipOptionalWhitespaces();
                literalOrVariableRef = this.getLiteralOrVariableRef();
                this.checkCondition(literalOrVariableRef != null, "Attributes must have a value after `=`");
            } else {
                this.input.backup(n4);
            }
            return new MFDataModel.Attribute(string, literalOrVariableRef);
        }
        this.input.gotoPosition(n2);
        return null;
    }

    private String getReservedBody() throws MFParseException {
        int n2;
        int n3 = this.skipWhitespaces();
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            if (StringUtils.isReservedChar(n2 = this.input.readCodePoint())) {
                stringBuilder.appendCodePoint(n2);
                continue;
            }
            if (n2 == 92) {
                n2 = this.input.readCodePoint();
                this.checkCondition(n2 == 123 || n2 == 124 || n2 == 125, "Invalid escape sequence. Only \\{, \\| and \\} are valid here.");
                stringBuilder.append(n2);
                continue;
            }
            if (n2 != 124) break;
            this.input.backup(1);
            MFDataModel.Literal literal = this.getQuotedLiteral();
            stringBuilder.append(literal.value);
        }
        if (n2 == -1) {
            return stringBuilder.toString();
        }
        if (stringBuilder.length() == 0) {
            this.input.backup(n3 + 1);
            return "";
        }
        this.input.backup(1);
        return stringBuilder.toString();
    }

    private String getIdentifier() throws MFParseException {
        String string = this.getName();
        if (string == null) {
            return null;
        }
        int n2 = this.input.readCodePoint();
        if (n2 == 58) {
            String string2 = this.getName();
            this.checkCondition(string2 != null, "Expected name after namespace '" + string + "'");
            return string + ":" + string2;
        }
        this.input.backup(1);
        return string;
    }

    private Map<String, MFDataModel.Option> getOptions() throws MFParseException {
        MFDataModel.Option option;
        LinkedHashMap<String, MFDataModel.Option> linkedHashMap = new LinkedHashMap<String, MFDataModel.Option>();
        while ((option = this.getOption()) != null) {
            if (linkedHashMap.containsKey(option.name)) {
                this.error("Duplicated option '" + option.name + "'");
            }
            linkedHashMap.put(option.name, option);
        }
        return linkedHashMap;
    }

    private MFDataModel.Option getOption() throws MFParseException {
        int n2 = this.input.getPosition();
        this.skipOptionalWhitespaces();
        String string = this.getIdentifier();
        if (string == null) {
            this.input.gotoPosition(n2);
            return null;
        }
        this.skipOptionalWhitespaces();
        int n3 = this.input.readCodePoint();
        this.checkCondition(n3 == 61, "Expected '='");
        MFDataModel.LiteralOrVariableRef literalOrVariableRef = this.getLiteralOrVariableRef();
        if (literalOrVariableRef == null) {
            this.error("Options must have a value. An empty string should be quoted.");
        }
        return new MFDataModel.Option(string, literalOrVariableRef);
    }

    private MFDataModel.LiteralOrVariableRef getLiteralOrVariableRef() throws MFParseException {
        int n2 = this.input.peekChar();
        if (n2 == 36) {
            return this.getVariableRef();
        }
        return this.getLiteral();
    }

    private MFDataModel.Literal getLiteral() throws MFParseException {
        int n2 = this.input.readCodePoint();
        switch (n2) {
            case 124: {
                this.input.backup(1);
                MFDataModel.Literal literal = this.getQuotedLiteral();
                return literal;
            }
        }
        this.input.backup(1);
        MFDataModel.Literal literal = this.getUnQuotedLiteral();
        return literal;
    }

    private MFDataModel.VariableRef getVariableRef() throws MFParseException {
        String string;
        int n2 = this.input.readCodePoint();
        if (n2 != 36) {
            this.checkCondition(n2 == 36, "We can't get here");
        }
        this.checkCondition((string = this.getName()) != null, "Invalid variable reference following $");
        return new MFDataModel.VariableRef(string);
    }

    private MFDataModel.Literal getQuotedLiteral() throws MFParseException {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.input.readCodePoint();
        this.checkCondition(n2 == 124, "expected starting '|'");
        while ((n2 = this.input.readCodePoint()) != -1) {
            if (StringUtils.isQuotedChar(n2)) {
                stringBuilder.appendCodePoint(n2);
                continue;
            }
            if (n2 != 92) break;
            n2 = this.input.readCodePoint();
            this.checkCondition(n2 == 124, "Invalid escape sequence, only \"\\|\" is valid here");
            stringBuilder.appendCodePoint(124);
        }
        this.checkCondition(n2 == 124, "expected ending '|'");
        return new MFDataModel.Literal(stringBuilder.toString());
    }

    private MFDataModel.Literal getUnQuotedLiteral() throws MFParseException {
        String string = this.getName();
        if (string != null) {
            return new MFDataModel.Literal(string);
        }
        return this.getNumberLiteral();
    }

    private MFDataModel.Literal getNumberLiteral() {
        String string = this.peekWithRegExp(RE_NUMBER_LITERAL);
        if (string != null) {
            return new MFDataModel.Literal(string);
        }
        return null;
    }

    private void skipMandatoryWhitespaces() throws MFParseException {
        int n2 = this.skipWhitespaces();
        this.checkCondition(n2 > 0, "Space expected");
    }

    private void skipOptionalWhitespaces() {
        this.skipWhitespaces();
    }

    private int skipWhitespaces() {
        int n2 = 0;
        int n3;
        while ((n3 = this.input.readCodePoint()) != -1) {
            if (!StringUtils.isWhitespace(n3)) {
                this.input.backup(1);
                return n2;
            }
            ++n2;
        }
        return n2;
    }

    private MFDataModel.Message getComplexMessage() throws MFParseException {
        MFDataModel.Declaration declaration;
        ArrayList<MFDataModel.Declaration> arrayList = new ArrayList<MFDataModel.Declaration>();
        boolean bl2 = false;
        while ((declaration = this.getDeclaration()) != null) {
            if (declaration instanceof MatchDeclaration) {
                bl2 = true;
                break;
            }
            arrayList.add(declaration);
        }
        if (bl2) {
            return this.getMatch(arrayList);
        }
        this.skipOptionalWhitespaces();
        int n2 = this.input.peekChar();
        if (n2 == -1) {
            return new MFDataModel.PatternMessage(arrayList, null);
        }
        MFDataModel.Pattern pattern = this.getQuotedPattern();
        return new MFDataModel.PatternMessage(arrayList, pattern);
    }

    private MFDataModel.SelectMessage getMatch(List<MFDataModel.Declaration> list) throws MFParseException {
        MFDataModel.Variant variant;
        Object object;
        ArrayList<MFDataModel.Expression> arrayList = new ArrayList<MFDataModel.Expression>();
        while (true) {
            this.skipMandatoryWhitespaces();
            object = this.getPlaceholder();
            if (object == null) break;
            this.checkCondition(!(object instanceof MFDataModel.Markup), "Cannot do selection on markup");
            arrayList.add((MFDataModel.Expression)object);
        }
        this.checkCondition(!arrayList.isEmpty(), "There should be at least one selector expression.");
        object = new ArrayList();
        while ((variant = this.getVariant()) != null) {
            object.add(variant);
        }
        return new MFDataModel.SelectMessage(list, arrayList, (List<MFDataModel.Variant>)object);
    }

    private MFDataModel.Variant getVariant() throws MFParseException {
        Object object;
        ArrayList<MFDataModel.LiteralOrCatchallKey> arrayList = new ArrayList<MFDataModel.LiteralOrCatchallKey>();
        while ((object = this.getKey(!arrayList.isEmpty())) != null) {
            arrayList.add((MFDataModel.LiteralOrCatchallKey)object);
        }
        this.skipOptionalWhitespaces();
        if (this.input.atEnd()) {
            this.checkCondition(arrayList.isEmpty(), "After selector keys it is mandatory to have a pattern.");
            return null;
        }
        object = this.getQuotedPattern();
        return new MFDataModel.Variant(arrayList, (MFDataModel.Pattern)object);
    }

    private MFDataModel.LiteralOrCatchallKey getKey(boolean bl2) throws MFParseException {
        if (bl2) {
            this.skipMandatoryWhitespaces();
        } else {
            this.skipOptionalWhitespaces();
        }
        int n2 = this.input.peekChar();
        if (n2 == 42) {
            this.input.readCodePoint();
            return new MFDataModel.CatchallKey();
        }
        if (n2 == -1) {
            return null;
        }
        return this.getLiteral();
    }

    private MFDataModel.Declaration getDeclaration() throws MFParseException {
        int n2 = this.input.getPosition();
        this.skipOptionalWhitespaces();
        int n3 = this.input.readCodePoint();
        if (n3 != 46) {
            this.input.gotoPosition(n2);
            return null;
        }
        String string = this.getName();
        this.checkCondition(string != null, "Expected a declaration after the '.'");
        switch (string) {
            case "input": {
                this.skipMandatoryWhitespaces();
                MFDataModel.Expression expression = this.getPlaceholder();
                String string2 = null;
                if (expression instanceof MFDataModel.VariableExpression) {
                    string2 = ((MFDataModel.VariableExpression)expression).arg.name;
                }
                if (!(expression instanceof MFDataModel.VariableExpression)) break;
                return new MFDataModel.InputDeclaration(string2, (MFDataModel.VariableExpression)expression);
            }
            case "local": {
                this.skipMandatoryWhitespaces();
                MFDataModel.VariableRef variableRef = this.getVariableRef();
                this.skipOptionalWhitespaces();
                n3 = this.input.readCodePoint();
                this.checkCondition(n3 == 61, string);
                this.skipOptionalWhitespaces();
                MFDataModel.Expression expression = this.getPlaceholder();
                if (!(variableRef instanceof MFDataModel.VariableRef)) break;
                return new MFDataModel.LocalDeclaration(variableRef.name, expression);
            }
            case "match": {
                return new MatchDeclaration();
            }
            default: {
                this.skipOptionalWhitespaces();
                String string3 = this.getReservedBody();
                ArrayList<MFDataModel.Expression> arrayList = new ArrayList<MFDataModel.Expression>();
                while (true) {
                    this.skipOptionalWhitespaces();
                    MFDataModel.Expression expression = this.getPlaceholder();
                    if (!(expression instanceof MFDataModel.VariableExpression)) break;
                    arrayList.add(expression);
                }
                return new MFDataModel.UnsupportedStatement(string, string3, arrayList);
            }
        }
        return null;
    }

    private MFDataModel.Pattern getQuotedPattern() throws MFParseException {
        int n2 = this.input.readCodePoint();
        this.checkCondition(n2 == 123, "Expected { for a complex body");
        n2 = this.input.readCodePoint();
        this.checkCondition(n2 == 123, "Expected second { for a complex body");
        MFDataModel.Pattern pattern = this.getPattern();
        n2 = this.input.readCodePoint();
        this.checkCondition(n2 == 125, "Expected } to end a complex body");
        n2 = this.input.readCodePoint();
        this.checkCondition(n2 == 125, "Expected second } to end a complex body");
        return pattern;
    }

    private String getName() throws MFParseException {
        StringBuilder stringBuilder;
        block2: {
            stringBuilder = new StringBuilder();
            int n2 = this.input.readCodePoint();
            this.checkCondition(n2 != -1, "Expected name or namespace.");
            if (!StringUtils.isNameStart(n2)) {
                this.input.backup(1);
                return null;
            }
            stringBuilder.appendCodePoint(n2);
            while (StringUtils.isNameChar(n2 = this.input.readCodePoint())) {
                stringBuilder.appendCodePoint(n2);
            }
            if (n2 == -1) break block2;
            this.input.backup(1);
        }
        return stringBuilder.toString();
    }

    private void checkCondition(boolean bl2, String string) throws MFParseException {
        if (!bl2) {
            this.error(string);
        }
    }

    private void error(String string) throws MFParseException {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.input == null) {
            stringBuilder.append("Parse error: ");
            stringBuilder.append(string);
        } else {
            int n2 = this.input.getPosition();
            stringBuilder.append("Parse error [" + this.input.getPosition() + "]: ");
            stringBuilder.append(string);
            stringBuilder.append("\n");
            if (n2 != -1) {
                stringBuilder.append(this.input.buffer.substring(0, n2));
                stringBuilder.append("^^^");
                stringBuilder.append(this.input.buffer.substring(n2));
            } else {
                stringBuilder.append(this.input.buffer);
                stringBuilder.append("^^^");
            }
        }
        throw new MFParseException(stringBuilder.toString(), this.input.getPosition());
    }

    private String peekWithRegExp(Pattern pattern) {
        StringView stringView = new StringView(this.input.buffer, this.input.getPosition());
        Matcher matcher = pattern.matcher(stringView);
        boolean bl2 = matcher.find();
        if (bl2) {
            this.input.skip(matcher.group().length());
            return matcher.group();
        }
        return null;
    }

    private static class MatchDeclaration
    implements MFDataModel.Declaration {
        private MatchDeclaration() {
        }
    }
}

