/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.units;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.IllegalIcuArgumentException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UResource;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.ConversionRates;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.MeasureUnitImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.UnitPreferences;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public class UnitsData {
    private static String[] simpleUnits = null;
    private static int[] simpleUnitCategories = null;
    private ConversionRates conversionRates = new ConversionRates();
    private UnitPreferences unitPreferences = new UnitPreferences();

    public static String[] getSimpleUnits() {
        return simpleUnits;
    }

    public ConversionRates getConversionRates() {
        return this.conversionRates;
    }

    public UnitPreferences getUnitPreferences() {
        return this.unitPreferences;
    }

    public static int getCategoryIndexOfSimpleUnit(int n2) {
        return simpleUnitCategories[n2];
    }

    public String getCategory(MeasureUnitImpl measureUnitImpl) {
        MeasureUnitImpl measureUnitImpl2 = this.getConversionRates().extractCompoundBaseUnit(measureUnitImpl);
        measureUnitImpl2.serialize();
        String string = measureUnitImpl2.getIdentifier();
        Integer n2 = Categories.baseUnitToIndex.get(string);
        if (n2 == null) {
            measureUnitImpl2.takeReciprocal();
            measureUnitImpl2.serialize();
            string = measureUnitImpl2.getIdentifier();
            n2 = Categories.baseUnitToIndex.get(string);
        }
        measureUnitImpl2.takeReciprocal();
        MeasureUnitImpl measureUnitImpl3 = measureUnitImpl2.copyAndSimplify();
        if (n2 == null) {
            measureUnitImpl3.serialize();
            string = measureUnitImpl3.getIdentifier();
            n2 = Categories.baseUnitToIndex.get(string);
        }
        if (n2 == null) {
            measureUnitImpl3.takeReciprocal();
            measureUnitImpl3.serialize();
            string = measureUnitImpl3.getIdentifier();
            n2 = Categories.baseUnitToIndex.get(string);
        }
        if (n2 == null) {
            throw new IllegalIcuArgumentException("This unit does not has a category" + measureUnitImpl.getIdentifier());
        }
        return Categories.indexToCategory[n2];
    }

    public UnitPreferences.UnitPreference[] getPreferencesFor(String string, String string2, ULocale uLocale) {
        return this.unitPreferences.getPreferencesFor(string, string2, uLocale, this);
    }

    static {
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "units");
        SimpleUnitIdentifiersSink simpleUnitIdentifiersSink = new SimpleUnitIdentifiersSink();
        iCUResourceBundle.getAllItemsWithFallback("convertUnits", simpleUnitIdentifiersSink);
        simpleUnits = simpleUnitIdentifiersSink.simpleUnits;
        simpleUnitCategories = simpleUnitIdentifiersSink.simpleUnitCategories;
    }

    public static class CategoriesSink
    extends UResource.Sink {
        HashMap<String, Integer> mapFromUnitToIndex = new HashMap();
        ArrayList<String> categories = new ArrayList();

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            assert (key.toString().equals("unitQuantities"));
            assert (value.getType() == 8);
            UResource.Array array = value.getArray();
            int n2 = 0;
            while (array.getValue(n2, value)) {
                assert (value.getType() == 2);
                UResource.Table table = value.getTable();
                assert (table.getSize() == 1) : "expecting single-entry table, got size: " + table.getSize();
                table.getKeyAndValue(0, key, value);
                assert (value.getType() == 0) : "expecting category string";
                this.mapFromUnitToIndex.put(key.toString(), this.categories.size());
                this.categories.add(value.toString());
                ++n2;
            }
        }
    }

    public static class Categories {
        static HashMap<String, Integer> baseUnitToIndex;
        static String[] indexToCategory;

        static {
            ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "units");
            CategoriesSink categoriesSink = new CategoriesSink();
            iCUResourceBundle.getAllItemsWithFallback("unitQuantities", categoriesSink);
            baseUnitToIndex = categoriesSink.mapFromUnitToIndex;
            indexToCategory = categoriesSink.categories.toArray(new String[0]);
        }
    }

    public static class Constants {
        public static final int kSimpleUnitOffset = 512;
        public static final int kPowerPartOffset = 256;
        public static final int kInitialCompoundPartOffset = 192;
        public static final int kCompoundPartOffset = 128;
        public static final int kPrefixOffset = 64;
        public static final String CONVERSION_UNIT_TABLE_NAME = "convertUnits";
        public static final String UNIT_PREFERENCE_TABLE_NAME = "unitPreferenceData";
        public static final String CATEGORY_TABLE_NAME = "unitQuantities";
        public static final String DEFAULT_REGION = "001";
        public static final String DEFAULT_USAGE = "default";
    }

    public static class SimpleUnitIdentifiersSink
    extends UResource.Sink {
        String[] simpleUnits = null;
        int[] simpleUnitCategories = null;

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            assert (key.toString().equals("convertUnits"));
            assert (value.getType() == 2);
            UResource.Table table = value.getTable();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            int n2 = 0;
            while (table.getKeyAndValue(n2, key, value)) {
                if (!key.toString().equals("kilogram")) {
                    UResource.Table table2 = value.getTable();
                    if (!table2.findValue("target", value)) {
                        assert (false) : "Could not find \"target\" for simple unit: " + key;
                    } else {
                        String string = value.getString();
                        arrayList.add(key.toString());
                        arrayList2.add(Categories.baseUnitToIndex.get(string));
                    }
                }
                ++n2;
            }
            this.simpleUnits = arrayList.toArray(new String[0]);
            this.simpleUnitCategories = new int[arrayList2.size()];
            Iterator iterator = arrayList2.iterator();
            for (int i2 = 0; i2 < this.simpleUnitCategories.length; ++i2) {
                this.simpleUnitCategories[i2] = (Integer)iterator.next();
            }
        }
    }
}

