/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.units;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Pattern;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.IllegalIcuArgumentException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.ConversionRates;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.MeasureUnitImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.SingleUnitImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MeasureUnit;

public class UnitsConverter {
    private BigDecimal conversionRate;
    private boolean reciprocal;
    private BigDecimal offset;
    private String specialSource;
    private String specialTarget;
    private static final BigDecimal[] minMetersPerSecForBeaufort = new BigDecimal[]{BigDecimal.valueOf(0.0), BigDecimal.valueOf(0.3), BigDecimal.valueOf(1.6), BigDecimal.valueOf(3.4), BigDecimal.valueOf(5.5), BigDecimal.valueOf(8.0), BigDecimal.valueOf(10.8), BigDecimal.valueOf(13.9), BigDecimal.valueOf(17.2), BigDecimal.valueOf(20.8), BigDecimal.valueOf(24.5), BigDecimal.valueOf(28.5), BigDecimal.valueOf(32.7), BigDecimal.valueOf(36.9), BigDecimal.valueOf(41.4), BigDecimal.valueOf(46.1), BigDecimal.valueOf(51.1), BigDecimal.valueOf(55.8), BigDecimal.valueOf(61.4)};

    public UnitsConverter(String string, String string2) {
        this(MeasureUnitImpl.forIdentifier(string), MeasureUnitImpl.forIdentifier(string2), new ConversionRates());
    }

    public UnitsConverter(MeasureUnitImpl measureUnitImpl, MeasureUnitImpl measureUnitImpl2, ConversionRates conversionRates) {
        Convertibility convertibility = UnitsConverter.extractConvertibility(measureUnitImpl, measureUnitImpl2, conversionRates);
        if (convertibility != Convertibility.CONVERTIBLE && convertibility != Convertibility.RECIPROCAL) {
            throw new IllegalIcuArgumentException("input units must be convertible or reciprocal");
        }
        this.specialSource = conversionRates.getSpecialMappingName(measureUnitImpl);
        this.specialTarget = conversionRates.getSpecialMappingName(measureUnitImpl2);
        if (this.specialSource == null && this.specialTarget == null) {
            Factor factor = conversionRates.getFactorToBase(measureUnitImpl);
            Factor factor2 = conversionRates.getFactorToBase(measureUnitImpl2);
            if (convertibility == Convertibility.CONVERTIBLE) {
                this.conversionRate = factor.divide(factor2).getConversionRate();
            } else {
                assert (convertibility == Convertibility.RECIPROCAL);
                this.conversionRate = factor.multiply(factor2).getConversionRate();
            }
            this.reciprocal = convertibility == Convertibility.RECIPROCAL;
            this.offset = conversionRates.getOffset(measureUnitImpl, measureUnitImpl2, factor, factor2, convertibility);
            assert (convertibility != Convertibility.RECIPROCAL || this.offset == BigDecimal.ZERO);
        } else {
            this.reciprocal = false;
            this.offset = BigDecimal.ZERO;
            this.conversionRate = this.specialSource == null ? conversionRates.getFactorToBase(measureUnitImpl).getConversionRate() : (this.specialTarget == null ? conversionRates.getFactorToBase(measureUnitImpl2).getConversionRate() : BigDecimal.ONE);
        }
    }

    public static Convertibility extractConvertibility(MeasureUnitImpl measureUnitImpl, MeasureUnitImpl measureUnitImpl2, ConversionRates conversionRates) {
        ArrayList<SingleUnitImpl> arrayList = conversionRates.extractBaseUnits(measureUnitImpl);
        ArrayList<SingleUnitImpl> arrayList2 = conversionRates.extractBaseUnits(measureUnitImpl2);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        UnitsConverter.insertInMap(hashMap, arrayList, 1);
        UnitsConverter.insertInMap(hashMap, arrayList2, -1);
        if (UnitsConverter.areDimensionsZeroes(hashMap)) {
            return Convertibility.CONVERTIBLE;
        }
        UnitsConverter.insertInMap(hashMap, arrayList2, 2);
        if (UnitsConverter.areDimensionsZeroes(hashMap)) {
            return Convertibility.RECIPROCAL;
        }
        return Convertibility.UNCONVERTIBLE;
    }

    private static void insertInMap(HashMap<String, Integer> hashMap, ArrayList<SingleUnitImpl> arrayList, int n2) {
        for (SingleUnitImpl singleUnitImpl : arrayList) {
            if (hashMap.containsKey(singleUnitImpl.getSimpleUnitID())) {
                hashMap.put(singleUnitImpl.getSimpleUnitID(), hashMap.get(singleUnitImpl.getSimpleUnitID()) + singleUnitImpl.getDimensionality() * n2);
                continue;
            }
            hashMap.put(singleUnitImpl.getSimpleUnitID(), singleUnitImpl.getDimensionality() * n2);
        }
    }

    private static boolean areDimensionsZeroes(HashMap<String, Integer> hashMap) {
        for (Integer n2 : hashMap.values()) {
            if (n2.equals(0)) continue;
            return false;
        }
        return true;
    }

    public BigDecimal convert(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = bigDecimal;
        if (this.specialSource != null || this.specialTarget != null) {
            BigDecimal bigDecimal3 = bigDecimal;
            bigDecimal3 = this.specialSource != null ? (this.specialSource.equals("beaufort") ? this.scaleToBase(bigDecimal, minMetersPerSecForBeaufort) : bigDecimal) : bigDecimal.multiply(this.conversionRate);
            bigDecimal2 = this.specialTarget != null ? (this.specialTarget.equals("beaufort") ? this.baseToScale(bigDecimal3, minMetersPerSecForBeaufort) : bigDecimal3) : bigDecimal3.divide(this.conversionRate, MathContext.DECIMAL128);
            return bigDecimal2;
        }
        bigDecimal2 = bigDecimal.multiply(this.conversionRate).add(this.offset);
        if (this.reciprocal) {
            assert (this.offset == BigDecimal.ZERO);
            if (bigDecimal2.compareTo(BigDecimal.ZERO) == 0) {
                return BigDecimal.ZERO;
            }
            bigDecimal2 = BigDecimal.ONE.divide(bigDecimal2, MathContext.DECIMAL128);
        }
        return bigDecimal2;
    }

    public BigDecimal convertInverse(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = bigDecimal;
        if (this.specialSource != null || this.specialTarget != null) {
            BigDecimal bigDecimal3 = bigDecimal;
            bigDecimal3 = this.specialTarget != null ? (this.specialTarget.equals("beaufort") ? this.scaleToBase(bigDecimal, minMetersPerSecForBeaufort) : bigDecimal) : bigDecimal.multiply(this.conversionRate);
            bigDecimal2 = this.specialSource != null ? (this.specialSource.equals("beaufort") ? this.baseToScale(bigDecimal3, minMetersPerSecForBeaufort) : bigDecimal3) : bigDecimal3.divide(this.conversionRate, MathContext.DECIMAL128);
            return bigDecimal2;
        }
        if (this.reciprocal) {
            assert (this.offset == BigDecimal.ZERO);
            if (bigDecimal2.compareTo(BigDecimal.ZERO) == 0) {
                return BigDecimal.ZERO;
            }
            bigDecimal2 = BigDecimal.ONE.divide(bigDecimal2, MathContext.DECIMAL128);
        }
        bigDecimal2 = bigDecimal2.subtract(this.offset).divide(this.conversionRate, MathContext.DECIMAL128);
        return bigDecimal2;
    }

    private BigDecimal scaleToBase(BigDecimal bigDecimal, BigDecimal[] bigDecimalArray) {
        BigDecimal bigDecimal2 = BigDecimal.valueOf(0.5);
        BigDecimal bigDecimal3 = bigDecimal.abs().add(bigDecimal2);
        BigDecimal bigDecimal4 = bigDecimal3.min(BigDecimal.valueOf(bigDecimalArray.length - 2));
        int n2 = bigDecimal4.intValue();
        return bigDecimalArray[n2].add(bigDecimalArray[n2 + 1]).multiply(bigDecimal2);
    }

    private BigDecimal baseToScale(BigDecimal bigDecimal, BigDecimal[] bigDecimalArray) {
        int n2;
        int n3 = Arrays.binarySearch(bigDecimalArray, bigDecimal.abs());
        if (n3 < 0) {
            n3 = -n3 - 2;
        }
        if (n3 > (n2 = bigDecimalArray.length - 2)) {
            n3 = n2;
        }
        return BigDecimal.valueOf(n3);
    }

    public ConversionInfo getConversionInfo() {
        ConversionInfo conversionInfo = new ConversionInfo();
        conversionInfo.conversionRate = this.conversionRate;
        conversionInfo.offset = this.offset;
        conversionInfo.reciprocal = this.reciprocal;
        return conversionInfo;
    }

    public String toString() {
        return "UnitsConverter [conversionRate=" + this.conversionRate + ", offset=" + this.offset + "]";
    }

    static class Factor {
        private BigDecimal factorNum = BigDecimal.valueOf(1L);
        private BigDecimal factorDen = BigDecimal.valueOf(1L);
        private int exponentFtToM = 0;
        private int exponentPi = 0;
        private int exponentGravity = 0;
        private int exponentG = 0;
        private int exponentGalImpToM3 = 0;
        private int exponentLbToKg = 0;
        private int exponentGlucoseMolarMass = 0;
        private int exponentItemPerMole = 0;
        private int exponentMetersPerAU = 0;
        private int exponentSecPerJulianYear = 0;
        private int exponentSpeedOfLightMetersPerSecond = 0;
        private int exponentShoToM3 = 0;
        private int exponentTsuboToM2 = 0;
        private int exponentShakuToM = 0;
        private int exponentAMU = 0;

        public static Factor processFactor(String string) {
            assert (!string.isEmpty());
            string = string.replaceAll("\\s+", "");
            String[] stringArray = string.split("/");
            assert (stringArray.length == 1 || stringArray.length == 2);
            if (stringArray.length == 1) {
                return Factor.processFactorWithoutDivision(stringArray[0]);
            }
            Factor factor = Factor.processFactorWithoutDivision(stringArray[0]);
            Factor factor2 = Factor.processFactorWithoutDivision(stringArray[1]);
            return factor.divide(factor2);
        }

        private static Factor processFactorWithoutDivision(String string) {
            Factor factor = new Factor();
            for (String string2 : string.split(Pattern.quote("*"))) {
                factor.addPoweredEntity(string2);
            }
            return factor;
        }

        protected Factor copy() {
            Factor factor = new Factor();
            factor.factorNum = this.factorNum;
            factor.factorDen = this.factorDen;
            factor.exponentFtToM = this.exponentFtToM;
            factor.exponentPi = this.exponentPi;
            factor.exponentGravity = this.exponentGravity;
            factor.exponentG = this.exponentG;
            factor.exponentGalImpToM3 = this.exponentGalImpToM3;
            factor.exponentLbToKg = this.exponentLbToKg;
            factor.exponentGlucoseMolarMass = this.exponentGlucoseMolarMass;
            factor.exponentItemPerMole = this.exponentItemPerMole;
            factor.exponentMetersPerAU = this.exponentMetersPerAU;
            factor.exponentSecPerJulianYear = this.exponentSecPerJulianYear;
            factor.exponentSpeedOfLightMetersPerSecond = this.exponentSpeedOfLightMetersPerSecond;
            factor.exponentShoToM3 = this.exponentShoToM3;
            factor.exponentTsuboToM2 = this.exponentTsuboToM2;
            factor.exponentShakuToM = this.exponentShakuToM;
            factor.exponentAMU = this.exponentAMU;
            return factor;
        }

        public BigDecimal getConversionRate() {
            Factor factor = this.copy();
            factor.multiply(new BigDecimal("0.3048"), this.exponentFtToM);
            factor.multiply(new BigDecimal("411557987.0").divide(new BigDecimal("131002976.0"), MathContext.DECIMAL128), this.exponentPi);
            factor.multiply(new BigDecimal("9.80665"), this.exponentGravity);
            factor.multiply(new BigDecimal("6.67408E-11"), this.exponentG);
            factor.multiply(new BigDecimal("0.00454609"), this.exponentGalImpToM3);
            factor.multiply(new BigDecimal("0.45359237"), this.exponentLbToKg);
            factor.multiply(new BigDecimal("180.1557"), this.exponentGlucoseMolarMass);
            factor.multiply(new BigDecimal("6.02214076E+23"), this.exponentItemPerMole);
            factor.multiply(new BigDecimal("149597870700"), this.exponentMetersPerAU);
            factor.multiply(new BigDecimal("31557600"), this.exponentSecPerJulianYear);
            factor.multiply(new BigDecimal("299792458"), this.exponentSpeedOfLightMetersPerSecond);
            factor.multiply(new BigDecimal("0.001803906836964688204"), this.exponentShoToM3);
            factor.multiply(new BigDecimal("3.305785123966942"), this.exponentTsuboToM2);
            factor.multiply(new BigDecimal("0.033057851239669"), this.exponentShakuToM);
            factor.multiply(new BigDecimal("1.66053878283E-27"), this.exponentAMU);
            return factor.factorNum.divide(factor.factorDen, MathContext.DECIMAL128);
        }

        private void multiply(BigDecimal bigDecimal, int n2) {
            if (n2 == 0) {
                return;
            }
            BigDecimal bigDecimal2 = bigDecimal.pow(Math.abs(n2), MathContext.DECIMAL128);
            if (n2 > 0) {
                this.factorNum = this.factorNum.multiply(bigDecimal2);
            } else {
                this.factorDen = this.factorDen.multiply(bigDecimal2);
            }
        }

        public Factor applyPrefix(MeasureUnit.MeasurePrefix measurePrefix) {
            Factor factor = this.copy();
            if (measurePrefix == MeasureUnit.MeasurePrefix.ONE) {
                return factor;
            }
            int n2 = measurePrefix.getBase();
            int n3 = measurePrefix.getPower();
            BigDecimal bigDecimal = BigDecimal.valueOf(n2).pow(Math.abs(n3), MathContext.DECIMAL128);
            if (n3 < 0) {
                factor.factorDen = this.factorDen.multiply(bigDecimal);
                return factor;
            }
            factor.factorNum = this.factorNum.multiply(bigDecimal);
            return factor;
        }

        public Factor power(int n2) {
            Factor factor = new Factor();
            if (n2 == 0) {
                return factor;
            }
            if (n2 > 0) {
                factor.factorNum = this.factorNum.pow(n2);
                factor.factorDen = this.factorDen.pow(n2);
            } else {
                factor.factorNum = this.factorDen.pow(n2 * -1);
                factor.factorDen = this.factorNum.pow(n2 * -1);
            }
            factor.exponentFtToM = this.exponentFtToM * n2;
            factor.exponentPi = this.exponentPi * n2;
            factor.exponentGravity = this.exponentGravity * n2;
            factor.exponentG = this.exponentG * n2;
            factor.exponentGalImpToM3 = this.exponentGalImpToM3 * n2;
            factor.exponentLbToKg = this.exponentLbToKg * n2;
            factor.exponentGlucoseMolarMass = this.exponentGlucoseMolarMass * n2;
            factor.exponentItemPerMole = this.exponentItemPerMole * n2;
            factor.exponentMetersPerAU = this.exponentMetersPerAU * n2;
            factor.exponentSecPerJulianYear = this.exponentSecPerJulianYear * n2;
            factor.exponentSpeedOfLightMetersPerSecond = this.exponentSpeedOfLightMetersPerSecond * n2;
            factor.exponentShoToM3 = this.exponentShoToM3 * n2;
            factor.exponentTsuboToM2 = this.exponentTsuboToM2 * n2;
            factor.exponentShakuToM = this.exponentShakuToM * n2;
            factor.exponentAMU = this.exponentAMU * n2;
            return factor;
        }

        public Factor divide(Factor factor) {
            Factor factor2 = new Factor();
            factor2.factorNum = this.factorNum.multiply(factor.factorDen);
            factor2.factorDen = this.factorDen.multiply(factor.factorNum);
            factor2.exponentFtToM = this.exponentFtToM - factor.exponentFtToM;
            factor2.exponentPi = this.exponentPi - factor.exponentPi;
            factor2.exponentGravity = this.exponentGravity - factor.exponentGravity;
            factor2.exponentG = this.exponentG - factor.exponentG;
            factor2.exponentGalImpToM3 = this.exponentGalImpToM3 - factor.exponentGalImpToM3;
            factor2.exponentLbToKg = this.exponentLbToKg - factor.exponentLbToKg;
            factor2.exponentGlucoseMolarMass = this.exponentGlucoseMolarMass - factor.exponentGlucoseMolarMass;
            factor2.exponentItemPerMole = this.exponentItemPerMole - factor.exponentItemPerMole;
            factor2.exponentMetersPerAU = this.exponentMetersPerAU - factor.exponentMetersPerAU;
            factor2.exponentSecPerJulianYear = this.exponentSecPerJulianYear - factor.exponentSecPerJulianYear;
            factor2.exponentSpeedOfLightMetersPerSecond = this.exponentSpeedOfLightMetersPerSecond - factor.exponentSpeedOfLightMetersPerSecond;
            factor2.exponentShoToM3 = this.exponentShoToM3 - factor.exponentShoToM3;
            factor2.exponentTsuboToM2 = this.exponentTsuboToM2 - factor.exponentTsuboToM2;
            factor2.exponentShakuToM = this.exponentShakuToM - factor.exponentShakuToM;
            factor2.exponentAMU = this.exponentAMU - factor.exponentAMU;
            return factor2;
        }

        public Factor multiply(Factor factor) {
            Factor factor2 = new Factor();
            factor2.factorNum = this.factorNum.multiply(factor.factorNum);
            factor2.factorDen = this.factorDen.multiply(factor.factorDen);
            factor2.exponentFtToM = this.exponentFtToM + factor.exponentFtToM;
            factor2.exponentPi = this.exponentPi + factor.exponentPi;
            factor2.exponentGravity = this.exponentGravity + factor.exponentGravity;
            factor2.exponentG = this.exponentG + factor.exponentG;
            factor2.exponentGalImpToM3 = this.exponentGalImpToM3 + factor.exponentGalImpToM3;
            factor2.exponentLbToKg = this.exponentLbToKg + factor.exponentLbToKg;
            factor2.exponentGlucoseMolarMass = this.exponentGlucoseMolarMass + factor.exponentGlucoseMolarMass;
            factor2.exponentItemPerMole = this.exponentItemPerMole + factor.exponentItemPerMole;
            factor2.exponentMetersPerAU = this.exponentMetersPerAU + factor.exponentMetersPerAU;
            factor2.exponentSecPerJulianYear = this.exponentSecPerJulianYear + factor.exponentSecPerJulianYear;
            factor2.exponentSpeedOfLightMetersPerSecond = this.exponentSpeedOfLightMetersPerSecond + factor.exponentSpeedOfLightMetersPerSecond;
            factor2.exponentShoToM3 = this.exponentShoToM3 + factor.exponentShoToM3;
            factor2.exponentTsuboToM2 = this.exponentTsuboToM2 + factor.exponentTsuboToM2;
            factor2.exponentShakuToM = this.exponentShakuToM + factor.exponentShakuToM;
            factor2.exponentAMU = this.exponentAMU + factor.exponentAMU;
            return factor2;
        }

        private void addPoweredEntity(String string) {
            String[] stringArray = string.split(Pattern.quote("^"));
            assert (stringArray.length == 1 || stringArray.length == 2);
            int n2 = stringArray.length == 2 ? Integer.parseInt(stringArray[1]) : 1;
            this.addEntity(stringArray[0], n2);
        }

        private void addEntity(String string, int n2) {
            if ("ft_to_m".equals(string)) {
                this.exponentFtToM += n2;
            } else if ("ft2_to_m2".equals(string)) {
                this.exponentFtToM += 2 * n2;
            } else if ("ft3_to_m3".equals(string)) {
                this.exponentFtToM += 3 * n2;
            } else if ("in3_to_m3".equals(string)) {
                this.exponentFtToM += 3 * n2;
                this.factorDen = this.factorDen.multiply(BigDecimal.valueOf(Math.pow(12.0, 3.0)));
            } else if ("gal_to_m3".equals(string)) {
                this.factorNum = this.factorNum.multiply(BigDecimal.valueOf(231L));
                this.exponentFtToM += 3 * n2;
                this.factorDen = this.factorDen.multiply(BigDecimal.valueOf(1728L));
            } else if ("gal_imp_to_m3".equals(string)) {
                this.exponentGalImpToM3 += n2;
            } else if ("G".equals(string)) {
                this.exponentG += n2;
            } else if ("gravity".equals(string)) {
                this.exponentGravity += n2;
            } else if ("lb_to_kg".equals(string)) {
                this.exponentLbToKg += n2;
            } else if ("glucose_molar_mass".equals(string)) {
                this.exponentGlucoseMolarMass += n2;
            } else if ("item_per_mole".equals(string)) {
                this.exponentItemPerMole += n2;
            } else if ("meters_per_AU".equals(string)) {
                this.exponentMetersPerAU += n2;
            } else if ("PI".equals(string)) {
                this.exponentPi += n2;
            } else if ("sec_per_julian_year".equals(string)) {
                this.exponentSecPerJulianYear += n2;
            } else if ("speed_of_light_meters_per_second".equals(string)) {
                this.exponentSpeedOfLightMetersPerSecond += n2;
            } else if ("sho_to_m3".equals(string)) {
                this.exponentShoToM3 += n2;
            } else if ("tsubo_to_m2".equals(string)) {
                this.exponentTsuboToM2 += n2;
            } else if ("shaku_to_m".equals(string)) {
                this.exponentShakuToM += n2;
            } else if ("AMU".equals(string)) {
                this.exponentAMU += n2;
            } else {
                BigDecimal bigDecimal = new BigDecimal(string).pow(n2, MathContext.DECIMAL128);
                this.factorNum = this.factorNum.multiply(bigDecimal);
            }
        }
    }

    public static class ConversionInfo {
        public BigDecimal conversionRate;
        public BigDecimal offset;
        public boolean reciprocal;
    }

    public static enum Convertibility {
        CONVERTIBLE,
        RECIPROCAL,
        UNCONVERTIBLE;

    }
}

