/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.units;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UResource;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.ConversionRates;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.MeasureUnitImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.SingleUnitImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.UnitsData;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public class UnitPreferences {
    private static final Map<String, String> measurementSystem;
    private HashMap<String, HashMap<String, UnitPreference[]>> mapToUnitPreferences = new HashMap();

    public UnitPreferences() {
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "units");
        UnitPreferencesSink unitPreferencesSink = new UnitPreferencesSink();
        iCUResourceBundle.getAllItemsWithFallback("unitPreferenceData", unitPreferencesSink);
        this.mapToUnitPreferences = unitPreferencesSink.getMapToUnitPreferences();
    }

    public static String formMapKey(String string, String string2) {
        return string + "++" + string2;
    }

    private static String[] getAllUsages(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            if (string.charAt(i2) != '-') continue;
            arrayList.add(string.substring(0, i2));
        }
        if (!string.equals("default")) {
            arrayList.add("default");
        }
        return arrayList.toArray(new String[0]);
    }

    public UnitPreference[] getPreferencesFor(String string, String string2, ULocale uLocale, UnitsData unitsData) {
        String string3;
        String string4;
        if ("temperature".equals(string)) {
            string4 = uLocale.getKeywordValue("mu");
            if ("fahrenhe".equals(string4)) {
                string4 = "fahrenheit";
            }
            try {
                string3 = string4 == null ? null : unitsData.getCategory(MeasureUnitImpl.forIdentifier(string4));
            }
            catch (Exception exception) {
                string3 = null;
            }
            if (string3 != null && string.equals(string3)) {
                UnitPreference[] unitPreferenceArray = new UnitPreference[]{new UnitPreference(string4, null, null)};
                return unitPreferenceArray;
            }
        }
        string4 = ULocale.getRegionForSupplementalData(uLocale, true);
        string3 = uLocale.getKeywordValue("measure");
        boolean bl2 = measurementSystem.containsKey(string3);
        String[] stringArray = UnitPreferences.getAllUsages(string2);
        UnitPreference[] unitPreferenceArray = null;
        for (String string5 : stringArray) {
            unitPreferenceArray = this.getUnitPreferences(string, string5, string4);
            if (unitPreferenceArray != null && bl2) {
                ConversionRates conversionRates = new ConversionRates();
                boolean bl3 = true;
                for (UnitPreference unitPreference : unitPreferenceArray) {
                    MeasureUnitImpl measureUnitImpl = MeasureUnitImpl.forIdentifier(unitPreference.getUnit());
                    ArrayList<SingleUnitImpl> arrayList = new ArrayList<SingleUnitImpl>(measureUnitImpl.getSingleUnits());
                    for (SingleUnitImpl singleUnitImpl : arrayList) {
                        String string6 = conversionRates.extractSystems(singleUnitImpl);
                        if (string6.contains("metric_adjacent") || string6.contains(string3)) continue;
                        bl3 = false;
                    }
                }
                if (!bl3) {
                    String string7 = measurementSystem.get(string3);
                    unitPreferenceArray = this.getUnitPreferences(string, string5, string7);
                }
            }
            if (unitPreferenceArray != null) break;
        }
        assert (unitPreferenceArray != null) : "At least the category must be exist";
        return unitPreferenceArray;
    }

    private UnitPreference[] getUnitPreferences(String string, String string2, String string3) {
        String string4 = UnitPreferences.formMapKey(string, string2);
        if (this.mapToUnitPreferences.containsKey(string4)) {
            UnitPreference[] unitPreferenceArray;
            HashMap<String, UnitPreference[]> hashMap = this.mapToUnitPreferences.get(string4);
            UnitPreference[] unitPreferenceArray2 = unitPreferenceArray = hashMap.containsKey(string3) ? hashMap.get(string3) : hashMap.get("001");
            assert (unitPreferenceArray != null);
            return unitPreferenceArray;
        }
        return null;
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("metric", "001");
        hashMap.put("ussystem", "US");
        hashMap.put("uksystem", "GB");
        measurementSystem = Collections.unmodifiableMap(hashMap);
    }

    public static class UnitPreferencesSink
    extends UResource.Sink {
        private HashMap<String, HashMap<String, UnitPreference[]>> mapToUnitPreferences = new HashMap();

        public HashMap<String, HashMap<String, UnitPreference[]>> getMapToUnitPreferences() {
            return this.mapToUnitPreferences;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            assert ("unitPreferenceData".equals(key.toString()));
            UResource.Table table = value.getTable();
            int n2 = 0;
            while (table.getKeyAndValue(n2, key, value)) {
                assert (value.getType() == 2);
                String string = key.toString();
                UResource.Table table2 = value.getTable();
                int n3 = 0;
                while (table2.getKeyAndValue(n3, key, value)) {
                    assert (value.getType() == 2);
                    String string2 = key.toString();
                    UResource.Table table3 = value.getTable();
                    int n4 = 0;
                    while (table3.getKeyAndValue(n4, key, value)) {
                        assert (value.getType() == 8);
                        String string3 = key.toString();
                        UResource.Array array = value.getArray();
                        ArrayList<UnitPreference> arrayList = new ArrayList<UnitPreference>();
                        int n5 = 0;
                        while (array.getValue(n5, value)) {
                            assert (value.getType() == 2);
                            UResource.Table table4 = value.getTable();
                            String string4 = null;
                            String string5 = "1";
                            String string6 = "";
                            int n6 = 0;
                            while (table4.getKeyAndValue(n6, key, value)) {
                                assert (value.getType() == 0);
                                String string7 = key.toString();
                                if ("unit".equals(string7)) {
                                    string4 = value.getString();
                                } else if ("geq".equals(string7)) {
                                    string5 = value.getString();
                                } else if ("skeleton".equals(string7)) {
                                    string6 = value.getString();
                                } else assert (false) : "key must be unit, geq or skeleton";
                                ++n6;
                            }
                            assert (string4 != null);
                            arrayList.add(new UnitPreference(string4, string5, string6));
                            ++n5;
                        }
                        assert (!arrayList.isEmpty());
                        this.insertUnitPreferences(string, string2, string3, arrayList.toArray(new UnitPreference[0]));
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
        }

        private void insertUnitPreferences(String string, String string2, String string3, UnitPreference[] unitPreferenceArray) {
            HashMap<Object, Object> hashMap;
            String string4 = UnitPreferences.formMapKey(string, string2);
            if (this.mapToUnitPreferences.containsKey(string4)) {
                hashMap = this.mapToUnitPreferences.get(string4);
            } else {
                hashMap = new HashMap();
                this.mapToUnitPreferences.put(string4, hashMap);
            }
            hashMap.put(string3, unitPreferenceArray);
        }
    }

    public static class UnitPreference {
        private final String unit;
        private final BigDecimal geq;
        private final String skeleton;

        public UnitPreference(String string, String string2, String string3) {
            this.unit = string;
            this.geq = string2 == null ? BigDecimal.valueOf(Double.MIN_VALUE) : new BigDecimal(string2);
            this.skeleton = string3 == null ? "" : string3;
        }

        public String getUnit() {
            return this.unit;
        }

        public BigDecimal getGeq() {
            return this.geq;
        }

        public String getSkeleton() {
            return this.skeleton;
        }
    }
}

