/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.units;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.HashMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.IllegalIcuArgumentException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UResource;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.MeasureUnitImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.SingleUnitImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.UnitsConverter;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MeasureUnit;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public class ConversionRates {
    private HashMap<String, ConversionRateInfo> mapToConversionRate;

    public ConversionRates() {
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "units");
        ConversionRatesSink conversionRatesSink = new ConversionRatesSink();
        iCUResourceBundle.getAllItemsWithFallback("convertUnits", conversionRatesSink);
        this.mapToConversionRate = conversionRatesSink.getMapToConversionRate();
    }

    private UnitsConverter.Factor getFactorToBase(SingleUnitImpl singleUnitImpl) {
        int n2 = singleUnitImpl.getDimensionality();
        MeasureUnit.MeasurePrefix measurePrefix = singleUnitImpl.getPrefix();
        UnitsConverter.Factor factor = UnitsConverter.Factor.processFactor(this.mapToConversionRate.get(singleUnitImpl.getSimpleUnitID()).getConversionRate());
        return factor.applyPrefix(measurePrefix).power(n2);
    }

    public UnitsConverter.Factor getFactorToBase(MeasureUnitImpl measureUnitImpl) {
        UnitsConverter.Factor factor = new UnitsConverter.Factor();
        for (SingleUnitImpl singleUnitImpl : measureUnitImpl.getSingleUnits()) {
            factor = factor.multiply(this.getFactorToBase(singleUnitImpl));
        }
        return factor;
    }

    protected BigDecimal getOffset(MeasureUnitImpl measureUnitImpl, MeasureUnitImpl measureUnitImpl2, UnitsConverter.Factor factor, UnitsConverter.Factor factor2, UnitsConverter.Convertibility convertibility) {
        if (convertibility != UnitsConverter.Convertibility.CONVERTIBLE) {
            return BigDecimal.valueOf(0L);
        }
        if (!this.checkSimpleUnit(measureUnitImpl) || !this.checkSimpleUnit(measureUnitImpl2)) {
            return BigDecimal.valueOf(0L);
        }
        String string = measureUnitImpl.getSingleUnits().get(0).getSimpleUnitID();
        String string2 = measureUnitImpl2.getSingleUnits().get(0).getSimpleUnitID();
        BigDecimal bigDecimal = this.mapToConversionRate.get(string).getOffset();
        BigDecimal bigDecimal2 = this.mapToConversionRate.get(string2).getOffset();
        return bigDecimal.subtract(bigDecimal2).divide(factor2.getConversionRate(), MathContext.DECIMAL128);
    }

    protected String getSpecialMappingName(MeasureUnitImpl measureUnitImpl) {
        if (!this.checkSimpleUnit(measureUnitImpl)) {
            return null;
        }
        String string = measureUnitImpl.getSingleUnits().get(0).getSimpleUnitID();
        return this.mapToConversionRate.get(string).getSpecialMappingName();
    }

    public MeasureUnitImpl extractCompoundBaseUnit(MeasureUnitImpl measureUnitImpl) {
        ArrayList<SingleUnitImpl> arrayList = this.extractBaseUnits(measureUnitImpl);
        MeasureUnitImpl measureUnitImpl2 = new MeasureUnitImpl();
        for (SingleUnitImpl singleUnitImpl : arrayList) {
            measureUnitImpl2.appendSingleUnit(singleUnitImpl);
        }
        return measureUnitImpl2;
    }

    public ArrayList<SingleUnitImpl> extractBaseUnits(MeasureUnitImpl measureUnitImpl) {
        ArrayList<SingleUnitImpl> arrayList = new ArrayList<SingleUnitImpl>();
        ArrayList<SingleUnitImpl> arrayList2 = measureUnitImpl.getSingleUnits();
        for (SingleUnitImpl singleUnitImpl : arrayList2) {
            arrayList.addAll(this.extractBaseUnits(singleUnitImpl));
        }
        return arrayList;
    }

    public ArrayList<SingleUnitImpl> extractBaseUnits(SingleUnitImpl singleUnitImpl) {
        String string = this.mapToConversionRate.get(singleUnitImpl.getSimpleUnitID()).getTarget();
        MeasureUnitImpl measureUnitImpl = MeasureUnitImpl.UnitsParser.parseForIdentifier(string);
        measureUnitImpl.applyDimensionality(singleUnitImpl.getDimensionality());
        return measureUnitImpl.getSingleUnits();
    }

    public String extractSystems(SingleUnitImpl singleUnitImpl) {
        return this.mapToConversionRate.get(singleUnitImpl.getSimpleUnitID()).getSystems();
    }

    private boolean checkSimpleUnit(MeasureUnitImpl measureUnitImpl) {
        if (measureUnitImpl.getComplexity() != MeasureUnit.Complexity.SINGLE) {
            return false;
        }
        SingleUnitImpl singleUnitImpl = measureUnitImpl.getSingleUnits().get(0);
        if (singleUnitImpl.getPrefix() != MeasureUnit.MeasurePrefix.ONE) {
            return false;
        }
        return singleUnitImpl.getDimensionality() == 1;
    }

    public static class ConversionRateInfo {
        private final String simpleUnit;
        private final String target;
        private final String conversionRate;
        private final BigDecimal offset;
        private final String specialMappingName;
        private final String systems;

        public ConversionRateInfo(String string, String string2, String string3, String string4, String string5, String string6) {
            this.simpleUnit = string;
            this.target = string2;
            this.conversionRate = string3;
            this.offset = ConversionRateInfo.forNumberWithDivision(string4);
            this.specialMappingName = string5;
            this.systems = string6;
        }

        private static BigDecimal forNumberWithDivision(String string) {
            String[] stringArray = string.split("/");
            assert (stringArray.length <= 2);
            if (stringArray.length == 1) {
                return new BigDecimal(stringArray[0]);
            }
            return new BigDecimal(stringArray[0]).divide(new BigDecimal(stringArray[1]), MathContext.DECIMAL128);
        }

        public String getTarget() {
            return this.target;
        }

        public BigDecimal getOffset() {
            return this.offset;
        }

        public String getConversionRate() {
            if (this.conversionRate == null) {
                throw new IllegalIcuArgumentException("trying to use a null conversion rate (for special?)");
            }
            return this.conversionRate;
        }

        public String getSpecialMappingName() {
            return this.specialMappingName;
        }

        public String getSystems() {
            return this.systems;
        }
    }

    public static class ConversionRatesSink
    extends UResource.Sink {
        private HashMap<String, ConversionRateInfo> mapToConversionRate = new HashMap();

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            assert ("convertUnits".equals(key.toString()));
            UResource.Table table = value.getTable();
            int n2 = 0;
            while (table.getKeyAndValue(n2, key, value)) {
                assert (value.getType() == 2);
                String string = key.toString();
                UResource.Table table2 = value.getTable();
                String string2 = null;
                String string3 = null;
                String string4 = "0";
                String string5 = null;
                String string6 = null;
                int n3 = 0;
                while (table2.getKeyAndValue(n3, key, value)) {
                    assert (value.getType() == 0);
                    String string7 = key.toString();
                    String string8 = value.toString().replaceAll(" ", "");
                    if ("target".equals(string7)) {
                        string2 = string8;
                    } else if ("factor".equals(string7)) {
                        string3 = string8;
                    } else if ("offset".equals(string7)) {
                        string4 = string8;
                    } else if ("special".equals(string7)) {
                        string5 = string8;
                    } else if ("systems".equals(string7)) {
                        string6 = value.toString();
                    } else assert (false) : "The key must be target, factor, offset, special, or systems";
                    ++n3;
                }
                assert (string2 != null);
                assert (string3 != null || string5 != null);
                this.mapToConversionRate.put(string, new ConversionRateInfo(string, string2, string3, string4, string5, string6));
                ++n2;
            }
        }

        public HashMap<String, ConversionRateInfo> getMapToConversionRate() {
            return this.mapToConversionRate;
        }
    }
}

