/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.personname;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.personname.FieldModifierImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.personname.PersonNameFormatterImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PersonName;

class PersonNamePattern {
    private String patternText;
    private Element[] patternElements;

    public static PersonNamePattern[] makePatterns(String[] stringArray, PersonNameFormatterImpl personNameFormatterImpl) {
        PersonNamePattern[] personNamePatternArray = new PersonNamePattern[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            personNamePatternArray[i2] = new PersonNamePattern(stringArray[i2], personNameFormatterImpl);
        }
        return personNamePatternArray;
    }

    public String toString() {
        return this.patternText;
    }

    private PersonNamePattern(String string, PersonNameFormatterImpl personNameFormatterImpl) {
        this.patternText = string;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder stringBuilder = new StringBuilder();
        block5: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (bl3) {
                stringBuilder.append(c2);
                bl3 = false;
                continue;
            }
            switch (c2) {
                case '\\': {
                    bl3 = true;
                    continue block5;
                }
                case '{': {
                    if (!bl2) {
                        if (stringBuilder.length() > 0) {
                            arrayList.add(new LiteralText(stringBuilder.toString()));
                            stringBuilder = new StringBuilder();
                        }
                        bl2 = true;
                        continue block5;
                    }
                    throw new IllegalArgumentException("Nested braces are not allowed in name patterns");
                }
                case '}': {
                    if (bl2) {
                        if (stringBuilder.length() <= 0) {
                            throw new IllegalArgumentException("No field name inside braces");
                        }
                        arrayList.add(new NameFieldImpl(stringBuilder.toString(), personNameFormatterImpl));
                        stringBuilder = new StringBuilder();
                        bl2 = false;
                        continue block5;
                    }
                    throw new IllegalArgumentException("Unmatched closing brace in literal text");
                }
                default: {
                    stringBuilder.append(c2);
                }
            }
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(new LiteralText(stringBuilder.toString()));
        }
        this.patternElements = arrayList.toArray(new Element[0]);
    }

    public String format(PersonName personName) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        personName = this.hackNameForEmptyFields(personName);
        for (Element element : this.patternElements) {
            if (element.isLiteral()) {
                if (bl3) continue;
                if (bl4) {
                    stringBuilder3.append(element.format(personName));
                    continue;
                }
                stringBuilder2.append(element.format(personName));
                continue;
            }
            String string = element.format(personName);
            if (string == null || string.isEmpty()) {
                if (!bl2) {
                    bl3 = true;
                    stringBuilder2.setLength(0);
                    continue;
                }
                bl4 = true;
                stringBuilder3.setLength(0);
                continue;
            }
            bl2 = true;
            bl3 = false;
            if (bl4) {
                stringBuilder.append(this.coalesce(stringBuilder2, stringBuilder3));
                stringBuilder.append(string);
                bl4 = false;
                continue;
            }
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder2.setLength(0);
            stringBuilder.append(element.format(personName));
        }
        if (!bl4) {
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        return stringBuilder.toString();
    }

    public int numPopulatedFields(PersonName personName) {
        int n2 = 0;
        for (Element element : this.patternElements) {
            n2 += element.isPopulated(personName) ? 1 : 0;
        }
        return n2;
    }

    public int numEmptyFields(PersonName personName) {
        int n2 = 0;
        for (Element element : this.patternElements) {
            n2 += !element.isLiteral() && !element.isPopulated(personName) ? 1 : 0;
        }
        return n2;
    }

    private String coalesce(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        int n2;
        int n3;
        if (this.endsWith(stringBuilder, stringBuilder2)) {
            stringBuilder2.setLength(0);
        }
        for (n3 = 0; n3 < stringBuilder.length() && !Character.isWhitespace(stringBuilder.charAt(n3)); ++n3) {
        }
        for (n2 = stringBuilder2.length() - 1; n2 >= 0 && !Character.isWhitespace(stringBuilder2.charAt(n2)); --n2) {
        }
        if (n3 < stringBuilder.length()) {
            ++n3;
        } else if (n2 >= 0) {
            --n2;
        }
        String string = stringBuilder.substring(0, n3) + stringBuilder2.substring(n2 + 1);
        stringBuilder.setLength(0);
        stringBuilder2.setLength(0);
        return string;
    }

    private boolean endsWith(StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        int n2;
        int n3 = stringBuilder.length() - 1;
        for (n2 = stringBuilder2.length() - 1; n3 >= 0 && n2 >= 0 && stringBuilder.charAt(n3) == stringBuilder2.charAt(n2); --n3, --n2) {
        }
        return n2 < 0;
    }

    private PersonName hackNameForEmptyFields(PersonName personName) {
        PersonName personName2 = personName;
        if (personName.getFieldValue(PersonName.NameField.SURNAME, Collections.emptySet()) == null) {
            boolean bl2 = false;
            for (Element element : this.patternElements) {
                if (element.isLiteral() || ((NameFieldImpl)element).fieldID != PersonName.NameField.GIVEN || ((NameFieldImpl)element).modifiers.containsKey((Object)PersonName.FieldModifier.INITIAL)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return new GivenToSurnamePersonName(personName);
            }
        }
        return personName2;
    }

    private static class GivenToSurnamePersonName
    implements PersonName {
        private PersonName underlyingPersonName;

        public GivenToSurnamePersonName(PersonName personName) {
            this.underlyingPersonName = personName;
        }

        public String toString() {
            return "Inverted version of " + this.underlyingPersonName.toString();
        }

        @Override
        public Locale getNameLocale() {
            return this.underlyingPersonName.getNameLocale();
        }

        @Override
        public PersonName.PreferredOrder getPreferredOrder() {
            return this.underlyingPersonName.getPreferredOrder();
        }

        @Override
        public String getFieldValue(PersonName.NameField nameField, Set<PersonName.FieldModifier> set) {
            if (nameField == PersonName.NameField.SURNAME) {
                return this.underlyingPersonName.getFieldValue(PersonName.NameField.GIVEN, set);
            }
            if (nameField == PersonName.NameField.GIVEN) {
                return null;
            }
            return this.underlyingPersonName.getFieldValue(nameField, set);
        }
    }

    private static class NameFieldImpl
    implements Element {
        private PersonName.NameField fieldID;
        private Map<PersonName.FieldModifier, FieldModifierImpl> modifiers;

        public NameFieldImpl(String string, PersonNameFormatterImpl personNameFormatterImpl) {
            ArrayList<PersonName.FieldModifier> arrayList = new ArrayList<PersonName.FieldModifier>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            this.fieldID = PersonName.NameField.forString(stringTokenizer.nextToken());
            while (stringTokenizer.hasMoreTokens()) {
                arrayList.add(PersonName.FieldModifier.forString(stringTokenizer.nextToken()));
            }
            if (this.fieldID == PersonName.NameField.SURNAME && personNameFormatterImpl.shouldCapitalizeSurname()) {
                arrayList.add(PersonName.FieldModifier.ALL_CAPS);
            }
            this.modifiers = new HashMap<PersonName.FieldModifier, FieldModifierImpl>();
            for (PersonName.FieldModifier fieldModifier : arrayList) {
                this.modifiers.put(fieldModifier, FieldModifierImpl.forName(fieldModifier, personNameFormatterImpl));
            }
            if (this.modifiers.containsKey((Object)PersonName.FieldModifier.RETAIN) && this.modifiers.containsKey((Object)PersonName.FieldModifier.INITIAL)) {
                FieldModifierImpl.InitialModifier initialModifier = (FieldModifierImpl.InitialModifier)this.modifiers.get((Object)PersonName.FieldModifier.INITIAL);
                initialModifier.setRetainPunctuation(true);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            stringBuilder.append((Object)this.fieldID);
            for (PersonName.FieldModifier fieldModifier : this.modifiers.keySet()) {
                stringBuilder.append("-");
                stringBuilder.append(fieldModifier.toString());
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        @Override
        public boolean isLiteral() {
            return false;
        }

        @Override
        public String format(PersonName personName) {
            HashSet<PersonName.FieldModifier> hashSet = new HashSet<PersonName.FieldModifier>(this.modifiers.keySet());
            String string = personName.getFieldValue(this.fieldID, hashSet);
            if (string != null) {
                for (PersonName.FieldModifier fieldModifier : hashSet) {
                    string = this.modifiers.get((Object)fieldModifier).modifyField(string);
                }
            }
            return string;
        }

        @Override
        public boolean isPopulated(PersonName personName) {
            String string = this.format(personName);
            return string != null && !string.isEmpty();
        }
    }

    private static class LiteralText
    implements Element {
        private String text;

        public LiteralText(String string) {
            this.text = string;
        }

        public String toString() {
            return this.text;
        }

        @Override
        public boolean isLiteral() {
            return true;
        }

        @Override
        public String format(PersonName personName) {
            return this.text;
        }

        @Override
        public boolean isPopulated(PersonName personName) {
            return false;
        }
    }

    private static interface Element {
        public boolean isLiteral();

        public String format(PersonName var1);

        public boolean isPopulated(PersonName var1);
    }
}

