/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.personname;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.personname.PersonNamePattern;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UScript;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PersonName;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PersonNameFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public class PersonNameFormatterImpl {
    private final Locale locale;
    private final PersonNamePattern[] gnFirstPatterns;
    private final PersonNamePattern[] snFirstPatterns;
    private final Set<String> gnFirstLocales;
    private final Set<String> snFirstLocales;
    private final String initialPattern;
    private final String initialSequencePattern;
    private final boolean capitalizeSurname;
    private final String foreignSpaceReplacement;
    private final String nativeSpaceReplacement;
    private final PersonNameFormatter.Length length;
    private final PersonNameFormatter.Usage usage;
    private final PersonNameFormatter.Formality formality;
    private final PersonNameFormatter.DisplayOrder displayOrder;
    static final Set<String> NON_DEFAULT_SCRIPTS = new HashSet<String>(Arrays.asList("Hani", "Hira", "Kana"));

    public PersonNameFormatterImpl(Locale locale, PersonNameFormatter.Length length, PersonNameFormatter.Usage usage, PersonNameFormatter.Formality formality, PersonNameFormatter.DisplayOrder displayOrder, boolean bl2) {
        this.length = length;
        this.usage = usage;
        this.formality = formality;
        this.displayOrder = displayOrder;
        this.capitalizeSurname = bl2;
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", locale);
        this.locale = locale;
        this.initialPattern = iCUResourceBundle.getStringWithFallback("personNames/initialPattern/initial");
        this.initialSequencePattern = iCUResourceBundle.getStringWithFallback("personNames/initialPattern/initialSequence");
        this.foreignSpaceReplacement = iCUResourceBundle.getStringWithFallback("personNames/foreignSpaceReplacement");
        this.nativeSpaceReplacement = iCUResourceBundle.getStringWithFallback("personNames/nativeSpaceReplacement");
        if (usage == PersonNameFormatter.Usage.MONOGRAM) {
            displayOrder = PersonNameFormatter.DisplayOrder.DEFAULT;
        } else if (displayOrder == PersonNameFormatter.DisplayOrder.SORTING) {
            usage = PersonNameFormatter.Usage.REFERRING;
        }
        String string = "personNames/namePattern/";
        String string2 = length != PersonNameFormatter.Length.DEFAULT ? length.toString().toLowerCase() : iCUResourceBundle.getStringWithFallback("personNames/parameterDefault/length");
        String string3 = formality != PersonNameFormatter.Formality.DEFAULT ? formality.toString().toLowerCase() : iCUResourceBundle.getStringWithFallback("personNames/parameterDefault/formality");
        String string4 = string2 + "-" + usage.toString().toLowerCase() + "-" + string3;
        if (displayOrder != PersonNameFormatter.DisplayOrder.SORTING) {
            ICUResourceBundle iCUResourceBundle2 = iCUResourceBundle.getWithFallback("personNames/namePattern/givenFirst-" + string4);
            ICUResourceBundle iCUResourceBundle3 = iCUResourceBundle.getWithFallback("personNames/namePattern/surnameFirst-" + string4);
            this.gnFirstPatterns = PersonNamePattern.makePatterns(this.asStringArray(iCUResourceBundle2), this);
            this.snFirstPatterns = PersonNamePattern.makePatterns(this.asStringArray(iCUResourceBundle3), this);
            this.gnFirstLocales = new HashSet<String>();
            Collections.addAll(this.gnFirstLocales, this.asStringArray(iCUResourceBundle.getWithFallback("personNames/nameOrderLocales/givenFirst")));
            this.snFirstLocales = new HashSet<String>();
            Collections.addAll(this.snFirstLocales, this.asStringArray(iCUResourceBundle.getWithFallback("personNames/nameOrderLocales/surnameFirst")));
        } else {
            ICUResourceBundle iCUResourceBundle4 = iCUResourceBundle.getWithFallback("personNames/namePattern/sorting-" + string4);
            this.gnFirstPatterns = PersonNamePattern.makePatterns(this.asStringArray(iCUResourceBundle4), this);
            this.snFirstPatterns = null;
            this.gnFirstLocales = null;
            this.snFirstLocales = null;
        }
    }

    public PersonNameFormatterImpl(Locale locale, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        this.length = PersonNameFormatter.Length.MEDIUM;
        this.usage = PersonNameFormatter.Usage.REFERRING;
        this.formality = PersonNameFormatter.Formality.FORMAL;
        this.displayOrder = PersonNameFormatter.DisplayOrder.DEFAULT;
        this.initialPattern = "{0}.";
        this.initialSequencePattern = "{0} {1}";
        this.capitalizeSurname = false;
        this.foreignSpaceReplacement = " ";
        this.nativeSpaceReplacement = " ";
        this.locale = locale;
        this.gnFirstPatterns = PersonNamePattern.makePatterns(stringArray, this);
        PersonNamePattern[] personNamePatternArray = this.snFirstPatterns = stringArray2 != null ? PersonNamePattern.makePatterns(stringArray2, this) : null;
        if (stringArray3 != null) {
            this.gnFirstLocales = new HashSet<String>();
            Collections.addAll(this.gnFirstLocales, stringArray3);
        } else {
            this.gnFirstLocales = null;
        }
        if (stringArray4 != null) {
            this.snFirstLocales = new HashSet<String>();
            Collections.addAll(this.snFirstLocales, stringArray4);
        } else {
            this.snFirstLocales = null;
        }
    }

    public String toString() {
        return "PersonNameFormatter: " + (Object)((Object)this.displayOrder) + "-" + (Object)((Object)this.length) + "-" + (Object)((Object)this.usage) + "-" + (Object)((Object)this.formality) + ", " + this.locale;
    }

    public String formatToString(PersonName personName) {
        Locale locale = this.getNameLocale(personName);
        String string = this.getNameScript(personName);
        if (!this.nameScriptMatchesLocale(string, this.locale)) {
            Locale locale2 = this.formattingLocaleExists(locale) ? locale : this.newLocaleWithScript(null, string, locale.getCountry());
            PersonNameFormatterImpl personNameFormatterImpl = new PersonNameFormatterImpl(locale2, this.length, this.usage, this.formality, this.displayOrder, this.capitalizeSurname);
            return personNameFormatterImpl.formatToString(personName);
        }
        String string2 = null;
        string2 = this.snFirstPatterns == null || this.nameIsGnFirst(personName) ? this.getBestPattern(this.gnFirstPatterns, personName).format(personName) : this.getBestPattern(this.snFirstPatterns, personName).format(personName);
        if (!this.nativeSpaceReplacement.equals(" ") || !this.foreignSpaceReplacement.equals(" ")) {
            string2 = this.localesMatch(locale, this.locale) ? string2.replace(" ", this.nativeSpaceReplacement) : string2.replace(" ", this.foreignSpaceReplacement);
        }
        return string2;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public PersonNameFormatter.Length getLength() {
        return this.length;
    }

    public PersonNameFormatter.Usage getUsage() {
        return this.usage;
    }

    public PersonNameFormatter.Formality getFormality() {
        return this.formality;
    }

    public PersonNameFormatter.DisplayOrder getDisplayOrder() {
        return this.displayOrder;
    }

    public boolean getSurnameAllCaps() {
        return this.capitalizeSurname;
    }

    public String getInitialPattern() {
        return this.initialPattern;
    }

    public String getInitialSequencePattern() {
        return this.initialSequencePattern;
    }

    public boolean shouldCapitalizeSurname() {
        return this.capitalizeSurname;
    }

    private String[] asStringArray(ICUResourceBundle iCUResourceBundle) {
        if (iCUResourceBundle.getType() == 0) {
            return new String[]{iCUResourceBundle.getString()};
        }
        if (iCUResourceBundle.getType() == 8) {
            return iCUResourceBundle.getStringArray();
        }
        throw new IllegalStateException("Unsupported resource type " + iCUResourceBundle.getType());
    }

    private boolean nameIsGnFirst(PersonName personName) {
        String string;
        Object object;
        ULocale uLocale;
        if (this.displayOrder == PersonNameFormatter.DisplayOrder.FORCE_GIVEN_FIRST) {
            return true;
        }
        if (this.displayOrder == PersonNameFormatter.DisplayOrder.FORCE_SURNAME_FIRST) {
            return false;
        }
        if (personName.getPreferredOrder() == PersonName.PreferredOrder.GIVEN_FIRST) {
            return true;
        }
        if (personName.getPreferredOrder() == PersonName.PreferredOrder.SURNAME_FIRST) {
            return false;
        }
        Locale locale = personName.getNameLocale();
        if (locale == null) {
            locale = this.getNameLocale(personName);
        }
        if (NON_DEFAULT_SCRIPTS.contains((uLocale = ULocale.forLocale(locale)).getScript())) {
            object = new ULocale.Builder();
            ((ULocale.Builder)object).setLocale(uLocale);
            ((ULocale.Builder)object).setScript(null);
            uLocale = ULocale.addLikelySubtags(((ULocale.Builder)object).build());
        }
        Object object2 = object = uLocale.getName();
        String string2 = uLocale.getLanguage();
        do {
            if (this.gnFirstLocales.contains(object)) {
                return true;
            }
            if (this.snFirstLocales.contains(object)) {
                return false;
            }
            String string3 = ((String)object).replaceAll("^" + string2, "und");
            if (this.gnFirstLocales.contains(string3)) {
                return true;
            }
            if (!this.snFirstLocales.contains(string3)) continue;
            return false;
        } while ((object = (string = ICUResourceBundle.getParentLocaleID((String)object, (String)object2, ICUResourceBundle.OpenType.LOCALE_DEFAULT_ROOT)) != null ? string : string2) != null);
        return true;
    }

    private PersonNamePattern getBestPattern(PersonNamePattern[] personNamePatternArray, PersonName personName) {
        if (personNamePatternArray.length == 1) {
            return personNamePatternArray[0];
        }
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        PersonNamePattern personNamePattern = null;
        for (PersonNamePattern personNamePattern2 : personNamePatternArray) {
            int n4 = personNamePattern2.numPopulatedFields(personName);
            int n5 = personNamePattern2.numEmptyFields(personName);
            if (n4 > n2) {
                n2 = n4;
                n3 = n5;
                personNamePattern = personNamePattern2;
                continue;
            }
            if (n4 != n2 || n5 >= n3) continue;
            n3 = n5;
            personNamePattern = personNamePattern2;
        }
        return personNamePattern;
    }

    private String getNameScript(PersonName personName) {
        String string = personName.getFieldValue(PersonName.NameField.SURNAME, Collections.emptySet());
        String string2 = personName.getFieldValue(PersonName.NameField.GIVEN, Collections.emptySet());
        String string3 = (string2 != null ? string2 : "") + (string != null ? string : "");
        int n2 = 103;
        for (int i2 = 0; n2 == 103 && i2 < string3.length(); ++i2) {
            int n3 = string3.codePointAt(i2);
            int n4 = UScript.getScript(n3);
            if (n4 == 0 || n4 == 1 || n4 == 103) continue;
            n2 = n4;
        }
        return UScript.getShortName(n2);
    }

    private Locale newLocaleWithScript(Locale locale, String string, String string2) {
        String string3;
        Locale locale2;
        if (string.equals("Zzzz")) {
            return locale;
        }
        Locale.Builder builder = new Locale.Builder();
        if (locale != null) {
            locale2 = locale;
            builder.setLocale(locale);
            string3 = ULocale.addLikelySubtags(ULocale.forLocale(locale)).getScript();
        } else {
            ULocale uLocale = ULocale.addLikelySubtags(new ULocale("und_" + string));
            builder.setLanguage(uLocale.getLanguage());
            locale2 = ULocale.addLikelySubtags(new ULocale(uLocale.getLanguage())).toLocale();
            string3 = locale2.getScript();
            if (string2 != null) {
                builder.setRegion(string2);
            }
        }
        if (!string.equals(string3) && this.nameScriptMatchesLocale(string, locale2)) {
            string = string3;
        }
        builder.setScript(string);
        return builder.build();
    }

    private Locale getNameLocale(PersonName personName) {
        return this.newLocaleWithScript(personName.getNameLocale(), this.getNameScript(personName), null);
    }

    private boolean nameScriptMatchesLocale(String string, Locale locale) {
        if (string.equals("Zzzz")) {
            return true;
        }
        int[] nArray = UScript.getCode(locale);
        int n2 = UScript.getCodeFromName(string);
        for (int n3 : nArray) {
            if (n3 != n2 && (n3 != 73 || n2 != 17) && (n3 != 74 || n2 != 17)) continue;
            return true;
        }
        return false;
    }

    private boolean formattingLocaleExists(Locale locale) {
        String string = locale.getLanguage();
        ICUResourceBundle iCUResourceBundle = ICUResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", ULocale.forLocale(locale), ICUResourceBundle.OpenType.LOCALE_DEFAULT_ROOT);
        if (!iCUResourceBundle.getULocale().getLanguage().equals(string)) {
            return false;
        }
        ICUResourceBundle iCUResourceBundle2 = iCUResourceBundle.getWithFallback("personNames/nameOrderLocales/givenFirst");
        ICUResourceBundle iCUResourceBundle3 = iCUResourceBundle.getWithFallback("personNames/nameOrderLocales/surnameFirst");
        return iCUResourceBundle2.getULocale().getLanguage().equals(string) || iCUResourceBundle3.getULocale().getLanguage().equals(string);
    }

    private boolean localesMatch(Locale locale, Locale locale2) {
        String string;
        String string2 = locale.getLanguage();
        if (string2.equals(string = locale2.getLanguage())) {
            return true;
        }
        return !(!string2.equals("ja") && !string2.equals("zh") || !string.equals("ja") && !string.equals("zh"));
    }
}

