/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.range;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UResource;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceTypeMismatchException;

public class StandardPluralRanges {
    StandardPlural[] flatTriples;
    int numTriples = 0;
    private static volatile Map<String, String> languageToSet;
    public static final StandardPluralRanges DEFAULT;

    private static Map<String, String> getLanguageToSet() {
        Map<String, String> map = languageToSet;
        if (map == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            PluralRangeSetsDataSink pluralRangeSetsDataSink = new PluralRangeSetsDataSink(hashMap);
            ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "pluralRanges");
            iCUResourceBundle.getAllItemsWithFallback("locales", pluralRangeSetsDataSink);
            map = Collections.unmodifiableMap(hashMap);
        }
        if (languageToSet == null) {
            languageToSet = map;
        }
        return languageToSet;
    }

    private static void getPluralRangesData(String string, StandardPluralRanges standardPluralRanges) {
        StringBuilder stringBuilder = new StringBuilder();
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "pluralRanges");
        stringBuilder.setLength(0);
        stringBuilder.append("rules/");
        stringBuilder.append(string);
        String string2 = stringBuilder.toString();
        PluralRangesDataSink pluralRangesDataSink = new PluralRangesDataSink(standardPluralRanges);
        iCUResourceBundle.getAllItemsWithFallback(string2, pluralRangesDataSink);
    }

    public static StandardPluralRanges forLocale(ULocale uLocale) {
        return StandardPluralRanges.forSet(StandardPluralRanges.getSetForLocale(uLocale));
    }

    public static StandardPluralRanges forSet(String string) {
        StandardPluralRanges standardPluralRanges = new StandardPluralRanges();
        if (string == null) {
            return DEFAULT;
        }
        StandardPluralRanges.getPluralRangesData(string, standardPluralRanges);
        return standardPluralRanges;
    }

    public static String getSetForLocale(ULocale uLocale) {
        return StandardPluralRanges.getLanguageToSet().get(uLocale.getLanguage());
    }

    private StandardPluralRanges() {
    }

    private void addPluralRange(StandardPlural standardPlural, StandardPlural standardPlural2, StandardPlural standardPlural3) {
        this.flatTriples[3 * this.numTriples] = standardPlural;
        this.flatTriples[3 * this.numTriples + 1] = standardPlural2;
        this.flatTriples[3 * this.numTriples + 2] = standardPlural3;
        ++this.numTriples;
    }

    private void setCapacity(int n2) {
        this.flatTriples = new StandardPlural[n2 * 3];
    }

    public StandardPlural resolve(StandardPlural standardPlural, StandardPlural standardPlural2) {
        for (int i2 = 0; i2 < this.numTriples; ++i2) {
            if (standardPlural != this.flatTriples[3 * i2] || standardPlural2 != this.flatTriples[3 * i2 + 1]) continue;
            return this.flatTriples[3 * i2 + 2];
        }
        return StandardPlural.OTHER;
    }

    static {
        DEFAULT = new StandardPluralRanges();
    }

    private static final class PluralRangesDataSink
    extends UResource.Sink {
        StandardPluralRanges output;

        PluralRangesDataSink(StandardPluralRanges standardPluralRanges) {
            this.output = standardPluralRanges;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            UResource.Array array = value.getArray();
            this.output.setCapacity(array.getSize());
            int n2 = 0;
            while (array.getValue(n2, value)) {
                UResource.Array array2 = value.getArray();
                if (array2.getSize() != 3) {
                    throw new UResourceTypeMismatchException("Expected 3 elements in pluralRanges.txt array");
                }
                array2.getValue(0, value);
                StandardPlural standardPlural = StandardPlural.fromString(value.getString());
                array2.getValue(1, value);
                StandardPlural standardPlural2 = StandardPlural.fromString(value.getString());
                array2.getValue(2, value);
                StandardPlural standardPlural3 = StandardPlural.fromString(value.getString());
                this.output.addPluralRange(standardPlural, standardPlural2, standardPlural3);
                ++n2;
            }
        }
    }

    private static final class PluralRangeSetsDataSink
    extends UResource.Sink {
        Map<String, String> output;

        PluralRangeSetsDataSink(Map<String, String> map) {
            this.output = map;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            UResource.Table table = value.getTable();
            int n2 = 0;
            while (table.getKeyAndValue(n2, key, value)) {
                assert (key.toString().equals(new ULocale(key.toString()).getLanguage()));
                this.output.put(key.toString(), value.toString());
                ++n2;
            }
        }
    }
}

