/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import java.text.Format;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedStringBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.ModifierStore;

public interface Modifier {
    public int apply(FormattedStringBuilder var1, int var2, int var3);

    public int getPrefixLength();

    public int getCodePointCount();

    public boolean isStrong();

    public boolean containsField(Format.Field var1);

    public Parameters getParameters();

    public boolean strictEquals(Modifier var1);

    default public boolean semanticallyEquivalent(Modifier modifier) {
        Parameters parameters = this.getParameters();
        Parameters parameters2 = modifier.getParameters();
        if (parameters == null && parameters2 == null) {
            return this.strictEquals(modifier);
        }
        if (parameters == null || parameters2 == null) {
            return false;
        }
        if (parameters.obj == null && parameters2.obj == null) {
            return this.strictEquals(modifier);
        }
        if (parameters.obj == null || parameters2.obj == null) {
            return false;
        }
        for (Signum signum : Signum.VALUES) {
            for (StandardPlural standardPlural : StandardPlural.VALUES) {
                Modifier modifier2;
                Modifier modifier3 = parameters.obj.getModifier(signum, standardPlural);
                if (modifier3 == (modifier2 = parameters2.obj.getModifier(signum, standardPlural))) continue;
                if (modifier3 == null || modifier2 == null) {
                    return false;
                }
                if (modifier3.strictEquals(modifier2)) continue;
                return false;
            }
        }
        return true;
    }

    public static class Parameters {
        public ModifierStore obj;
        public Signum signum;
        public StandardPlural plural;
    }

    public static enum Signum {
        NEG,
        NEG_ZERO,
        POS_ZERO,
        POS;

        static final int COUNT;
        public static final Signum[] VALUES;

        static {
            COUNT = Signum.values().length;
            VALUES = Signum.values();
        }
    }
}

