/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedStringBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedValueStringBuilderImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.LocalizedNumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class LocalizedNumberFormatterAsFormat
extends Format {
    private static final long serialVersionUID = 1L;
    private final transient LocalizedNumberFormatter formatter;
    private final transient ULocale locale;

    public LocalizedNumberFormatterAsFormat(LocalizedNumberFormatter localizedNumberFormatter, ULocale uLocale) {
        this.formatter = localizedNumberFormatter;
        this.locale = uLocale;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException();
        }
        DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = new DecimalQuantity_DualStorageBCD((Number)object);
        FormattedStringBuilder formattedStringBuilder = new FormattedStringBuilder();
        this.formatter.formatImpl(decimalQuantity_DualStorageBCD, formattedStringBuilder);
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        boolean bl2 = FormattedValueStringBuilderImpl.nextFieldPosition(formattedStringBuilder, fieldPosition);
        if (bl2 && stringBuffer.length() != 0) {
            fieldPosition.setBeginIndex(fieldPosition.getBeginIndex() + stringBuffer.length());
            fieldPosition.setEndIndex(fieldPosition.getEndIndex() + stringBuffer.length());
        }
        Utility.appendTo(formattedStringBuilder, stringBuffer);
        return stringBuffer;
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        if (!(object instanceof Number)) {
            throw new IllegalArgumentException();
        }
        return this.formatter.format((Number)object).toCharacterIterator();
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        throw new UnsupportedOperationException();
    }

    public LocalizedNumberFormatter getNumberFormatter() {
        return this.formatter;
    }

    public int hashCode() {
        return this.formatter.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof LocalizedNumberFormatterAsFormat)) {
            return false;
        }
        return this.formatter.equals(((LocalizedNumberFormatterAsFormat)object).getNumberFormatter());
    }

    private Object writeReplace() throws ObjectStreamException {
        Proxy proxy = new Proxy();
        proxy.languageTag = this.locale.toLanguageTag();
        proxy.skeleton = this.formatter.toSkeleton();
        return proxy;
    }

    static class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        String languageTag;
        String skeleton;

        @Override
        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeByte(0);
            objectOutput.writeUTF(this.languageTag);
            objectOutput.writeUTF(this.skeleton);
        }

        @Override
        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            objectInput.readByte();
            this.languageTag = objectInput.readUTF();
            this.skeleton = objectInput.readUTF();
        }

        private Object readResolve() throws ObjectStreamException {
            return NumberFormatter.forSkeleton(this.skeleton).locale(ULocale.forLanguageTag(this.languageTag)).toFormat();
        }
    }
}

