/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.AffixPatternProvider;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalFormatProperties;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.PatternStringParser;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.PropertiesAffixPatternProvider;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CurrencyPluralInfo;

public class CurrencyPluralInfoAffixProvider
implements AffixPatternProvider {
    private final PropertiesAffixPatternProvider[] affixesByPlural = new PropertiesAffixPatternProvider[StandardPlural.COUNT];

    public CurrencyPluralInfoAffixProvider(CurrencyPluralInfo currencyPluralInfo, DecimalFormatProperties decimalFormatProperties) {
        DecimalFormatProperties decimalFormatProperties2 = new DecimalFormatProperties();
        decimalFormatProperties2.copyFrom(decimalFormatProperties);
        for (StandardPlural standardPlural : StandardPlural.VALUES) {
            String string = currencyPluralInfo.getCurrencyPluralPattern(standardPlural.getKeyword());
            PatternStringParser.parseToExistingProperties(string, decimalFormatProperties2);
            this.affixesByPlural[standardPlural.ordinal()] = new PropertiesAffixPatternProvider(decimalFormatProperties2);
        }
    }

    @Override
    public char charAt(int n2, int n3) {
        int n4 = n2 & 0xFF;
        return this.affixesByPlural[n4].charAt(n2, n3);
    }

    @Override
    public int length(int n2) {
        int n3 = n2 & 0xFF;
        return this.affixesByPlural[n3].length(n2);
    }

    @Override
    public String getString(int n2) {
        int n3 = n2 & 0xFF;
        return this.affixesByPlural[n3].getString(n2);
    }

    @Override
    public boolean positiveHasPlusSign() {
        return this.affixesByPlural[StandardPlural.OTHER.ordinal()].positiveHasPlusSign();
    }

    @Override
    public boolean hasNegativeSubpattern() {
        return this.affixesByPlural[StandardPlural.OTHER.ordinal()].hasNegativeSubpattern();
    }

    @Override
    public boolean negativeHasMinusSign() {
        return this.affixesByPlural[StandardPlural.OTHER.ordinal()].negativeHasMinusSign();
    }

    @Override
    public boolean hasCurrencySign() {
        return this.affixesByPlural[StandardPlural.OTHER.ordinal()].hasCurrencySign();
    }

    @Override
    public boolean containsSymbolType(int n2) {
        return this.affixesByPlural[StandardPlural.OTHER.ordinal()].containsSymbolType(n2);
    }

    @Override
    public boolean hasBody() {
        return this.affixesByPlural[StandardPlural.OTHER.ordinal()].hasBody();
    }

    @Override
    public boolean currencyAsDecimal() {
        return this.affixesByPlural[StandardPlural.OTHER.ordinal()].currencyAsDecimal();
    }
}

