/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import java.text.Format;
import java.util.Arrays;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedStringBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Modifier;

public class ConstantMultiFieldModifier
implements Modifier {
    protected final char[] prefixChars;
    protected final char[] suffixChars;
    protected final Object[] prefixFields;
    protected final Object[] suffixFields;
    private final boolean overwrite;
    private final boolean strong;
    private final Modifier.Parameters parameters;

    public ConstantMultiFieldModifier(FormattedStringBuilder formattedStringBuilder, FormattedStringBuilder formattedStringBuilder2, boolean bl2, boolean bl3) {
        this(formattedStringBuilder, formattedStringBuilder2, bl2, bl3, null);
    }

    public ConstantMultiFieldModifier(FormattedStringBuilder formattedStringBuilder, FormattedStringBuilder formattedStringBuilder2, boolean bl2, boolean bl3, Modifier.Parameters parameters) {
        this.prefixChars = formattedStringBuilder.toCharArray();
        this.suffixChars = formattedStringBuilder2.toCharArray();
        this.prefixFields = formattedStringBuilder.toFieldArray();
        this.suffixFields = formattedStringBuilder2.toFieldArray();
        this.overwrite = bl2;
        this.strong = bl3;
        this.parameters = parameters;
    }

    @Override
    public int apply(FormattedStringBuilder formattedStringBuilder, int n2, int n3) {
        int n4 = formattedStringBuilder.insert(n2, this.prefixChars, this.prefixFields);
        if (this.overwrite) {
            n4 += formattedStringBuilder.splice(n2 + n4, n3 + n4, "", 0, 0, null);
        }
        n4 += formattedStringBuilder.insert(n3 + n4, this.suffixChars, this.suffixFields);
        return n4;
    }

    @Override
    public int getPrefixLength() {
        return this.prefixChars.length;
    }

    @Override
    public int getCodePointCount() {
        return Character.codePointCount(this.prefixChars, 0, this.prefixChars.length) + Character.codePointCount(this.suffixChars, 0, this.suffixChars.length);
    }

    @Override
    public boolean isStrong() {
        return this.strong;
    }

    @Override
    public boolean containsField(Format.Field field) {
        int n2;
        for (n2 = 0; n2 < this.prefixFields.length; ++n2) {
            if (this.prefixFields[n2] != field) continue;
            return true;
        }
        for (n2 = 0; n2 < this.suffixFields.length; ++n2) {
            if (this.suffixFields[n2] != field) continue;
            return true;
        }
        return false;
    }

    @Override
    public Modifier.Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public boolean strictEquals(Modifier modifier) {
        if (!(modifier instanceof ConstantMultiFieldModifier)) {
            return false;
        }
        ConstantMultiFieldModifier constantMultiFieldModifier = (ConstantMultiFieldModifier)modifier;
        return Arrays.equals(this.prefixChars, constantMultiFieldModifier.prefixChars) && Arrays.equals(this.prefixFields, constantMultiFieldModifier.prefixFields) && Arrays.equals(this.suffixChars, constantMultiFieldModifier.suffixChars) && Arrays.equals(this.suffixFields, constantMultiFieldModifier.suffixFields) && this.overwrite == constantMultiFieldModifier.overwrite && this.strong == constantMultiFieldModifier.strong;
    }

    public String toString() {
        FormattedStringBuilder formattedStringBuilder = new FormattedStringBuilder();
        this.apply(formattedStringBuilder, 0, 0);
        int n2 = this.getPrefixLength();
        return String.format("<ConstantMultiFieldModifier prefix:'%s' suffix:'%s'>", formattedStringBuilder.subSequence(0, n2), formattedStringBuilder.subSequence(n2, formattedStringBuilder.length()));
    }
}

