/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UResource;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MultiplierProducer;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CompactDecimalFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public class CompactData
implements MultiplierProducer {
    private static final String USE_FALLBACK = "<USE FALLBACK>";
    private final String[] patterns = new String[21 * StandardPlural.COUNT];
    private final byte[] multipliers = new byte[21];
    private byte largestMagnitude = 0;
    private boolean isEmpty = true;
    private static final int COMPACT_MAX_DIGITS = 20;

    public void populate(ULocale uLocale, String string, CompactDecimalFormat.CompactStyle compactStyle, CompactType compactType) {
        assert (this.isEmpty);
        CompactDataSink compactDataSink = new CompactDataSink(this);
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", uLocale);
        boolean bl2 = string.equals("latn");
        boolean bl3 = compactStyle == CompactDecimalFormat.CompactStyle.SHORT;
        StringBuilder stringBuilder = new StringBuilder();
        CompactData.getResourceBundleKey(string, compactStyle, compactType, stringBuilder);
        iCUResourceBundle.getAllItemsWithFallbackNoFail(stringBuilder.toString(), compactDataSink);
        if (this.isEmpty && !bl2) {
            CompactData.getResourceBundleKey("latn", compactStyle, compactType, stringBuilder);
            iCUResourceBundle.getAllItemsWithFallbackNoFail(stringBuilder.toString(), compactDataSink);
        }
        if (this.isEmpty && !bl3) {
            CompactData.getResourceBundleKey(string, CompactDecimalFormat.CompactStyle.SHORT, compactType, stringBuilder);
            iCUResourceBundle.getAllItemsWithFallbackNoFail(stringBuilder.toString(), compactDataSink);
        }
        if (this.isEmpty && !bl2 && !bl3) {
            CompactData.getResourceBundleKey("latn", CompactDecimalFormat.CompactStyle.SHORT, compactType, stringBuilder);
            iCUResourceBundle.getAllItemsWithFallbackNoFail(stringBuilder.toString(), compactDataSink);
        }
        if (this.isEmpty) {
            throw new ICUException("Could not load compact decimal data for locale " + uLocale);
        }
    }

    private static void getResourceBundleKey(String string, CompactDecimalFormat.CompactStyle compactStyle, CompactType compactType, StringBuilder stringBuilder) {
        stringBuilder.setLength(0);
        stringBuilder.append("NumberElements/");
        stringBuilder.append(string);
        stringBuilder.append(compactStyle == CompactDecimalFormat.CompactStyle.SHORT ? "/patternsShort" : "/patternsLong");
        stringBuilder.append(compactType == CompactType.DECIMAL ? "/decimalFormat" : "/currencyFormat");
    }

    public void populate(Map<String, Map<String, String>> map) {
        assert (this.isEmpty);
        for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
            byte by2 = (byte)(entry.getKey().length() - 1);
            for (Map.Entry<String, String> entry2 : entry.getValue().entrySet()) {
                String string;
                String string2 = entry2.getKey().toString();
                StandardPlural standardPlural = StandardPlural.fromString(string2);
                this.patterns[CompactData.getIndex((int)by2, (StandardPlural)standardPlural)] = string = entry2.getValue().toString();
                int n2 = CompactData.countZeros(string);
                if (n2 <= 0) continue;
                this.multipliers[by2] = (byte)(n2 - by2 - 1);
                if (by2 > this.largestMagnitude) {
                    this.largestMagnitude = by2;
                }
                this.isEmpty = false;
            }
        }
    }

    @Override
    public int getMultiplier(int n2) {
        if (n2 < 0) {
            return 0;
        }
        if (n2 > this.largestMagnitude) {
            n2 = this.largestMagnitude;
        }
        return this.multipliers[n2];
    }

    public String getPattern(int n2, PluralRules pluralRules, DecimalQuantity decimalQuantity) {
        StandardPlural standardPlural;
        if (n2 < 0) {
            return null;
        }
        if (n2 > this.largestMagnitude) {
            n2 = this.largestMagnitude;
        }
        String string = null;
        if (decimalQuantity.isHasIntegerValue()) {
            long l2 = decimalQuantity.toLong(true);
            if (l2 == 0L) {
                string = this.patterns[CompactData.getIndex(n2, StandardPlural.EQ_0)];
            } else if (l2 == 1L) {
                string = this.patterns[CompactData.getIndex(n2, StandardPlural.EQ_1)];
            }
            if (string != null) {
                return string;
            }
        }
        if ((string = this.patterns[CompactData.getIndex(n2, standardPlural = decimalQuantity.getStandardPlural(pluralRules))]) == null && standardPlural != StandardPlural.OTHER) {
            string = this.patterns[CompactData.getIndex(n2, StandardPlural.OTHER)];
        }
        if (string == USE_FALLBACK) {
            string = null;
        }
        return string;
    }

    public void getUniquePatterns(Set<String> set) {
        assert (set.isEmpty());
        set.addAll(Arrays.asList(this.patterns));
        set.remove(USE_FALLBACK);
        set.remove(null);
    }

    private static final int getIndex(int n2, StandardPlural standardPlural) {
        return n2 * StandardPlural.COUNT + standardPlural.ordinal();
    }

    private static final int countZeros(String string) {
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '0') {
                ++n2;
                continue;
            }
            if (n2 > 0) break;
        }
        return n2;
    }

    private static final class CompactDataSink
    extends UResource.Sink {
        CompactData data;

        public CompactDataSink(CompactData compactData) {
            this.data = compactData;
        }

        @Override
        public void put(UResource.Key key, UResource.Value value, boolean bl2) {
            UResource.Table table = value.getTable();
            int n2 = 0;
            while (table.getKeyAndValue(n2, key, value)) {
                byte by2 = (byte)(key.length() - 1);
                if (by2 < 20) {
                    byte by3 = this.data.multipliers[by2];
                    UResource.Table table2 = value.getTable();
                    int n3 = 0;
                    while (table2.getKeyAndValue(n3, key, value)) {
                        StandardPlural standardPlural = StandardPlural.fromString(key.toString());
                        if (this.data.patterns[CompactData.getIndex(by2, standardPlural)] == null) {
                            int n4;
                            String string = value.toString();
                            if (string.equals("0")) {
                                string = CompactData.USE_FALLBACK;
                            }
                            ((CompactData)this.data).patterns[CompactData.getIndex((int)by2, (StandardPlural)standardPlural)] = string;
                            if (by3 == 0 && (n4 = CompactData.countZeros(string)) > 0) {
                                by3 = (byte)(n4 - by2 - 1);
                            }
                        }
                        ++n3;
                    }
                    if (this.data.multipliers[by2] == 0) {
                        ((CompactData)this.data).multipliers[by2] = by3;
                        if (by2 > this.data.largestMagnitude) {
                            this.data.largestMagnitude = by2;
                        }
                        this.data.isEmpty = false;
                    } else assert (this.data.multipliers[by2] == by3);
                }
                ++n2;
            }
        }
    }

    public static enum CompactType {
        DECIMAL,
        CURRENCY;

    }
}

