/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Modifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.ModifierStore;

public class AdoptingModifierStore
implements ModifierStore {
    private final Modifier positive;
    private final Modifier posZero;
    private final Modifier negZero;
    private final Modifier negative;
    final Modifier[] mods;
    boolean frozen;

    public AdoptingModifierStore(Modifier modifier, Modifier modifier2, Modifier modifier3, Modifier modifier4) {
        this.positive = modifier;
        this.posZero = modifier2;
        this.negZero = modifier3;
        this.negative = modifier4;
        this.mods = null;
        this.frozen = true;
    }

    public AdoptingModifierStore() {
        this.positive = null;
        this.posZero = null;
        this.negZero = null;
        this.negative = null;
        this.mods = new Modifier[4 * StandardPlural.COUNT];
        this.frozen = false;
    }

    public void setModifier(Modifier.Signum signum, StandardPlural standardPlural, Modifier modifier) {
        assert (!this.frozen);
        this.mods[AdoptingModifierStore.getModIndex((Modifier.Signum)signum, (StandardPlural)standardPlural)] = modifier;
    }

    public void freeze() {
        this.frozen = true;
    }

    public Modifier getModifierWithoutPlural(Modifier.Signum signum) {
        assert (this.frozen);
        assert (this.mods == null);
        assert (signum != null);
        switch (signum) {
            case POS: {
                return this.positive;
            }
            case POS_ZERO: {
                return this.posZero;
            }
            case NEG_ZERO: {
                return this.negZero;
            }
            case NEG: {
                return this.negative;
            }
        }
        throw new AssertionError((Object)"Unreachable");
    }

    @Override
    public Modifier getModifier(Modifier.Signum signum, StandardPlural standardPlural) {
        assert (this.frozen);
        assert (this.positive == null);
        return this.mods[AdoptingModifierStore.getModIndex(signum, standardPlural)];
    }

    private static int getModIndex(Modifier.Signum signum, StandardPlural standardPlural) {
        assert (signum != null);
        assert (standardPlural != null);
        return standardPlural.ordinal() * Modifier.Signum.COUNT + signum.ordinal();
    }
}

