/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;

public final class AsciiUtil {
    public static boolean caseIgnoreMatch(String string, String string2) {
        char c2;
        char c3;
        int n2;
        if (Utility.sameObjects(string, string2)) {
            return true;
        }
        int n3 = string.length();
        if (n3 != string2.length()) {
            return false;
        }
        for (n2 = 0; n2 < n3 && ((c3 = string.charAt(n2)) == (c2 = string2.charAt(n2)) || AsciiUtil.toLower(c3) == AsciiUtil.toLower(c2)); ++n2) {
        }
        return n2 == n3;
    }

    public static int caseIgnoreCompare(String string, String string2) {
        if (Utility.sameObjects(string, string2)) {
            return 0;
        }
        return AsciiUtil.toLowerString(string).compareTo(AsciiUtil.toLowerString(string2));
    }

    public static char toUpper(char c2) {
        if (c2 >= 'a' && c2 <= 'z') {
            c2 = (char)(c2 - 32);
        }
        return c2;
    }

    public static char toLower(char c2) {
        if (c2 >= 'A' && c2 <= 'Z') {
            c2 = (char)(c2 + 32);
        }
        return c2;
    }

    public static String toLowerString(String string) {
        char c2;
        int n2;
        for (n2 = 0; n2 < string.length() && ((c2 = string.charAt(n2)) < 'A' || c2 > 'Z'); ++n2) {
        }
        if (n2 == string.length()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, n2));
        while (n2 < string.length()) {
            stringBuilder.append(AsciiUtil.toLower(string.charAt(n2)));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String toUpperString(String string) {
        char c2;
        int n2;
        for (n2 = 0; n2 < string.length() && ((c2 = string.charAt(n2)) < 'a' || c2 > 'z'); ++n2) {
        }
        if (n2 == string.length()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, n2));
        while (n2 < string.length()) {
            stringBuilder.append(AsciiUtil.toUpper(string.charAt(n2)));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String toTitleString(String string) {
        if (string.length() == 0) {
            return string;
        }
        int n2 = 0;
        char c2 = string.charAt(n2);
        if (c2 < 'a' || c2 > 'z') {
            for (n2 = 1; n2 < string.length() && (c2 < 'A' || c2 > 'Z'); ++n2) {
            }
        }
        if (n2 == string.length()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.substring(0, n2));
        if (n2 == 0) {
            stringBuilder.append(AsciiUtil.toUpper(string.charAt(n2)));
            ++n2;
        }
        while (n2 < string.length()) {
            stringBuilder.append(AsciiUtil.toLower(string.charAt(n2)));
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static boolean isAlpha(char c2) {
        return c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z';
    }

    public static boolean isAlphaString(String string) {
        boolean bl2 = true;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (AsciiUtil.isAlpha(string.charAt(i2))) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    public static boolean isNumeric(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    public static boolean isNumericString(String string) {
        boolean bl2 = true;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (AsciiUtil.isNumeric(string.charAt(i2))) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    public static boolean isAlphaNumeric(char c2) {
        return AsciiUtil.isAlpha(c2) || AsciiUtil.isNumeric(c2);
    }

    public static boolean isAlphaNumericString(String string) {
        boolean bl2 = true;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (AsciiUtil.isAlphaNumeric(string.charAt(i2))) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    public static class CaseInsensitiveKey {
        private String _key;
        private int _hash;

        public CaseInsensitiveKey(String string) {
            this._key = string;
            this._hash = AsciiUtil.toLowerString(string).hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof CaseInsensitiveKey) {
                return AsciiUtil.caseIgnoreMatch(this._key, ((CaseInsensitiveKey)object)._key);
            }
            return false;
        }

        public int hashCode() {
            return this._hash;
        }
    }
}

