/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.impl.RecordWriter;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;

public class XMLRecordWriter
implements RecordWriter {
    private Writer w;
    private List<String> nameStack;
    static final String NULL_NAME = "Null";
    private static final String INDENT = "    ";

    public XMLRecordWriter(Writer writer) {
        this.w = writer;
        this.nameStack = new ArrayList<String>();
    }

    @Override
    public boolean open(String string) {
        this.newline();
        this.writeString("<" + string + ">");
        this.nameStack.add(string);
        return true;
    }

    @Override
    public boolean close() {
        int n2 = this.nameStack.size() - 1;
        if (n2 >= 0) {
            String string = this.nameStack.remove(n2);
            this.newline();
            this.writeString("</" + string + ">");
            return true;
        }
        return false;
    }

    public void flush() {
        try {
            this.w.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void bool(String string, boolean bl2) {
        this.internalString(string, String.valueOf(bl2));
    }

    @Override
    public void boolArray(String string, boolean[] blArray) {
        if (blArray != null) {
            String[] stringArray = new String[blArray.length];
            for (int i2 = 0; i2 < blArray.length; ++i2) {
                stringArray[i2] = String.valueOf(blArray[i2]);
            }
            this.stringArray(string, stringArray);
        }
    }

    private static String ctos(char c2) {
        if (c2 == '<') {
            return "&lt;";
        }
        if (c2 == '&') {
            return "&amp;";
        }
        return String.valueOf(c2);
    }

    @Override
    public void character(String string, char c2) {
        if (c2 != '\uffff') {
            this.internalString(string, XMLRecordWriter.ctos(c2));
        }
    }

    @Override
    public void characterArray(String string, char[] cArray) {
        if (cArray != null) {
            String[] stringArray = new String[cArray.length];
            for (int i2 = 0; i2 < cArray.length; ++i2) {
                char c2 = cArray[i2];
                stringArray[i2] = c2 == '\uffff' ? NULL_NAME : XMLRecordWriter.ctos(c2);
            }
            this.internalStringArray(string, stringArray);
        }
    }

    @Override
    public void namedIndex(String string, String[] stringArray, int n2) {
        if (n2 >= 0) {
            this.internalString(string, stringArray[n2]);
        }
    }

    @Override
    public void namedIndexArray(String string, String[] stringArray, byte[] byArray) {
        if (byArray != null) {
            String[] stringArray2 = new String[byArray.length];
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byte by2 = byArray[i2];
                stringArray2[i2] = by2 < 0 ? NULL_NAME : stringArray[by2];
            }
            this.internalStringArray(string, stringArray2);
        }
    }

    public static String normalize(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = null;
        boolean bl2 = false;
        char c2 = '\u0000';
        boolean bl3 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            c2 = string.charAt(i2);
            if (UCharacter.isWhitespace(c2)) {
                if (stringBuilder == null && (bl2 || c2 != ' ')) {
                    stringBuilder = new StringBuilder(string.substring(0, i2));
                }
                if (bl2) continue;
                bl2 = true;
                bl3 = false;
                c2 = ' ';
            } else {
                bl2 = false;
                boolean bl4 = bl3 = c2 == '<' || c2 == '&';
                if (bl3 && stringBuilder == null) {
                    stringBuilder = new StringBuilder(string.substring(0, i2));
                }
            }
            if (stringBuilder == null) continue;
            if (bl3) {
                stringBuilder.append(c2 == '<' ? "&lt;" : "&amp;");
                continue;
            }
            stringBuilder.append(c2);
        }
        if (stringBuilder != null) {
            return stringBuilder.toString();
        }
        return string;
    }

    private void internalString(String string, String string2) {
        if (string2 != null) {
            this.newline();
            this.writeString("<" + string + ">" + string2 + "</" + string + ">");
        }
    }

    private void internalStringArray(String string, String[] stringArray) {
        if (stringArray != null) {
            this.push(string + "List");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2];
                if (string2 == null) {
                    string2 = NULL_NAME;
                }
                this.string(string, string2);
            }
            this.pop();
        }
    }

    @Override
    public void string(String string, String string2) {
        this.internalString(string, XMLRecordWriter.normalize(string2));
    }

    @Override
    public void stringArray(String string, String[] stringArray) {
        if (stringArray != null) {
            this.push(string + "List");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = XMLRecordWriter.normalize(stringArray[i2]);
                if (string2 == null) {
                    string2 = NULL_NAME;
                }
                this.internalString(string, string2);
            }
            this.pop();
        }
    }

    @Override
    public void stringTable(String string, String[][] stringArray) {
        if (stringArray != null) {
            this.push(string + "Table");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String[] stringArray2 = stringArray[i2];
                if (stringArray2 == null) {
                    this.internalString(string + "List", NULL_NAME);
                    continue;
                }
                this.stringArray(string, stringArray2);
            }
            this.pop();
        }
    }

    private void push(String string) {
        this.newline();
        this.writeString("<" + string + ">");
        this.nameStack.add(string);
    }

    private void pop() {
        int n2 = this.nameStack.size() - 1;
        String string = this.nameStack.remove(n2);
        this.newline();
        this.writeString("</" + string + ">");
    }

    private void newline() {
        this.writeString("\n");
        for (int i2 = 0; i2 < this.nameStack.size(); ++i2) {
            this.writeString(INDENT);
        }
    }

    private void writeString(String string) {
        if (this.w != null) {
            try {
                this.w.write(string);
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
                this.w = null;
            }
        }
    }
}

