/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.BasicPeriodFormatterFactory;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.Period;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.PeriodFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.TimeUnit;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.impl.PeriodFormatterData;

class BasicPeriodFormatter
implements PeriodFormatter {
    private BasicPeriodFormatterFactory factory;
    private String localeName;
    private PeriodFormatterData data;
    private BasicPeriodFormatterFactory.Customizations customs;

    BasicPeriodFormatter(BasicPeriodFormatterFactory basicPeriodFormatterFactory, String string, PeriodFormatterData periodFormatterData, BasicPeriodFormatterFactory.Customizations customizations) {
        this.factory = basicPeriodFormatterFactory;
        this.localeName = string;
        this.data = periodFormatterData;
        this.customs = customizations;
    }

    @Override
    public String format(Period period) {
        if (!period.isSet()) {
            throw new IllegalArgumentException("period is not set");
        }
        return this.format(period.timeLimit, period.inFuture, period.counts);
    }

    @Override
    public PeriodFormatter withLocale(String string) {
        if (!this.localeName.equals(string)) {
            PeriodFormatterData periodFormatterData = this.factory.getData(string);
            return new BasicPeriodFormatter(this.factory, string, periodFormatterData, this.customs);
        }
        return this;
    }

    private String format(int n2, boolean bl2, int[] nArray) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = 0;
        for (n8 = 0; n8 < nArray.length; ++n8) {
            if (nArray[n8] <= 0) continue;
            n9 |= 1 << n8;
        }
        if (!this.data.allowZero()) {
            n8 = 0;
            n7 = 1;
            while (n8 < nArray.length) {
                if ((n9 & n7) != 0 && nArray[n8] == 1) {
                    n9 &= ~n7;
                }
                ++n8;
                n7 <<= 1;
            }
            if (n9 == 0) {
                return null;
            }
        }
        n8 = 0;
        if (this.data.useMilliseconds() != 0 && (n9 & 1 << TimeUnit.MILLISECOND.ordinal) != 0) {
            n7 = TimeUnit.SECOND.ordinal;
            n6 = TimeUnit.MILLISECOND.ordinal;
            n5 = 1 << n7;
            n4 = 1 << n6;
            switch (this.data.useMilliseconds()) {
                case 2: {
                    if ((n9 & n5) == 0) break;
                    int n10 = n7;
                    nArray[n10] = nArray[n10] + (nArray[n6] - 1) / 1000;
                    n9 &= ~n4;
                    n8 = 1;
                    break;
                }
                case 1: {
                    if ((n9 & n5) == 0) {
                        n9 |= n5;
                        nArray[n7] = 1;
                    }
                    int n11 = n7;
                    nArray[n11] = nArray[n11] + (nArray[n6] - 1) / 1000;
                    n9 &= ~n4;
                    n8 = 1;
                }
            }
        }
        n6 = nArray.length - 1;
        for (n7 = 0; n7 < nArray.length && (n9 & 1 << n7) == 0; ++n7) {
        }
        while (n6 > n7 && (n9 & 1 << n6) == 0) {
            --n6;
        }
        n5 = 1;
        for (n4 = n7; n4 <= n6; ++n4) {
            if ((n9 & 1 << n4) == 0 || nArray[n4] <= 1) continue;
            n5 = 0;
            break;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.customs.displayLimit || n5 != 0) {
            n2 = 0;
        }
        int n12 = !this.customs.displayDirection || n5 != 0 ? 0 : (bl2 ? 2 : 1);
        boolean bl3 = this.data.appendPrefix(n2, n12, stringBuffer);
        boolean bl4 = n7 != n6;
        boolean bl5 = true;
        boolean bl6 = false;
        boolean bl7 = this.customs.separatorVariant != 0;
        int n13 = n3 = n7;
        while (n3 <= n6) {
            if (bl6) {
                this.data.appendSkippedUnit(stringBuffer);
                bl6 = false;
                bl5 = true;
            }
            while (++n13 < n6 && (n9 & 1 << n13) == 0) {
                bl6 = true;
            }
            TimeUnit timeUnit = TimeUnit.units[n3];
            int n14 = nArray[n3] - 1;
            int n15 = this.customs.countVariant;
            if (n3 == n6) {
                if (n8 != 0) {
                    n15 = 5;
                }
            } else {
                n15 = 0;
            }
            boolean bl8 = n3 == n6;
            boolean bl9 = this.data.appendUnit(timeUnit, n14, n15, this.customs.unitVariant, bl7, bl3, bl4, bl8, bl5, stringBuffer);
            bl6 |= bl9;
            bl5 = false;
            if (this.customs.separatorVariant != 0 && n13 <= n6) {
                boolean bl10 = n3 == n7;
                boolean bl11 = n13 == n6;
                boolean bl12 = this.customs.separatorVariant == 2;
                bl3 = this.data.appendUnitSeparator(timeUnit, bl12, bl10, bl11, stringBuffer);
            } else {
                bl3 = false;
            }
            n3 = n13;
        }
        this.data.appendSuffix(n2, n12, stringBuffer);
        return stringBuffer.toString();
    }
}

