/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Normalizer2Impl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.Collation;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationData;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CharsTrie;

public final class TailoredSet {
    private CollationData data;
    private CollationData baseData;
    private UnicodeSet tailored;
    private StringBuilder unreversedPrefix = new StringBuilder();
    private String suffix;

    public TailoredSet(UnicodeSet unicodeSet) {
        this.tailored = unicodeSet;
    }

    public void forData(CollationData collationData) {
        this.data = collationData;
        this.baseData = collationData.base;
        assert (this.baseData != null);
        for (Trie2.Range range : this.data.trie) {
            if (range.leadSurrogate) break;
            this.enumTailoredRange(range.startCodePoint, range.endCodePoint, range.value, this);
        }
    }

    private void enumTailoredRange(int n2, int n3, int n4, TailoredSet tailoredSet) {
        if (n4 == 192) {
            return;
        }
        tailoredSet.handleCE32(n2, n3, n4);
    }

    private void handleCE32(int n2, int n3, int n4) {
        assert (n4 != 192);
        if (Collation.isSpecialCE32(n4) && (n4 = this.data.getIndirectCE32(n4)) == 192) {
            return;
        }
        do {
            int n5 = this.baseData.getFinalCE32(this.baseData.getCE32(n2));
            if (Collation.isSelfContainedCE32(n4) && Collation.isSelfContainedCE32(n5)) {
                if (n4 == n5) continue;
                this.tailored.add(n2);
                continue;
            }
            this.compare(n2, n4, n5);
        } while (++n2 <= n3);
    }

    private void compare(int n2, int n3, int n4) {
        int n5;
        int n6;
        if (Collation.isPrefixCE32(n3)) {
            n6 = Collation.indexFromCE32(n3);
            n3 = this.data.getFinalCE32(this.data.getCE32FromContexts(n6));
            if (Collation.isPrefixCE32(n4)) {
                n5 = Collation.indexFromCE32(n4);
                n4 = this.baseData.getFinalCE32(this.baseData.getCE32FromContexts(n5));
                this.comparePrefixes(n2, this.data.contexts, n6 + 2, this.baseData.contexts, n5 + 2);
            } else {
                this.addPrefixes(this.data, n2, this.data.contexts, n6 + 2);
            }
        } else if (Collation.isPrefixCE32(n4)) {
            n6 = Collation.indexFromCE32(n4);
            n4 = this.baseData.getFinalCE32(this.baseData.getCE32FromContexts(n6));
            this.addPrefixes(this.baseData, n2, this.baseData.contexts, n6 + 2);
        }
        if (Collation.isContractionCE32(n3)) {
            n6 = Collation.indexFromCE32(n3);
            n3 = (n3 & 0x100) != 0 ? 1 : this.data.getFinalCE32(this.data.getCE32FromContexts(n6));
            if (Collation.isContractionCE32(n4)) {
                n5 = Collation.indexFromCE32(n4);
                n4 = (n4 & 0x100) != 0 ? 1 : this.baseData.getFinalCE32(this.baseData.getCE32FromContexts(n5));
                this.compareContractions(n2, this.data.contexts, n6 + 2, this.baseData.contexts, n5 + 2);
            } else {
                this.addContractions(n2, this.data.contexts, n6 + 2);
            }
        } else if (Collation.isContractionCE32(n4)) {
            n6 = Collation.indexFromCE32(n4);
            n4 = this.baseData.getFinalCE32(this.baseData.getCE32FromContexts(n6));
            this.addContractions(n2, this.baseData.contexts, n6 + 2);
        }
        if (Collation.isSpecialCE32(n3)) {
            n6 = Collation.tagFromCE32(n3);
            assert (n6 != 8);
            assert (n6 != 9);
            assert (n6 != 14);
        } else {
            n6 = -1;
        }
        if (Collation.isSpecialCE32(n4)) {
            n5 = Collation.tagFromCE32(n4);
            assert (n5 != 8);
            assert (n5 != 9);
        } else {
            n5 = -1;
        }
        if (n5 == 14) {
            if (!Collation.isLongPrimaryCE32(n3)) {
                this.add(n2);
                return;
            }
            long l2 = this.baseData.ces[Collation.indexFromCE32(n4)];
            long l3 = Collation.getThreeBytePrimaryForOffsetData(n2, l2);
            if (Collation.primaryFromLongPrimaryCE32(n3) != l3) {
                this.add(n2);
                return;
            }
        }
        if (n6 != n5) {
            this.add(n2);
            return;
        }
        if (n6 == 5) {
            int n7;
            int n8 = Collation.lengthFromCE32(n3);
            if (n8 != (n7 = Collation.lengthFromCE32(n4))) {
                this.add(n2);
                return;
            }
            int n9 = Collation.indexFromCE32(n3);
            int n10 = Collation.indexFromCE32(n4);
            for (int i2 = 0; i2 < n8; ++i2) {
                if (this.data.ce32s[n9 + i2] == this.baseData.ce32s[n10 + i2]) continue;
                this.add(n2);
                break;
            }
        } else if (n6 == 6) {
            int n11;
            int n12 = Collation.lengthFromCE32(n3);
            if (n12 != (n11 = Collation.lengthFromCE32(n4))) {
                this.add(n2);
                return;
            }
            int n13 = Collation.indexFromCE32(n3);
            int n14 = Collation.indexFromCE32(n4);
            for (int i3 = 0; i3 < n12; ++i3) {
                if (this.data.ces[n13 + i3] == this.baseData.ces[n14 + i3]) continue;
                this.add(n2);
                break;
            }
        } else if (n6 == 12) {
            StringBuilder stringBuilder = new StringBuilder();
            int n15 = Normalizer2Impl.Hangul.decompose(n2, stringBuilder);
            if (this.tailored.contains(stringBuilder.charAt(0)) || this.tailored.contains(stringBuilder.charAt(1)) || n15 == 3 && this.tailored.contains(stringBuilder.charAt(2))) {
                this.add(n2);
            }
        } else if (n3 != n4) {
            this.add(n2);
        }
    }

    private void comparePrefixes(int n2, CharSequence charSequence, int n3, CharSequence charSequence2, int n4) {
        CharsTrie.Iterator iterator = new CharsTrie(charSequence, n3).iterator();
        CharsTrie.Iterator iterator2 = new CharsTrie(charSequence2, n4).iterator();
        String string = null;
        String string2 = null;
        String string3 = "\uffff";
        CharsTrie.Entry entry = null;
        CharsTrie.Entry entry2 = null;
        while (true) {
            if (string == null) {
                if (iterator.hasNext()) {
                    entry = iterator.next();
                    string = entry.chars.toString();
                } else {
                    entry = null;
                    string = string3;
                }
            }
            if (string2 == null) {
                if (iterator2.hasNext()) {
                    entry2 = iterator2.next();
                    string2 = entry2.chars.toString();
                } else {
                    entry2 = null;
                    string2 = string3;
                }
            }
            if (Utility.sameObjects(string, string3) && Utility.sameObjects(string2, string3)) break;
            int n5 = string.compareTo(string2);
            if (n5 < 0) {
                assert (entry != null);
                this.addPrefix(this.data, string, n2, entry.value);
                entry = null;
                string = null;
                continue;
            }
            if (n5 > 0) {
                assert (entry2 != null);
                this.addPrefix(this.baseData, string2, n2, entry2.value);
                entry2 = null;
                string2 = null;
                continue;
            }
            this.setPrefix(string);
            assert (entry != null && entry2 != null);
            this.compare(n2, entry.value, entry2.value);
            this.resetPrefix();
            entry2 = null;
            entry = null;
            string2 = null;
            string = null;
        }
    }

    private void compareContractions(int n2, CharSequence charSequence, int n3, CharSequence charSequence2, int n4) {
        CharsTrie.Iterator iterator = new CharsTrie(charSequence, n3).iterator();
        CharsTrie.Iterator iterator2 = new CharsTrie(charSequence2, n4).iterator();
        String string = null;
        String string2 = null;
        String string3 = "\uffff\uffff";
        CharsTrie.Entry entry = null;
        CharsTrie.Entry entry2 = null;
        while (true) {
            if (string == null) {
                if (iterator.hasNext()) {
                    entry = iterator.next();
                    string = entry.chars.toString();
                } else {
                    entry = null;
                    string = string3;
                }
            }
            if (string2 == null) {
                if (iterator2.hasNext()) {
                    entry2 = iterator2.next();
                    string2 = entry2.chars.toString();
                } else {
                    entry2 = null;
                    string2 = string3;
                }
            }
            if (Utility.sameObjects(string, string3) && Utility.sameObjects(string2, string3)) break;
            int n5 = string.compareTo(string2);
            if (n5 < 0) {
                this.addSuffix(n2, string);
                entry = null;
                string = null;
                continue;
            }
            if (n5 > 0) {
                this.addSuffix(n2, string2);
                entry2 = null;
                string2 = null;
                continue;
            }
            this.suffix = string;
            this.compare(n2, entry.value, entry2.value);
            this.suffix = null;
            entry2 = null;
            entry = null;
            string2 = null;
            string = null;
        }
    }

    private void addPrefixes(CollationData collationData, int n2, CharSequence charSequence, int n3) {
        for (CharsTrie.Entry entry : new CharsTrie(charSequence, n3)) {
            this.addPrefix(collationData, entry.chars, n2, entry.value);
        }
    }

    private void addPrefix(CollationData collationData, CharSequence charSequence, int n2, int n3) {
        this.setPrefix(charSequence);
        n3 = collationData.getFinalCE32(n3);
        if (Collation.isContractionCE32(n3)) {
            int n4 = Collation.indexFromCE32(n3);
            this.addContractions(n2, collationData.contexts, n4 + 2);
        }
        this.tailored.add(new StringBuilder(this.unreversedPrefix.appendCodePoint(n2)));
        this.resetPrefix();
    }

    private void addContractions(int n2, CharSequence charSequence, int n3) {
        for (CharsTrie.Entry entry : new CharsTrie(charSequence, n3)) {
            this.addSuffix(n2, entry.chars);
        }
    }

    private void addSuffix(int n2, CharSequence charSequence) {
        this.tailored.add(new StringBuilder(this.unreversedPrefix).appendCodePoint(n2).append(charSequence));
    }

    private void add(int n2) {
        if (this.unreversedPrefix.length() == 0 && this.suffix == null) {
            this.tailored.add(n2);
        } else {
            StringBuilder stringBuilder = new StringBuilder(this.unreversedPrefix);
            stringBuilder.appendCodePoint(n2);
            if (this.suffix != null) {
                stringBuilder.append(this.suffix);
            }
            this.tailored.add(stringBuilder);
        }
    }

    private void setPrefix(CharSequence charSequence) {
        this.unreversedPrefix.setLength(0);
        this.unreversedPrefix.append(charSequence).reverse();
    }

    private void resetPrefix() {
        this.unreversedPrefix.setLength(0);
    }
}

