/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.Collation;

public final class CollationRootElements {
    public static final long PRIMARY_SENTINEL = 0xFFFFFF00L;
    public static final int SEC_TER_DELTA_FLAG = 128;
    public static final int PRIMARY_STEP_MASK = 127;
    public static final int IX_FIRST_TERTIARY_INDEX = 0;
    static final int IX_FIRST_SECONDARY_INDEX = 1;
    static final int IX_FIRST_PRIMARY_INDEX = 2;
    static final int IX_COMMON_SEC_AND_TER_CE = 3;
    static final int IX_SEC_TER_BOUNDARIES = 4;
    static final int IX_COUNT = 5;
    private long[] elements;

    public CollationRootElements(long[] lArray) {
        this.elements = lArray;
    }

    public int getTertiaryBoundary() {
        return (int)this.elements[4] << 8 & 0xFF00;
    }

    long getFirstTertiaryCE() {
        return this.elements[(int)this.elements[0]] & 0xFFFFFFFFFFFFFF7FL;
    }

    long getLastTertiaryCE() {
        return this.elements[(int)this.elements[1] - 1] & 0xFFFFFFFFFFFFFF7FL;
    }

    public int getLastCommonSecondary() {
        return (int)this.elements[4] >> 16 & 0xFF00;
    }

    public int getSecondaryBoundary() {
        return (int)this.elements[4] >> 8 & 0xFF00;
    }

    long getFirstSecondaryCE() {
        return this.elements[(int)this.elements[1]] & 0xFFFFFFFFFFFFFF7FL;
    }

    long getLastSecondaryCE() {
        return this.elements[(int)this.elements[2] - 1] & 0xFFFFFFFFFFFFFF7FL;
    }

    long getFirstPrimary() {
        return this.elements[(int)this.elements[2]];
    }

    long getFirstPrimaryCE() {
        return Collation.makeCE(this.getFirstPrimary());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long lastCEWithPrimaryBefore(long l2) {
        long l3;
        if (l2 == 0L) {
            return 0L;
        }
        assert (l2 > this.elements[(int)this.elements[2]]);
        int n2 = this.findP(l2);
        long l4 = this.elements[n2];
        if (l2 == (l4 & 0xFFFFFF00L)) {
            assert ((l4 & 0x7FL) == 0L);
            l3 = this.elements[n2 - 1];
            if ((l3 & 0x80L) == 0L) {
                l2 = l3 & 0xFFFFFF00L;
                l3 = 0x5000500L;
                return l2 << 32 | l3 & 0xFFFFFFFFFFFFFF7FL;
            }
            n2 -= 2;
            while (true) {
                if (((l2 = this.elements[n2]) & 0x80L) == 0L) {
                    l2 &= 0xFFFFFF00L;
                    return l2 << 32 | l3 & 0xFFFFFFFFFFFFFF7FL;
                }
                --n2;
            }
        }
        l2 = l4 & 0xFFFFFF00L;
        l3 = 0x5000500L;
        while (true) {
            if (((l4 = this.elements[++n2]) & 0x80L) == 0L) {
                assert ((l4 & 0x7FL) == 0L);
                return l2 << 32 | l3 & 0xFFFFFFFFFFFFFF7FL;
            }
            l3 = l4;
        }
    }

    long firstCEWithPrimaryAtLeast(long l2) {
        if (l2 == 0L) {
            return 0L;
        }
        int n2 = this.findP(l2);
        if (l2 != (this.elements[n2] & 0xFFFFFF00L)) {
            while (((l2 = this.elements[++n2]) & 0x80L) != 0L) {
            }
            assert ((l2 & 0x7FL) == 0L);
        }
        return l2 << 32 | 0x5000500L;
    }

    long getPrimaryBefore(long l2, boolean bl2) {
        int n2;
        int n3 = this.findPrimary(l2);
        long l3 = this.elements[n3];
        if (l2 == (l3 & 0xFFFFFF00L)) {
            n2 = (int)l3 & 0x7F;
            if (n2 == 0) {
                while (((l2 = this.elements[--n3]) & 0x80L) != 0L) {
                }
                return l2 & 0xFFFFFF00L;
            }
        } else {
            long l4 = this.elements[n3 + 1];
            assert (CollationRootElements.isEndOfPrimaryRange(l4));
            n2 = (int)l4 & 0x7F;
        }
        if ((l2 & 0xFFFFL) == 0L) {
            return Collation.decTwoBytePrimaryByOneStep(l2, bl2, n2);
        }
        return Collation.decThreeBytePrimaryByOneStep(l2, bl2, n2);
    }

    int getSecondaryBefore(long l2, int n2) {
        int n3;
        int n4;
        int n5;
        if (l2 == 0L) {
            n5 = (int)this.elements[1];
            n4 = 0;
            n3 = (int)(this.elements[n5] >> 16);
        } else {
            n5 = this.findPrimary(l2) + 1;
            n4 = 256;
            n3 = (int)this.getFirstSecTerForPrimary(n5) >>> 16;
        }
        assert (n2 >= n3);
        while (n2 > n3) {
            n4 = n3;
            assert ((this.elements[n5] & 0x80L) != 0L);
            n3 = (int)(this.elements[n5++] >> 16);
        }
        assert (n3 == n2);
        return n4;
    }

    int getTertiaryBefore(long l2, int n2, int n3) {
        long l3;
        int n4;
        int n5;
        assert ((n3 & 0xFFFFC0C0) == 0);
        if (l2 == 0L) {
            if (n2 == 0) {
                n5 = (int)this.elements[0];
                n4 = 0;
            } else {
                n5 = (int)this.elements[1];
                n4 = 256;
            }
            l3 = this.elements[n5] & 0xFFFFFFFFFFFFFF7FL;
        } else {
            n5 = this.findPrimary(l2) + 1;
            n4 = 256;
            l3 = this.getFirstSecTerForPrimary(n5);
        }
        long l4 = (long)n2 << 16 | (long)n3;
        while (l4 > l3) {
            if ((int)(l3 >> 16) == n2) {
                n4 = (int)l3;
            }
            assert ((this.elements[n5] & 0x80L) != 0L);
            l3 = this.elements[n5++] & 0xFFFFFFFFFFFFFF7FL;
        }
        assert (l3 == l4);
        return n4 & 0xFFFF;
    }

    int findPrimary(long l2) {
        assert ((l2 & 0xFFL) == 0L);
        int n2 = this.findP(l2);
        assert (CollationRootElements.isEndOfPrimaryRange(this.elements[n2 + 1]) || l2 == (this.elements[n2] & 0xFFFFFF00L));
        return n2;
    }

    long getPrimaryAfter(long l2, int n2, boolean bl2) {
        int n3;
        long l3;
        assert (l2 == (this.elements[n2] & 0xFFFFFF00L) || CollationRootElements.isEndOfPrimaryRange(this.elements[n2 + 1]));
        if (((l3 = this.elements[++n2]) & 0x80L) == 0L && (n3 = (int)l3 & 0x7F) != 0) {
            if ((l2 & 0xFFFFL) == 0L) {
                return Collation.incTwoBytePrimaryByOffset(l2, bl2, n3);
            }
            return Collation.incThreeBytePrimaryByOffset(l2, bl2, n3);
        }
        while ((l3 & 0x80L) != 0L) {
            l3 = this.elements[++n2];
        }
        assert ((l3 & 0x7FL) == 0L);
        return l3;
    }

    int getSecondaryAfter(int n2, int n3) {
        int n4;
        long l2;
        if (n2 == 0) {
            assert (n3 != 0);
            n2 = (int)this.elements[1];
            l2 = this.elements[n2];
            n4 = 65536;
        } else {
            assert (n2 >= (int)this.elements[2]);
            l2 = this.getFirstSecTerForPrimary(n2 + 1);
            n4 = this.getSecondaryBoundary();
        }
        do {
            int n5;
            if ((n5 = (int)(l2 >> 16)) <= n3) continue;
            return n5;
        } while (((l2 = this.elements[++n2]) & 0x80L) != 0L);
        return n4;
    }

    int getTertiaryAfter(int n2, int n3, int n4) {
        long l2;
        int n5;
        if (n2 == 0) {
            if (n3 == 0) {
                assert (n4 != 0);
                n2 = (int)this.elements[0];
                n5 = 16384;
            } else {
                n2 = (int)this.elements[1];
                n5 = this.getTertiaryBoundary();
            }
            l2 = this.elements[n2] & 0xFFFFFFFFFFFFFF7FL;
        } else {
            assert (n2 >= (int)this.elements[2]);
            l2 = this.getFirstSecTerForPrimary(n2 + 1);
            n5 = this.getTertiaryBoundary();
        }
        long l3 = ((long)n3 & 0xFFFFFFFFL) << 16 | (long)n4;
        while (true) {
            if (l2 > l3) {
                assert (l2 >> 16 == (long)n3);
                return (int)l2 & 0xFFFF;
            }
            if (((l2 = this.elements[++n2]) & 0x80L) == 0L || l2 >> 16 > (long)n3) {
                return n5;
            }
            l2 &= 0xFFFFFFFFFFFFFF7FL;
        }
    }

    private long getFirstSecTerForPrimary(int n2) {
        long l2 = this.elements[n2];
        if ((l2 & 0x80L) == 0L) {
            return 0x5000500L;
        }
        if ((l2 &= 0xFFFFFFFFFFFFFF7FL) > 0x5000500L) {
            return 0x5000500L;
        }
        return l2;
    }

    private int findP(long l2) {
        assert (l2 >> 24 != 254L);
        int n2 = (int)this.elements[2];
        assert (l2 >= this.elements[n2]);
        int n3 = this.elements.length - 1;
        assert (this.elements[n3] >= 0xFFFFFF00L);
        assert (l2 < this.elements[n3]);
        while (n2 + 1 < n3) {
            int n4 = (int)(((long)n2 + (long)n3) / 2L);
            long l3 = this.elements[n4];
            if ((l3 & 0x80L) != 0L) {
                int n5;
                for (n5 = n4 + 1; n5 != n3; ++n5) {
                    l3 = this.elements[n5];
                    if ((l3 & 0x80L) != 0L) continue;
                    n4 = n5;
                    break;
                }
                if ((l3 & 0x80L) != 0L) {
                    for (n5 = n4 - 1; n5 != n2; --n5) {
                        l3 = this.elements[n5];
                        if ((l3 & 0x80L) != 0L) continue;
                        n4 = n5;
                        break;
                    }
                    if ((l3 & 0x80L) != 0L) break;
                }
            }
            if (l2 < (l3 & 0xFFFFFF00L)) {
                n3 = n4;
                continue;
            }
            n2 = n4;
        }
        return n2;
    }

    private static boolean isEndOfPrimaryRange(long l2) {
        return (l2 & 0x80L) == 0L && (l2 & 0x7FL) != 0L;
    }
}

