/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationSettings;

public final class CollationKeys {
    public static final LevelCallback SIMPLE_LEVEL_FALLBACK = new LevelCallback();
    private static final int SEC_COMMON_LOW = 5;
    private static final int SEC_COMMON_MIDDLE = 37;
    static final int SEC_COMMON_HIGH = 69;
    private static final int SEC_COMMON_MAX_COUNT = 33;
    private static final int CASE_LOWER_FIRST_COMMON_LOW = 1;
    private static final int CASE_LOWER_FIRST_COMMON_MIDDLE = 7;
    private static final int CASE_LOWER_FIRST_COMMON_HIGH = 13;
    private static final int CASE_LOWER_FIRST_COMMON_MAX_COUNT = 7;
    private static final int CASE_UPPER_FIRST_COMMON_LOW = 3;
    private static final int CASE_UPPER_FIRST_COMMON_HIGH = 15;
    private static final int CASE_UPPER_FIRST_COMMON_MAX_COUNT = 13;
    private static final int TER_ONLY_COMMON_LOW = 5;
    private static final int TER_ONLY_COMMON_MIDDLE = 101;
    private static final int TER_ONLY_COMMON_HIGH = 197;
    private static final int TER_ONLY_COMMON_MAX_COUNT = 97;
    private static final int TER_LOWER_FIRST_COMMON_LOW = 5;
    private static final int TER_LOWER_FIRST_COMMON_MIDDLE = 37;
    private static final int TER_LOWER_FIRST_COMMON_HIGH = 69;
    private static final int TER_LOWER_FIRST_COMMON_MAX_COUNT = 33;
    private static final int TER_UPPER_FIRST_COMMON_LOW = 133;
    private static final int TER_UPPER_FIRST_COMMON_MIDDLE = 165;
    private static final int TER_UPPER_FIRST_COMMON_HIGH = 197;
    private static final int TER_UPPER_FIRST_COMMON_MAX_COUNT = 33;
    private static final int QUAT_COMMON_LOW = 28;
    private static final int QUAT_COMMON_MIDDLE = 140;
    private static final int QUAT_COMMON_HIGH = 252;
    private static final int QUAT_COMMON_MAX_COUNT = 113;
    private static final int QUAT_SHIFTED_LIMIT_BYTE = 27;
    private static final int[] levelMasks = new int[]{2, 6, 22, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 54};

    private static SortKeyLevel getSortKeyLevel(int n2, int n3) {
        return (n2 & n3) != 0 ? new SortKeyLevel() : null;
    }

    private CollationKeys() {
    }

    public static void writeSortKeyUpToQuaternary(CollationIterator collationIterator, boolean[] blArray, CollationSettings collationSettings, SortKeyByteSink sortKeyByteSink, int n2, LevelCallback levelCallback, boolean bl2) {
        int n3 = collationSettings.options;
        int n4 = levelMasks[CollationSettings.getStrength(n3)];
        if ((n3 & 0x400) != 0) {
            n4 |= 8;
        }
        if ((n4 &= ~((1 << n2) - 1)) == 0) {
            return;
        }
        long l2 = (n3 & 0xC) == 0 ? 0L : collationSettings.variableTop + 1L;
        int n5 = CollationSettings.getTertiaryMask(n3);
        byte[] byArray = new byte[3];
        SortKeyLevel sortKeyLevel = CollationKeys.getSortKeyLevel(n4, 8);
        SortKeyLevel sortKeyLevel2 = CollationKeys.getSortKeyLevel(n4, 4);
        SortKeyLevel sortKeyLevel3 = CollationKeys.getSortKeyLevel(n4, 16);
        SortKeyLevel sortKeyLevel4 = CollationKeys.getSortKeyLevel(n4, 32);
        long l3 = 0L;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (true) {
            int n12;
            int n13;
            int n14;
            collationIterator.clearCEsIfNoneRemaining();
            long l4 = collationIterator.nextCE();
            long l5 = l4 >>> 32;
            if (l5 < l2 && l5 > 0x2000000L) {
                if (n9 != 0) {
                    --n9;
                    while (n9 >= 113) {
                        sortKeyLevel4.appendByte(140);
                        n9 -= 113;
                    }
                    sortKeyLevel4.appendByte(28 + n9);
                    n9 = 0;
                }
                do {
                    if ((n4 & 0x20) != 0) {
                        if (collationSettings.hasReordering()) {
                            l5 = collationSettings.reorder(l5);
                        }
                        if ((int)l5 >>> 24 >= 27) {
                            sortKeyLevel4.appendByte(27);
                        }
                        sortKeyLevel4.appendWeight32(l5);
                    }
                    while ((l5 = (l4 = collationIterator.nextCE()) >>> 32) == 0L) {
                    }
                } while (l5 < l2 && l5 > 0x2000000L);
            }
            if (l5 > 1L && (n4 & 2) != 0) {
                n14 = blArray[(int)l5 >>> 24];
                if (collationSettings.hasReordering()) {
                    l5 = collationSettings.reorder(l5);
                }
                n13 = (int)l5 >>> 24;
                if (n14 == 0 || n13 != (int)l3 >>> 24) {
                    if (l3 != 0L) {
                        if (l5 < l3) {
                            if (n13 > 2) {
                                sortKeyByteSink.Append(3);
                            }
                        } else {
                            sortKeyByteSink.Append(255);
                        }
                    }
                    sortKeyByteSink.Append(n13);
                    l3 = n14 != 0 ? l5 : 0L;
                }
                if ((n12 = (int)((byte)(l5 >>> 16))) != 0) {
                    byArray[0] = n12;
                    byArray[1] = (byte)(l5 >>> 8);
                    byArray[2] = (byte)l5;
                    sortKeyByteSink.Append(byArray, byArray[1] == 0 ? 1 : (byArray[2] == 0 ? 2 : 3));
                }
                if (!bl2 && sortKeyByteSink.Overflowed()) {
                    return;
                }
            }
            if ((n14 = (int)l4) == 0) continue;
            if ((n4 & 4) != 0 && (n13 = n14 >>> 16) != 0) {
                if (n13 == 1280 && ((n3 & 0x800) == 0 || l5 != 0x2000000L)) {
                    ++n7;
                } else if ((n3 & 0x800) == 0) {
                    if (n7 != 0) {
                        --n7;
                        while (n7 >= 33) {
                            sortKeyLevel2.appendByte(37);
                            n7 -= 33;
                        }
                        n12 = n13 < 1280 ? 5 + n7 : 69 - n7;
                        sortKeyLevel2.appendByte(n12);
                        n7 = 0;
                    }
                    sortKeyLevel2.appendWeight16(n13);
                } else {
                    int n15;
                    if (n7 != 0) {
                        n12 = --n7 % 33;
                        n15 = n10 < 1280 ? 5 + n12 : 69 - n12;
                        sortKeyLevel2.appendByte(n15);
                        n7 -= n12;
                        while (n7 > 0) {
                            sortKeyLevel2.appendByte(37);
                            n7 -= 33;
                        }
                    }
                    if (0L < l5 && l5 <= 0x2000000L) {
                        byte[] byArray2 = sortKeyLevel2.data();
                        n15 = sortKeyLevel2.length() - 1;
                        while (n11 < n15) {
                            byte by2 = byArray2[n11];
                            byArray2[n11++] = byArray2[n15];
                            byArray2[n15--] = by2;
                        }
                        sortKeyLevel2.appendByte(l5 == 1L ? 1 : 2);
                        n10 = 0;
                        n11 = sortKeyLevel2.length();
                    } else {
                        sortKeyLevel2.appendReverseWeight16(n13);
                        n10 = n13;
                    }
                }
            }
            if ((n4 & 8) != 0 && !(CollationSettings.getStrength(n3) == 0 ? l5 == 0L : n14 >>> 16 == 0)) {
                n13 = n14 >>> 8 & 0xFF;
                assert ((n13 & 0xC0) != 192);
                if ((n13 & 0xC0) == 0 && n13 > 1) {
                    ++n6;
                } else {
                    if ((n3 & 0x100) == 0) {
                        if (!(n6 == 0 || n13 <= 1 && sortKeyLevel.isEmpty())) {
                            --n6;
                            while (n6 >= 7) {
                                sortKeyLevel.appendByte(112);
                                n6 -= 7;
                            }
                            int n16 = n13 <= 1 ? 1 + n6 : 13 - n6;
                            sortKeyLevel.appendByte(n16 << 4);
                            n6 = 0;
                        }
                        if (n13 > 1) {
                            n13 = 13 + (n13 >>> 6) << 4;
                        }
                    } else {
                        if (n6 != 0) {
                            --n6;
                            while (n6 >= 13) {
                                sortKeyLevel.appendByte(48);
                                n6 -= 13;
                            }
                            sortKeyLevel.appendByte(3 + n6 << 4);
                            n6 = 0;
                        }
                        if (n13 > 1) {
                            n13 = 3 - (n13 >>> 6) << 4;
                        }
                    }
                    sortKeyLevel.appendByte(n13);
                }
            }
            if ((n4 & 0x10) != 0) {
                n13 = n14 & n5;
                assert ((n14 & 0xC000) != 49152);
                if (n13 == 1280) {
                    ++n8;
                } else if ((n5 & 0x8000) == 0) {
                    if (n8 != 0) {
                        --n8;
                        while (n8 >= 97) {
                            sortKeyLevel3.appendByte(101);
                            n8 -= 97;
                        }
                        int n17 = n13 < 1280 ? 5 + n8 : 197 - n8;
                        sortKeyLevel3.appendByte(n17);
                        n8 = 0;
                    }
                    if (n13 > 1280) {
                        n13 += 49152;
                    }
                    sortKeyLevel3.appendWeight16(n13);
                } else if ((n3 & 0x100) == 0) {
                    if (n8 != 0) {
                        --n8;
                        while (n8 >= 33) {
                            sortKeyLevel3.appendByte(37);
                            n8 -= 33;
                        }
                        int n18 = n13 < 1280 ? 5 + n8 : 69 - n8;
                        sortKeyLevel3.appendByte(n18);
                        n8 = 0;
                    }
                    if (n13 > 1280) {
                        n13 += 16384;
                    }
                    sortKeyLevel3.appendWeight16(n13);
                } else {
                    if (n13 > 256) {
                        if (n14 >>> 16 != 0) {
                            if ((n13 ^= 0xC000) < 50432) {
                                n13 -= 16384;
                            }
                        } else {
                            assert (34304 <= n13 && n13 <= 49151);
                            n13 += 16384;
                        }
                    }
                    if (n8 != 0) {
                        --n8;
                        while (n8 >= 33) {
                            sortKeyLevel3.appendByte(165);
                            n8 -= 33;
                        }
                        int n19 = n13 < 34048 ? 133 + n8 : 197 - n8;
                        sortKeyLevel3.appendByte(n19);
                        n8 = 0;
                    }
                    sortKeyLevel3.appendWeight16(n13);
                }
            }
            if ((n4 & 0x20) != 0) {
                n13 = n14 & 0xFFFF;
                if ((n13 & 0xC0) == 0 && n13 > 256) {
                    ++n9;
                } else if (n13 == 256 && (n3 & 0xC) == 0 && sortKeyLevel4.isEmpty()) {
                    sortKeyLevel4.appendByte(1);
                } else {
                    n13 = n13 == 256 ? 1 : 252 + (n13 >>> 6 & 3);
                    if (n9 != 0) {
                        --n9;
                        while (n9 >= 113) {
                            sortKeyLevel4.appendByte(140);
                            n9 -= 113;
                        }
                        int n20 = n13 < 28 ? 28 + n9 : 252 - n9;
                        sortKeyLevel4.appendByte(n20);
                        n9 = 0;
                    }
                    sortKeyLevel4.appendByte(n13);
                }
            }
            if (n14 >>> 24 == 1) break;
        }
        if ((n4 & 4) != 0) {
            if (!levelCallback.needToWrite(2)) {
                return;
            }
            sortKeyByteSink.Append(1);
            sortKeyLevel2.appendTo(sortKeyByteSink);
        }
        if ((n4 & 8) != 0) {
            if (!levelCallback.needToWrite(3)) {
                return;
            }
            sortKeyByteSink.Append(1);
            int n21 = sortKeyLevel.length() - 1;
            int n22 = 0;
            for (int i2 = 0; i2 < n21; ++i2) {
                byte by3 = sortKeyLevel.getAt(i2);
                assert ((by3 & 0xF) == 0 && by3 != 0);
                if (n22 == 0) {
                    n22 = by3;
                    continue;
                }
                sortKeyByteSink.Append(n22 | by3 >> 4 & 0xF);
                n22 = 0;
            }
            if (n22 != 0) {
                sortKeyByteSink.Append(n22);
            }
        }
        if ((n4 & 0x10) != 0) {
            if (!levelCallback.needToWrite(4)) {
                return;
            }
            sortKeyByteSink.Append(1);
            sortKeyLevel3.appendTo(sortKeyByteSink);
        }
        if ((n4 & 0x20) != 0) {
            if (!levelCallback.needToWrite(5)) {
                return;
            }
            sortKeyByteSink.Append(1);
            sortKeyLevel4.appendTo(sortKeyByteSink);
        }
    }

    private static final class SortKeyLevel {
        private static final int INITIAL_CAPACITY = 40;
        byte[] buffer = new byte[40];
        int len = 0;

        SortKeyLevel() {
        }

        boolean isEmpty() {
            return this.len == 0;
        }

        int length() {
            return this.len;
        }

        byte getAt(int n2) {
            return this.buffer[n2];
        }

        byte[] data() {
            return this.buffer;
        }

        void appendByte(int n2) {
            if (this.len < this.buffer.length || this.ensureCapacity(1)) {
                this.buffer[this.len++] = (byte)n2;
            }
        }

        void appendWeight16(int n2) {
            int n3;
            assert ((n2 & 0xFFFF) != 0);
            byte by2 = (byte)(n2 >>> 8);
            byte by3 = (byte)n2;
            int n4 = n3 = by3 == 0 ? 1 : 2;
            if (this.len + n3 <= this.buffer.length || this.ensureCapacity(n3)) {
                this.buffer[this.len++] = by2;
                if (by3 != 0) {
                    this.buffer[this.len++] = by3;
                }
            }
        }

        void appendWeight32(long l2) {
            int n2;
            assert (l2 != 0L);
            byte[] byArray = new byte[]{(byte)(l2 >>> 24), (byte)(l2 >>> 16), (byte)(l2 >>> 8), (byte)l2};
            int n3 = byArray[1] == 0 ? 1 : (byArray[2] == 0 ? 2 : (n2 = byArray[3] == 0 ? 3 : 4));
            if (this.len + n2 <= this.buffer.length || this.ensureCapacity(n2)) {
                this.buffer[this.len++] = byArray[0];
                if (byArray[1] != 0) {
                    this.buffer[this.len++] = byArray[1];
                    if (byArray[2] != 0) {
                        this.buffer[this.len++] = byArray[2];
                        if (byArray[3] != 0) {
                            this.buffer[this.len++] = byArray[3];
                        }
                    }
                }
            }
        }

        void appendReverseWeight16(int n2) {
            int n3;
            assert ((n2 & 0xFFFF) != 0);
            byte by2 = (byte)(n2 >>> 8);
            byte by3 = (byte)n2;
            int n4 = n3 = by3 == 0 ? 1 : 2;
            if (this.len + n3 <= this.buffer.length || this.ensureCapacity(n3)) {
                if (by3 == 0) {
                    this.buffer[this.len++] = by2;
                } else {
                    this.buffer[this.len] = by3;
                    this.buffer[this.len + 1] = by2;
                    this.len += 2;
                }
            }
        }

        void appendTo(SortKeyByteSink sortKeyByteSink) {
            assert (this.len > 0 && this.buffer[this.len - 1] == 1);
            sortKeyByteSink.Append(this.buffer, this.len - 1);
        }

        private boolean ensureCapacity(int n2) {
            int n3 = 2 * this.buffer.length;
            int n4 = this.len + 2 * n2;
            if (n3 < n4) {
                n3 = n4;
            }
            if (n3 < 200) {
                n3 = 200;
            }
            byte[] byArray = new byte[n3];
            System.arraycopy(this.buffer, 0, byArray, 0, this.len);
            this.buffer = byArray;
            return true;
        }
    }

    public static class LevelCallback {
        boolean needToWrite(int n2) {
            return true;
        }
    }

    public static abstract class SortKeyByteSink {
        protected byte[] buffer_;
        private int appended_ = 0;

        public SortKeyByteSink(byte[] byArray) {
            this.buffer_ = byArray;
        }

        public void setBufferAndAppended(byte[] byArray, int n2) {
            this.buffer_ = byArray;
            this.appended_ = n2;
        }

        public void Append(byte[] byArray, int n2) {
            if (n2 <= 0 || byArray == null) {
                return;
            }
            int n3 = this.appended_;
            this.appended_ += n2;
            int n4 = this.buffer_.length - n3;
            if (n2 <= n4) {
                System.arraycopy(byArray, 0, this.buffer_, n3, n2);
            } else {
                this.AppendBeyondCapacity(byArray, 0, n2, n3);
            }
        }

        public void Append(int n2) {
            if (this.appended_ < this.buffer_.length || this.Resize(1, this.appended_)) {
                this.buffer_[this.appended_] = (byte)n2;
            }
            ++this.appended_;
        }

        public int NumberOfBytesAppended() {
            return this.appended_;
        }

        public int GetRemainingCapacity() {
            return this.buffer_.length - this.appended_;
        }

        public boolean Overflowed() {
            return this.appended_ > this.buffer_.length;
        }

        protected abstract void AppendBeyondCapacity(byte[] var1, int var2, int var3, int var4);

        protected abstract boolean Resize(int var1, int var2);
    }
}

