/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationSettings;

public final class CollationFastLatin {
    public static final int VERSION = 2;
    public static final int LATIN_MAX = 383;
    public static final int LATIN_LIMIT = 384;
    static final int LATIN_MAX_UTF8_LEAD = 197;
    static final int PUNCT_START = 8192;
    static final int PUNCT_LIMIT = 8256;
    static final int NUM_FAST_CHARS = 448;
    static final int SHORT_PRIMARY_MASK = 64512;
    static final int INDEX_MASK = 1023;
    static final int SECONDARY_MASK = 992;
    static final int CASE_MASK = 24;
    static final int LONG_PRIMARY_MASK = 65528;
    static final int TERTIARY_MASK = 7;
    static final int CASE_AND_TERTIARY_MASK = 31;
    static final int TWO_SHORT_PRIMARIES_MASK = -67044352;
    static final int TWO_LONG_PRIMARIES_MASK = -458760;
    static final int TWO_SECONDARIES_MASK = 0x3E003E0;
    static final int TWO_CASES_MASK = 0x180018;
    static final int TWO_TERTIARIES_MASK = 458759;
    static final int CONTRACTION = 1024;
    static final int EXPANSION = 2048;
    static final int MIN_LONG = 3072;
    static final int LONG_INC = 8;
    static final int MAX_LONG = 4088;
    static final int MIN_SHORT = 4096;
    static final int SHORT_INC = 1024;
    static final int MAX_SHORT = 64512;
    static final int MIN_SEC_BEFORE = 0;
    static final int SEC_INC = 32;
    static final int MAX_SEC_BEFORE = 128;
    static final int COMMON_SEC = 160;
    static final int MIN_SEC_AFTER = 192;
    static final int MAX_SEC_AFTER = 352;
    static final int MIN_SEC_HIGH = 384;
    static final int MAX_SEC_HIGH = 992;
    static final int SEC_OFFSET = 32;
    static final int COMMON_SEC_PLUS_OFFSET = 192;
    static final int TWO_SEC_OFFSETS = 0x200020;
    static final int TWO_COMMON_SEC_PLUS_OFFSET = 0xC000C0;
    static final int LOWER_CASE = 8;
    static final int TWO_LOWER_CASES = 524296;
    static final int COMMON_TER = 0;
    static final int MAX_TER_AFTER = 7;
    static final int TER_OFFSET = 32;
    static final int COMMON_TER_PLUS_OFFSET = 32;
    static final int TWO_TER_OFFSETS = 0x200020;
    static final int TWO_COMMON_TER_PLUS_OFFSET = 0x200020;
    static final int MERGE_WEIGHT = 3;
    static final int EOS = 2;
    static final int BAIL_OUT = 1;
    static final int CONTR_CHAR_MASK = 511;
    static final int CONTR_LENGTH_SHIFT = 9;
    public static final int BAIL_OUT_RESULT = -2;

    static int getCharIndex(char c2) {
        if (c2 <= '\u017f') {
            return c2;
        }
        if ('\u2000' <= c2 && c2 < '\u2040') {
            return c2 - 7808;
        }
        return -1;
    }

    public static int getOptions(CollationData collationData, CollationSettings collationSettings, char[] cArray) {
        int n2;
        int n3;
        int n4;
        char[] cArray2 = collationData.fastLatinTableHeader;
        if (cArray2 == null) {
            return -1;
        }
        assert (cArray2[0] >> 8 == 2);
        if (cArray.length != 384) {
            assert (false);
            return -1;
        }
        if ((collationSettings.options & 0xC) == 0) {
            n4 = 3071;
        } else {
            n3 = cArray2[0] & 0xFF;
            int n5 = 1 + collationSettings.getMaxVariable();
            if (n5 >= n3) {
                return -1;
            }
            n4 = cArray2[n5];
        }
        n3 = 0;
        if (collationSettings.hasReordering()) {
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = 0L;
            for (int i2 = 4096; i2 < 4104; ++i2) {
                long l6 = collationData.getFirstPrimaryForGroup(i2);
                l6 = collationSettings.reorder(l6);
                if (i2 == 4100) {
                    l3 = l2;
                    l4 = l6;
                    continue;
                }
                if (l6 == 0L) continue;
                if (l6 < l2) {
                    return -1;
                }
                if (l4 != 0L && l5 == 0L && l2 == l3) {
                    l5 = l6;
                }
                l2 = l6;
            }
            long l7 = collationData.getFirstPrimaryForGroup(25);
            if ((l7 = collationSettings.reorder(l7)) < l2) {
                return -1;
            }
            if (l5 == 0L) {
                l5 = l7;
            }
            if (l3 >= l4 || l4 >= l5) {
                n3 = 1;
            }
        }
        char[] cArray3 = collationData.fastLatinTable;
        for (n2 = 0; n2 < 384; ++n2) {
            int n6 = cArray3[n2];
            n6 = n6 >= 4096 ? (n6 &= 0xFC00) : (n6 > n4 ? (n6 &= 0xFFF8) : 0);
            cArray[n2] = (char)n6;
        }
        if (n3 != 0 || (collationSettings.options & 2) != 0) {
            for (n2 = 48; n2 <= 57; ++n2) {
                cArray[n2] = '\u0000';
            }
        }
        return n4 << 16 | collationSettings.options;
    }

    public static int compareUTF16(char[] cArray, char[] cArray2, int n2, CharSequence charSequence, CharSequence charSequence2, int n3) {
        int n4;
        int n5 = n2 >> 16;
        n2 &= 0xFFFF;
        int n6 = n3;
        int n7 = n3;
        int n8 = 0;
        int n9 = 0;
        while (true) {
            block80: {
                block83: {
                    block82: {
                        block81: {
                            if (n8 != 0) break block80;
                            if (n6 != charSequence.length()) break block81;
                            n8 = 2;
                            break block80;
                        }
                        if ((n4 = charSequence.charAt(n6++)) > 383) break block82;
                        n8 = cArray2[n4];
                        if (n8 != 0) break block80;
                        if (n4 <= 57 && n4 >= 48 && (n2 & 2) != 0) {
                            return -2;
                        }
                        n8 = cArray[n4];
                        break block83;
                    }
                    n8 = 8192 <= n4 && n4 < 8256 ? cArray[n4 - 8192 + 384] : CollationFastLatin.lookup(cArray, n4);
                }
                if (n8 >= 4096) {
                    n8 &= 0xFC00;
                } else if (n8 > n5) {
                    n8 &= 0xFFF8;
                } else {
                    long l2 = CollationFastLatin.nextPair(cArray, n4, n8, charSequence, n6);
                    if (l2 < 0L) {
                        ++n6;
                        l2 ^= 0xFFFFFFFFFFFFFFFFL;
                    }
                    if ((n8 = (int)l2) == 1) {
                        return -2;
                    }
                    n8 = CollationFastLatin.getPrimaries(n5, n8);
                    continue;
                }
            }
            while (n9 == 0) {
                if (n7 == charSequence2.length()) {
                    n9 = 2;
                    break;
                }
                if ((n4 = (int)charSequence2.charAt(n7++)) <= 383) {
                    n9 = cArray2[n4];
                    if (n9 != 0) break;
                    if (n4 <= 57 && n4 >= 48 && (n2 & 2) != 0) {
                        return -2;
                    }
                    n9 = cArray[n4];
                } else {
                    n9 = 8192 <= n4 && n4 < 8256 ? cArray[n4 - 8192 + 384] : CollationFastLatin.lookup(cArray, n4);
                }
                if (n9 >= 4096) {
                    n9 &= 0xFC00;
                    break;
                }
                if (n9 > n5) {
                    n9 &= 0xFFF8;
                    break;
                }
                long l3 = CollationFastLatin.nextPair(cArray, n4, n9, charSequence2, n7);
                if (l3 < 0L) {
                    ++n7;
                    l3 ^= 0xFFFFFFFFFFFFFFFFL;
                }
                if ((n9 = (int)l3) == 1) {
                    return -2;
                }
                n9 = CollationFastLatin.getPrimaries(n5, n9);
            }
            if (n8 == n9) {
                if (n8 == 2) break;
                n9 = 0;
                n8 = 0;
                continue;
            }
            n4 = n8 & 0xFFFF;
            int n10 = n9 & 0xFFFF;
            if (n4 != n10) {
                return n4 < n10 ? -1 : 1;
            }
            if (n8 == 2) break;
            n8 >>>= 16;
            n9 >>>= 16;
        }
        if (CollationSettings.getStrength(n2) >= 1) {
            n6 = n7 = n3;
            n9 = 0;
            n8 = 0;
            while (true) {
                if (n8 == 0) {
                    if (n6 == charSequence.length()) {
                        n8 = 2;
                    } else if ((n8 = (n4 = (int)charSequence.charAt(n6++)) <= 383 ? cArray[n4] : (8192 <= n4 && n4 < 8256 ? cArray[n4 - 8192 + 384] : CollationFastLatin.lookup(cArray, n4))) >= 4096) {
                        n8 = CollationFastLatin.getSecondariesFromOneShortCE(n8);
                    } else if (n8 > n5) {
                        n8 = 192;
                    } else {
                        long l4 = CollationFastLatin.nextPair(cArray, n4, n8, charSequence, n6);
                        if (l4 < 0L) {
                            ++n6;
                            l4 ^= 0xFFFFFFFFFFFFFFFFL;
                        }
                        n8 = CollationFastLatin.getSecondaries(n5, (int)l4);
                        continue;
                    }
                }
                while (n9 == 0) {
                    if (n7 == charSequence2.length()) {
                        n9 = 2;
                        break;
                    }
                    if ((n9 = (n4 = (int)charSequence2.charAt(n7++)) <= 383 ? cArray[n4] : (8192 <= n4 && n4 < 8256 ? cArray[n4 - 8192 + 384] : CollationFastLatin.lookup(cArray, n4))) >= 4096) {
                        n9 = CollationFastLatin.getSecondariesFromOneShortCE(n9);
                        break;
                    }
                    if (n9 > n5) {
                        n9 = 192;
                        break;
                    }
                    long l5 = CollationFastLatin.nextPair(cArray, n4, n9, charSequence2, n7);
                    if (l5 < 0L) {
                        ++n7;
                        l5 ^= 0xFFFFFFFFFFFFFFFFL;
                    }
                    n9 = CollationFastLatin.getSecondaries(n5, (int)l5);
                }
                if (n8 == n9) {
                    if (n8 == 2) break;
                    n9 = 0;
                    n8 = 0;
                    continue;
                }
                n4 = n8 & 0xFFFF;
                int n11 = n9 & 0xFFFF;
                if (n4 != n11) {
                    if ((n2 & 0x800) != 0) {
                        return -2;
                    }
                    return n4 < n11 ? -1 : 1;
                }
                if (n8 == 2) break;
                n8 >>>= 16;
                n9 >>>= 16;
            }
        }
        if ((n2 & 0x400) != 0) {
            n4 = CollationSettings.getStrength(n2) == 0 ? 1 : 0;
            n6 = n7 = n3;
            n9 = 0;
            n8 = 0;
            while (true) {
                int n12;
                if (n8 == 0) {
                    if (n6 == charSequence.length()) {
                        n8 = 2;
                    } else {
                        int n13 = n8 = (n12 = charSequence.charAt(n6++)) <= 383 ? cArray[n12] : CollationFastLatin.lookup(cArray, n12);
                        if (n8 < 3072) {
                            long l6 = CollationFastLatin.nextPair(cArray, n12, n8, charSequence, n6);
                            if (l6 < 0L) {
                                ++n6;
                                l6 ^= 0xFFFFFFFFFFFFFFFFL;
                            }
                            n8 = (int)l6;
                        }
                        n8 = CollationFastLatin.getCases(n5, n4 != 0, n8);
                        continue;
                    }
                }
                while (n9 == 0) {
                    if (n7 == charSequence2.length()) {
                        n9 = 2;
                        break;
                    }
                    int n14 = n9 = (n12 = (int)charSequence2.charAt(n7++)) <= 383 ? cArray[n12] : CollationFastLatin.lookup(cArray, n12);
                    if (n9 < 3072) {
                        long l7 = CollationFastLatin.nextPair(cArray, n12, n9, charSequence2, n7);
                        if (l7 < 0L) {
                            ++n7;
                            l7 ^= 0xFFFFFFFFFFFFFFFFL;
                        }
                        n9 = (int)l7;
                    }
                    n9 = CollationFastLatin.getCases(n5, n4 != 0, n9);
                }
                if (n8 == n9) {
                    if (n8 == 2) break;
                    n9 = 0;
                    n8 = 0;
                    continue;
                }
                n12 = n8 & 0xFFFF;
                int n15 = n9 & 0xFFFF;
                if (n12 != n15) {
                    if ((n2 & 0x100) == 0) {
                        return n12 < n15 ? -1 : 1;
                    }
                    return n12 < n15 ? 1 : -1;
                }
                if (n8 == 2) break;
                n8 >>>= 16;
                n9 >>>= 16;
            }
        }
        if (CollationSettings.getStrength(n2) <= 1) {
            return 0;
        }
        n4 = CollationSettings.isTertiaryWithCaseBits(n2) ? 1 : 0;
        n6 = n7 = n3;
        n9 = 0;
        n8 = 0;
        while (true) {
            int n16;
            if (n8 == 0) {
                if (n6 == charSequence.length()) {
                    n8 = 2;
                } else {
                    int n17 = n8 = (n16 = charSequence.charAt(n6++)) <= 383 ? cArray[n16] : CollationFastLatin.lookup(cArray, n16);
                    if (n8 < 3072) {
                        long l8 = CollationFastLatin.nextPair(cArray, n16, n8, charSequence, n6);
                        if (l8 < 0L) {
                            ++n6;
                            l8 ^= 0xFFFFFFFFFFFFFFFFL;
                        }
                        n8 = (int)l8;
                    }
                    n8 = CollationFastLatin.getTertiaries(n5, n4 != 0, n8);
                    continue;
                }
            }
            while (n9 == 0) {
                if (n7 == charSequence2.length()) {
                    n9 = 2;
                    break;
                }
                int n18 = n9 = (n16 = (int)charSequence2.charAt(n7++)) <= 383 ? cArray[n16] : CollationFastLatin.lookup(cArray, n16);
                if (n9 < 3072) {
                    long l9 = CollationFastLatin.nextPair(cArray, n16, n9, charSequence2, n7);
                    if (l9 < 0L) {
                        ++n7;
                        l9 ^= 0xFFFFFFFFFFFFFFFFL;
                    }
                    n9 = (int)l9;
                }
                n9 = CollationFastLatin.getTertiaries(n5, n4 != 0, n9);
            }
            if (n8 == n9) {
                if (n8 == 2) break;
                n9 = 0;
                n8 = 0;
                continue;
            }
            n16 = n8 & 0xFFFF;
            int n19 = n9 & 0xFFFF;
            if (n16 != n19) {
                if (CollationSettings.sortsTertiaryUpperCaseFirst(n2)) {
                    if (n16 > 3) {
                        n16 ^= 0x18;
                    }
                    if (n19 > 3) {
                        n19 ^= 0x18;
                    }
                }
                return n16 < n19 ? -1 : 1;
            }
            if (n8 == 2) break;
            n8 >>>= 16;
            n9 >>>= 16;
        }
        if (CollationSettings.getStrength(n2) <= 2) {
            return 0;
        }
        n6 = n7 = n3;
        n9 = 0;
        n8 = 0;
        while (true) {
            int n20;
            if (n8 == 0) {
                if (n6 == charSequence.length()) {
                    n8 = 2;
                } else {
                    int n21 = n8 = (n20 = charSequence.charAt(n6++)) <= 383 ? cArray[n20] : CollationFastLatin.lookup(cArray, n20);
                    if (n8 < 3072) {
                        long l10 = CollationFastLatin.nextPair(cArray, n20, n8, charSequence, n6);
                        if (l10 < 0L) {
                            ++n6;
                            l10 ^= 0xFFFFFFFFFFFFFFFFL;
                        }
                        n8 = (int)l10;
                    }
                    n8 = CollationFastLatin.getQuaternaries(n5, n8);
                    continue;
                }
            }
            while (n9 == 0) {
                if (n7 == charSequence2.length()) {
                    n9 = 2;
                    break;
                }
                int n22 = n9 = (n20 = (int)charSequence2.charAt(n7++)) <= 383 ? cArray[n20] : CollationFastLatin.lookup(cArray, n20);
                if (n9 < 3072) {
                    long l11 = CollationFastLatin.nextPair(cArray, n20, n9, charSequence2, n7);
                    if (l11 < 0L) {
                        ++n7;
                        l11 ^= 0xFFFFFFFFFFFFFFFFL;
                    }
                    n9 = (int)l11;
                }
                n9 = CollationFastLatin.getQuaternaries(n5, n9);
            }
            if (n8 == n9) {
                if (n8 == 2) break;
                n9 = 0;
                n8 = 0;
                continue;
            }
            n20 = n8 & 0xFFFF;
            int n23 = n9 & 0xFFFF;
            if (n20 != n23) {
                return n20 < n23 ? -1 : 1;
            }
            if (n8 == 2) break;
            n8 >>>= 16;
            n9 >>>= 16;
        }
        return 0;
    }

    private static int lookup(char[] cArray, int n2) {
        assert (n2 > 383);
        if (8192 <= n2 && n2 < 8256) {
            return cArray[n2 - 8192 + 384];
        }
        if (n2 == 65534) {
            return 3;
        }
        if (n2 == 65535) {
            return 64680;
        }
        return 1;
    }

    private static long nextPair(char[] cArray, int n2, int n3, CharSequence charSequence, int n4) {
        int n5;
        if (n3 >= 3072 || n3 < 1024) {
            return n3;
        }
        if (n3 >= 2048) {
            int n6 = 448 + (n3 & 0x3FF);
            return (long)cArray[n6 + 1] << 16 | (long)cArray[n6];
        }
        int n7 = 448 + (n3 & 0x3FF);
        boolean bl2 = false;
        if (n4 != charSequence.length()) {
            int n8;
            int n9 = n4;
            if ((n5 = (int)charSequence.charAt(n9++)) > 383) {
                if (8192 <= n5 && n5 < 8256) {
                    n5 = n5 - 8192 + 384;
                } else if (n5 == 65534 || n5 == 65535) {
                    n5 = -1;
                } else {
                    return 1L;
                }
            }
            int n10 = n7;
            char c2 = cArray[n10];
            while ((n8 = (c2 = cArray[n10 += c2 >> 9]) & 0x1FF) < n5) {
            }
            if (n8 == n5) {
                n7 = n10;
                bl2 = true;
            }
        }
        if ((n5 = cArray[n7] >> 9) == 1) {
            return 1L;
        }
        n3 = cArray[n7 + 1];
        long l2 = n5 == 2 ? (long)n3 : (long)cArray[n7 + 2] << 16 | (long)n3;
        return bl2 ? l2 ^ 0xFFFFFFFFFFFFFFFFL : l2;
    }

    private static int getPrimaries(int n2, int n3) {
        int n4 = n3 & 0xFFFF;
        if (n4 >= 4096) {
            return n3 & 0xFC00FC00;
        }
        if (n4 > n2) {
            return n3 & 0xFFF8FFF8;
        }
        if (n4 >= 3072) {
            return 0;
        }
        return n3;
    }

    private static int getSecondariesFromOneShortCE(int n2) {
        if ((n2 &= 0x3E0) < 384) {
            return n2 + 32;
        }
        return n2 + 32 << 16 | 0xC0;
    }

    private static int getSecondaries(int n2, int n3) {
        if (n3 <= 65535) {
            if (n3 >= 4096) {
                n3 = CollationFastLatin.getSecondariesFromOneShortCE(n3);
            } else if (n3 > n2) {
                n3 = 192;
            } else if (n3 >= 3072) {
                n3 = 0;
            }
        } else {
            int n4 = n3 & 0xFFFF;
            if (n4 >= 4096) {
                n3 = (n3 & 0x3E003E0) + 0x200020;
            } else if (n4 > n2) {
                n3 = 0xC000C0;
            } else {
                assert (n4 >= 3072);
                n3 = 0;
            }
        }
        return n3;
    }

    private static int getCases(int n2, boolean bl2, int n3) {
        if (n3 <= 65535) {
            if (n3 >= 4096) {
                int n4 = n3;
                n3 &= 0x18;
                if (!bl2 && (n4 & 0x3E0) >= 384) {
                    n3 |= 0x80000;
                }
            } else if (n3 > n2) {
                n3 = 8;
            } else if (n3 >= 3072) {
                n3 = 0;
            }
        } else {
            int n5 = n3 & 0xFFFF;
            if (n5 >= 4096) {
                n3 = bl2 && (n3 & 0xFC000000) == 0 ? (n3 &= 0x18) : (n3 &= 0x180018);
            } else if (n5 > n2) {
                n3 = 524296;
            } else {
                assert (n5 >= 3072);
                n3 = 0;
            }
        }
        return n3;
    }

    private static int getTertiaries(int n2, boolean bl2, int n3) {
        if (n3 <= 65535) {
            if (n3 >= 4096) {
                int n4 = n3;
                if (bl2) {
                    n3 = (n3 & 0x1F) + 32;
                    if ((n4 & 0x3E0) >= 384) {
                        n3 |= 0x280000;
                    }
                } else {
                    n3 = (n3 & 7) + 32;
                    if ((n4 & 0x3E0) >= 384) {
                        n3 |= 0x200000;
                    }
                }
            } else if (n3 > n2) {
                n3 = (n3 & 7) + 32;
                if (bl2) {
                    n3 |= 8;
                }
            } else if (n3 >= 3072) {
                n3 = 0;
            }
        } else {
            int n5 = n3 & 0xFFFF;
            if (n5 >= 4096) {
                n3 = bl2 ? (n3 &= 0x1F001F) : (n3 &= 0x70007);
                n3 += 0x200020;
            } else if (n5 > n2) {
                n3 = (n3 & 0x70007) + 0x200020;
                if (bl2) {
                    n3 |= 0x80008;
                }
            } else {
                assert (n5 >= 3072);
                n3 = 0;
            }
        }
        return n3;
    }

    private static int getQuaternaries(int n2, int n3) {
        if (n3 <= 65535) {
            if (n3 >= 4096) {
                n3 = (n3 & 0x3E0) >= 384 ? -67044352 : 64512;
            } else if (n3 > n2) {
                n3 = 64512;
            } else if (n3 >= 3072) {
                n3 &= 0xFFF8;
            }
        } else {
            int n4 = n3 & 0xFFFF;
            if (n4 > n2) {
                n3 = -67044352;
            } else {
                assert (n4 >= 3072);
                n3 &= 0xFFF8FFF8;
            }
        }
        return n3;
    }

    private CollationFastLatin() {
    }
}

