/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import java.text.ParseException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Norm2AllModes;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Normalizer2Impl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.Collation;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationDataBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationFastLatin;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationLoader;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationRootElements;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationRuleParser;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationSettings;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationTailoring;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationWeights;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.UTF16CollationIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.UVector32;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.UVector64;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CanonicalIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer2;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSetIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUInputTooLongException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public final class CollationBuilder
extends CollationRuleParser.Sink {
    private static final boolean DEBUG = false;
    private static int kClosureLoopLimit = 6560;
    private static final UnicodeSet COMPOSITES = new UnicodeSet("[:NFD_QC=N:]");
    private static final int MAX_INDEX = 1048575;
    private static final int HAS_BEFORE2 = 64;
    private static final int HAS_BEFORE3 = 32;
    private static final int IS_TAILORED = 8;
    private Normalizer2 nfd;
    private Normalizer2 fcd;
    private Normalizer2Impl nfcImpl;
    private CollationTailoring base;
    private CollationData baseData;
    private CollationRootElements rootElements;
    private long variableTop;
    private CollationDataBuilder dataBuilder;
    private boolean fastLatinEnabled;
    private UnicodeSet optimizeSet = new UnicodeSet();
    private long[] ces = new long[31];
    private int cesLength;
    private UVector32 rootPrimaryIndexes;
    private UVector64 nodes;

    public CollationBuilder(CollationTailoring collationTailoring) {
        this.nfd = Normalizer2.getNFDInstance();
        this.fcd = Norm2AllModes.getFCDNormalizer2();
        this.nfcImpl = Norm2AllModes.getNFCInstance().impl;
        this.base = collationTailoring;
        this.baseData = collationTailoring.data;
        this.rootElements = new CollationRootElements(collationTailoring.data.rootElements);
        this.variableTop = 0L;
        this.dataBuilder = new CollationDataBuilder();
        this.fastLatinEnabled = true;
        this.cesLength = 0;
        this.rootPrimaryIndexes = new UVector32();
        this.nodes = new UVector64();
        this.nfcImpl.ensureCanonIterData();
        this.dataBuilder.initForTailoring(this.baseData);
    }

    public CollationTailoring parseAndBuild(String string) throws ParseException {
        if (this.baseData.rootElements == null) {
            throw new UnsupportedOperationException("missing root elements data, tailoring not supported");
        }
        CollationTailoring collationTailoring = new CollationTailoring(this.base.settings);
        CollationRuleParser collationRuleParser = new CollationRuleParser(this.baseData);
        this.variableTop = this.base.settings.readOnly().variableTop;
        collationRuleParser.setSink(this);
        collationRuleParser.setImporter(new BundleImporter());
        CollationSettings collationSettings = collationTailoring.settings.copyOnWrite();
        collationRuleParser.parse(string, collationSettings);
        if (this.dataBuilder.hasMappings()) {
            this.makeTailoredCEs();
            this.closeOverComposites();
            this.finalizeCEs();
            this.optimizeSet.add(0, 127);
            this.optimizeSet.add(192, 255);
            this.optimizeSet.remove(44032, 55203);
            this.dataBuilder.optimize(this.optimizeSet);
            collationTailoring.ensureOwnedData();
            if (this.fastLatinEnabled) {
                this.dataBuilder.enableFastLatin();
            }
            this.dataBuilder.build(collationTailoring.ownedData);
            this.dataBuilder = null;
        } else {
            collationTailoring.data = this.baseData;
        }
        collationSettings.fastLatinOptions = CollationFastLatin.getOptions(collationTailoring.data, collationSettings, collationSettings.fastLatinPrimaries);
        collationTailoring.setRules(string);
        collationTailoring.setVersion(this.base.version, 0);
        return collationTailoring;
    }

    @Override
    void addReset(int n2, CharSequence charSequence) {
        assert (charSequence.length() != 0);
        if (charSequence.charAt(0) == '\ufffe') {
            this.ces[0] = this.getSpecialResetPosition(charSequence);
            this.cesLength = 1;
            assert ((this.ces[0] & 0xC0C0L) == 0L);
        } else {
            String string = this.nfd.normalize(charSequence);
            this.cesLength = this.dataBuilder.getCEs(string, this.ces, 0);
            if (this.cesLength > 31) {
                throw new IllegalArgumentException("reset position maps to too many collation elements (more than 31)");
            }
        }
        if (n2 == 15) {
            return;
        }
        assert (0 <= n2 && n2 <= 2);
        int n3 = this.findOrInsertNodeForCEs(n2);
        long l2 = this.nodes.elementAti(n3);
        while (CollationBuilder.strengthFromNode(l2) > n2) {
            n3 = CollationBuilder.previousIndexFromNode(l2);
            l2 = this.nodes.elementAti(n3);
        }
        if (CollationBuilder.strengthFromNode(l2) == n2 && CollationBuilder.isTailoredNode(l2)) {
            n3 = CollationBuilder.previousIndexFromNode(l2);
        } else if (n2 == 0) {
            int n4;
            long l3 = CollationBuilder.weight32FromNode(l2);
            if (l3 == 0L) {
                throw new UnsupportedOperationException("reset primary-before ignorable not possible");
            }
            if (l3 <= this.rootElements.getFirstPrimary()) {
                throw new UnsupportedOperationException("reset primary-before first non-ignorable not supported");
            }
            if (l3 == 0xFF020200L) {
                throw new UnsupportedOperationException("reset primary-before [first trailing] not supported");
            }
            l3 = this.rootElements.getPrimaryBefore(l3, this.baseData.isCompressiblePrimary(l3));
            n3 = this.findOrInsertNodeForPrimary(l3);
            while ((n4 = CollationBuilder.nextIndexFromNode(l2 = this.nodes.elementAti(n3))) != 0) {
                n3 = n4;
            }
        } else {
            n3 = this.findCommonNode(n3, 1);
            if (n2 >= 2) {
                n3 = this.findCommonNode(n3, 2);
            }
            if (CollationBuilder.strengthFromNode(l2 = this.nodes.elementAti(n3)) == n2) {
                int n5;
                int n6;
                int n7 = CollationBuilder.weight16FromNode(l2);
                if (n7 == 0) {
                    throw new UnsupportedOperationException(n2 == 1 ? "reset secondary-before secondary ignorable not possible" : "reset tertiary-before completely ignorable not possible");
                }
                assert (n7 > 256);
                n7 = this.getWeight16Before(n3, l2, n2);
                int n8 = n6 = CollationBuilder.previousIndexFromNode(l2);
                while (true) {
                    int n9;
                    if ((n9 = CollationBuilder.strengthFromNode(l2 = this.nodes.elementAti(n8))) < n2) {
                        assert (n7 >= 1280 || n8 == n6);
                        n5 = 1280;
                        break;
                    }
                    if (n9 == n2 && !CollationBuilder.isTailoredNode(l2)) {
                        n5 = CollationBuilder.weight16FromNode(l2);
                        break;
                    }
                    n8 = CollationBuilder.previousIndexFromNode(l2);
                }
                if (n5 == n7) {
                    n3 = n6;
                } else {
                    l2 = CollationBuilder.nodeFromWeight16(n7) | CollationBuilder.nodeFromStrength(n2);
                    n3 = this.insertNodeBetween(n6, n3, l2);
                }
            } else {
                int n10 = this.getWeight16Before(n3, l2, n2);
                n3 = this.findOrInsertWeakNode(n3, n10, n2);
            }
            n2 = CollationBuilder.ceStrength(this.ces[this.cesLength - 1]);
        }
        this.ces[this.cesLength - 1] = CollationBuilder.tempCEFromIndexAndStrength(n3, n2);
    }

    private int getWeight16Before(int n2, long l2, int n3) {
        int n4;
        assert (CollationBuilder.strengthFromNode(l2) < n3 || !CollationBuilder.isTailoredNode(l2));
        int n5 = CollationBuilder.strengthFromNode(l2) == 2 ? CollationBuilder.weight16FromNode(l2) : 1280;
        while (CollationBuilder.strengthFromNode(l2) > 1) {
            n2 = CollationBuilder.previousIndexFromNode(l2);
            l2 = this.nodes.elementAti(n2);
        }
        if (CollationBuilder.isTailoredNode(l2)) {
            return 256;
        }
        int n6 = CollationBuilder.strengthFromNode(l2) == 1 ? CollationBuilder.weight16FromNode(l2) : 1280;
        while (CollationBuilder.strengthFromNode(l2) > 0) {
            n2 = CollationBuilder.previousIndexFromNode(l2);
            l2 = this.nodes.elementAti(n2);
        }
        if (CollationBuilder.isTailoredNode(l2)) {
            return 256;
        }
        long l3 = CollationBuilder.weight32FromNode(l2);
        if (n3 == 1) {
            n4 = this.rootElements.getSecondaryBefore(l3, n6);
        } else {
            n4 = this.rootElements.getTertiaryBefore(l3, n6, n5);
            assert ((n4 & 0xFFFFC0C0) == 0);
        }
        return n4;
    }

    private long getSpecialResetPosition(CharSequence charSequence) {
        long l2;
        int n2;
        long l3;
        assert (charSequence.length() == 2);
        int n3 = 0;
        boolean bl2 = false;
        CollationRuleParser.Position position = CollationRuleParser.POSITION_VALUES[charSequence.charAt(1) - 10240];
        switch (position) {
            case FIRST_TERTIARY_IGNORABLE: {
                return 0L;
            }
            case LAST_TERTIARY_IGNORABLE: {
                return 0L;
            }
            case FIRST_SECONDARY_IGNORABLE: {
                int n4 = this.findOrInsertNodeForRootCE(0L, 2);
                long l4 = this.nodes.elementAti(n4);
                n4 = CollationBuilder.nextIndexFromNode(l4);
                if (n4 != 0) {
                    l4 = this.nodes.elementAti(n4);
                    assert (CollationBuilder.strengthFromNode(l4) <= 2);
                    if (CollationBuilder.isTailoredNode(l4) && CollationBuilder.strengthFromNode(l4) == 2) {
                        return CollationBuilder.tempCEFromIndexAndStrength(n4, 2);
                    }
                }
                return this.rootElements.getFirstTertiaryCE();
            }
            case LAST_SECONDARY_IGNORABLE: {
                l3 = this.rootElements.getLastTertiaryCE();
                n3 = 2;
                break;
            }
            case FIRST_PRIMARY_IGNORABLE: {
                n2 = this.findOrInsertNodeForRootCE(0L, 1);
                l2 = this.nodes.elementAti(n2);
                while ((n2 = CollationBuilder.nextIndexFromNode(l2)) != 0 && (n3 = CollationBuilder.strengthFromNode(l2 = this.nodes.elementAti(n2))) >= 1) {
                    if (n3 != 1) continue;
                    if (!CollationBuilder.isTailoredNode(l2)) break;
                    if (CollationBuilder.nodeHasBefore3(l2)) {
                        n2 = CollationBuilder.nextIndexFromNode(this.nodes.elementAti(CollationBuilder.nextIndexFromNode(l2)));
                        assert (CollationBuilder.isTailoredNode(this.nodes.elementAti(n2)));
                    }
                    return CollationBuilder.tempCEFromIndexAndStrength(n2, 1);
                }
                l3 = this.rootElements.getFirstSecondaryCE();
                n3 = 1;
                break;
            }
            case LAST_PRIMARY_IGNORABLE: {
                l3 = this.rootElements.getLastSecondaryCE();
                n3 = 1;
                break;
            }
            case FIRST_VARIABLE: {
                l3 = this.rootElements.getFirstPrimaryCE();
                bl2 = true;
                break;
            }
            case LAST_VARIABLE: {
                l3 = this.rootElements.lastCEWithPrimaryBefore(this.variableTop + 1L);
                break;
            }
            case FIRST_REGULAR: {
                l3 = this.rootElements.firstCEWithPrimaryAtLeast(this.variableTop + 1L);
                bl2 = true;
                break;
            }
            case LAST_REGULAR: {
                l3 = this.rootElements.firstCEWithPrimaryAtLeast(this.baseData.getFirstPrimaryForGroup(17));
                break;
            }
            case FIRST_IMPLICIT: {
                l3 = this.baseData.getSingleCE(19968);
                break;
            }
            case LAST_IMPLICIT: {
                throw new UnsupportedOperationException("reset to [last implicit] not supported");
            }
            case FIRST_TRAILING: {
                l3 = Collation.makeCE(0xFF020200L);
                bl2 = true;
                break;
            }
            case LAST_TRAILING: {
                throw new IllegalArgumentException("LDML forbids tailoring to U+FFFF");
            }
            default: {
                assert (false);
                return 0L;
            }
        }
        n2 = this.findOrInsertNodeForRootCE(l3, n3);
        l2 = this.nodes.elementAti(n2);
        if ((position.ordinal() & 1) == 0) {
            if (!CollationBuilder.nodeHasAnyBefore(l2) && bl2) {
                n2 = CollationBuilder.nextIndexFromNode(l2);
                if (n2 != 0) {
                    l2 = this.nodes.elementAti(n2);
                    assert (CollationBuilder.isTailoredNode(l2));
                    l3 = CollationBuilder.tempCEFromIndexAndStrength(n2, n3);
                } else {
                    assert (n3 == 0);
                    long l5 = l3 >>> 32;
                    int n5 = this.rootElements.findPrimary(l5);
                    boolean bl3 = this.baseData.isCompressiblePrimary(l5);
                    l5 = this.rootElements.getPrimaryAfter(l5, n5, bl3);
                    l3 = Collation.makeCE(l5);
                    n2 = this.findOrInsertNodeForRootCE(l3, 0);
                    l2 = this.nodes.elementAti(n2);
                }
            }
            if (CollationBuilder.nodeHasAnyBefore(l2)) {
                if (CollationBuilder.nodeHasBefore2(l2)) {
                    n2 = CollationBuilder.nextIndexFromNode(this.nodes.elementAti(CollationBuilder.nextIndexFromNode(l2)));
                    l2 = this.nodes.elementAti(n2);
                }
                if (CollationBuilder.nodeHasBefore3(l2)) {
                    n2 = CollationBuilder.nextIndexFromNode(this.nodes.elementAti(CollationBuilder.nextIndexFromNode(l2)));
                }
                assert (CollationBuilder.isTailoredNode(this.nodes.elementAti(n2)));
                l3 = CollationBuilder.tempCEFromIndexAndStrength(n2, n3);
            }
        } else {
            long l6;
            int n6;
            while ((n6 = CollationBuilder.nextIndexFromNode(l2)) != 0 && CollationBuilder.strengthFromNode(l6 = this.nodes.elementAti(n6)) >= n3) {
                n2 = n6;
                l2 = l6;
            }
            if (CollationBuilder.isTailoredNode(l2)) {
                l3 = CollationBuilder.tempCEFromIndexAndStrength(n2, n3);
            }
        }
        return l3;
    }

    @Override
    void addRelation(int n2, CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        int n3;
        String string = charSequence.length() == 0 ? "" : this.nfd.normalize(charSequence);
        String string2 = this.nfd.normalize(charSequence2);
        int n4 = string2.length();
        if (n4 >= 2) {
            n3 = string2.charAt(0);
            if (Normalizer2Impl.Hangul.isJamoL(n3) || Normalizer2Impl.Hangul.isJamoV(n3)) {
                throw new UnsupportedOperationException("contractions starting with conjoining Jamo L or V not supported");
            }
            n3 = string2.charAt(n4 - 1);
            if (Normalizer2Impl.Hangul.isJamoL(n3) || Normalizer2Impl.Hangul.isJamoV(n3) && Normalizer2Impl.Hangul.isJamoL(string2.charAt(n4 - 2))) {
                throw new UnsupportedOperationException("contractions ending with conjoining Jamo L or L+V not supported");
            }
        }
        if (n2 != 15) {
            n3 = this.findOrInsertNodeForCEs(n2);
            assert (this.cesLength > 0);
            long l2 = this.ces[this.cesLength - 1];
            if (n2 == 0 && !CollationBuilder.isTempCE(l2) && l2 >>> 32 == 0L) {
                throw new UnsupportedOperationException("tailoring primary after ignorables not supported");
            }
            if (n2 == 3 && l2 == 0L) {
                throw new UnsupportedOperationException("tailoring quaternary after tertiary ignorables not supported");
            }
            n3 = this.insertTailoredNodeAfter(n3, n2);
            int n5 = CollationBuilder.ceStrength(l2);
            if (n2 < n5) {
                n5 = n2;
            }
            this.ces[this.cesLength - 1] = CollationBuilder.tempCEFromIndexAndStrength(n3, n5);
        }
        this.setCaseBits(string2);
        n3 = this.cesLength;
        if (charSequence3.length() != 0) {
            String string3 = this.nfd.normalize(charSequence3);
            this.cesLength = this.dataBuilder.getCEs(string3, this.ces, this.cesLength);
            if (this.cesLength > 31) {
                throw new IllegalArgumentException("extension string adds too many collation elements (more than 31 total)");
            }
        }
        int n6 = -1;
        if (!(string.contentEquals(charSequence) && string2.contentEquals(charSequence2) || this.ignorePrefix(charSequence) || this.ignoreString(charSequence2))) {
            n6 = this.addIfDifferent(charSequence, charSequence2, this.ces, this.cesLength, n6);
        }
        this.addWithClosure(string, string2, this.ces, this.cesLength, n6);
        this.cesLength = n3;
    }

    private int findOrInsertNodeForCEs(int n2) {
        long l2;
        assert (0 <= n2 && n2 <= 3);
        while (true) {
            if (this.cesLength == 0) {
                this.ces[0] = 0L;
                l2 = 0L;
                this.cesLength = 1;
                break;
            }
            l2 = this.ces[this.cesLength - 1];
            if (CollationBuilder.ceStrength(l2) <= n2) break;
            --this.cesLength;
        }
        if (CollationBuilder.isTempCE(l2)) {
            return CollationBuilder.indexFromTempCE(l2);
        }
        if ((int)(l2 >>> 56) == 254) {
            throw new UnsupportedOperationException("tailoring relative to an unassigned code point not supported");
        }
        return this.findOrInsertNodeForRootCE(l2, n2);
    }

    private int findOrInsertNodeForRootCE(long l2, int n2) {
        assert ((int)(l2 >>> 56) != 254);
        assert ((l2 & 0xC0L) == 0L);
        int n3 = this.findOrInsertNodeForPrimary(l2 >>> 32);
        if (n2 >= 1) {
            int n4 = (int)l2;
            n3 = this.findOrInsertWeakNode(n3, n4 >>> 16, 1);
            if (n2 >= 2) {
                n3 = this.findOrInsertWeakNode(n3, n4 & 0x3F3F, 2);
            }
        }
        return n3;
    }

    private static final int binarySearchForRootPrimaryNode(int[] nArray, int n2, long[] lArray, long l2) {
        if (n2 == 0) {
            return -1;
        }
        int n3 = 0;
        int n4 = n2;
        int n5;
        long l3;
        long l4;
        while (l2 != (l4 = (l3 = lArray[nArray[n5 = (int)(((long)n3 + (long)n4) / 2L)]]) >>> 32)) {
            if (l2 < l4) {
                if (n5 == n3) {
                    return ~n3;
                }
                n4 = n5;
                continue;
            }
            if (n5 == n3) {
                return ~(n3 + 1);
            }
            n3 = n5;
        }
        return n5;
    }

    private int findOrInsertNodeForPrimary(long l2) {
        int n2 = CollationBuilder.binarySearchForRootPrimaryNode(this.rootPrimaryIndexes.getBuffer(), this.rootPrimaryIndexes.size(), this.nodes.getBuffer(), l2);
        if (n2 >= 0) {
            return this.rootPrimaryIndexes.elementAti(n2);
        }
        int n3 = this.nodes.size();
        this.nodes.addElement(CollationBuilder.nodeFromWeight32(l2));
        this.rootPrimaryIndexes.insertElementAt(n3, ~n2);
        return n3;
    }

    private int findOrInsertWeakNode(int n2, int n3, int n4) {
        int n5;
        assert (0 <= n2 && n2 < this.nodes.size());
        assert (1 <= n4 && n4 <= 2);
        if (n3 == 1280) {
            return this.findCommonNode(n2, n4);
        }
        long l2 = this.nodes.elementAti(n2);
        assert (CollationBuilder.strengthFromNode(l2) < n4);
        if (n3 != 0 && n3 < 1280) {
            int n6 = n5 = n4 == 1 ? 64 : 32;
            if ((l2 & (long)n5) == 0L) {
                long l3 = CollationBuilder.nodeFromWeight16(1280) | CollationBuilder.nodeFromStrength(n4);
                if (n4 == 1) {
                    l3 |= l2 & 0x20L;
                    l2 &= 0xFFFFFFFFFFFFFFDFL;
                }
                this.nodes.setElementAt(l2 | (long)n5, n2);
                int n7 = CollationBuilder.nextIndexFromNode(l2);
                l2 = CollationBuilder.nodeFromWeight16(n3) | CollationBuilder.nodeFromStrength(n4);
                n2 = this.insertNodeBetween(n2, n7, l2);
                this.insertNodeBetween(n2, n7, l3);
                return n2;
            }
        }
        while ((n5 = CollationBuilder.nextIndexFromNode(l2)) != 0) {
            l2 = this.nodes.elementAti(n5);
            int n8 = CollationBuilder.strengthFromNode(l2);
            if (n8 <= n4) {
                if (n8 < n4) break;
                if (!CollationBuilder.isTailoredNode(l2)) {
                    int n9 = CollationBuilder.weight16FromNode(l2);
                    if (n9 == n3) {
                        return n5;
                    }
                    if (n9 > n3) break;
                }
            }
            n2 = n5;
        }
        l2 = CollationBuilder.nodeFromWeight16(n3) | CollationBuilder.nodeFromStrength(n4);
        return this.insertNodeBetween(n2, n5, l2);
    }

    private int insertTailoredNodeAfter(int n2, int n3) {
        int n4;
        assert (0 <= n2 && n2 < this.nodes.size());
        if (n3 >= 1) {
            n2 = this.findCommonNode(n2, 1);
            if (n3 >= 2) {
                n2 = this.findCommonNode(n2, 2);
            }
        }
        long l2 = this.nodes.elementAti(n2);
        while ((n4 = CollationBuilder.nextIndexFromNode(l2)) != 0 && CollationBuilder.strengthFromNode(l2 = this.nodes.elementAti(n4)) > n3) {
            n2 = n4;
        }
        l2 = 8L | CollationBuilder.nodeFromStrength(n3);
        return this.insertNodeBetween(n2, n4, l2);
    }

    private int insertNodeBetween(int n2, int n3, long l2) {
        assert (CollationBuilder.previousIndexFromNode(l2) == 0);
        assert (CollationBuilder.nextIndexFromNode(l2) == 0);
        assert (CollationBuilder.nextIndexFromNode(this.nodes.elementAti(n2)) == n3);
        int n4 = this.nodes.size();
        this.nodes.addElement(l2 |= CollationBuilder.nodeFromPreviousIndex(n2) | CollationBuilder.nodeFromNextIndex(n3));
        l2 = this.nodes.elementAti(n2);
        this.nodes.setElementAt(CollationBuilder.changeNodeNextIndex(l2, n4), n2);
        if (n3 != 0) {
            l2 = this.nodes.elementAti(n3);
            this.nodes.setElementAt(CollationBuilder.changeNodePreviousIndex(l2, n4), n3);
        }
        return n4;
    }

    private int findCommonNode(int n2, int n3) {
        assert (1 <= n3 && n3 <= 2);
        long l2 = this.nodes.elementAti(n2);
        if (CollationBuilder.strengthFromNode(l2) >= n3) {
            return n2;
        }
        if (n3 == 1 ? !CollationBuilder.nodeHasBefore2(l2) : !CollationBuilder.nodeHasBefore3(l2)) {
            return n2;
        }
        n2 = CollationBuilder.nextIndexFromNode(l2);
        l2 = this.nodes.elementAti(n2);
        assert (!CollationBuilder.isTailoredNode(l2) && CollationBuilder.strengthFromNode(l2) == n3 && CollationBuilder.weight16FromNode(l2) < 1280);
        do {
            n2 = CollationBuilder.nextIndexFromNode(l2);
            l2 = this.nodes.elementAti(n2);
            assert (CollationBuilder.strengthFromNode(l2) >= n3);
        } while (CollationBuilder.isTailoredNode(l2) || CollationBuilder.strengthFromNode(l2) > n3 || CollationBuilder.weight16FromNode(l2) < 1280);
        assert (CollationBuilder.weight16FromNode(l2) == 1280);
        return n2;
    }

    private void setCaseBits(CharSequence charSequence) {
        int n2;
        int n3 = 0;
        for (int i2 = 0; i2 < this.cesLength; ++i2) {
            if (CollationBuilder.ceStrength(this.ces[i2]) != 0) continue;
            ++n3;
        }
        assert (n3 <= 31);
        long l2 = 0L;
        if (n3 > 0) {
            CharSequence charSequence2 = charSequence;
            UTF16CollationIterator uTF16CollationIterator = new UTF16CollationIterator(this.baseData, false, charSequence2, 0);
            int n4 = uTF16CollationIterator.fetchCEs() - 1;
            assert (n4 >= 0 && uTF16CollationIterator.getCE(n4) == 0x101000100L);
            n2 = 0;
            int n5 = 0;
            for (int i3 = 0; i3 < n4; ++i3) {
                long l3 = uTF16CollationIterator.getCE(i3);
                if (l3 >>> 32 == 0L) continue;
                ++n5;
                int n6 = (int)l3 >> 14 & 3;
                assert (n6 == 0 || n6 == 2);
                if (n5 < n3) {
                    l2 |= (long)n6 << (n5 - 1) * 2;
                    continue;
                }
                if (n5 == n3) {
                    n2 = n6;
                    continue;
                }
                if (n6 == n2) continue;
                n2 = 1;
                break;
            }
            if (n5 >= n3) {
                l2 |= (long)n2 << (n3 - 1) * 2;
            }
        }
        for (int i4 = 0; i4 < this.cesLength; ++i4) {
            long l4 = this.ces[i4] & 0xFFFFFFFFFFFF3FFFL;
            n2 = CollationBuilder.ceStrength(l4);
            if (n2 == 0) {
                l4 |= (l2 & 3L) << 14;
                l2 >>>= 2;
            } else if (n2 == 2) {
                l4 |= 0x8000L;
            }
            this.ces[i4] = l4;
        }
    }

    @Override
    void suppressContractions(UnicodeSet unicodeSet) {
        this.dataBuilder.suppressContractions(unicodeSet);
    }

    @Override
    void optimize(UnicodeSet unicodeSet) {
        this.optimizeSet.addAll(unicodeSet);
    }

    private int addWithClosure(CharSequence charSequence, CharSequence charSequence2, long[] lArray, int n2, int n3) {
        n3 = this.addIfDifferent(charSequence, charSequence2, lArray, n2, n3);
        n3 = this.addOnlyClosure(charSequence, charSequence2, lArray, n2, n3);
        this.addTailComposites(charSequence, charSequence2);
        return n3;
    }

    private int addOnlyClosure(CharSequence charSequence, CharSequence charSequence2, long[] lArray, int n2, int n3) {
        int n4 = 0;
        if (charSequence.length() == 0) {
            String string;
            CanonicalIterator canonicalIterator = new CanonicalIterator(charSequence2.toString());
            String string2 = "";
            while ((string = canonicalIterator.next()) != null) {
                if (this.ignoreString(string) || string.contentEquals(charSequence2)) continue;
                if (n4++ > kClosureLoopLimit) {
                    throw new ICUInputTooLongException("Too many closure");
                }
                n3 = this.addIfDifferent(string2, string, lArray, n2, n3);
            }
        } else {
            String string;
            CanonicalIterator canonicalIterator = new CanonicalIterator(charSequence.toString());
            CanonicalIterator canonicalIterator2 = new CanonicalIterator(charSequence2.toString());
            while ((string = canonicalIterator.next()) != null) {
                String string3;
                if (this.ignorePrefix(string)) continue;
                boolean bl2 = string.contentEquals(charSequence);
                while ((string3 = canonicalIterator2.next()) != null) {
                    if (this.ignoreString(string3) || bl2 && string3.contentEquals(charSequence2)) continue;
                    if (n4++ > kClosureLoopLimit) {
                        throw new ICUInputTooLongException("Too many closure");
                    }
                    n3 = this.addIfDifferent(string, string3, lArray, n2, n3);
                }
                canonicalIterator2.reset();
            }
        }
        return n3;
    }

    private void addTailComposites(CharSequence charSequence, CharSequence charSequence2) {
        int n2;
        int n3 = charSequence2.length();
        while (true) {
            if (n3 == 0) {
                return;
            }
            n2 = Character.codePointBefore(charSequence2, n3);
            if (this.nfd.getCombiningClass(n2) == 0) break;
            n3 -= Character.charCount(n2);
        }
        if (Normalizer2Impl.Hangul.isJamoL(n2)) {
            return;
        }
        UnicodeSet unicodeSet = new UnicodeSet();
        if (!this.nfcImpl.getCanonStartSet(n2, unicodeSet)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        long[] lArray = new long[31];
        UnicodeSetIterator unicodeSetIterator = new UnicodeSetIterator(unicodeSet);
        while (unicodeSetIterator.next()) {
            int n4;
            int n5;
            assert (unicodeSetIterator.codepoint != -1);
            int n6 = unicodeSetIterator.codepoint;
            String string = this.nfd.getDecomposition(n6);
            if (!this.mergeCompositeIntoString(charSequence2, n3, n6, string, stringBuilder, stringBuilder2) || (n5 = this.dataBuilder.getCEs(charSequence, stringBuilder, lArray, 0)) > 31 || (n4 = this.addIfDifferent(charSequence, stringBuilder2, lArray, n5, -1)) == -1) continue;
            this.addOnlyClosure(charSequence, stringBuilder, lArray, n5, n4);
        }
    }

    private boolean mergeCompositeIntoString(CharSequence charSequence, int n2, int n3, CharSequence charSequence2, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        assert (Character.codePointBefore(charSequence, n2) == Character.codePointAt(charSequence2, 0));
        int n4 = Character.offsetByCodePoints(charSequence2, 0, 1);
        if (n4 == charSequence2.length()) {
            return false;
        }
        if (this.equalSubSequences(charSequence, n2, charSequence2, n4)) {
            return false;
        }
        stringBuilder.setLength(0);
        stringBuilder.append(charSequence, 0, n2);
        stringBuilder2.setLength(0);
        stringBuilder2.append(charSequence, 0, n2 - n4).appendCodePoint(n3);
        int n5 = n2;
        int n6 = n4;
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        while (true) {
            if (n7 < 0) {
                if (n5 >= charSequence.length()) break;
                n7 = Character.codePointAt(charSequence, n5);
                n8 = this.nfd.getCombiningClass(n7);
                assert (n8 != 0);
            }
            if (n6 >= charSequence2.length()) break;
            int n10 = Character.codePointAt(charSequence2, n6);
            n9 = this.nfd.getCombiningClass(n10);
            if (n9 == 0) {
                return false;
            }
            if (n8 < n9) {
                return false;
            }
            if (n9 < n8) {
                stringBuilder.appendCodePoint(n10);
                n6 += Character.charCount(n10);
                continue;
            }
            if (n10 != n7) {
                return false;
            }
            stringBuilder.appendCodePoint(n10);
            n6 += Character.charCount(n10);
            n5 += Character.charCount(n10);
            n7 = -1;
        }
        if (n7 >= 0) {
            if (n8 < n9) {
                return false;
            }
            stringBuilder.append(charSequence, n5, charSequence.length());
            stringBuilder2.append(charSequence, n5, charSequence.length());
        } else if (n6 < charSequence2.length()) {
            stringBuilder.append(charSequence2, n6, charSequence2.length());
        }
        assert (this.nfd.isNormalized(stringBuilder));
        assert (this.fcd.isNormalized(stringBuilder2));
        assert (this.nfd.normalize(stringBuilder2).equals(stringBuilder.toString()));
        return true;
    }

    private boolean equalSubSequences(CharSequence charSequence, int n2, CharSequence charSequence2, int n3) {
        int n4 = charSequence.length();
        if (n4 - n2 != charSequence2.length() - n3) {
            return false;
        }
        while (n2 < n4) {
            if (charSequence.charAt(n2++) == charSequence2.charAt(n3++)) continue;
            return false;
        }
        return true;
    }

    private boolean ignorePrefix(CharSequence charSequence) {
        return !this.isFCD(charSequence);
    }

    private boolean ignoreString(CharSequence charSequence) {
        return !this.isFCD(charSequence) || Normalizer2Impl.Hangul.isHangul(charSequence.charAt(0));
    }

    private boolean isFCD(CharSequence charSequence) {
        return this.fcd.isNormalized(charSequence);
    }

    private void closeOverComposites() {
        String string = "";
        UnicodeSetIterator unicodeSetIterator = new UnicodeSetIterator(COMPOSITES);
        while (unicodeSetIterator.next()) {
            assert (unicodeSetIterator.codepoint != -1);
            String string2 = this.nfd.getDecomposition(unicodeSetIterator.codepoint);
            this.cesLength = this.dataBuilder.getCEs(string2, this.ces, 0);
            if (this.cesLength > 31) continue;
            String string3 = unicodeSetIterator.getString();
            this.addIfDifferent(string, string3, this.ces, this.cesLength, -1);
        }
    }

    private int addIfDifferent(CharSequence charSequence, CharSequence charSequence2, long[] lArray, int n2, int n3) {
        long[] lArray2 = new long[31];
        int n4 = this.dataBuilder.getCEs(charSequence, charSequence2, lArray2, 0);
        if (!CollationBuilder.sameCEs(lArray, n2, lArray2, n4)) {
            if (n3 == -1) {
                n3 = this.dataBuilder.encodeCEs(lArray, n2);
            }
            this.dataBuilder.addCE32(charSequence, charSequence2, n3);
        }
        return n3;
    }

    private static boolean sameCEs(long[] lArray, int n2, long[] lArray2, int n3) {
        if (n2 != n3) {
            return false;
        }
        assert (n2 <= 31);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (lArray[i2] == lArray2[i2]) continue;
            return false;
        }
        return true;
    }

    private static final int alignWeightRight(int n2) {
        if (n2 != 0) {
            while ((n2 & 0xFF) == 0) {
                n2 >>>= 8;
            }
        }
        return n2;
    }

    private void makeTailoredCEs() {
        CollationWeights collationWeights = new CollationWeights();
        CollationWeights collationWeights2 = new CollationWeights();
        CollationWeights collationWeights3 = new CollationWeights();
        long[] lArray = this.nodes.getBuffer();
        for (int i2 = 0; i2 < this.rootPrimaryIndexes.size(); ++i2) {
            int n2;
            int n3 = this.rootPrimaryIndexes.elementAti(i2);
            long l2 = lArray[n3];
            long l3 = CollationBuilder.weight32FromNode(l2);
            int n4 = n2 = l3 == 0L ? 0 : 1280;
            int n5 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            int n6 = l3 == 0L ? 0 : this.rootElements.findPrimary(l3);
            int n7 = CollationBuilder.nextIndexFromNode(l2);
            while (n7 != 0) {
                n3 = n7;
                l2 = lArray[n3];
                n7 = CollationBuilder.nextIndexFromNode(l2);
                int n8 = CollationBuilder.strengthFromNode(l2);
                if (n8 == 3) {
                    assert (CollationBuilder.isTailoredNode(l2));
                    if (n5 == 3) {
                        throw new UnsupportedOperationException("quaternary tailoring gap too small");
                    }
                    ++n5;
                } else {
                    int n9;
                    int n10;
                    if (n8 == 2) {
                        if (CollationBuilder.isTailoredNode(l2)) {
                            if (!bl4) {
                                n10 = CollationBuilder.countTailoredNodes(lArray, n7, 2) + 1;
                                if (n4 == 0) {
                                    n4 = this.rootElements.getTertiaryBoundary() - 256;
                                    n9 = (int)this.rootElements.getFirstTertiaryCE() & 0x3F3F;
                                } else if (!bl2 && !bl3) {
                                    n9 = this.rootElements.getTertiaryAfter(n6, n2, n4);
                                } else if (n4 == 256) {
                                    n9 = 1280;
                                } else {
                                    assert (n4 == 1280);
                                    n9 = this.rootElements.getTertiaryBoundary();
                                }
                                assert (n9 == 16384 || (n9 & 0xFFFFC0C0) == 0);
                                collationWeights3.initForTertiary();
                                if (!collationWeights3.allocWeights(n4, n9, n10)) {
                                    throw new UnsupportedOperationException("tertiary tailoring gap too small");
                                }
                                bl4 = true;
                            }
                            n4 = (int)collationWeights3.nextWeight();
                            assert (n4 != -1);
                        } else {
                            n4 = CollationBuilder.weight16FromNode(l2);
                            bl4 = false;
                        }
                    } else {
                        if (n8 == 1) {
                            if (CollationBuilder.isTailoredNode(l2)) {
                                if (!bl3) {
                                    n10 = CollationBuilder.countTailoredNodes(lArray, n7, 1) + 1;
                                    if (n2 == 0) {
                                        n2 = this.rootElements.getSecondaryBoundary() - 256;
                                        n9 = (int)(this.rootElements.getFirstSecondaryCE() >> 16);
                                    } else if (!bl2) {
                                        n9 = this.rootElements.getSecondaryAfter(n6, n2);
                                    } else if (n2 == 256) {
                                        n9 = 1280;
                                    } else {
                                        assert (n2 == 1280);
                                        n9 = this.rootElements.getSecondaryBoundary();
                                    }
                                    if (n2 == 1280) {
                                        n2 = this.rootElements.getLastCommonSecondary();
                                    }
                                    collationWeights2.initForSecondary();
                                    if (!collationWeights2.allocWeights(n2, n9, n10)) {
                                        throw new UnsupportedOperationException("secondary tailoring gap too small");
                                    }
                                    bl3 = true;
                                }
                                n2 = (int)collationWeights2.nextWeight();
                                assert (n2 != -1);
                            } else {
                                n2 = CollationBuilder.weight16FromNode(l2);
                                bl3 = false;
                            }
                        } else {
                            assert (CollationBuilder.isTailoredNode(l2));
                            if (!bl2) {
                                n10 = CollationBuilder.countTailoredNodes(lArray, n7, 0) + 1;
                                n9 = this.baseData.isCompressiblePrimary(l3);
                                long l4 = this.rootElements.getPrimaryAfter(l3, n6, n9 != 0);
                                collationWeights.initForPrimary(n9 != 0);
                                if (!collationWeights.allocWeights(l3, l4, n10)) {
                                    throw new UnsupportedOperationException("primary tailoring gap too small");
                                }
                                bl2 = true;
                            }
                            l3 = collationWeights.nextWeight();
                            assert (l3 != 0xFFFFFFFFL);
                            n2 = 1280;
                            bl3 = false;
                        }
                        n4 = n2 == 0 ? 0 : 1280;
                        bl4 = false;
                    }
                    n5 = 0;
                }
                if (!CollationBuilder.isTailoredNode(l2)) continue;
                lArray[n3] = Collation.makeCE(l3, n2, n4, n5);
            }
        }
    }

    private static int countTailoredNodes(long[] lArray, int n2, int n3) {
        long l2;
        int n4 = 0;
        while (n2 != 0 && CollationBuilder.strengthFromNode(l2 = lArray[n2]) >= n3) {
            if (CollationBuilder.strengthFromNode(l2) == n3) {
                if (!CollationBuilder.isTailoredNode(l2)) break;
                ++n4;
            }
            n2 = CollationBuilder.nextIndexFromNode(l2);
        }
        return n4;
    }

    private void finalizeCEs() {
        CollationDataBuilder collationDataBuilder = new CollationDataBuilder();
        collationDataBuilder.initForTailoring(this.baseData);
        CEFinalizer cEFinalizer = new CEFinalizer(this.nodes.getBuffer());
        collationDataBuilder.copyFrom(this.dataBuilder, cEFinalizer);
        this.dataBuilder = collationDataBuilder;
    }

    private static long tempCEFromIndexAndStrength(int n2, int n3) {
        return 4629700417037541376L + ((long)(n2 & 0xFE000) << 43) + ((long)(n2 & 0x1FC0) << 42) + (long)((n2 & 0x3F) << 24) + (long)(n3 << 8);
    }

    private static int indexFromTempCE(long l2) {
        return (int)((l2 -= 4629700417037541376L) >> 43) & 0xFE000 | (int)(l2 >> 42) & 0x1FC0 | (int)(l2 >> 24) & 0x3F;
    }

    private static int strengthFromTempCE(long l2) {
        return (int)l2 >> 8 & 3;
    }

    private static boolean isTempCE(long l2) {
        int n2 = (int)l2 >>> 24;
        return 6 <= n2 && n2 <= 69;
    }

    private static int indexFromTempCE32(int n2) {
        return (n2 -= 1077937696) >> 11 & 0xFE000 | n2 >> 10 & 0x1FC0 | n2 >> 8 & 0x3F;
    }

    private static boolean isTempCE32(int n2) {
        return (n2 & 0xFF) >= 2 && 6 <= (n2 >> 8 & 0xFF) && (n2 >> 8 & 0xFF) <= 69;
    }

    private static int ceStrength(long l2) {
        return CollationBuilder.isTempCE(l2) ? CollationBuilder.strengthFromTempCE(l2) : ((l2 & 0xFF00000000000000L) != 0L ? 0 : (((int)l2 & 0xFF000000) != 0 ? 1 : (l2 != 0L ? 2 : 15)));
    }

    private static long nodeFromWeight32(long l2) {
        return l2 << 32;
    }

    private static long nodeFromWeight16(int n2) {
        return (long)n2 << 48;
    }

    private static long nodeFromPreviousIndex(int n2) {
        return (long)n2 << 28;
    }

    private static long nodeFromNextIndex(int n2) {
        return n2 << 8;
    }

    private static long nodeFromStrength(int n2) {
        return n2;
    }

    private static long weight32FromNode(long l2) {
        return l2 >>> 32;
    }

    private static int weight16FromNode(long l2) {
        return (int)(l2 >> 48) & 0xFFFF;
    }

    private static int previousIndexFromNode(long l2) {
        return (int)(l2 >> 28) & 0xFFFFF;
    }

    private static int nextIndexFromNode(long l2) {
        return (int)l2 >> 8 & 0xFFFFF;
    }

    private static int strengthFromNode(long l2) {
        return (int)l2 & 3;
    }

    private static boolean nodeHasBefore2(long l2) {
        return (l2 & 0x40L) != 0L;
    }

    private static boolean nodeHasBefore3(long l2) {
        return (l2 & 0x20L) != 0L;
    }

    private static boolean nodeHasAnyBefore(long l2) {
        return (l2 & 0x60L) != 0L;
    }

    private static boolean isTailoredNode(long l2) {
        return (l2 & 8L) != 0L;
    }

    private static long changeNodePreviousIndex(long l2, int n2) {
        return l2 & 0xFFFF00000FFFFFFFL | CollationBuilder.nodeFromPreviousIndex(n2);
    }

    private static long changeNodeNextIndex(long l2, int n2) {
        return l2 & 0xFFFFFFFFF00000FFL | CollationBuilder.nodeFromNextIndex(n2);
    }

    static {
        COMPOSITES.remove(44032, 55203);
    }

    private static final class CEFinalizer
    implements CollationDataBuilder.CEModifier {
        private long[] finalCEs;

        CEFinalizer(long[] lArray) {
            this.finalCEs = lArray;
        }

        @Override
        public long modifyCE32(int n2) {
            assert (!Collation.isSpecialCE32(n2));
            if (CollationBuilder.isTempCE32(n2)) {
                return this.finalCEs[CollationBuilder.indexFromTempCE32(n2)] | (long)((n2 & 0xC0) << 8);
            }
            return 0x101000100L;
        }

        @Override
        public long modifyCE(long l2) {
            if (CollationBuilder.isTempCE(l2)) {
                return this.finalCEs[CollationBuilder.indexFromTempCE(l2)] | l2 & 0xC000L;
            }
            return 0x101000100L;
        }
    }

    private static final class BundleImporter
    implements CollationRuleParser.Importer {
        BundleImporter() {
        }

        @Override
        public String getRules(String string, String string2) {
            return CollationLoader.loadRules(new ULocale(string), string2);
        }
    }
}

