/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter;

import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CharacterIteration;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.DictionaryBreakEngine;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.ModelIndex;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundleIterator;

public class MlBreakEngine {
    private static final int MAX_FEATURE = 13;
    private UnicodeSet fDigitOrOpenPunctuationOrAlphabetSet;
    private UnicodeSet fClosePunctuationSet;
    private List<HashMap<String, Integer>> fModel;
    private int fNegativeSum;

    public MlBreakEngine(UnicodeSet unicodeSet, UnicodeSet unicodeSet2) {
        this.fDigitOrOpenPunctuationOrAlphabetSet = unicodeSet;
        this.fClosePunctuationSet = unicodeSet2;
        this.fModel = new ArrayList<HashMap<String, Integer>>(13);
        for (int i2 = 0; i2 < 13; ++i2) {
            this.fModel.add(new HashMap());
        }
        this.fNegativeSum = 0;
        this.loadMLModel();
    }

    public int divideUpRange(CharacterIterator characterIterator, int n2, int n3, CharacterIterator characterIterator2, int n4, int[] nArray, DictionaryBreakEngine.DequeI dequeI) {
        int n5;
        if (n2 >= n3) {
            return 0;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n4);
        String string = this.transform(characterIterator2);
        int n6 = n4 + 4;
        int[] nArray2 = new int[n6];
        int n7 = this.initIndexList(characterIterator2, nArray2, n4);
        arrayList.add(0, 0);
        int n8 = 0;
        while (n8 + 1 < n4) {
            this.evaluateBreakpoint(string, nArray2, n8, n7, arrayList);
            if (n8 + 4 < n4) {
                nArray2[n8 + 6] = n7;
                n7 += Character.charCount(CharacterIteration.next32(characterIterator2));
            }
            ++n8;
        }
        if ((Integer)arrayList.get(arrayList.size() - 1) != n4) {
            arrayList.add(n4);
        }
        n8 = 0;
        int n9 = -1;
        int n10 = arrayList.size();
        for (n5 = 0; n5 < n10; ++n5) {
            int n11 = nArray[arrayList.get(n5)] + n2;
            characterIterator.setIndex(n11);
            if (n11 > n9 && (n11 != n2 || n11 > 0 && this.fClosePunctuationSet.contains(CharacterIteration.previous32(characterIterator)))) {
                dequeI.push(n11);
                ++n8;
            }
            n9 = n11;
        }
        if (!dequeI.isEmpty() && dequeI.peek() == n3) {
            characterIterator.setIndex(n3);
            n5 = CharacterIteration.current32(characterIterator);
            if (n5 != Integer.MAX_VALUE && !this.fDigitOrOpenPunctuationOrAlphabetSet.contains(n5)) {
                dequeI.pop();
                --n8;
            }
        }
        if (!dequeI.isEmpty()) {
            characterIterator.setIndex(dequeI.peek());
        }
        return n8;
    }

    private String transform(CharacterIterator characterIterator) {
        StringBuilder stringBuilder = new StringBuilder();
        characterIterator.setIndex(0);
        char c2 = characterIterator.first();
        while (c2 != '\uffff') {
            stringBuilder.append(c2);
            c2 = characterIterator.next();
        }
        return stringBuilder.toString();
    }

    private void evaluateBreakpoint(String string, int[] nArray, int n2, int n3, ArrayList<Integer> arrayList) {
        int n4;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.fNegativeSum;
        for (n4 = 0; n4 < 6; ++n4) {
            n5 = n2 + n4;
            if (nArray[n5] == -1) continue;
            n6 = nArray[n5 + 1] != -1 ? nArray[n5 + 1] : n3;
            n7 += this.fModel.get(ModelIndex.kUWStart.getValue() + n4).getOrDefault(string.substring(nArray[n5], n6), 0).intValue();
        }
        for (n4 = 0; n4 < 3; ++n4) {
            n5 = n2 + n4 + 1;
            if (nArray[n5] == -1 || nArray[n5 + 1] == -1) continue;
            n6 = nArray[n5 + 2] != -1 ? nArray[n5 + 2] : n3;
            n7 += this.fModel.get(ModelIndex.kBWStart.getValue() + n4).getOrDefault(string.substring(nArray[n5], n6), 0).intValue();
        }
        for (n4 = 0; n4 < 4; ++n4) {
            n5 = n2 + n4;
            if (nArray[n5] == -1 || nArray[n5 + 1] == -1 || nArray[n5 + 2] == -1) continue;
            n6 = nArray[n5 + 3] != -1 ? nArray[n5 + 3] : n3;
            n7 += this.fModel.get(ModelIndex.kTWStart.getValue() + n4).getOrDefault(string.substring(nArray[n5], n6), 0).intValue();
        }
        if (n7 > 0) {
            arrayList.add(n2 + 1);
        }
    }

    private int initIndexList(CharacterIterator characterIterator, int[] nArray, int n2) {
        int n3 = 0;
        characterIterator.setIndex(n3);
        Arrays.fill(nArray, -1);
        if (n2 > 0) {
            nArray[2] = 0;
            n3 += Character.charCount(CharacterIteration.current32(characterIterator));
            if (n2 > 1) {
                nArray[3] = n3;
                n3 += Character.charCount(CharacterIteration.next32(characterIterator));
                if (n2 > 2) {
                    nArray[4] = n3;
                    n3 += Character.charCount(CharacterIteration.next32(characterIterator));
                    if (n2 > 3) {
                        nArray[5] = n3;
                        n3 += Character.charCount(CharacterIteration.next32(characterIterator));
                    }
                }
            }
        }
        return n3;
    }

    private void loadMLModel() {
        int n2 = 0;
        UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/brkitr", "jaml");
        this.initKeyValue(uResourceBundle, "UW1Keys", "UW1Values", this.fModel.get(n2++));
        this.initKeyValue(uResourceBundle, "UW2Keys", "UW2Values", this.fModel.get(n2++));
        this.initKeyValue(uResourceBundle, "UW3Keys", "UW3Values", this.fModel.get(n2++));
        this.initKeyValue(uResourceBundle, "UW4Keys", "UW4Values", this.fModel.get(n2++));
        this.initKeyValue(uResourceBundle, "UW5Keys", "UW5Values", this.fModel.get(n2++));
        this.initKeyValue(uResourceBundle, "UW6Keys", "UW6Values", this.fModel.get(n2++));
        this.initKeyValue(uResourceBundle, "BW1Keys", "BW1Values", this.fModel.get(n2++));
        this.initKeyValue(uResourceBundle, "BW2Keys", "BW2Values", this.fModel.get(n2++));
        this.initKeyValue(uResourceBundle, "BW3Keys", "BW3Values", this.fModel.get(n2++));
        this.initKeyValue(uResourceBundle, "TW1Keys", "TW1Values", this.fModel.get(n2++));
        this.initKeyValue(uResourceBundle, "TW2Keys", "TW2Values", this.fModel.get(n2++));
        this.initKeyValue(uResourceBundle, "TW3Keys", "TW3Values", this.fModel.get(n2++));
        this.initKeyValue(uResourceBundle, "TW4Keys", "TW4Values", this.fModel.get(n2++));
        this.fNegativeSum /= 2;
    }

    private void initKeyValue(UResourceBundle uResourceBundle, String string, String string2, HashMap<String, Integer> hashMap) {
        int n2 = 0;
        UResourceBundle uResourceBundle2 = uResourceBundle.get(string);
        UResourceBundle uResourceBundle3 = uResourceBundle.get(string2);
        int[] nArray = uResourceBundle3.getIntVector();
        UResourceBundleIterator uResourceBundleIterator = uResourceBundle2.getIterator();
        while (uResourceBundleIterator.hasNext()) {
            this.fNegativeSum -= nArray[n2];
            hashMap.put(uResourceBundleIterator.nextString(), nArray[n2++]);
        }
    }
}

